/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAclSolutionFile;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPermissionMask;
import org.pentaho.platform.api.engine.IPermissionRecipient;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginOperation;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.repository.ISolutionRepositoryService;
import org.pentaho.platform.api.repository.SolutionRepositoryServiceException;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.security.SimplePermissionMask;
import org.pentaho.platform.engine.security.SimpleRole;
import org.pentaho.platform.engine.security.SimpleUser;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.VersionHelper;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionRepositoryServiceImpl
implements ISolutionRepositoryService {
    private static final long serialVersionUID = -5870073658756939643L;
    private static final Log logger = LogFactory.getLog(SolutionRepositoryServiceImpl.class);
    private static final String URL_ENCODING = "UTF-8";
    private static final String RESPONSE_DOCUMENT_ENCODING = "UTF-8";
    private static final String RESPONSE_DOCUMENT_VERSION_NUM = "1.0";
    private static final ThreadLocal<SAXParserFactory> SAX_FACTORY = new ThreadLocal();

    public boolean delete(IPentahoSession userSession, String solution, String path, String name) throws IOException {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        String fullPath = ActionInfo.buildSolutionPath((String)solution, (String)path, (String)name);
        return repository.removeSolutionFile(fullPath);
    }

    public boolean createFolder(IPentahoSession userSession, String solution, String path, String name, String desc) throws IOException {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        if (solution == null) {
            solution = "";
        }
        if (name == null || name.indexOf("/") >= 0 || name.indexOf("\\") >= 0 || name.indexOf(47) >= 0) {
            return false;
        }
        String parentFolderPath = ActionInfo.buildSolutionPath((String)solution, (String)path, (String)"/");
        ISolutionFile parentSolutionFile = repository.getSolutionFile(parentFolderPath, 4);
        if (parentSolutionFile != null && parentSolutionFile.isDirectory()) {
            File parent = new File(PentahoSystem.getApplicationContext().getSolutionPath(parentFolderPath));
            File newFolder = new File(parent, name);
            if (newFolder.exists()) {
                return false;
            }
            repository.createFolder(newFolder);
            String defaultIndex = "<index><name>" + name + "</name><description>" + (desc != null ? desc : name) + "</description><icon>reporting.png</icon><visible>true</visible><display-type>list</display-type></index>";
            String indexPath = ActionInfo.buildSolutionPath((String)solution, (String)path, (String)name);
            String repositoryBaseURL = PentahoSystem.getApplicationContext().getSolutionPath("");
            repository.addSolutionFile(repositoryBaseURL, indexPath, "index.xml", defaultIndex.getBytes(), false);
            return true;
        }
        return false;
    }

    protected boolean acceptFilter(String name, String[] filters) {
        if (filters == null || filters.length == 0) {
            return false;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (!name.endsWith(filters[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean accept(boolean isAdministrator, ISolutionRepository repository, ISolutionFile file) {
        return isAdministrator || repository.hasAccess(file, 1);
    }

    /*
     * Unable to fully structure code
     */
    protected void processRepositoryFile(IPentahoSession session, boolean isAdministrator, ISolutionRepository repository, Node parentNode, ISolutionFile file, String[] filters) {
        name = file.getFileName();
        if (name.startsWith("system") || name.startsWith("tmp") || name.startsWith(".")) {
            return;
        }
        if (!this.accept(isAdministrator, repository, file)) {
            return;
        }
        if (file.isDirectory()) {
            if (repository.getRootFolder(1).getFullPath().equals(file.getFullPath())) {
                for (ISolutionFile childSolutionFile : children = file.listFiles()) {
                    this.processRepositoryFile(session, isAdministrator, repository, parentNode, childSolutionFile, filters);
                }
                return;
            }
            child = null;
            key = file.getFullPath() + file.getLastModified() + LocaleHelper.getLocale();
            cacheManager = PentahoSystem.getCacheManager(null);
            if (cacheManager != null && cacheManager.cacheEnabled("repository-service-cache")) {
                child = (Element)cacheManager.getFromRegionCache("repository-service-cache", (Object)key);
            }
            if (child == null) {
                child = parentNode instanceof Document != false ? ((Document)parentNode).createElement("file") : parentNode.getOwnerDocument().createElement("file");
                try {
                    localizedName = repository.getLocalizedFileProperty(file, "name", 1);
                    child.setAttribute("localized-name", localizedName == null || "".equals(localizedName) != false ? name : localizedName);
                }
                catch (Exception e) {
                    child.setAttribute("localized-name", name);
                }
                try {
                    visible = repository.getLocalizedFileProperty(file, "visible", 1);
                    child.setAttribute("visible", visible == null || "".equals(visible) != false ? "false" : visible);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    child.setAttribute("visible", "false");
                }
                description = repository.getLocalizedFileProperty(file, "description", 1);
                child.setAttribute("description", description == null || "".equals(description) != false ? name : description);
                child.setAttribute("name", name);
                child.setAttribute("isDirectory", "true");
                child.setAttribute("lastModifiedDate", "" + file.getLastModified());
                if (cacheManager != null && cacheManager.cacheEnabled("repository-service-cache")) {
                    cacheManager.putInRegionCache("repository-service-cache", (Object)key, (Object)child);
                }
            } else {
                newChild = parentNode instanceof Document != false ? ((Document)parentNode).createElement("file") : parentNode.getOwnerDocument().createElement("file");
                attributes = child.getAttributes();
                for (i = 0; i < attributes.getLength(); ++i) {
                    attribute = attributes.item(i);
                    newChild.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
                }
                child = newChild;
            }
            parentNode.appendChild(child);
            for (ISolutionFile childSolutionFile : children = file.listFiles()) {
                this.processRepositoryFile(session, isAdministrator, repository, child, childSolutionFile, filters);
            }
        } else {
            pluginInputStream = null;
            try {
                lastPoint = name.lastIndexOf(46);
                extension = "";
                if (lastPoint != -1) {
                    extension = name.substring(lastPoint + 1).toLowerCase();
                }
                addFile = this.acceptFilter(name, filters) != false || "xaction".equals(extension) != false || "url".equals(extension) != false;
                isPlugin = false;
                pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)session);
                if (pluginManager != null) {
                    types = pluginManager.getContentTypes();
                    isPlugin = types != null && types.contains(extension) != false;
                    addFile |= isPlugin;
                }
                if (!addFile) ** GOTO lbl214
                cacheManager = PentahoSystem.getCacheManager(null);
                child = null;
                key = file.getFullPath() + file.getLastModified() + LocaleHelper.getLocale();
                if (cacheManager != null && cacheManager.cacheEnabled("repository-service-cache")) {
                    child = (Element)cacheManager.getFromRegionCache("repository-service-cache", (Object)key);
                }
                if (child == null) {
                    v0 = child = parentNode instanceof Document != false ? ((Document)parentNode).createElement("file") : parentNode.getOwnerDocument().createElement("file");
                    if (cacheManager != null && cacheManager.cacheEnabled("repository-service-cache")) {
                        cacheManager.putInRegionCache("repository-service-cache", (Object)key, (Object)child);
                    }
                } else {
                    newChild = parentNode instanceof Document != false ? ((Document)parentNode).createElement("file") : parentNode.getOwnerDocument().createElement("file");
                    attributes = child.getAttributes();
                    for (i = 0; i < attributes.getLength(); ++i) {
                        attribute = attributes.item(i);
                        newChild.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
                    }
                    parentNode.appendChild(newChild);
                    return;
                }
                parentNode.appendChild(child);
                fileInfo = null;
                if (name.endsWith(".xaction")) {
                    solution = file.getSolutionPath();
                    path = "";
                    if (solution.startsWith("/")) {
                        solution = solution.substring(1);
                    }
                    if ((pos = solution.indexOf(47)) != -1) {
                        path = solution.substring(pos + 1);
                        solution = solution.substring(0, pos);
                    }
                    requestContext = PentahoRequestContextHolder.getRequestContext();
                    contextPath = requestContext.getContextPath();
                    paramServiceUrl = contextPath + "ServiceAction?solution=" + URLEncoder.encode(solution, "UTF-8") + "&path=" + URLEncoder.encode(path, "UTF-8") + "&action=" + URLEncoder.encode(name, "UTF-8") + "&component=xaction-parameter";
                    child.setAttribute("param-service-url", paramServiceUrl);
                    url = contextPath + "ViewAction?solution=" + URLEncoder.encode(solution, "UTF-8") + "&path=" + URLEncoder.encode(path, "UTF-8") + "&action=" + URLEncoder.encode(name, "UTF-8");
                    child.setAttribute("url", url);
                } else if (name.endsWith(".url")) {
                    props = new String(file.getData());
                    tokenizer = new StringTokenizer(props, "\n");
                    while (tokenizer.hasMoreTokens()) {
                        line = tokenizer.nextToken();
                        pos = line.indexOf(61);
                        if (pos <= 0) continue;
                        propname = line.substring(0, pos);
                        value = line.substring(pos + 1);
                        if (value != null && value.length() > 0 && value.charAt(value.length() - 1) == '\r') {
                            value = value.substring(0, value.length() - 1);
                        }
                        if (!"URL".equalsIgnoreCase(propname)) continue;
                        child.setAttribute("url", value);
                    }
                } else if (isPlugin) {
                    try {
                        pluginInputStream = new PluginFileInputStream(repository, file);
                        fileInfo = pluginManager.getFileInfo(extension, session, file, (InputStream)pluginInputStream);
                        handlerId = pluginManager.getContentGeneratorIdForType(extension, session);
                        fileUrl = pluginManager.getContentGeneratorUrlForType(extension, session);
                        solution = file.getSolutionPath();
                        path = "";
                        requestContext = PentahoRequestContextHolder.getRequestContext();
                        contextPath = requestContext.getContextPath();
                        if (solution.startsWith("/")) {
                            solution = solution.substring(1);
                        }
                        if ((pos = solution.indexOf(47)) != -1) {
                            path = solution.substring(pos + 1);
                            solution = solution.substring(0, pos);
                        }
                        url = null;
                        if (!"".equals(fileUrl)) {
                            url = contextPath + fileUrl + "?solution=" + URLEncoder.encode(solution, "UTF-8") + "&path=" + URLEncoder.encode(path, "UTF-8") + "&action=" + URLEncoder.encode(name, "UTF-8");
                        } else {
                            info = pluginManager.getContentInfoFromExtension(extension, session);
                            for (IPluginOperation operation : info.getOperations()) {
                                if (!operation.getId().equalsIgnoreCase("RUN")) continue;
                                command = operation.getCommand();
                                command = command.replaceAll("\\{solution\\}", URLEncoder.encode(solution, "UTF-8"));
                                command = command.replaceAll("\\{path\\}", URLEncoder.encode(path, "UTF-8"));
                                command = command.replaceAll("\\{name\\}", URLEncoder.encode(name, "UTF-8"));
                                url = contextPath + command;
                                break;
                            }
                            if (url == null) {
                                url = contextPath + "content/" + handlerId + "?solution=" + URLEncoder.encode(solution, "UTF-8") + "&path=" + URLEncoder.encode(path, "UTF-8") + "&action=" + URLEncoder.encode(name, "UTF-8");
                            }
                        }
                        child.setAttribute("url", url);
                        paramUrl = null;
                        info = pluginManager.getContentInfoFromExtension(extension, session);
                        for (IPluginOperation operation : info.getOperations()) {
                            if (!operation.getId().equals("PARAMETER")) continue;
                            command = operation.getCommand();
                            command = command.replaceAll("\\{solution\\}", URLEncoder.encode(solution, "UTF-8"));
                            command = command.replaceAll("\\{path\\}", URLEncoder.encode(path, "UTF-8"));
                            command = command.replaceAll("\\{name\\}", URLEncoder.encode(name, "UTF-8"));
                            paramUrl = contextPath + command;
                            break;
                        }
                        if (StringUtil.isEmpty(paramUrl)) ** GOTO lbl165
                        child.setAttribute("param-service-url", paramUrl);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
lbl165:
                // 7 sources

                if (fileInfo != null) {
                    if ("none".equals(fileInfo.getDisplayType())) {
                        child.setAttribute("visible", "false");
                    } else {
                        child.setAttribute("visible", "true");
                    }
                } else {
                    try {
                        visible = "none".equals(repository.getLocalizedFileProperty(file, "documentation/result-type", 1)) != false ? "false" : "true";
                        child.setAttribute("visible", visible == null || "".equals(visible) != false || "true".equals(visible) != false ? "true" : "false");
                    }
                    catch (Exception e) {
                        child.setAttribute("visible", "true");
                    }
                }
                try {
                    localizedName = null;
                    localizedName = name.endsWith(".url") != false ? repository.getLocalizedFileProperty(file, "url_name", 1) : (fileInfo != null ? fileInfo.getTitle() : repository.getLocalizedFileProperty(file, "title", 1));
                    child.setAttribute("localized-name", localizedName == null || "".equals(localizedName) != false ? name : localizedName);
                }
                catch (Exception e) {
                    child.setAttribute("localized-name", name);
                }
                try {
                    if (name.endsWith(".url")) {
                        url_description = repository.getLocalizedFileProperty(file, "url_description", 1);
                        description = repository.getLocalizedFileProperty(file, "description", 1);
                        if (url_description == null && description == null) {
                            child.setAttribute("description", name);
                        } else {
                            child.setAttribute("description", url_description == null || "".equals(url_description) != false ? description : url_description);
                        }
                    } else if (name.endsWith(".xaction")) {
                        description = repository.getLocalizedFileProperty(file, "description", 1);
                        child.setAttribute("description", description == null || "".equals(description) != false ? name : description);
                    } else if (fileInfo != null) {
                        child.setAttribute("description", fileInfo.getDescription());
                    } else {
                        child.setAttribute("description", name);
                    }
                }
                catch (Exception e) {
                    child.setAttribute("description", "xxxxxxx");
                }
                child.setAttribute("name", name);
                child.setAttribute("isDirectory", "" + file.isDirectory());
                child.setAttribute("lastModifiedDate", "" + file.getLastModified());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            finally {
                IOUtils.closeQuietly(pluginInputStream);
            }
        }
    }

    public Document getSolutionRepositoryDoc(IPentahoSession session, String[] filters) throws ParserConfigurationException {
        ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
        Document document = null;
        if (cacheManager != null && cacheManager.cacheEnabled("repository-service-cache")) {
            document = (Document)cacheManager.getFromRegionCache("repository-service-cache", (Object)(session.getName() + LocaleHelper.getLocale()));
        }
        if (document == null) {
            ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            ISolutionFile rootFile = repository.getRootFolder(1);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("repository");
            document.appendChild(root);
            root.setAttribute("path", rootFile.getFullPath());
            root.setAttribute("product-id", VersionHelper.getVersionInfo().getProductID());
            root.setAttribute("version-major", VersionHelper.getVersionInfo().getVersionMajor());
            root.setAttribute("version-minor", VersionHelper.getVersionInfo().getVersionMinor());
            root.setAttribute("version-relase", VersionHelper.getVersionInfo().getVersionRelease());
            root.setAttribute("version-milestone", VersionHelper.getVersionInfo().getVersionMilestone());
            root.setAttribute("version-build", VersionHelper.getVersionInfo().getVersionBuild());
            boolean isAdministrator = SecurityHelper.isPentahoAdministrator((IPentahoSession)session);
            this.processRepositoryFile(session, isAdministrator, repository, root, rootFile, filters);
            if (cacheManager != null && cacheManager.cacheEnabled("repository-service-cache")) {
                cacheManager.putInRegionCache("repository-service-cache", (Object)(session.getName() + LocaleHelper.getLocale()), (Object)document);
            }
        }
        return document;
    }

    public Document getSolutionRepositoryFileDetails(IPentahoSession session, String fullPath) throws ParserConfigurationException {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
        ISolutionFile rootFile = repository.getSolutionFile(fullPath, 1);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        boolean isAdministrator = SecurityHelper.isPentahoAdministrator((IPentahoSession)session);
        this.processRepositoryFile(session, isAdministrator, repository, document, rootFile, new String[0]);
        return document;
    }

    private Map<IPermissionRecipient, IPermissionMask> createAclFromXml(String strXml) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SolutionRepositoryServiceImpl.getSAXParserFactory().newSAXParser();
        HashMap<IPermissionRecipient, IPermissionMask> m = new HashMap<IPermissionRecipient, IPermissionMask>();
        AclParserHandler h = new AclParserHandler(m);
        String encoding = XmlHelper.getEncoding((String)strXml);
        ByteArrayInputStream is = new ByteArrayInputStream(strXml.getBytes(encoding));
        parser.parse((InputStream)is, (DefaultHandler)h);
        return m;
    }

    public void setAcl(String solution, String path, String filename, String strAclXml, IPentahoSession userSession) throws SolutionRepositoryServiceException, IOException, PentahoAccessControlException {
        String fullPath;
        if (StringUtil.doesPathContainParentPathSegment((String)solution) || StringUtil.doesPathContainParentPathSegment((String)path)) {
            String msg = Messages.getString((String)"AdhocWebService.ERROR_0008_MISSING_OR_INVALID_REPORT_NAME");
            throw new SolutionRepositoryServiceException(msg);
        }
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        ISolutionFile solutionFile = repository.getSolutionFile(fullPath = ActionInfo.buildSolutionPath((String)solution, (String)path, (String)filename), 32);
        if (solutionFile instanceof IAclSolutionFile) {
            Map<IPermissionRecipient, IPermissionMask> acl;
            try {
                acl = this.createAclFromXml(strAclXml);
            }
            catch (ParserConfigurationException e) {
                throw new SolutionRepositoryServiceException("ParserConfigurationException", (Throwable)e);
            }
            catch (SAXException e) {
                throw new SolutionRepositoryServiceException("SAXException", (Throwable)e);
            }
            catch (IOException e) {
                throw new SolutionRepositoryServiceException("IOException", (Throwable)e);
            }
            repository.setPermissions(solutionFile, acl);
        }
    }

    public String getAclXml(String solution, String path, String filename, IPentahoSession userSession) throws SolutionRepositoryServiceException, IOException {
        if (StringUtil.doesPathContainParentPathSegment((String)solution) || StringUtil.doesPathContainParentPathSegment((String)path)) {
            String msg = Messages.getString((String)"AdhocWebService.ERROR_0008_MISSING_OR_INVALID_REPORT_NAME");
            throw new SolutionRepositoryServiceException(msg);
        }
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        String fullPath = ActionInfo.buildSolutionPath((String)solution, (String)path, (String)filename);
        ISolutionFile solutionFile = repository.getSolutionFile(fullPath, 1);
        String strXml = null;
        if (solutionFile instanceof IAclSolutionFile) {
            Map filePermissions = repository.getPermissions(solutionFile);
            strXml = this.getAclAsXml(filePermissions);
        } else {
            strXml = "<acl notsupported='true'/>";
        }
        return strXml;
    }

    private String getAclAsXml(Map<IPermissionRecipient, IPermissionMask> filePermissions) {
        StringBuffer sb = new StringBuffer(XmlHelper.createXmlProcessingInstruction((String)RESPONSE_DOCUMENT_VERSION_NUM, (String)"UTF-8"));
        sb.append("<acl>");
        for (Map.Entry<IPermissionRecipient, IPermissionMask> filePerm : filePermissions.entrySet()) {
            IPermissionRecipient permRecipient = filePerm.getKey();
            if (permRecipient instanceof SimpleRole) {
                sb.append("<entry role='" + permRecipient.getName() + "' permissions='" + filePerm.getValue().getMask() + "'/>");
                continue;
            }
            sb.append("<entry user='" + permRecipient.getName() + "' permissions='" + filePerm.getValue().getMask() + "'/>");
        }
        sb.append("</acl>");
        return sb.toString();
    }

    protected static SAXParserFactory getSAXParserFactory() {
        SAXParserFactory threadLocalSAXParserFactory = SAX_FACTORY.get();
        if (null == threadLocalSAXParserFactory) {
            threadLocalSAXParserFactory = SAXParserFactory.newInstance();
            SAX_FACTORY.set(threadLocalSAXParserFactory);
        }
        return threadLocalSAXParserFactory;
    }

    static {
        ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
        if (!cacheManager.cacheEnabled("repository-service-cache")) {
            cacheManager.addCacheRegion("repository-service-cache");
        }
    }

    protected class PluginFileInputStream
    extends InputStream {
        private ISolutionRepository repository;
        private ISolutionFile file;
        private InputStream inputStream;
        private final String relativePath;

        public PluginFileInputStream(ISolutionRepository repository, ISolutionFile file) {
            this.repository = repository;
            this.file = file;
            this.relativePath = file.getSolutionPath() + "/" + file.getFileName();
        }

        public int read() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = this.repository.getResourceInputStream(this.relativePath, true, 1);
            }
            return this.inputStream.read();
        }

        public int read(byte[] b) throws IOException {
            if (this.inputStream == null) {
                this.inputStream = this.repository.getResourceInputStream(this.relativePath, true, 1);
            }
            return this.inputStream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.inputStream == null) {
                this.inputStream = this.repository.getResourceInputStream(this.relativePath, true, 1);
            }
            return this.inputStream.read(b, off, len);
        }

        public synchronized void mark(int readlimit) {
            if (this.inputStream != null) {
                this.inputStream.mark(readlimit);
            }
        }

        public boolean markSupported() {
            if (this.inputStream != null) {
                return this.inputStream.markSupported();
            }
            return super.markSupported();
        }

        public synchronized void reset() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.reset();
            }
            super.reset();
        }

        public long skip(long n) throws IOException {
            if (this.inputStream != null) {
                this.inputStream.skip(n);
            }
            return super.skip(n);
        }

        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }

        public int available() throws IOException {
            if (this.inputStream != null) {
                return this.inputStream.available();
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AclParserHandler
    extends DefaultHandler {
        Map<IPermissionRecipient, IPermissionMask> acl;

        public AclParserHandler(Map<IPermissionRecipient, IPermissionMask> acl) {
            this.acl = acl;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("entry")) {
                String permissions = attributes.getValue("", "permissions");
                Object permRecipient = null;
                String user = attributes.getValue("", "user");
                permRecipient = null != user ? new SimpleUser(user) : new SimpleRole(attributes.getValue("", "role"));
                this.acl.put((IPermissionRecipient)permRecipient, (IPermissionMask)new SimplePermissionMask(Integer.parseInt(permissions)));
            }
        }
    }
}

