/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution;

import java.io.InputStream;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginOperation;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.solution.SolutionRepositoryServiceImpl;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SolutionRepositoryServiceImplFast
extends SolutionRepositoryServiceImpl {
    private static final String REPOSITORY_SERVICE_FILEINFO_CACHE_REGION = "repository-service-fileinfo-cache";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processRepositoryFile(IPentahoSession session, boolean isAdministrator, ISolutionRepository repository, Node parentNode, ISolutionFile file, String[] filters) {
        String name = file.getFileName();
        if (name.startsWith("system") || name.startsWith("tmp") || name.startsWith(".")) {
            return;
        }
        if (!this.accept(isAdministrator, repository, file)) {
            return;
        }
        if (file.isDirectory()) {
            ISolutionFile[] children;
            if (repository.getRootFolder(1).getFullPath().equals(file.getFullPath())) {
                ISolutionFile[] children2;
                for (ISolutionFile childSolutionFile : children2 = file.listFiles()) {
                    this.processRepositoryFile(session, isAdministrator, repository, parentNode, childSolutionFile, filters);
                }
                return;
            }
            Element child = null;
            String key = file.getFullPath() + file.getLastModified() + LocaleHelper.getLocale();
            ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
            if (cacheManager != null && cacheManager.cacheEnabled(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION)) {
                child = (Element)cacheManager.getFromRegionCache(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION, (Object)key);
            }
            if (child == null) {
                child = parentNode instanceof Document ? ((Document)parentNode).createElement("file") : parentNode.getOwnerDocument().createElement("file");
                try {
                    String localizedName = repository.getLocalizedFileProperty(file, "name", 1);
                    child.setAttribute("localized-name", localizedName == null || "".equals(localizedName) ? name : localizedName);
                }
                catch (Exception e) {
                    child.setAttribute("localized-name", name);
                }
                try {
                    String visible = repository.getLocalizedFileProperty(file, "visible", 1);
                    child.setAttribute("visible", visible == null || "".equals(visible) ? "false" : visible);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    child.setAttribute("visible", "false");
                }
                String description = repository.getLocalizedFileProperty(file, "description", 1);
                child.setAttribute("description", description == null || "".equals(description) ? name : description);
                child.setAttribute("name", name);
                child.setAttribute("isDirectory", "true");
                child.setAttribute("lastModifiedDate", "" + file.getLastModified());
                if (cacheManager != null && cacheManager.cacheEnabled(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION)) {
                    cacheManager.putInRegionCache(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION, (Object)key, (Object)child);
                }
            } else {
                Element newChild = parentNode instanceof Document ? ((Document)parentNode).createElement("file") : parentNode.getOwnerDocument().createElement("file");
                NamedNodeMap attributes = child.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    newChild.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
                }
                child = newChild;
            }
            parentNode.appendChild(child);
            for (ISolutionFile childSolutionFile : children = file.listFiles()) {
                this.processRepositoryFile(session, isAdministrator, repository, child, childSolutionFile, filters);
            }
            return;
        }
        SolutionRepositoryServiceImpl.PluginFileInputStream pluginInputStream = null;
        try {
            int lastPoint = name.lastIndexOf(46);
            String extension = "";
            if (lastPoint != -1) {
                extension = name.substring(lastPoint + 1).toLowerCase();
            }
            boolean addFile = this.acceptFilter(name, filters) || "xaction".equals(extension) || "url".equals(extension);
            boolean isPlugin = false;
            IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)session);
            if (pluginManager != null) {
                Set types = pluginManager.getContentTypes();
                isPlugin = types != null && types.contains(extension);
                addFile |= isPlugin;
            }
            if (!addFile) return;
            ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
            Element child = null;
            String key = file.getFullPath() + file.getLastModified() + LocaleHelper.getLocale();
            if (cacheManager != null && cacheManager.cacheEnabled(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION)) {
                child = (Element)cacheManager.getFromRegionCache(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION, (Object)key);
            }
            if (child == null) {
                Element element = child = parentNode instanceof Document ? ((Document)parentNode).createElement("file") : parentNode.getOwnerDocument().createElement("file");
                if (cacheManager != null && cacheManager.cacheEnabled(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION)) {
                    cacheManager.putInRegionCache(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION, (Object)key, (Object)child);
                }
            } else {
                Element newChild = parentNode instanceof Document ? ((Document)parentNode).createElement("file") : parentNode.getOwnerDocument().createElement("file");
                NamedNodeMap attributes = child.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    newChild.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
                }
                parentNode.appendChild(newChild);
                return;
            }
            parentNode.appendChild(child);
            IFileInfo fileInfo = null;
            try {
                String visible = "none".equals(repository.getLocalizedFileProperty(file, "documentation/result-type", 1)) ? "false" : "true";
                child.setAttribute("visible", visible == null || "".equals(visible) || "true".equals(visible) ? "true" : "false");
            }
            catch (Exception e) {
                child.setAttribute("visible", "true");
            }
            if (!name.endsWith(".xaction")) {
                if (name.endsWith(".url")) {
                    String props = new String(file.getData());
                    StringTokenizer tokenizer = new StringTokenizer(props, "\n");
                    while (tokenizer.hasMoreTokens()) {
                        String line = tokenizer.nextToken();
                        int pos = line.indexOf(61);
                        if (pos <= 0) continue;
                        String propname = line.substring(0, pos);
                        String value = line.substring(pos + 1);
                        if (value != null && value.length() > 0 && value.charAt(value.length() - 1) == '\r') {
                            value = value.substring(0, value.length() - 1);
                        }
                        if (!"URL".equalsIgnoreCase(propname)) continue;
                        child.setAttribute("url", value);
                    }
                } else if (isPlugin) {
                    try {
                        int pos;
                        pluginInputStream = new SolutionRepositoryServiceImpl.PluginFileInputStream(repository, file);
                        fileInfo = pluginManager.getFileInfo(extension, session, file, (InputStream)pluginInputStream);
                        String handlerId = pluginManager.getContentGeneratorIdForType(extension, session);
                        String fileUrl = pluginManager.getContentGeneratorUrlForType(extension, session);
                        String solution = file.getSolutionPath();
                        String path = "";
                        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
                        String contextPath = requestContext.getContextPath();
                        if (solution.startsWith("/")) {
                            solution = solution.substring(1);
                        }
                        if ((pos = solution.indexOf(47)) != -1) {
                            path = solution.substring(pos + 1);
                            solution = solution.substring(0, pos);
                        }
                        String url = null;
                        if (!"".equals(fileUrl)) {
                            url = contextPath + fileUrl + "?solution=" + solution + "&path=" + path + "&action=" + name;
                        } else {
                            IContentInfo info = pluginManager.getContentInfoFromExtension(extension, session);
                            for (IPluginOperation operation : info.getOperations()) {
                                if (!operation.getId().equalsIgnoreCase("RUN")) continue;
                                String command = operation.getCommand();
                                command = command.replaceAll("\\{solution\\}", solution);
                                command = command.replaceAll("\\{path\\}", path);
                                command = command.replaceAll("\\{name\\}", name);
                                url = contextPath + command;
                                break;
                            }
                            if (url == null) {
                                url = contextPath + "content/" + handlerId + "?solution=" + solution + "&path=" + path + "&action=" + name;
                            }
                        }
                        child.setAttribute("url", url);
                        String paramServiceUrl = contextPath + "content/" + handlerId + "?solution=" + solution + "&path=" + path + "&action=" + name;
                        child.setAttribute("param-service-url", paramServiceUrl);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            try {
                String localizedName = null;
                localizedName = name.endsWith(".url") ? repository.getLocalizedFileProperty(file, "url_name", 1) : (fileInfo != null ? fileInfo.getTitle() : repository.getLocalizedFileProperty(file, "title", 1));
                child.setAttribute("localized-name", localizedName == null || "".equals(localizedName) ? name : localizedName);
            }
            catch (Exception e) {
                child.setAttribute("localized-name", name);
            }
            try {
                if (name.endsWith(".url")) {
                    String url_description = repository.getLocalizedFileProperty(file, "url_description", 1);
                    String description = repository.getLocalizedFileProperty(file, "description", 1);
                    if (url_description == null && description == null) {
                        child.setAttribute("description", name);
                    } else {
                        child.setAttribute("description", url_description == null || "".equals(url_description) ? description : url_description);
                    }
                } else if (name.endsWith(".xaction")) {
                    String description = repository.getLocalizedFileProperty(file, "description", 1);
                    child.setAttribute("description", description == null || "".equals(description) ? name : description);
                } else if (fileInfo != null) {
                    child.setAttribute("description", fileInfo.getDescription());
                } else {
                    child.setAttribute("description", name);
                }
            }
            catch (Exception e) {
                child.setAttribute("description", "xxxxxxx");
            }
            child.setAttribute("name", name);
            child.setAttribute("isDirectory", "" + file.isDirectory());
            child.setAttribute("lastModifiedDate", "" + file.getLastModified());
            return;
        }
        finally {
            IOUtils.closeQuietly(pluginInputStream);
        }
    }

    static {
        ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
        if (!cacheManager.cacheEnabled("repository-service-cache")) {
            cacheManager.addCacheRegion("repository-service-cache");
        }
        if (!cacheManager.cacheEnabled(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION)) {
            cacheManager.addCacheRegion(REPOSITORY_SERVICE_FILEINFO_CACHE_REGION);
        }
    }
}

