/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.dbbased;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IAclHolder;
import org.pentaho.platform.api.engine.IAclPublisher;
import org.pentaho.platform.api.engine.IAclSolutionFile;
import org.pentaho.platform.api.engine.IAclVoter;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoAclEntry;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPermissionMask;
import org.pentaho.platform.api.engine.IPermissionRecipient;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.ISolutionAttributeContributor;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFilter;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.api.repository.RepositoryException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.security.SimplePermissionMask;
import org.pentaho.platform.engine.security.SimpleRole;
import org.pentaho.platform.engine.security.SimpleSession;
import org.pentaho.platform.engine.security.SpringSecurityPermissionMgr;
import org.pentaho.platform.engine.services.actionsequence.SequenceDefinition;
import org.pentaho.platform.engine.services.solution.SolutionReposHelper;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.solution.SolutionRepositoryBase;
import org.pentaho.platform.repository.solution.dbbased.DbRepositoryClassLoader;
import org.pentaho.platform.repository.solution.dbbased.InfoHolder;
import org.pentaho.platform.repository.solution.dbbased.RepositoryFile;
import org.pentaho.platform.repository.solution.dbbased.RepositoryUpdateHelper;
import org.pentaho.platform.util.FileHelper;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.xml.XmlHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbBasedSolutionRepository
extends SolutionRepositoryBase
implements IPentahoInitializer {
    private static final long serialVersionUID = -8270135463210017284L;
    private static final String BREAD_CRUMBS_TAG = "breadcrumbs/";
    private ISolutionAttributeContributor defaultSolutionAtributeContributor = new DefaultSolutionAttributeContributor();
    private ISolutionFilter defaultSolutionFilter = new DefaultSolutionFilter();
    private String repositoryName;
    private RepositoryFile rootDirectory;
    private static final byte[] lock = new byte[0];
    private boolean repositoryInit = false;

    public DbBasedSolutionRepository() {
        this.init();
    }

    @Override
    public void init() {
        if (!this.repositoryInit) {
            super.init();
            String reposName = PentahoSystem.getSystemSetting((String)"solution-repository/db-repository-name", null);
            if (reposName != null) {
                this.setRepositoryName(reposName);
                SolutionRepositoryBase.logger.info((Object)Messages.getString("SolutionRepository.WARN_0002_USING_SOLUTION_NAME", this.getRepositoryName()));
            } else {
                SolutionRepositoryBase.logger.info((Object)Messages.getString("SolutionRepository.WARN_0001_UNDEFINED_SOLUTION_NAME"));
            }
            RepositoryFile root = (RepositoryFile)this.internalGetRootFolder();
            if (root == null) {
                String path = PentahoSystem.getApplicationContext().getSolutionPath("");
                this.loadSolutionFromFileSystem(this.getSession(), path, true);
                root = (RepositoryFile)this.internalGetRootFolder();
            }
            this.repositoryInit = true;
        }
    }

    public IActionSequence getActionSequence(String solutionName, String actionPath, String sequenceName, int localLoggingLevel, int actionOperation) {
        String action = this.buildDirectoryPath(solutionName, actionPath, sequenceName);
        if (action == null || action.length() == 0) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0008_ACTION_SEQUENCE_NAME_INVALID"));
            return null;
        }
        Document actionSequenceDocument = this.getSolutionDocument(action, actionOperation);
        if (actionSequenceDocument == null) {
            return null;
        }
        IActionSequence actionSequence = SequenceDefinition.ActionSequenceFactory((Document)actionSequenceDocument, (String)sequenceName, (String)actionPath, (String)solutionName, (ILogger)this, (IApplicationContext)PentahoSystem.getApplicationContext(), (int)localLoggingLevel);
        if (actionSequence == null) {
            return null;
        }
        return actionSequence;
    }

    public boolean hasAccess(ISolutionFile aFile, int actionOperation) {
        if (aFile instanceof IAclSolutionFile) {
            return SecurityHelper.hasAccess((IAclSolutionFile)((IAclSolutionFile)aFile), (int)actionOperation, (IPentahoSession)this.getSession());
        }
        return true;
    }

    protected boolean isPentahoAdministrator() {
        return SecurityHelper.isPentahoAdministrator((IPentahoSession)this.getSession());
    }

    public Document getSolutionDocument(String documentPath, int actionOperation) {
        ISolutionFile file = (ISolutionFile)this.getRepositoryObjectFromCache(documentPath);
        if (file == null) {
            file = this.getFileByPath(documentPath, actionOperation);
            if (file != null) {
                this.putRepositoryObjectInCache(documentPath, file);
            } else {
                SolutionRepositoryBase.logger.info((Object)Messages.getString("SolutionRepository.INFO_0010_DOCUMENT_NOT_FOUND", documentPath));
                return null;
            }
        }
        Document document = null;
        if (file.getData() != null) {
            try {
                document = XmlDom4JHelper.getDocFromString((String)new String(file.getData()), (EntityResolver)this.getResourceLoader());
            }
            catch (Throwable t) {
                this.error(Messages.getErrorString("SolutionRepository.ERROR_0017_INVALID_XML_DOCUMENT", documentPath), t);
                return null;
            }
        } else {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0019_NO_DATA_IN_FILE", file.getFileName()));
            return null;
        }
        if (document == null && file != null && file.getData() != null) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0009_INVALID_DOCUMENT", documentPath));
            return null;
        }
        this.localizeDoc((Node)document, file);
        return document;
    }

    public void reloadSolutionRepository(IPentahoSession localSession, int localLoggingLevel) {
        this.loggingLevel = localLoggingLevel;
        String path = PentahoSystem.getApplicationContext().getSolutionPath("");
        DbRepositoryClassLoader.clearResourceCache();
        this.loadSolutionFromFileSystem(localSession, path, true);
    }

    private void loadSolutionPath(String solutionName, String path, int localLoggingLevel) {
        this.loggingLevel = localLoggingLevel;
        if (this.isCachingAvailable()) {
            String localDirStr = this.buildDirectoryPath(solutionName, path, null);
            Document repository = DocumentHelper.createDocument();
            Element rootNode = null;
            RepositoryFile directory = (RepositoryFile)this.getFileByPath(localDirStr, 1);
            if (directory == null) {
                return;
            }
            if (directory.isRoot()) {
                rootNode = repository.addElement("repository");
                Document indexDoc = this.getSolutionDocument(directory.getFullPath() + '/' + "index.xml", 1);
                if (indexDoc != null) {
                    this.addIndexToRepository(indexDoc, directory, rootNode, path, solutionName);
                }
                this.processDir(rootNode, directory, solutionName, 1, 2);
            } else {
                Element filesNode = repository.addElement("files");
                rootNode = filesNode.addElement("file");
                rootNode.addAttribute("type", "FILE.FOLDER");
                rootNode.addElement("path").setText(path != null ? path : "");
                Document indexDoc = this.getSolutionDocument(directory.getFullPath() + '/' + "index.xml", 1);
                if (indexDoc != null) {
                    this.addIndexToRepository(indexDoc, directory, rootNode, path, solutionName);
                }
                this.processDir(rootNode, directory, solutionName, 1, 2);
                filesNode.addElement("location").setText(this.getPathNames(solutionName, path) + '/');
            }
            this.putRepositoryObjectInCache(localDirStr + this.getLocale().toString(), repository);
        }
    }

    @Override
    protected String buildDirectoryPath(String solution, String path, String action) {
        String localDirStr = this.repositoryName;
        if (solution != null && solution.length() > 0) {
            localDirStr = localDirStr + solution;
            if (path != null && path.length() > 0) {
                localDirStr = localDirStr + '/';
                localDirStr = localDirStr + path;
            }
        }
        if (action != null && action.length() > 0) {
            String seperator = new String() + '/';
            if (!localDirStr.endsWith(seperator)) {
                localDirStr = localDirStr + '/';
            }
            localDirStr = localDirStr + action;
        }
        return localDirStr;
    }

    private Document getCachedSolutionDocument(String solutionName, String pathName, int actionOperation) {
        if (actionOperation == 1) {
            String localDirStr = this.buildDirectoryPath(solutionName, pathName, null);
            Object cachedRepo = this.getRepositoryObjectFromCache(localDirStr + this.getLocale().toString());
            if (cachedRepo == null) {
                this.loadSolutionPath(solutionName, pathName, this.loggingLevel);
                cachedRepo = this.getRepositoryObjectFromCache(localDirStr + this.getLocale().toString());
            }
            return (Document)cachedRepo;
        }
        return null;
    }

    protected void processDir(Element parentNode, RepositoryFile parentDir, String solutionId, int actionOperation, int recurseLevels) {
        RepositoryFile[] files;
        if (recurseLevels <= 0) {
            return;
        }
        for (RepositoryFile element : files = parentDir.listRepositoryFiles()) {
            if (element.isDirectory()) continue;
            String fileName = element.getFileName();
            this.processFile(fileName, element, parentNode, solutionId, actionOperation);
        }
        for (RepositoryFile element : files) {
            String thisSolution;
            if (!element.isDirectory() || element.getFileName().equalsIgnoreCase("system") || element.getFileName().equalsIgnoreCase("CVS") || element.getFileName().equalsIgnoreCase(".svn")) continue;
            Element dirNode = parentNode.addElement("file");
            dirNode.addAttribute("type", "FILE.FOLDER");
            this.defaultSolutionAtributeContributor.contributeAttributes((ISolutionFile)element, dirNode);
            String path = this.getSolutionPath(element);
            if (solutionId == null) {
                thisSolution = this.getSolutionId(element);
            } else {
                thisSolution = solutionId;
                dirNode.addElement("path").setText(path);
            }
            Document indexDoc = this.getSolutionDocument(element.getFullPath() + '/' + "index.xml", actionOperation);
            if (indexDoc != null) {
                this.addIndexToRepository(indexDoc, element, dirNode, path, thisSolution);
            } else {
                dirNode.addAttribute("visible", "false");
                String dirName = element.getFileName();
                dirNode.addAttribute("name", XmlHelper.encode((String)dirName));
                dirNode.addElement("title").setText(dirName);
            }
            this.processDir(dirNode, element, thisSolution, actionOperation, recurseLevels - 1);
        }
    }

    protected void processFile(String fileName, RepositoryFile element, Element parentNode, String solutionId, int actionOperation) {
        if (fileName.equals("Entries") || fileName.equals("Repository") || fileName.equals("Root")) {
            return;
        }
        int lastPoint = fileName.lastIndexOf(46);
        if (lastPoint == -1) {
            return;
        }
        String extension = fileName.substring(lastPoint + 1).toLowerCase();
        if (fileName.toLowerCase().endsWith(".url") && this.hasAccess(element, actionOperation)) {
            this.addUrlToRepository(element, parentNode);
            return;
        }
        boolean addFile = "xaction".equals(extension);
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)this.getSession());
        if (pluginManager != null) {
            Set types = pluginManager.getContentTypes();
            addFile |= types != null && types.contains(extension);
        }
        if (!addFile) {
            return;
        }
        String path = this.getSolutionPath(element);
        if (fileName.toLowerCase().endsWith(".xaction")) {
            this.info(Messages.getString("SolutionRepository.DEBUG_ADDING_ACTION", fileName));
            IActionSequence actionSequence = this.getActionSequence(solutionId, path, fileName, this.loggingLevel, actionOperation);
            if (actionSequence == null) {
                if (!(solutionId != null && solutionId.length() != 0 || path != null && path.length() != 0)) {
                    this.info(Messages.getString("SolutionRepository.INFO_0008_NOT_ADDED", fileName));
                } else {
                    this.error(Messages.getErrorString("SolutionRepository.ERROR_0006_INVALID_SEQUENCE_DOCUMENT", fileName));
                }
            } else {
                this.addToRepository(actionSequence, parentNode, element);
            }
        } else if (pluginManager != null) {
            String fullPath = solutionId + '/' + (StringUtil.isEmpty((String)path) ? "" : path + '/') + fileName;
            try {
                IFileInfo fileInfo = this.getFileInfo(solutionId, path, fileName, extension, pluginManager, actionOperation);
                this.addToRepository(fileInfo, solutionId, path, fileName, parentNode, element);
            }
            catch (Exception e) {
                this.error(Messages.getErrorString("SolutionRepository.ERROR_0021_FILE_NOT_ADDED", fullPath), e);
            }
        }
    }

    private void addToRepository(IFileInfo info, String solution, String path, String fileName, Element parentNode, RepositoryFile file) {
        String displayType;
        Element dirNode = parentNode.addElement("file");
        dirNode.addAttribute("type", "FILE.ACTIVITY");
        dirNode.addElement("filename").setText(fileName);
        dirNode.addElement("path").setText(path);
        dirNode.addElement("solution").setText(solution);
        dirNode.addElement("title").setText(info.getTitle());
        String description = info.getDescription();
        if (description == null) {
            dirNode.addElement("description");
        } else {
            dirNode.addElement("description").setText(description);
        }
        String author = info.getAuthor();
        if (author == null) {
            dirNode.addElement("author");
        } else {
            dirNode.addElement("author").setText(author);
        }
        String iconPath = info.getIcon();
        if (iconPath != null && !iconPath.equals("")) {
            String rolloverIconPath = null;
            int rolloverIndex = iconPath.indexOf("|");
            if (rolloverIndex > -1) {
                rolloverIconPath = iconPath.substring(rolloverIndex + 1);
                iconPath = iconPath.substring(0, rolloverIndex);
            }
            if (this.publishIcon(file.retrieveParent().getFullPath(), iconPath)) {
                dirNode.addElement("icon").setText("getImage?image=icons/" + iconPath);
            } else {
                dirNode.addElement("icon").setText(info.getIcon());
            }
            if (rolloverIconPath != null) {
                if (this.publishIcon(PentahoSystem.getApplicationContext().getSolutionPath(solution + File.separator + path), rolloverIconPath)) {
                    dirNode.addElement("rollovericon").setText("getImage?image=icons/" + rolloverIconPath);
                } else {
                    dirNode.addElement("rollovericon").setText(rolloverIconPath);
                }
            }
        }
        if ((displayType = info.getDisplayType()) == null || "none".equalsIgnoreCase(displayType)) {
            dirNode.addAttribute("visible", "false");
        } else {
            dirNode.addAttribute("visible", "true");
            dirNode.addAttribute("displaytype", displayType);
        }
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getSession());
        boolean subscribable = false;
        if (subscriptionRepository != null) {
            subscribable = subscriptionRepository.getContentByActionReference(solution + '/' + path + '/' + fileName) != null;
        }
        dirNode.addElement("properties").setText("subscribable=" + Boolean.toString(subscribable));
    }

    protected String getSolutionId(RepositoryFile file) {
        String path = file.getFullPath();
        if (path.length() < this.repositoryName.length()) {
            return "";
        }
        if ((path = path.substring(this.repositoryName.length())).indexOf(47) != -1) {
            path = path.substring(0, path.indexOf(47));
        }
        return path;
    }

    protected String getSolutionPath(RepositoryFile file) {
        String path = file.getFullPath();
        try {
            path = path.substring(this.repositoryName.length());
            if (!file.isDirectory()) {
                path = path.substring(0, path.lastIndexOf(47));
            }
            if (path.indexOf(47) == -1) {
                return "";
            }
            path = path.substring(path.indexOf(47) + 1);
        }
        catch (StringIndexOutOfBoundsException ex) {
            return "";
        }
        return path;
    }

    protected void addIndexToRepository(Document indexDoc, RepositoryFile directoryFile, Element directoryNode, String path, String solution) {
        if (!directoryFile.isDirectory()) {
            return;
        }
        String dirName = this.getValue(indexDoc, "/index/name", directoryFile.getFileName().replace('_', ' '));
        String description = this.getValue(indexDoc, "/index/description", "");
        String iconPath = this.getValue(indexDoc, "/index/icon", "");
        String displayType = this.getValue(indexDoc, "/index/display-type", "icons");
        boolean visible = this.getValue(indexDoc, "/index/visible", "false").equalsIgnoreCase("true");
        path = XmlHelper.encode((String)path);
        String name = XmlHelper.encode((String)directoryFile.getFileName());
        if (directoryFile.isDirectory() && this.getPathNames(solution, path) == null) {
            this.cacheLocalizedDirectoryName(dirName, directoryFile, solution, path);
        }
        directoryNode.addAttribute("name", name);
        directoryNode.addElement("title").setText(dirName);
        directoryNode.addAttribute("path", path);
        directoryNode.addElement("description").setText(description);
        if (iconPath != null && !iconPath.equals("")) {
            String rolloverIconPath = null;
            int rolloverIndex = iconPath.indexOf("|");
            if (rolloverIndex > -1) {
                rolloverIconPath = iconPath.substring(rolloverIndex + 1);
                iconPath = iconPath.substring(0, rolloverIndex);
            }
            if (this.publishIcon(directoryFile.isDirectory() ? directoryFile.getFullPath() : directoryFile.retrieveParent().getFullPath(), iconPath)) {
                directoryNode.addElement("icon").setText("getImage?image=icons/" + iconPath);
            } else {
                directoryNode.addElement("icon").setText(iconPath);
            }
            if (rolloverIconPath != null) {
                if (this.publishIcon(directoryFile.isDirectory() ? directoryFile.getFullPath() : directoryFile.retrieveParent().getFullPath(), rolloverIconPath)) {
                    directoryNode.addElement("rollovericon").setText("getImage?image=icons/" + rolloverIconPath);
                } else {
                    directoryNode.addElement("rollovericon").setText(rolloverIconPath);
                }
            }
        }
        Boolean visability = null;
        boolean hasAccess = SecurityHelper.hasAccess((IAclSolutionFile)directoryFile, (int)1, (IPentahoSession)this.getSession());
        visability = !hasAccess ? new Boolean(false) : new Boolean(visible);
        directoryNode.addAttribute("visible", visability.toString());
        directoryNode.addAttribute("displaytype", displayType);
        if (solution != null && solution.length() > 0) {
            directoryNode.addElement("solution").setText(solution);
        } else {
            directoryNode.addElement("solution").setText(this.getSolutionId(directoryFile));
        }
    }

    private void cacheLocalizedDirectoryName(String localizedPath, RepositoryFile directoryFile, String solution, String path) {
        if (directoryFile.isRoot()) {
            this.putRepositoryObjectInCache(BREAD_CRUMBS_TAG + this.buildDirectoryPath(solution, path, null), localizedPath);
        } else {
            String localizedAncestors = (String)this.getRepositoryObjectFromCache(BREAD_CRUMBS_TAG + directoryFile.retrieveParent().getFullPath());
            if (localizedAncestors != null) {
                localizedPath = localizedAncestors + '/' + localizedPath;
                this.putRepositoryObjectInCache(BREAD_CRUMBS_TAG + this.buildDirectoryPath(solution, path, null), localizedPath);
            } else {
                Document indexDoc = this.getSolutionDocument(directoryFile.retrieveParent().getFullPath() + '/' + "index.xml", 1);
                localizedPath = indexDoc == null ? directoryFile.retrieveParent().getFileName() + '/' + localizedPath : this.getValue(indexDoc, "/index/name", directoryFile.retrieveParent().getFileName().replace('_', ' ')) + '/' + localizedPath;
                this.cacheLocalizedDirectoryName(localizedPath, (RepositoryFile)directoryFile.retrieveParent(), solution, path);
            }
        }
    }

    protected void addUrlToRepository(RepositoryFile file, Element parentNode) {
        String urlContent = new String(file.getData());
        StringTokenizer tokenizer = new StringTokenizer(urlContent, "\n");
        String url = null;
        String title = file.getFileName();
        String description = null;
        String iconPath = null;
        String target = null;
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            int pos = line.indexOf(61);
            if (pos <= 0) continue;
            String name = line.substring(0, pos);
            String value = line.substring(pos + 1);
            if (value != null && value.length() > 0 && value.charAt(value.length() - 1) == '\r') {
                value = value.substring(0, value.length() - 1);
            }
            if ("URL".equalsIgnoreCase(name)) {
                url = value;
            }
            if ("name".equalsIgnoreCase(name)) {
                title = value;
            }
            if ("description".equalsIgnoreCase(name)) {
                description = value;
            }
            if ("icon".equalsIgnoreCase(name)) {
                iconPath = value;
            }
            if (!"target".equalsIgnoreCase(name)) continue;
            target = value;
        }
        if (url != null) {
            Element dirNode = parentNode.addElement("file");
            dirNode.addAttribute("type", "FILE.URL");
            dirNode.addElement("filename").setText(file.getFileName());
            dirNode.addElement("title").setText(title);
            if (target != null) {
                dirNode.addElement("target").setText(target);
            }
            if (description != null) {
                dirNode.addElement("description").setText(description);
            }
            if (iconPath != null && !iconPath.equals("")) {
                String rolloverIconPath = null;
                int rolloverIndex = iconPath.indexOf("|");
                if (rolloverIndex > -1) {
                    rolloverIconPath = iconPath.substring(rolloverIndex + 1);
                    iconPath = iconPath.substring(0, rolloverIndex);
                }
                if (this.publishIcon(file.retrieveParent().getFullPath(), iconPath)) {
                    dirNode.addElement("icon").setText("getImage?image=icons/" + iconPath);
                } else {
                    dirNode.addElement("icon").setText(iconPath);
                }
                if (rolloverIconPath != null) {
                    if (this.publishIcon(file.retrieveParent().getFullPath(), rolloverIconPath)) {
                        dirNode.addElement("rollovericon").setText("getImage?image=icons/" + rolloverIconPath);
                    } else {
                        dirNode.addElement("rollovericon").setText(rolloverIconPath);
                    }
                }
            }
            dirNode.addElement("url").setText(url);
            dirNode.addAttribute("visible", "true");
            dirNode.addAttribute("displaytype", "url");
            this.localizeDoc((Node)dirNode, file);
        }
    }

    protected void addToRepository(IActionSequence actionSequence, Element parentNode, RepositoryFile file) {
        String displayType;
        Element dirNode = parentNode.addElement("file");
        dirNode.addAttribute("type", "FILE.ACTIVITY");
        this.defaultSolutionAtributeContributor.contributeAttributes((ISolutionFile)file, dirNode);
        if (actionSequence.getSequenceName() == null || actionSequence.getSolutionPath() == null || actionSequence.getSolutionName() == null) {
            this.error(Messages.getString("SolutionRepository.ERROR_0008_ACTION_SEQUENCE_NAME_INVALID"));
            return;
        }
        dirNode.addElement("filename").setText(actionSequence.getSequenceName());
        dirNode.addElement("path").setText(actionSequence.getSolutionPath());
        dirNode.addElement("solution").setText(actionSequence.getSolutionName());
        String title = actionSequence.getTitle();
        if (title == null) {
            dirNode.addElement("title").setText(actionSequence.getSequenceName());
        } else {
            dirNode.addElement("title").setText(title);
        }
        String description = actionSequence.getDescription();
        if (description == null) {
            dirNode.addElement("description");
        } else {
            dirNode.addElement("description").setText(description);
        }
        String author = actionSequence.getAuthor();
        if (author == null) {
            dirNode.addElement("author");
        } else {
            dirNode.addElement("author").setText(author);
        }
        String iconPath = actionSequence.getIcon();
        if (iconPath != null && !iconPath.equals("")) {
            String rolloverIconPath = null;
            int rolloverIndex = iconPath.indexOf("|");
            if (rolloverIndex > -1) {
                rolloverIconPath = iconPath.substring(rolloverIndex + 1);
                iconPath = iconPath.substring(0, rolloverIndex);
            }
            if (this.publishIcon(file.retrieveParent().getFullPath(), iconPath)) {
                dirNode.addElement("icon").setText("getImage?image=icons/" + iconPath);
            } else {
                dirNode.addElement("icon").setText(actionSequence.getIcon());
            }
            if (rolloverIconPath != null) {
                if (this.publishIcon(file.retrieveParent().getFullPath(), rolloverIconPath)) {
                    dirNode.addElement("rollovericon").setText("getImage?image=icons/" + rolloverIconPath);
                } else {
                    dirNode.addElement("rollovericon").setText(rolloverIconPath);
                }
            }
        }
        if ((displayType = actionSequence.getResultType()) == null || "none".equalsIgnoreCase(displayType)) {
            dirNode.addAttribute("visible", "false");
        } else {
            dirNode.addAttribute("visible", "true");
            dirNode.addAttribute("displaytype", displayType);
        }
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getSession());
        boolean subscribable = subscriptionRepository.getContentByActionReference(actionSequence.getSolutionName() + '/' + actionSequence.getSolutionPath() + '/' + actionSequence.getSequenceName()) != null;
        dirNode.addElement("properties").setText("subscribable=" + Boolean.toString(subscribable));
    }

    protected boolean publishIcon(String dirPath, String iconPath) {
        String iconRepositoryPath;
        RepositoryFile iconSource;
        String pathSeperator = new StringBuffer().append('/').toString();
        if (!iconPath.startsWith(pathSeperator)) {
            iconPath = pathSeperator + iconPath;
        }
        if ((iconSource = (RepositoryFile)this.getFileByPath(iconRepositoryPath = dirPath + iconPath, 1)) != null) {
            File tmpDir = this.getFile("system/tmp/icons", true);
            tmpDir.mkdirs();
            File iconDestintation = new File(tmpDir.getAbsoluteFile() + File.separator + iconPath);
            if (iconDestintation.exists()) {
                iconDestintation.delete();
            }
            try {
                FileOutputStream outputStream = new FileOutputStream(iconDestintation);
                outputStream.write(iconSource.getData());
                outputStream.flush();
                outputStream.close();
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public Document getSolutions(String solutionName, String pathName, int actionOperation, boolean visibleOnly) {
        return this.getCachedSolutionDocument(solutionName, pathName, actionOperation);
    }

    private String getPathNames(String solution, String path) {
        String key = BREAD_CRUMBS_TAG + this.buildDirectoryPath(solution, path, null);
        return (String)this.getRepositoryObjectFromCache(key);
    }

    public Document getSolutionTree(int actionOperation) {
        return this.getSolutionTree(actionOperation, this.defaultSolutionFilter);
    }

    public Document getSolutionTree(int actionOperation, ISolutionFilter filter) {
        Document document = DocumentHelper.createDocument();
        this.getRootFolder(actionOperation);
        if (!this.hasAccess(this.rootDirectory, actionOperation)) {
            if (SolutionRepositoryBase.logger.isDebugEnabled()) {
                SolutionRepositoryBase.logger.debug((Object)Messages.getString("SolutionRepository.ACCESS_DENIED", this.rootDirectory.getFullPath(), Integer.toString(actionOperation)));
            }
            return document;
        }
        Element root = document.addElement("tree");
        SolutionReposHelper.processSolutionTree((Element)root, (ISolutionFile)this.rootDirectory, (ISolutionFilter)filter, (int)actionOperation);
        return document;
    }

    public Document getSolutionStructure(int actionOperation) {
        Document document = DocumentHelper.createDocument();
        this.getRootFolder(actionOperation);
        if (this.rootDirectory == null) {
            return null;
        }
        Element root = document.addElement("repository").addAttribute("location", this.rootDirectory.getFullPath());
        SolutionReposHelper.processSolutionStructure((Element)root, (ISolutionFile)this.rootDirectory, (ISolutionFilter)this.defaultSolutionFilter, (int)actionOperation);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchronizeSolutionWithSolutionSource(IPentahoSession pSession) {
        byte[] byArray = lock;
        synchronized (lock) {
            try {
                RepositoryFile solution = (RepositoryFile)this.getRootFolder(1);
                if (solution != null) {
                    HibernateUtil.beginTransaction();
                    HibernateUtil.makeTransient(solution);
                    HibernateUtil.commitTransaction();
                    HibernateUtil.flushSession();
                }
                this.loadSolutionFromFileSystem(pSession, PentahoSystem.getApplicationContext().getSolutionPath(""), true);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            catch (Exception ex) {
                SolutionRepositoryBase.logger.error((Object)ex);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
        }
    }

    public boolean solutionSynchronizationSupported() {
        return true;
    }

    public String resetSolutionFromFileSystem(IPentahoSession pSession) {
        if (this.synchronizeSolutionWithSolutionSource(pSession)) {
            return Messages.getString("SolutionRepository.INFO_0009_RESET_SUCCESS");
        }
        return Messages.getString("SolutionRepository.ERROR_0013_RESET_FAILED", "Error");
    }

    public List loadSolutionFromFileSystem(IPentahoSession pSession, String solutionRoot, boolean deleteOrphans) throws RepositoryException {
        byte[] byArray = lock;
        synchronized (lock) {
            SolutionRepositoryBase.logger.info((Object)Messages.getString("SolutionRepository.INFO_0001_BEGIN_LOAD_DB_REPOSITORY"));
            HibernateUtil.beginTransaction();
            File solutionFile = new File(solutionRoot);
            RepositoryFile solution = null;
            try {
                if (solutionFile.isDirectory()) {
                    Map reposFileStructure = this.getAllRepositoryModDates();
                    String fromBase = solutionFile.getAbsolutePath();
                    String toBase = solutionFile.getName().charAt(0) == '/' ? solutionFile.getName() : "/" + solutionFile.getName();
                    RepositoryUpdateHelper updateHelper = new RepositoryUpdateHelper(fromBase, toBase, reposFileStructure, this);
                    InfoHolder checkBase = (InfoHolder)reposFileStructure.get(toBase);
                    if (checkBase != null) {
                        checkBase.touched = true;
                        solution = (RepositoryFile)this.internalGetFileByPath(null);
                        updateHelper.createdOrRetrievedFolders.put(toBase, solution);
                    } else {
                        solution = new RepositoryFile(solutionFile.getName(), null, null, solutionFile.lastModified());
                        updateHelper.createdOrRetrievedFolders.put(toBase, solution);
                        SolutionRepositoryBase.logger.info((Object)Messages.getString("SolutionRepository.INFO_0002_UPDATED_FOLDER", solution.getFullPath()));
                    }
                    this.repositoryName = solution.getFullPath() + '/';
                    this.recurseCheckUpdatedFiles(updateHelper, solutionFile);
                    updateHelper.processUpdates();
                    updateHelper.processAdditions();
                    HibernateUtil.makePersistent(solution);
                    List deletions = updateHelper.processDeletions(deleteOrphans);
                    IAclPublisher aclPublisher = (IAclPublisher)PentahoSystem.get(IAclPublisher.class, (IPentahoSession)pSession);
                    if (aclPublisher != null) {
                        aclPublisher.publishDefaultAcls((IAclSolutionFile)solution);
                    }
                    HibernateUtil.commitTransaction();
                    HibernateUtil.flushSession();
                    this.resetRepository();
                    SolutionRepositoryBase.logger.info((Object)Messages.getString("SolutionRepository.INFO_0003_END_LOAD_DB_REPOSITORY"));
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return deletions;
                }
                throw new RepositoryException(Messages.getString("SolutionRepository.ERROR_0012_INVALID_SOLUTION_ROOT", solutionRoot));
            }
            catch (HibernateException hibernateException) {
                try {
                    HibernateUtil.rollbackTransaction();
                }
                catch (HibernateException ignored) {
                    SolutionRepositoryBase.logger.error((Object)"SolutionRepository.ERROR_0011_TRANSACTION_FAILED", (Throwable)ignored);
                }
                throw new RepositoryException((Throwable)hibernateException);
            }
            catch (IOException ex) {
                throw new RepositoryException((Throwable)ex);
            }
        }
    }

    private void recurseCheckUpdatedFiles(RepositoryUpdateHelper updateHelper, File solutionFile) throws IOException {
        File[] files = solutionFile.listFiles();
        if (files != null) {
            for (File aFile : files) {
                if (aFile.isDirectory()) {
                    String directoryName = aFile.getName();
                    if (SolutionReposHelper.ignoreDirectory((String)directoryName)) continue;
                    updateHelper.recordFolder(aFile);
                    this.recurseCheckUpdatedFiles(updateHelper, aFile);
                    continue;
                }
                if (SolutionReposHelper.ignoreFile((String)aFile.getName())) continue;
                updateHelper.recordFile(aFile);
            }
        }
    }

    private Map getAllRepositoryModDates() {
        Session hibSession = HibernateUtil.getSession();
        String nameQuery = "org.pentaho.platform.repository.solution.dbbased.RepositoryFile.filesWithModDates";
        Query qry = hibSession.getNamedQuery(nameQuery).setCacheable(true);
        List rtn = qry.list();
        HashMap<Object, InfoHolder> modMap = new HashMap<Object, InfoHolder>();
        for (int i = 0; i < rtn.size(); ++i) {
            Object[] aResult = (Object[])rtn.get(i);
            modMap.put(aResult[0], new InfoHolder(aResult[1], aResult[2]));
        }
        return modMap;
    }

    private RepositoryFile findRootRepositoryByName(String rootRepositoryName) {
        Session hibSession = HibernateUtil.getSession();
        String nameQuery = "org.pentaho.platform.repository.solution.dbbased.RepositoryFile.findNamedRootSolutionFolders";
        Query qry = hibSession.getNamedQuery(nameQuery).setCacheable(true);
        qry.setString("fileName", rootRepositoryName);
        RepositoryFile rtn = null;
        try {
            rtn = (RepositoryFile)qry.uniqueResult();
        }
        catch (HibernateException ex) {
            logger.error((Object)Messages.getString("SolutionRepository.ERROR_0022_HIBERNATE_EXCEPTION", rootRepositoryName), (Throwable)ex);
            throw ex;
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISolutionFile internalGetRootFolder() {
        byte[] byArray = lock;
        synchronized (lock) {
            if (this.repositoryName != null) {
                this.rootDirectory = this.findRootRepositoryByName(this.getRepositoryName());
                if (null == this.rootDirectory) {
                    this.warn(Messages.getString("SolutionRepository.WARN_0003_REPOSITORY_NOT_FOUND_BY_NAME", this.getRepositoryName()));
                }
            } else {
                Session hibSession = HibernateUtil.getSession();
                String nameQuery = "org.pentaho.platform.repository.solution.dbbased.RepositoryFile.findAllRootSolutionFolders";
                Query qry = hibSession.getNamedQuery(nameQuery).setCacheable(true);
                RepositoryFile rtn = null;
                try {
                    rtn = (RepositoryFile)qry.uniqueResult();
                }
                catch (HibernateException ex) {
                    logger.error((Object)Messages.getString("SolutionRepository.ERROR_0022_HIBERNATE_EXCEPTION", this.rootDirectory.getFullPath()), (Throwable)ex);
                    throw ex;
                }
                if (rtn == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                this.repositoryName = rtn.getFullPath() + '/';
                this.rootDirectory = rtn;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.rootDirectory;
        }
    }

    @Override
    public ISolutionFile getRootFolder(int actionOperation) {
        ISolutionFile rootFolder = this.internalGetRootFolder();
        if (!this.hasAccess(rootFolder, actionOperation)) {
            this.rootDirectory = null;
        }
        return this.rootDirectory;
    }

    @Override
    public Document getFullSolutionTree(int actionOperation, ISolutionFilter filter, ISolutionFile startingFile) {
        startingFile = startingFile == null ? this.getRootFolder(actionOperation) : startingFile;
        return super.getFullSolutionTree(actionOperation, filter, startingFile);
    }

    protected RepositoryFile getSolutionById(String anId) {
        Session hibSession = HibernateUtil.getSession();
        RepositoryFile rtn = (RepositoryFile)hibSession.load(RepositoryFile.class, (Serializable)((Object)anId));
        return rtn;
    }

    protected List getChildrenFilesByParentId(String parentId) {
        Session hibSession = HibernateUtil.getSession();
        String parentIdQuery = "org.pentaho.platform.repository.solution.dbbased.RepositoryFile.findChildrenFilesByParentId";
        Query qry = hibSession.getNamedQuery(parentIdQuery).setString("parentId", parentId).setCacheable(true);
        return qry.list();
    }

    private String removeRepositoryNameFromSystemPath(String systemPath) {
        Pattern p;
        Matcher m;
        if (systemPath != null && (m = (p = Pattern.compile("[/\\\\]" + this.getRepositoryName() + "([/\\\\]system[/\\\\].*)")).matcher(systemPath)).matches()) {
            systemPath = m.group(1);
        }
        return systemPath;
    }

    protected ISolutionFile internalGetFileByPath(String path) {
        String nameQuery;
        Session hibernateSession;
        Query qry;
        String cleanPath = this.removeRepositoryNameFromSystemPath(path);
        if (cleanPath == null) {
            return this.internalGetRootFolder();
        }
        if (SolutionRepositoryBase.isSystemPath(cleanPath)) {
            return super.getFileByPath(super.buildDirectoryPath(this.repositoryName, cleanPath), 0);
        }
        String fullPath = cleanPath.replace('\\', '/');
        if (this.repositoryName != null && !fullPath.startsWith(this.repositoryName)) {
            fullPath = fullPath.startsWith("/") || fullPath.startsWith("\\") ? this.repositoryName + fullPath.substring(1) : this.repositoryName + fullPath;
        }
        if ((fullPath = fullPath.replaceAll("//", "/")).endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        if ((qry = (hibernateSession = HibernateUtil.getSession()).getNamedQuery(nameQuery = "org.pentaho.platform.repository.solution.dbbased.RepositoryFile.findFileByPath").setCacheable(true).setString("fullPath", fullPath)).list().size() > 0) {
            RepositoryFile rtn = null;
            try {
                rtn = (RepositoryFile)qry.uniqueResult();
            }
            catch (HibernateException ex) {
                logger.error((Object)Messages.getString("SolutionRepository.ERROR_0022_HIBERNATE_EXCEPTION", cleanPath), (Throwable)ex);
                throw ex;
            }
            return rtn;
        }
        return null;
    }

    @Override
    protected ISolutionFile getFileByPath(String path, int actionOperation) {
        ISolutionFile file = this.internalGetFileByPath(path);
        if (!this.hasAccess(file, actionOperation)) {
            return null;
        }
        return file;
    }

    public ClassLoader getClassLoader(String path) {
        return new DbRepositoryClassLoader(path, this);
    }

    public boolean resourceExists(String solutionPath, int actionOperation) {
        return this.getFileByPath(solutionPath, actionOperation) != null;
    }

    private boolean internalResourceExists(String solutionPath) {
        return this.internalGetFileByPath(solutionPath) != null;
    }

    public long resourceSize(String solutionPath, int actionOperation) {
        RepositoryFile file = (RepositoryFile)this.getFileByPath(solutionPath, actionOperation);
        if (file == null) {
            return 0L;
        }
        return file.getData().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSolutionFile(String solutionPath) {
        byte[] byArray = lock;
        synchronized (lock) {
            if (DbBasedSolutionRepository.isSystemPath(solutionPath)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            String fullPath = this.repositoryName;
            String sepStr = Character.toString('/');
            if (solutionPath != null && solutionPath.length() > 0) {
                fullPath = fullPath.endsWith(sepStr) && solutionPath.startsWith(sepStr) ? fullPath + solutionPath.substring(1) : (!fullPath.endsWith(sepStr) && !solutionPath.startsWith(sepStr) ? fullPath + sepStr + solutionPath.substring(1) : fullPath + solutionPath);
            } else if (fullPath.endsWith(sepStr)) {
                fullPath = fullPath.substring(0, fullPath.length() - 1);
            }
            RepositoryFile file = (RepositoryFile)this.getFileByPath(fullPath, 16);
            if (file == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            RepositoryFile parent = (RepositoryFile)file.retrieveParent();
            super.removeSolutionFile(solutionPath);
            if (parent != null) {
                parent.removeChildFile(file);
            }
            Session hibSession = HibernateUtil.getSession();
            HibernateUtil.beginTransaction();
            hibSession.delete((Object)file);
            HibernateUtil.commitTransaction();
            this.resetRepository();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public boolean removeSolutionFile(String solution, String path, String fileName) {
        String solutionPath = "";
        if (solution != null && solution.length() > 0) {
            solutionPath = solutionPath + solution;
        }
        if (path != null && path.length() > 0) {
            solutionPath = solutionPath + '/' + path;
        }
        if (fileName != null && fileName.length() > 0) {
            solutionPath = solutionPath + '/' + fileName;
        }
        return this.removeSolutionFile(solutionPath);
    }

    public boolean deleteRepository(String repositoryNameToDelete) {
        String oldName = this.getRepositoryName();
        this.setRepositoryName(repositoryNameToDelete);
        boolean result = this.removeSolutionFile("", "", "");
        this.setRepositoryName(oldName);
        return result;
    }

    public String getRepositoryName() {
        return this.repositoryName == null ? this.repositoryName : this.repositoryName.substring(1, this.repositoryName.length() - 1);
    }

    public void setRepositoryName(String value) {
        if (value == null) {
            this.repositoryName = null;
            return;
        }
        String repoName = value;
        String pathSep = new StringBuffer().append('/').toString();
        if (!repoName.startsWith(pathSep)) {
            repoName = pathSep + repoName;
        }
        if (!repoName.endsWith(pathSep)) {
            repoName = repoName + pathSep;
        }
        this.repositoryName = this.repositoryName != null ? this.repositoryName : repoName;
    }

    private void setXMLPermissionAttributes(IPentahoAclEntry entry, Element node) {
        node.addAttribute("aclAdministration", Boolean.toString(entry.isPermitted(60)));
        node.addAttribute("aclExecute", Boolean.toString(entry.isPermitted(1)));
        node.addAttribute("aclSubscribe", Boolean.toString(entry.isPermitted(2)));
        node.addAttribute("aclModifyAcl", Boolean.toString(entry.isPermitted(32) || SecurityHelper.isPentahoAdministrator((IPentahoSession)this.getSession())));
    }

    public void exitPoint() {
        try {
            HibernateUtil.commitTransaction();
            HibernateUtil.flushSession();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            HibernateUtil.closeSession();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addSolutionFile(String baseUrl, String path, String fileName, byte[] data, boolean overwrite) {
        byte[] byArray = lock;
        synchronized (lock) {
            while (path != null && (path.endsWith("/") || path.endsWith("\\"))) {
                path = path.substring(0, path.length() - 1);
            }
            if (StringUtil.isEmpty((String)path)) {
                logger.error((Object)Messages.getErrorString("SolutionRepository.ERROR_0023_INVALID_PUBLISH_LOCATION_ROOT"));
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return 2;
            }
            if (SolutionRepositoryBase.isSystemPath(path) && this.isPentahoAdministrator() || SolutionRepositoryBase.isSystemTmpPath(path)) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return super.addSolutionFile(baseUrl, path, fileName, data, overwrite);
            }
            RepositoryFile parent = (RepositoryFile)this.getFileByPath(path, 1);
            RepositoryFile reposFile = (RepositoryFile)this.internalGetFileByPath(path + '/' + fileName);
            HibernateUtil.beginTransaction();
            if (reposFile == null) {
                if (parent == null || !parent.isDirectory() || !this.hasAccess(parent, 4) && !this.isPentahoAdministrator()) {
                    HibernateUtil.commitTransaction();
                    HibernateUtil.flushSession();
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return 2;
                }
                try {
                    reposFile = new RepositoryFile(fileName, parent, data);
                    HibernateUtil.commitTransaction();
                    HibernateUtil.flushSession();
                    this.resetRepository();
                    super.addSolutionFile(baseUrl, path, fileName, data, overwrite);
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return 3;
                }
                catch (Exception e) {
                    SolutionRepositoryBase.logger.error((Object)e);
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return 2;
                }
            }
            if (!overwrite) {
                HibernateUtil.commitTransaction();
                HibernateUtil.flushSession();
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return 1;
            }
            if (!this.hasAccess(reposFile, 8) && !this.isPentahoAdministrator()) {
                HibernateUtil.commitTransaction();
                HibernateUtil.flushSession();
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return 2;
            }
            reposFile.setData(data);
            reposFile.setLastModified(new Date().getTime());
            super.addSolutionFile(baseUrl, path, fileName, data, overwrite);
            this.resetRepository();
            try {
                HibernateUtil.commitTransaction();
                HibernateUtil.flushSession();
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return 3;
            }
            catch (Exception e) {
                SolutionRepositoryBase.logger.error((Object)e);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return 2;
            }
        }
    }

    @Override
    public int addSolutionFile(String baseUrl, String path, String fileName, File f, boolean overwrite) {
        byte[] bytes;
        try {
            bytes = FileHelper.getBytesFromFile((File)f);
        }
        catch (IOException e) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0014_COULD_NOT_SAVE_FILE", fileName), e);
            return 2;
        }
        return this.addSolutionFile(baseUrl, path, fileName, bytes, overwrite);
    }

    public String[] getAllActionSequences(int actionOperation) {
        Session hibSession = HibernateUtil.getSession();
        String nameQuery = "org.pentaho.platform.repository.solution.dbbased.RepositoryFile.findAllActionSequences";
        Query qry = hibSession.getNamedQuery(nameQuery).setCacheable(true);
        List rtn = qry.list();
        ArrayList<String> values = new ArrayList<String>();
        for (RepositoryFile file : rtn) {
            if (!this.defaultSolutionFilter.keepFile((ISolutionFile)file, actionOperation)) continue;
            String path = file.getFullPath();
            path = path.substring(this.repositoryName.length());
            values.add(path);
        }
        return values.toArray(new String[0]);
    }

    public long getSolutionFileLastModified(String path, int actionOperation) {
        RepositoryFile file = (RepositoryFile)this.getFileByPath(path, actionOperation);
        long mod = -1L;
        if (file != null) {
            mod = file.getLastModified();
        }
        return mod;
    }

    public boolean supportsAccessControls() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int publish(String baseUrl, String path, String fileName, byte[] data, boolean overwrite) throws PentahoAccessControlException {
        byte[] byArray = lock;
        synchronized (lock) {
            String fullPath = path + '/' + fileName;
            boolean alreadyExists = this.internalResourceExists(fullPath);
            int res = this.addSolutionFile(baseUrl, path, fileName, data, overwrite);
            if (res == 3 && !alreadyExists) {
                ISolutionFile justPublishedFile = this.internalGetFileByPath(fullPath);
                SpringSecurityPermissionMgr permissionMgr = SpringSecurityPermissionMgr.instance();
                HibernateUtil.beginTransaction();
                if (SecurityHelper.canHaveACLS((ISolutionFile)justPublishedFile)) {
                    permissionMgr.setPermissions(this.getDefaultPublishAcl(), (Object)justPublishedFile);
                }
            }
            if (res == 3 && fileName != null && fileName.toLowerCase().endsWith(".xmi")) {
                IMetadataDomainRepository repo = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, null);
                repo.reloadDomains();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return res;
        }
    }

    protected Map<IPermissionRecipient, IPermissionMask> getDefaultPublishAcl() {
        HashMap<IPermissionRecipient, IPermissionMask> acl = new HashMap<IPermissionRecipient, IPermissionMask>();
        acl.put((IPermissionRecipient)new SimpleSession(this.getSession()), (IPermissionMask)new SimplePermissionMask(-1));
        IPentahoSession sess = this.getSession();
        IAclVoter voter = (IAclVoter)PentahoSystem.get(IAclVoter.class, (IPentahoSession)sess);
        acl.put((IPermissionRecipient)new SimpleRole(voter.getAdminRole().getAuthority()), (IPermissionMask)new SimplePermissionMask(-1));
        return acl;
    }

    public int publish(String baseUrl, String path, String fileName, File f, boolean overwrite) throws PentahoAccessControlException {
        byte[] bytes;
        try {
            bytes = FileHelper.getBytesFromFile((File)f);
        }
        catch (IOException e) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0014_COULD_NOT_SAVE_FILE", fileName), e);
            return 2;
        }
        return this.publish(baseUrl, path, fileName, bytes, overwrite);
    }

    public void share(ISolutionFile file, List<IPermissionRecipient> shareRecipients) {
        for (IPermissionRecipient shareRecipient : shareRecipients) {
            this.addPermission(file, shareRecipient, (IPermissionMask)new SimplePermissionMask(3));
        }
    }

    public void addPermission(ISolutionFile file, IPermissionRecipient recipient, IPermissionMask permission) {
        if (this.hasAccess(file, 32)) {
            SpringSecurityPermissionMgr permissionMgr = SpringSecurityPermissionMgr.instance();
            Map acl = permissionMgr.getPermissions((Object)file);
            if (acl.isEmpty()) {
                acl = permissionMgr.getEffectivePermissions((Object)file);
            }
            acl.put(recipient, permission);
            try {
                this.setPermissions(file, acl);
            }
            catch (PentahoAccessControlException ignored) {
                // empty catch block
            }
        }
    }

    public void setPermissions(ISolutionFile file, Map<IPermissionRecipient, IPermissionMask> acl) throws PentahoAccessControlException {
        if (!SecurityHelper.canHaveACLS((ISolutionFile)file)) {
            throw new PentahoAccessControlException(Messages.getString("SolutionRepository.ACCESS_DENIED", file.getFullPath(), Integer.toString(32)));
        }
        if (!this.hasAccess(file, 32)) {
            throw new PentahoAccessControlException(Messages.getString("SolutionRepository.ACCESS_DENIED", file.getFullPath(), Integer.toString(32)));
        }
        SpringSecurityPermissionMgr permissionMgr = SpringSecurityPermissionMgr.instance();
        HibernateUtil.beginTransaction();
        permissionMgr.setPermissions(acl, (Object)file);
    }

    public Map<IPermissionRecipient, IPermissionMask> getPermissions(ISolutionFile file) {
        if (!SecurityHelper.canHaveACLS((ISolutionFile)file)) {
            return Collections.emptyMap();
        }
        if (this.hasAccess(file, 1)) {
            SpringSecurityPermissionMgr permissionMgr = SpringSecurityPermissionMgr.instance();
            HibernateUtil.beginTransaction();
            return permissionMgr.getPermissions((Object)file);
        }
        return null;
    }

    public Map<IPermissionRecipient, IPermissionMask> getEffectivePermissions(ISolutionFile file) {
        if (!SecurityHelper.canHaveACLS((ISolutionFile)file)) {
            return Collections.emptyMap();
        }
        if (this.hasAccess(file, 1)) {
            SpringSecurityPermissionMgr permissionMgr = SpringSecurityPermissionMgr.instance();
            HibernateUtil.beginTransaction();
            return permissionMgr.getEffectivePermissions((Object)file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ISolutionFile createFolder(File newFolder) throws IOException {
        byte[] byArray = lock;
        synchronized (lock) {
            HibernateUtil.beginTransaction();
            try {
                ISolutionFile parentFolder;
                if (!this.isPathedUnderSolutionRoot(newFolder)) {
                    throw new IOException(Messages.getErrorString("SolutionRepository.ERROR_0021_FILE_NOT_ADDED", newFolder.getName()));
                }
                String newFolderCanonicalPath = newFolder.getCanonicalPath();
                String relativePath = newFolderCanonicalPath.substring(this.rootCanonicalName.length());
                if (relativePath.startsWith(File.separator)) {
                    relativePath = relativePath.substring(1);
                }
                int lastSlashIndex = relativePath.lastIndexOf(File.separator);
                String relativePathToParent = null;
                if (lastSlashIndex > -1) {
                    relativePathToParent = relativePath.substring(0, lastSlashIndex);
                }
                if ((parentFolder = this.getFileByPath(relativePathToParent, 4)) == null) {
                    ISolutionFile iSolutionFile = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return iSolutionFile;
                }
                String solutionRoot = PentahoSystem.getApplicationContext().getSolutionPath("");
                File solutionFile = new File(solutionRoot);
                if (solutionFile.isDirectory()) {
                    Map reposFileStructure = this.getAllRepositoryModDates();
                    String fromBase = solutionFile.getAbsolutePath();
                    String toBase = solutionFile.getName().charAt(0) == '/' ? solutionFile.getName() : "/" + solutionFile.getName();
                    RepositoryUpdateHelper updateHelper = new RepositoryUpdateHelper(fromBase, toBase, reposFileStructure, this);
                    RepositoryFile returnFile = updateHelper.createFolder(newFolder);
                    SpringSecurityPermissionMgr permissionMgr = SpringSecurityPermissionMgr.instance();
                    permissionMgr.setPermissions(this.getDefaultPublishAcl(), (Object)returnFile);
                    super.createFolder(newFolder);
                    RepositoryFile repositoryFile = returnFile;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return repositoryFile;
                }
            }
            finally {
                HibernateUtil.commitTransaction();
                HibernateUtil.flushSession();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    private class DefaultSolutionAttributeContributor
    implements ISolutionAttributeContributor {
        private DefaultSolutionAttributeContributor() {
        }

        public void contributeAttributes(ISolutionFile solutionFile, Element childNode) {
            IPentahoSession sess;
            IAclVoter voter;
            IPentahoAclEntry access;
            if (solutionFile instanceof IAclHolder && (access = (voter = (IAclVoter)PentahoSystem.get(IAclVoter.class, (IPentahoSession)(sess = DbBasedSolutionRepository.this.getSession()))).getEffectiveAcl(sess, (IAclHolder)solutionFile)) != null) {
                DbBasedSolutionRepository.this.setXMLPermissionAttributes(access, childNode);
            }
        }
    }

    private class DefaultSolutionFilter
    implements ISolutionFilter {
        private DefaultSolutionFilter() {
        }

        public boolean keepFile(ISolutionFile solutionFile, int actionOperation) {
            if (solutionFile instanceof IAclHolder) {
                return DbBasedSolutionRepository.this.hasAccess(solutionFile, actionOperation);
            }
            return true;
        }
    }
}

