/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.dbbased;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.solution.SolutionRepositoryBase;
import org.pentaho.platform.repository.solution.dbbased.DbBasedSolutionRepository;

public class DbRepositoryClassLoader
extends ClassLoader {
    protected static final Log logger = LogFactory.getLog(SolutionRepositoryBase.class);
    private static final HashMap resourceMap = new HashMap();
    String path;
    DbBasedSolutionRepository repository;

    public DbRepositoryClassLoader(String inPath, DbBasedSolutionRepository inRepository) {
        this.path = inPath;
        this.repository = inRepository;
    }

    public InputStream getResourceAsStream(String name) {
        String key = this.path + '/' + name;
        byte[] bytes = (byte[])resourceMap.get(key);
        if (bytes == null) {
            try {
                bytes = this.repository.getResourceAsBytes(key, false, 1);
                resourceMap.put(key, bytes);
            }
            catch (IOException ignored) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)Messages.getString("DbRepositoryClassLoader.RESOURCE_NOT_FOUND", name));
                }
                return null;
            }
        }
        return new ByteArrayInputStream(bytes);
    }

    public static void clearResourceCache() {
        resourceMap.clear();
    }
}

