/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.dbbased;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Restrictions;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.solution.dbbased.DbBasedSolutionRepository;
import org.pentaho.platform.repository.solution.dbbased.InfoHolder;
import org.pentaho.platform.repository.solution.dbbased.RepositoryFile;
import org.pentaho.platform.util.FileHelper;

public class RepositoryUpdateHelper {
    protected static final Log logger = LogFactory.getLog(RepositoryUpdateHelper.class);
    String fromBase;
    String toBase;
    Map nameReplacementMap = new HashMap();
    Map reposFileStructure;
    Map createdOrRetrievedFolders = new HashMap();
    List updatedFiles = new ArrayList();
    List newFolders = new ArrayList();
    List newFiles = new ArrayList();
    List updatedFolders = new ArrayList();
    DbBasedSolutionRepository dbBasedRepository;
    private static final Pattern SlashPattern = Pattern.compile("\\\\");

    protected RepositoryUpdateHelper(String fromBase, String toBase, Map reposFileStructure, DbBasedSolutionRepository inRepository) {
        this.fromBase = fromBase;
        this.toBase = toBase;
        this.reposFileStructure = reposFileStructure;
        this.dbBasedRepository = inRepository;
    }

    protected String convertFileName(String fName) {
        String rtn = (String)this.nameReplacementMap.get(fName);
        if (rtn == null) {
            rtn = this.toBase + SlashPattern.matcher(fName.substring(this.fromBase.length())).replaceAll("/");
            this.nameReplacementMap.put(fName, rtn);
        }
        return rtn;
    }

    protected void processAdditions() throws IOException {
        int i;
        for (i = 0; i < this.newFolders.size(); ++i) {
            File newFolder = (File)this.newFolders.get(i);
            RepositoryFile newFolderObject = this.createFolder(newFolder);
            logger.info((Object)Messages.getString("SolutionRepository.INFO_0004_ADDED_FOLDER", newFolderObject.getFullPath()));
        }
        for (i = 0; i < this.newFiles.size(); ++i) {
            File newFile = (File)this.newFiles.get(i);
            RepositoryFile newFileObject = this.createNewFile(newFile);
            logger.info((Object)Messages.getString("SolutionRepository.INFO_0006_ADDED_FILE", newFileObject.getFullPath()));
        }
    }

    protected void processUpdates() throws IOException {
        for (int i = 0; i < this.updatedFiles.size(); ++i) {
            File updatedFile = (File)this.updatedFiles.get(i);
            String updRepoFileName = this.convertFileName(updatedFile.getAbsolutePath());
            RepositoryFile updRepoFileObject = (RepositoryFile)this.dbBasedRepository.internalGetFileByPath(updRepoFileName);
            byte[] data = FileHelper.getBytesFromFile((File)updatedFile);
            updRepoFileObject.setLastModified(updatedFile.lastModified());
            updRepoFileObject.setData(data);
            logger.info((Object)Messages.getString("SolutionRepository.INFO_0007_UPDATED_FILE", updRepoFileObject.getFullPath()));
        }
        RepositoryFile updFolderObject = null;
        for (int i = 0; i < this.updatedFolders.size(); ++i) {
            File updatedFolder = (File)this.updatedFolders.get(i);
            String folderNameCorrected = this.convertFileName(updatedFolder.getAbsolutePath());
            updFolderObject = (RepositoryFile)this.createdOrRetrievedFolders.get(folderNameCorrected);
            if (updFolderObject == null) {
                updFolderObject = (RepositoryFile)this.dbBasedRepository.internalGetFileByPath(folderNameCorrected);
                this.createdOrRetrievedFolders.put(folderNameCorrected, updFolderObject);
            }
            updFolderObject.setLastModified(updatedFolder.lastModified());
            logger.info((Object)Messages.getString("SolutionRepository.INFO_0002_UPDATED_FOLDER", folderNameCorrected));
        }
    }

    protected List processDeletions(boolean deleteOrphans) {
        ArrayList deletions = new ArrayList();
        for (Map.Entry me : this.reposFileStructure.entrySet()) {
            InfoHolder info = (InfoHolder)me.getValue();
            if (info.touched) continue;
            deletions.add(me.getKey());
        }
        if (deleteOrphans) {
            this.performHibernateDelete(deletions);
        }
        return deletions;
    }

    protected void performHibernateDelete(List deletions) {
        ArrayList<Criteria> listOfDeletions = new ArrayList<Criteria>();
        Criteria criteria = null;
        if (deletions != null && deletions.size() > 0) {
            if (HibernateUtil.isOracleDialect()) {
                for (int i = 0; i < deletions.size(); i += 500) {
                    int maxChunkIndex = i + 500 > deletions.size() ? deletions.size() : i + 500;
                    List chunkDeletions = deletions.subList(i, maxChunkIndex);
                    criteria = HibernateUtil.getSession().createCriteria(RepositoryFile.class);
                    criteria.add(Restrictions.in((String)"fullPath", chunkDeletions));
                    listOfDeletions.add(criteria);
                }
            } else {
                criteria = HibernateUtil.getSession().createCriteria(RepositoryFile.class);
                criteria.add(Restrictions.in((String)"fullPath", (Collection)deletions));
                criteria.setFetchMode("parent", FetchMode.JOIN);
                listOfDeletions.add(criteria);
            }
            for (Criteria element : listOfDeletions) {
                List deleteResult = element.list();
                for (int i = 0; i < deleteResult.size(); ++i) {
                    RepositoryFile toBeDeleted = (RepositoryFile)deleteResult.get(i);
                    RepositoryFile deletedParent = (RepositoryFile)toBeDeleted.retrieveParent();
                    if (deletedParent != null) {
                        deletedParent.removeChildFile(toBeDeleted);
                    }
                    HibernateUtil.makeTransient(toBeDeleted);
                }
            }
        }
    }

    protected void recordFolder(File aFile) throws IOException {
        String fixedFileName = this.convertFileName(aFile.getAbsolutePath());
        InfoHolder infoHolder = (InfoHolder)this.reposFileStructure.get(fixedFileName);
        if (infoHolder != null) {
            infoHolder.touched = true;
            if (aFile.lastModified() != infoHolder.lastModifiedDate) {
                this.updatedFolders.add(aFile);
            }
        } else {
            this.newFolders.add(aFile);
        }
    }

    protected boolean recordFile(File f) throws IOException {
        boolean changed = false;
        String fName = f.getAbsolutePath();
        String convertedSolnFileName = this.convertFileName(fName);
        long lastRDBMSModDate = this.getLastModifiedDateFromMap(convertedSolnFileName);
        if (lastRDBMSModDate > 0L) {
            if (f.lastModified() != lastRDBMSModDate) {
                this.updatedFiles.add(f);
                changed = true;
            }
        } else {
            this.newFiles.add(f);
        }
        return changed;
    }

    protected long getLastModifiedDateFromMap(String fileName) {
        InfoHolder info = (InfoHolder)this.reposFileStructure.get(fileName);
        if (info != null) {
            info.touched = true;
            return info.lastModifiedDate;
        }
        return -1L;
    }

    protected ISolutionFile getParent(String parentName) {
        RepositoryFile theParent = (RepositoryFile)this.createdOrRetrievedFolders.get(parentName);
        if (theParent == null) {
            theParent = this.dbBasedRepository.internalGetFileByPath(parentName);
            this.createdOrRetrievedFolders.put(parentName, theParent);
        }
        return theParent;
    }

    protected RepositoryFile createFolder(File newFolder) throws IOException {
        String fixedFolderName = this.convertFileName(newFolder.getAbsolutePath());
        File parentFolder = newFolder.getParentFile();
        String fixedParentFolderName = this.convertFileName(parentFolder.getAbsolutePath());
        RepositoryFile parentFolderObject = (RepositoryFile)this.getParent(fixedParentFolderName);
        if (parentFolderObject == null) {
            parentFolderObject = (RepositoryFile)this.dbBasedRepository.internalGetRootFolder();
        }
        RepositoryFile newFolderObject = new RepositoryFile(newFolder.getName(), parentFolderObject, null, newFolder.lastModified());
        this.createdOrRetrievedFolders.put(fixedFolderName, newFolderObject);
        return newFolderObject;
    }

    protected RepositoryFile createNewFile(File newFile) throws IOException {
        File parentFolder = newFile.getParentFile();
        String fixedParentFolderName = this.convertFileName(parentFolder.getAbsolutePath());
        RepositoryFile parentFolderObject = (RepositoryFile)this.getParent(fixedParentFolderName);
        RepositoryFile newFileObject = new RepositoryFile(newFile.getName(), parentFolderObject, FileHelper.getBytesFromFile((File)newFile), newFile.lastModified());
        return newFileObject;
    }
}

