/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.filebased;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPermissionMask;
import org.pentaho.platform.api.engine.IPermissionRecipient;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFilter;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionResource;
import org.pentaho.platform.engine.services.actionsequence.SequenceDefinition;
import org.pentaho.platform.engine.services.solution.SolutionReposHelper;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.solution.SolutionRepositoryBase;
import org.pentaho.platform.repository.solution.filebased.FileSolutionFile;
import org.pentaho.platform.util.FileHelper;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.xml.XmlHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedSolutionRepository
extends SolutionRepositoryBase {
    private static final long serialVersionUID = -8270135463210017284L;
    private ISolutionFilter defaultSolutionFilter = new DefaultSolutionFilter();
    private boolean useActionSequenceCaching = false;
    private boolean repositoryInit = false;

    public FileBasedSolutionRepository() {
        this.init();
    }

    @Override
    public void init() {
        if (!this.repositoryInit) {
            super.init();
            String flag = PentahoSystem.getSystemSetting((String)"filebased-solution-cache", (String)"false");
            try {
                this.useActionSequenceCaching = Boolean.getBoolean(flag);
            }
            catch (Exception e) {
                this.useActionSequenceCaching = false;
            }
            this.repositoryInit = true;
        }
    }

    public ClassLoader getClassLoader(String path) {
        File localeDir = new File(PentahoSystem.getApplicationContext().getSolutionPath(path));
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{localeDir.toURL()}, null);
            return loader;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0024_CREATING_CLASSLOADER"));
            return null;
        }
    }

    public IActionSequence getActionSequence(String solutionName, String actionPath, String sequenceName, int localLoggingLevel, int actionOperation) {
        IActionSequence actionSequence = null;
        String action = actionPath != null && !"".equals(actionPath) ? solutionName + File.separator + actionPath + File.separator + sequenceName : solutionName + File.separator + sequenceName;
        if (this.useActionSequenceCaching) {
            actionSequence = (IActionSequence)this.getRepositoryObjectFromCache(action);
        }
        if (actionSequence != null) {
            return actionSequence;
        }
        Document actionSequenceDocument = this.getSolutionDocument(action, actionOperation);
        if (actionSequenceDocument == null) {
            return null;
        }
        actionSequence = SequenceDefinition.ActionSequenceFactory((Document)actionSequenceDocument, (String)sequenceName, (String)actionPath, (String)solutionName, (ILogger)this, (IApplicationContext)PentahoSystem.getApplicationContext(), (int)localLoggingLevel);
        if (actionSequence == null) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0016_FAILED_TO_CREATE_ACTION_SEQUENCE", action));
            return null;
        }
        if (this.useActionSequenceCaching) {
            this.putRepositoryObjectInCache(action, actionSequence);
        }
        return actionSequence;
    }

    public Document getSolutionDocument(String solutionName, String actionPath, String actionName, int actionOperation) {
        return this.getSolutionDocument(solutionName + File.separator + actionPath + File.separator + actionName, actionOperation);
    }

    public Document getSolutionDocument(String documentPath, int actionOperation) {
        File file = this.getFile(documentPath, false);
        if (null == file) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0001_FILE_DOES_NOT_EXIST", documentPath));
            return null;
        }
        if (!file.exists()) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0001_FILE_DOES_NOT_EXIST", documentPath));
            return null;
        }
        if (!file.canRead()) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0020_FILE_IS_NOT_READABLE", documentPath));
            return null;
        }
        Document document = null;
        try {
            document = XmlDom4JHelper.getDocFromFile((File)file, (EntityResolver)this.getResourceLoader());
        }
        catch (Exception e) {
            this.error(Messages.getString("SolutionRepository.ERROR_0009_INVALID_DOCUMENT", documentPath));
            return null;
        }
        this.localizeDoc((Node)document, new FileSolutionFile(file, ((FileSolutionFile)this.getRootFolder(actionOperation)).getFile()));
        return document;
    }

    private File getFile(IRuntimeContext runtimeContext, String path) {
        if (runtimeContext == null) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0002_NULL_RUNTIME_CONTEXT"));
            return null;
        }
        File f = this.getFile(runtimeContext.getSolutionName() + File.separator + path, false);
        if (!f.exists()) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0003_NULL_SOLUTION_FILE", path));
            return null;
        }
        this.debug(Messages.getString("SolutionRepository.DEBUG_FILE_PATH", f.getAbsolutePath()));
        return f;
    }

    protected String getActionDefinition(IRuntimeContext runtimeContext, String actionPath) {
        if (runtimeContext == null || runtimeContext.getInstanceId() == null || runtimeContext.getActionName() == null) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0004_INVALID_CONTEXT"));
        }
        this.genLogIdFromInfo(runtimeContext.getInstanceId(), "SOLUTION-REPOSITORY", runtimeContext.getActionName());
        File f = this.getFile(runtimeContext, actionPath);
        if (f == null) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0005_INVALID_SOLUTION_FILE") + actionPath);
        }
        return FileHelper.getStringFromFile((File)f);
    }

    protected Document getActionDefinitionDocument(IRuntimeContext runtimeContext, String actionPath) {
        this.genLogIdFromInfo(runtimeContext.getInstanceId(), "SOLUTION-REPOSITORY", runtimeContext.getActionName());
        File f = this.getFile(runtimeContext, actionPath);
        if (f == null) {
            return null;
        }
        Document document = null;
        try {
            document = XmlDom4JHelper.getDocFromFile((File)f, (EntityResolver)this.getResourceLoader());
        }
        catch (Exception e) {
            this.error(Messages.getString("SolutionRepository.ERROR_0009_INVALID_DOCUMENT", actionPath), e);
            return null;
        }
        return document;
    }

    public void reloadSolutionRepository(IPentahoSession localSession, int localLoggingLevel) {
        if (this.isCachingAvailable()) {
            File rootDir = this.getFile("", false);
            Document repository = DocumentHelper.createDocument();
            Element rootNode = repository.addElement("repository");
            this.processDir(rootNode, rootDir, null, 0, 60);
            this.resetRepository();
            this.putRepositoryObjectInCache(this.getRepositoryKey(), repository);
        }
    }

    protected void processDir(Element parentNode, File parentDir, String solutionId, int pathIdx, int actionOperation) {
        File[] files;
        for (File element : files = parentDir.listFiles()) {
            if (element.isDirectory()) continue;
            String fileName = element.getName();
            this.processFile(fileName, element, parentNode, solutionId, pathIdx, actionOperation);
        }
        for (File element : files) {
            if (element.isDirectory() && !element.getName().equalsIgnoreCase("system") && !element.getName().equalsIgnoreCase("CVS") && !element.getName().equalsIgnoreCase(".svn")) {
                String thisSolution;
                Element dirNode = parentNode.addElement("file");
                dirNode.addAttribute("type", "FILE.FOLDER");
                String path = "";
                if (solutionId == null) {
                    thisSolution = element.getName();
                    pathIdx = this.rootPath.length() + File.separator.length() + thisSolution.length();
                } else {
                    thisSolution = solutionId;
                    path = element.getAbsolutePath().substring(pathIdx);
                    path = path.replace('\\', '/');
                    dirNode.addElement("path").setText(path);
                }
                File indexFile = new File(element, "index.xml");
                Document indexDoc = null;
                if (indexFile.exists()) {
                    indexDoc = this.getSolutionDocument(thisSolution, path, "index.xml", actionOperation);
                }
                if (indexDoc != null) {
                    this.addIndexToRepository(indexDoc, element, dirNode, path, thisSolution);
                } else {
                    dirNode.addAttribute("visible", "false");
                    String dirName = element.getName();
                    dirNode.addAttribute("name", XmlHelper.encode((String)dirName));
                    dirNode.addElement("title").setText(dirName);
                }
                this.processDir(dirNode, element, thisSolution, pathIdx, actionOperation);
                continue;
            }
            if (solutionId != null || !element.getName().equalsIgnoreCase("index.xml")) continue;
            Document indexDoc = null;
            indexDoc = this.getSolutionDocument("", "", "index.xml", actionOperation);
            if (indexDoc == null) continue;
            this.addIndexToRepository(indexDoc, parentDir, parentNode, "", "");
        }
    }

    protected void processFile(String fileName, File element, Element parentNode, String solutionId, int pathIdx, int actionOperation) {
        if (fileName.equals("Entries") || fileName.equals("Repository") || fileName.equals("Root")) {
            return;
        }
        int lastPoint = fileName.lastIndexOf(46);
        if (lastPoint == -1) {
            return;
        }
        String extension = fileName.substring(lastPoint + 1).toLowerCase();
        String solutionPath = element.getAbsolutePath().substring(this.rootPath.length());
        if ("url".equals(extension)) {
            this.addUrlToRepository(element, parentNode, solutionPath, actionOperation);
        }
        boolean addFile = "xaction".equals(extension);
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)this.getSession());
        if (pluginManager != null) {
            Set types = pluginManager.getContentTypes();
            addFile |= types != null && types.contains(extension);
        }
        if (!addFile) {
            return;
        }
        String path = element.getAbsolutePath().substring(pathIdx);
        if (!path.equals(fileName)) {
            path = path.substring(0, path.length() - fileName.length() - 1);
            path = path.replace('\\', '/');
        } else {
            path = "";
        }
        if (fileName.toLowerCase().endsWith(".xaction")) {
            this.info(Messages.getString("SolutionRepository.DEBUG_ADDING_ACTION", fileName));
            IActionSequence actionSequence = this.getActionSequence(solutionId, path, fileName, this.loggingLevel, actionOperation);
            if (actionSequence == null) {
                this.error(Messages.getErrorString("SolutionRepository.ERROR_0006_INVALID_SEQUENCE_DOCUMENT", fileName));
            } else {
                this.addToRepository(actionSequence, parentNode, element);
            }
        } else if (pluginManager != null) {
            String fullPath = solutionId + '/' + (StringUtil.isEmpty((String)path) ? "" : path + '/') + fileName;
            try {
                IFileInfo fileInfo = this.getFileInfo(solutionId, path, fileName, extension, pluginManager, 1);
                this.addToRepository(fileInfo, solutionId, path, fileName, parentNode, element);
            }
            catch (Exception e) {
                this.error(Messages.getErrorString("SolutionRepository.ERROR_0021_FILE_NOT_ADDED", fullPath), e);
            }
        }
    }

    private void addToRepository(IFileInfo info, String solution, String path, String fileName, Element parentNode, File file) {
        String displayType;
        Element dirNode = parentNode.addElement("file");
        dirNode.addAttribute("type", "FILE.ACTIVITY");
        dirNode.addElement("filename").setText(fileName);
        dirNode.addElement("path").setText(path);
        dirNode.addElement("solution").setText(solution);
        dirNode.addElement("title").setText(info.getTitle());
        String description = info.getDescription();
        if (description == null) {
            dirNode.addElement("description");
        } else {
            dirNode.addElement("description").setText(description);
        }
        String author = info.getAuthor();
        if (author == null) {
            dirNode.addElement("author");
        } else {
            dirNode.addElement("author").setText(author);
        }
        String iconPath = info.getIcon();
        if (iconPath != null && !iconPath.equals("")) {
            String rolloverIconPath = null;
            int rolloverIndex = iconPath.indexOf("|");
            if (rolloverIndex > -1) {
                rolloverIconPath = iconPath.substring(rolloverIndex + 1);
                iconPath = iconPath.substring(0, rolloverIndex);
            }
            if (this.publishIcon(file.getParentFile().getAbsolutePath(), iconPath)) {
                dirNode.addElement("icon").setText("getImage?image=icons/" + iconPath);
            } else {
                dirNode.addElement("icon").setText(info.getIcon());
            }
            if (rolloverIconPath != null) {
                if (this.publishIcon(PentahoSystem.getApplicationContext().getSolutionPath(solution + File.separator + path), rolloverIconPath)) {
                    dirNode.addElement("rollovericon").setText("getImage?image=icons/" + rolloverIconPath);
                } else {
                    dirNode.addElement("rollovericon").setText(rolloverIconPath);
                }
            }
        }
        if ((displayType = info.getDisplayType()) == null || "none".equalsIgnoreCase(displayType)) {
            dirNode.addAttribute("visible", "false");
        } else {
            dirNode.addAttribute("visible", "true");
            dirNode.addAttribute("displaytype", displayType);
        }
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getSession());
        boolean subscribable = false;
        if (subscriptionRepository != null) {
            subscribable = subscriptionRepository.getContentByActionReference(solution + '/' + path + '/' + fileName) != null;
        }
        dirNode.addElement("properties").setText("subscribable=" + Boolean.toString(subscribable));
    }

    protected String getLocaleString(String key, String baseName, ISolutionFile baseFile) {
        File searchDir = ((FileSolutionFile)baseFile.retrieveParent()).getFile();
        try {
            boolean searching = true;
            while (searching) {
                URLClassLoader loader = new URLClassLoader(new URL[]{searchDir.toURL()}, null);
                String localeText = null;
                try {
                    ResourceBundle rb = ResourceBundle.getBundle(baseName, this.getLocale(), loader);
                    localeText = rb.getString(key.substring(1));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (localeText != null) {
                    return localeText;
                }
                if (!searching) continue;
                if (!baseName.equals("messages")) {
                    baseName = "messages";
                    continue;
                }
                if (searchDir.equals(this.rootFile)) {
                    searching = false;
                    continue;
                }
                searchDir = searchDir.getParentFile();
            }
            return null;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0007_COULD_NOT_READ_PROPERTIES", baseFile.getFullPath()), e);
            return null;
        }
    }

    protected void addIndexToRepository(Document indexDoc, File directoryFile, Element directoryNode, String path, String solution) {
        String dirName = this.getValue(indexDoc, "/index/name", directoryFile.getName().replace('_', ' '));
        String description = this.getValue(indexDoc, "/index/description", "");
        String iconPath = this.getValue(indexDoc, "/index/icon", "");
        String displayType = this.getValue(indexDoc, "/index/display-type", "icons");
        boolean visible = this.getValue(indexDoc, "/index/visible", "false").equalsIgnoreCase("true");
        if (solution == null) {
            directoryNode.addAttribute("name", solution);
        } else {
            directoryNode.addAttribute("name", XmlHelper.encode((String)directoryFile.getName()));
        }
        directoryNode.addElement("title").setText(dirName);
        directoryNode.addAttribute("path", XmlHelper.encode((String)path));
        directoryNode.addElement("description").setText(description);
        if (!StringUtil.isEmpty((String)iconPath)) {
            String rolloverIconPath = null;
            int rolloverIndex = iconPath.indexOf("|");
            if (rolloverIndex > -1) {
                rolloverIconPath = iconPath.substring(rolloverIndex + 1);
                iconPath = iconPath.substring(0, rolloverIndex);
            }
            if (this.publishIcon(PentahoSystem.getApplicationContext().getSolutionPath(solution + File.separator + path), iconPath)) {
                directoryNode.addElement("icon").setText("getImage?image=icons/" + iconPath);
            } else {
                directoryNode.addElement("icon").setText(iconPath);
            }
            if (rolloverIconPath != null) {
                if (this.publishIcon(PentahoSystem.getApplicationContext().getSolutionPath(solution + File.separator + path), rolloverIconPath)) {
                    directoryNode.addElement("rollovericon").setText("getImage?image=icons/" + rolloverIconPath);
                } else {
                    directoryNode.addElement("rollovericon").setText(rolloverIconPath);
                }
            }
        }
        directoryNode.addAttribute("visible", Boolean.toString(visible));
        directoryNode.addAttribute("displaytype", displayType);
        directoryNode.addElement("solution").setText(solution);
    }

    protected void addUrlToRepository(File file, Element parentNode, String solutionPath, int actionOperation) {
        ActionResource urlResource = new ActionResource(file.getName(), 1, "text/url", solutionPath);
        try {
            String urlContent = this.getResourceAsString((IActionSequenceResource)urlResource, actionOperation);
            StringTokenizer tokenizer = new StringTokenizer(urlContent, "\n");
            String url = null;
            String title = file.getName();
            String description = null;
            String iconPath = null;
            String target = null;
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                int pos = line.indexOf(61);
                if (pos <= 0) continue;
                String name = line.substring(0, pos);
                String value = line.substring(pos + 1);
                if (value != null && value.length() > 0 && value.charAt(value.length() - 1) == '\r') {
                    value = value.substring(0, value.length() - 1);
                }
                if ("URL".equalsIgnoreCase(name)) {
                    url = value;
                }
                if ("name".equalsIgnoreCase(name)) {
                    title = value;
                }
                if ("description".equalsIgnoreCase(name)) {
                    description = value;
                }
                if ("icon".equalsIgnoreCase(name)) {
                    iconPath = value;
                }
                if (!"target".equalsIgnoreCase(name)) continue;
                target = value;
            }
            if (url != null) {
                Element dirNode = parentNode.addElement("file");
                dirNode.addAttribute("type", "FILE.URL");
                dirNode.addElement("filename").setText(file.getName());
                dirNode.addElement("title").setText(title);
                if (target != null) {
                    dirNode.addElement("target").setText(target);
                }
                if (description != null) {
                    dirNode.addElement("description").setText(description);
                }
                if (iconPath != null && !iconPath.equals("")) {
                    String rolloverIconPath = null;
                    int rolloverIndex = iconPath.indexOf("|");
                    if (rolloverIndex > -1) {
                        rolloverIconPath = iconPath.substring(rolloverIndex + 1);
                        iconPath = iconPath.substring(0, rolloverIndex);
                    }
                    if (this.publishIcon(file.getParentFile().getAbsolutePath(), iconPath)) {
                        dirNode.addElement("icon").setText("getImage?image=icons/" + iconPath);
                    } else {
                        dirNode.addElement("icon").setText(iconPath);
                    }
                    if (rolloverIconPath != null) {
                        if (this.publishIcon(PentahoSystem.getApplicationContext().getSolutionPath(solutionPath), rolloverIconPath)) {
                            dirNode.addElement("rollovericon").setText("getImage?image=icons/" + rolloverIconPath);
                        } else {
                            dirNode.addElement("rollovericon").setText(rolloverIconPath);
                        }
                    }
                }
                dirNode.addElement("url").setText(url);
                dirNode.addAttribute("visible", "true");
                dirNode.addAttribute("displaytype", "url");
                this.localizeDoc((Node)dirNode, new FileSolutionFile(file, ((FileSolutionFile)this.getRootFolder(actionOperation)).getFile()));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected void addToRepository(IActionSequence actionSequence, Element parentNode, File file) {
        String displayType;
        Element dirNode = parentNode.addElement("file");
        dirNode.addAttribute("type", "FILE.ACTIVITY");
        if (actionSequence.getSequenceName() == null || actionSequence.getSolutionPath() == null || actionSequence.getSolutionName() == null) {
            this.error(Messages.getString("SolutionRepository.ERROR_0008_ACTION_SEQUENCE_NAME_INVALID"));
            return;
        }
        dirNode.addElement("filename").setText(actionSequence.getSequenceName());
        dirNode.addElement("path").setText(actionSequence.getSolutionPath());
        dirNode.addElement("solution").setText(actionSequence.getSolutionName());
        String title = actionSequence.getTitle();
        if (title == null) {
            dirNode.addElement("title").setText(actionSequence.getSequenceName());
        } else {
            dirNode.addElement("title").setText(title);
        }
        String description = actionSequence.getDescription();
        if (description == null) {
            dirNode.addElement("description");
        } else {
            dirNode.addElement("description").setText(description);
        }
        String author = actionSequence.getAuthor();
        if (author == null) {
            dirNode.addElement("author");
        } else {
            dirNode.addElement("author").setText(author);
        }
        String iconPath = actionSequence.getIcon();
        if (iconPath != null && !iconPath.equals("")) {
            String rolloverIconPath = null;
            int rolloverIndex = iconPath.indexOf("|");
            if (rolloverIndex > -1) {
                rolloverIconPath = iconPath.substring(rolloverIndex + 1);
                iconPath = iconPath.substring(0, rolloverIndex);
            }
            if (this.publishIcon(file.getParentFile().getAbsolutePath(), iconPath)) {
                dirNode.addElement("icon").setText("getImage?image=icons/" + iconPath);
            } else {
                dirNode.addElement("icon").setText(actionSequence.getIcon());
            }
            if (rolloverIconPath != null) {
                if (this.publishIcon(PentahoSystem.getApplicationContext().getSolutionPath(actionSequence.getSolutionName() + File.separator + actionSequence.getSolutionPath()), rolloverIconPath)) {
                    dirNode.addElement("rollovericon").setText("getImage?image=icons/" + rolloverIconPath);
                } else {
                    dirNode.addElement("rollovericon").setText(rolloverIconPath);
                }
            }
        }
        if ((displayType = actionSequence.getResultType()) == null || "none".equalsIgnoreCase(displayType)) {
            dirNode.addAttribute("visible", "false");
        } else {
            dirNode.addAttribute("visible", "true");
            dirNode.addAttribute("displaytype", displayType);
        }
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getSession());
        boolean subscribable = false;
        if (subscriptionRepository != null) {
            subscribable = subscriptionRepository.getContentByActionReference(actionSequence.getSolutionName() + '/' + actionSequence.getSolutionPath() + '/' + actionSequence.getSequenceName()) != null;
        }
        dirNode.addElement("properties").setText("subscribable=" + Boolean.toString(subscribable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean publishIcon(String dirPath, String iconPath) {
        File iconSource = new File(dirPath + File.separator + iconPath);
        if (iconSource.exists()) {
            File tmpDir = this.getFile("system/tmp/icons", true);
            tmpDir.mkdirs();
            File iconDestintation = new File(tmpDir.getAbsoluteFile() + File.separator + iconPath);
            if (iconDestintation.exists()) {
                iconDestintation.delete();
            }
            try {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(iconSource));
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(iconDestintation));
                try {
                    IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
                }
                finally {
                    ((OutputStream)outputStream).close();
                    ((InputStream)stream).close();
                }
            }
            catch (FileNotFoundException e) {
                this.error(e.getLocalizedMessage());
            }
            catch (IOException e) {
                this.error(e.getLocalizedMessage());
            }
            return true;
        }
        return false;
    }

    public Document getSolutions(String solutionName, String pathName, int actionOperation, boolean visibleOnly) {
        return this.getSolutions(actionOperation);
    }

    @Override
    public Document getSolutions(int actionOperation) {
        Object cachedRepo = this.getRepositoryObjectFromCache(this.getRepositoryKey());
        if (cachedRepo == null) {
            this.reloadSolutionRepository(this.getSession(), this.loggingLevel);
            cachedRepo = this.getRepositoryObjectFromCache(this.getRepositoryKey());
        }
        return (Document)cachedRepo;
    }

    private Document getActionSequences(String solution, String path, boolean subDirectories, boolean visibleOnly, int actionOperation) {
        List nodes = solution == null ? this.getSolutionNames(solution, path, actionOperation, visibleOnly) : this.getFileListIterator(solution, path, subDirectories, visibleOnly);
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("files");
        Element pathNames = root.addElement("location");
        pathNames.setText(this.getPathNames(solution, path));
        for (Node node : nodes) {
            root.add((Node)node.clone());
        }
        return document;
    }

    private String getPathNames(String solutionId, String path) {
        String[] folders;
        Document repository = (Document)this.getRepositoryObjectFromCache(this.getRepositoryKey());
        if (repository == null) {
            this.reloadSolutionRepository(this.getSession(), this.loggingLevel);
            repository = (Document)this.getRepositoryObjectFromCache(this.getRepositoryKey());
        }
        if (solutionId == null) {
            return "";
        }
        String xPath = "/repository/file[@type=\"FILE.FOLDER\"][@name=\"" + XmlHelper.encode((String)solutionId) + "\"]";
        if (path != null && (folders = path.split("/")) != null) {
            for (String element : folders) {
                xPath = xPath + "/file[@type=\"FILE.FOLDER\"][@name=\"" + XmlHelper.encode((String)element) + "\"]";
                xPath = xPath + "[@visible=\"true\"]";
            }
        }
        StringBuffer sb = new StringBuffer();
        List list = repository.selectNodes(xPath);
        if (list != null && list.size() > 0) {
            boolean done = false;
            for (Element node = (Element)list.get(0); node != null && !done; node = node.getParent()) {
                Node titleNode = node.selectSingleNode("title");
                if (titleNode != null) {
                    String name = titleNode.getText();
                    sb.insert(0, name + "/");
                    continue;
                }
                done = true;
            }
        }
        return sb.toString();
    }

    private List getFileListIterator(String solutionId, String path, boolean subDirectories, boolean visibleOnly) {
        String[] folders;
        Document repository = (Document)this.getRepositoryObjectFromCache(this.getRepositoryKey());
        if (repository == null) {
            this.reloadSolutionRepository(this.getSession(), this.loggingLevel);
            repository = (Document)this.getRepositoryObjectFromCache(this.getRepositoryKey());
        }
        String xPath = solutionId == null ? "/repository/file[@type=\"FILE.FOLDER\"]" : "/repository/file[@type=\"FILE.FOLDER\"][@name=\"" + XmlHelper.encode((String)solutionId) + "\"]";
        if (path != null && (folders = path.split("/")) != null) {
            for (String element : folders) {
                xPath = xPath + "/file[@type=\"FILE.FOLDER\"][@name=\"" + XmlHelper.encode((String)element) + "\"]";
                if (!visibleOnly) continue;
                xPath = xPath + "[@visible=\"true\"]";
            }
        }
        if (subDirectories) {
            xPath = "descendant-or-self::" + xPath;
        }
        this.debug(Messages.getString("SolutionRepository.DEBUG_FILE_LIST_XPATH", xPath));
        return repository.selectNodes(xPath);
    }

    public Document getSolutionStructure(int actionOperation) {
        Document document = DocumentHelper.createDocument();
        File rootDir = this.getFile("", false);
        Element root = document.addElement("repository").addAttribute("location", rootDir.getAbsolutePath());
        this.processSolutionTree(root, rootDir);
        return document;
    }

    public Document getSolutionTree(int actionOperation, ISolutionFilter filter) {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("tree");
        SolutionReposHelper.processSolutionTree((Element)root, (ISolutionFile)new FileSolutionFile(this.rootFile, this.rootFile), (ISolutionFilter)filter, (int)actionOperation);
        return document;
    }

    public Document getSolutionTree(int actionOperation) {
        return this.getSolutionTree(actionOperation, this.defaultSolutionFilter);
    }

    private void processSolutionTree(Element parentNode, File targetFile) {
        if (targetFile.isDirectory()) {
            if (!SolutionReposHelper.ignoreDirectory((String)targetFile.getName())) {
                File[] files;
                Element childNode = parentNode.addElement("entry").addAttribute("type", "directory").addAttribute("name", targetFile.getName());
                for (File file : files = targetFile.listFiles()) {
                    this.processSolutionTree(childNode, file);
                }
            }
        } else if (!targetFile.isHidden() && !SolutionReposHelper.ignoreFile((String)targetFile.getName())) {
            parentNode.addElement("entry").addAttribute("type", "file").addAttribute("name", targetFile.getName());
        }
    }

    public boolean resourceExists(String solutionPath, int actionOperation) {
        String filePath = PentahoSystem.getApplicationContext().getSolutionPath(solutionPath);
        File file = new File(filePath);
        return file.exists();
    }

    public long resourceSize(String solutionPath, int actionOperation) {
        if (!this.resourceExists(solutionPath, actionOperation)) {
            return -1L;
        }
        String filePath = PentahoSystem.getApplicationContext().getSolutionPath(solutionPath);
        File file = new File(filePath);
        return file.length();
    }

    public String[] getAllActionSequences(int actionOperation) {
        File rootDir = this.getFile("", false);
        List files = new ArrayList();
        files = this.getAllActionSequences(rootDir, files);
        String[] value = new String[files.size()];
        Iterator iter = files.iterator();
        int i = 0;
        int solutionPathOffset = PentahoSystem.getApplicationContext().getSolutionPath("").length();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            String filePath = file.getAbsolutePath();
            filePath = filePath.substring(solutionPathOffset);
            filePath = filePath.replace('\\', '/');
            value[i++] = filePath;
        }
        return value;
    }

    private List getAllActionSequences(File rootDir, List files) {
        File[] fileArray;
        if (!rootDir.isDirectory()) {
            return files;
        }
        for (File element : fileArray = rootDir.listFiles(new xActionFileFilter())) {
            files.add(element);
        }
        for (File element : fileArray = rootDir.listFiles()) {
            if (!element.isDirectory()) continue;
            this.getAllActionSequences(element, files);
        }
        return files;
    }

    public long getSolutionFileLastModified(String path, int actionOperation) {
        File file = this.getFile(path, false);
        long mod = -1L;
        if (file != null) {
            mod = file.lastModified();
        }
        return mod;
    }

    @Override
    public Document getNavigationUIDocument(String solution, String path, int actionOperation) {
        Document document = null;
        document = StringUtil.isEmpty((String)solution) ? this.getSolutions(1) : this.getActionSequences(solution, path, false, true, 1);
        return document;
    }

    public String getRepositoryName() {
        return "";
    }

    public boolean supportsAccessControls() {
        return false;
    }

    private String getRepositoryKey() {
        return "repository" + this.getLocale().toString();
    }

    public boolean hasAccess(ISolutionFile file, int actionOperation) {
        return true;
    }

    public int publish(String baseUrl, String path, String fileName, byte[] data, boolean overwrite) throws PentahoAccessControlException {
        return this.addSolutionFile(baseUrl, path, fileName, data, overwrite);
    }

    public int publish(String baseUrl, String path, String fileName, File f, boolean overwrite) throws PentahoAccessControlException {
        return this.addSolutionFile(baseUrl, path, fileName, f, overwrite);
    }

    public void share(ISolutionFile file, List<IPermissionRecipient> shareRecipient) {
    }

    public void addPermission(ISolutionFile file, IPermissionRecipient recipient, IPermissionMask permission) {
    }

    public void setPermissions(ISolutionFile file, Map<IPermissionRecipient, IPermissionMask> acl) throws PentahoAccessControlException {
    }

    public Map<IPermissionRecipient, IPermissionMask> getPermissions(ISolutionFile file) {
        return Collections.emptyMap();
    }

    public Map<IPermissionRecipient, IPermissionMask> getEffectivePermissions(ISolutionFile file) {
        return Collections.emptyMap();
    }

    public boolean synchronizeSolutionWithSolutionSource(IPentahoSession pSession) {
        throw new UnsupportedOperationException("Synchronization is not supported by this implementor");
    }

    public boolean solutionSynchronizationSupported() {
        return false;
    }

    private class DefaultSolutionFilter
    implements ISolutionFilter {
        private DefaultSolutionFilter() {
        }

        public boolean keepFile(ISolutionFile solutionFile, int actionOperation) {
            return true;
        }
    }

    class xActionFileFilter
    implements FilenameFilter {
        xActionFileFilter() {
        }

        public boolean accept(File dir, String name) {
            int seperatorIndex = name.lastIndexOf(46);
            if (seperatorIndex != -1) {
                return name.substring(name.lastIndexOf(46)).equalsIgnoreCase(".xaction");
            }
            return false;
        }
    }
}

