/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.filebased;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.solution.filebased.FileBasedSolutionRepository;

public class FileInfo {
    public static final String FILE_TYPE_ACTIVITY = "FILE.ACTIVITY";
    public static final String FILE_TYPE_FOLDER = "FILE.FOLDER";
    public static final String FILE_TYPE_RULES = "FILE_RULES";
    public static final String FILE_TYPE_REPORT = "FILE_REPORT";
    public static final String FILE_TYPE_WORKFLOW = "FILE_WORKFLOW";
    public static final String FILE_TYPE_XPDL = "FILE_XPDL";
    public static final String FILE_TYPE_BIRT = "FILE_BIRT";
    public static final String FILE_TYPE_MODEL = "FILE_MODEL";
    public static final String FILE_TYPE_VIEW = "FILE_VIEW";
    public static final String FILE_TYPE_CONTENT = "FILE_CONTENT";
    public static final String FILE_TYPE_XML = "FILE_XML";
    public static final String FILE_TYPE_INDEX = "FILE_INDEX";
    public static final String FILE_TYPE_URL = "FILE.URL";
    public static final String FILE_DISPLAY_TYPE_SOLUTION = "solution";
    public static final String FILE_DISPLAY_TYPE_FOLDER = "folder";
    public static final String FILE_DISPLAY_TYPE_REPORT = "report";
    public static final String FILE_DISPLAY_TYPE_PROCESS = "process";
    public static final String FILE_DISPLAY_TYPE_RULE = "rule";
    public static final String FILE_DISPLAY_TYPE_VIEW = "view";
    public static final String FILE_DISPLAY_TYPE_URL = "url";
    public static final String FILE_DISPLAY_TYPE_UNKNOWN = "unknown";
    private String author;
    private String fileName;
    private String solutionId;
    private String path;
    private String name;
    private String description;
    private boolean hasParameters;
    private Date lastUpdated;
    private long size;
    private List parameterNames;
    private String type;
    private String mimeType;
    private String iconPath;
    private String url;
    private String displayType;
    private boolean visible;

    public FileInfo() {
    }

    public FileInfo(String fileName, Date lastModified, String path, String solutionId, FileBasedSolutionRepository repository) {
        this.path = path;
        this.solutionId = solutionId;
        String fileNameCaseless = fileName.toLowerCase();
        this.hasParameters = false;
        this.iconPath = null;
        this.url = null;
        this.displayType = FILE_DISPLAY_TYPE_UNKNOWN;
        if (fileNameCaseless.endsWith(".xaction")) {
            Document doc = repository.getSolutionDocument(solutionId, path, fileName, 1);
            if (doc == null && doc != null) {
                this.type = FILE_TYPE_ACTIVITY;
                this.mimeType = "text/xml";
                this.name = doc.selectSingleNode("/pentaho-activity/activity-info/name").getText();
                this.description = doc.selectSingleNode("/pentaho-activity/activity-info/description").getText();
                this.author = doc.selectSingleNode("/pentaho-activity/activity-info/author").getText();
                Node node = doc.selectSingleNode("/pentaho-activity/activity-info/display-type");
                if (node != null) {
                    this.displayType = node.getText();
                    if (!(this.displayType.equals(FILE_DISPLAY_TYPE_PROCESS) || this.displayType.equals(FILE_DISPLAY_TYPE_REPORT) || this.displayType.equals(FILE_DISPLAY_TYPE_RULE) || this.displayType.equals(FILE_DISPLAY_TYPE_VIEW))) {
                        this.displayType = FILE_DISPLAY_TYPE_UNKNOWN;
                    }
                }
                this.visible = (node = doc.selectSingleNode("/pentaho-activity/activity-info/visible")) != null ? "true".equalsIgnoreCase(node.getText()) : false;
                node = doc.selectSingleNode("/pentaho-activity/activity-info/result-mime-type");
                if (node != null) {
                    this.mimeType = node.getText();
                }
                this.lastUpdated = null;
                this.size = -1L;
                List params = doc.selectNodes("/pentaho-activity/activity-definition[1]/parameters/parameter/name");
                if (params != null) {
                    Iterator it = params.iterator();
                    this.parameterNames = new ArrayList();
                    while (it.hasNext()) {
                        this.parameterNames.add(((Element)it.next()).getText());
                        this.hasParameters = true;
                    }
                }
            }
        } else if (fileNameCaseless.endsWith(".xml")) {
            this.visible = false;
            if (fileNameCaseless.endsWith("rules.xml")) {
                this.type = FILE_TYPE_RULES;
            } else if (fileNameCaseless.endsWith("birt.xml")) {
                this.type = FILE_TYPE_BIRT;
                this.visible = true;
            } else {
                this.type = fileNameCaseless.endsWith("report.xml") ? FILE_TYPE_REPORT : (fileNameCaseless.endsWith("workflow.xml") ? FILE_TYPE_WORKFLOW : (fileNameCaseless.endsWith("view.xml") ? FILE_TYPE_VIEW : (fileNameCaseless.endsWith("model.xml") ? FILE_TYPE_MODEL : (fileNameCaseless.endsWith("index.xml") ? FILE_TYPE_INDEX : FILE_TYPE_XML))));
            }
            this.mimeType = "text/xml";
            Document doc = repository.getSolutionDocument(solutionId, path, fileName, 1);
            if (doc != null) {
                Node node = doc.selectSingleNode("//file-info/name");
                this.name = node == null ? fileName.replace('_', ' ') : node.getText();
                node = doc.selectSingleNode("//file-info/description");
                this.description = node == null ? "" : node.getText();
                node = doc.selectSingleNode("//file-info/author");
                this.author = node == null ? "" : node.getText();
                node = doc.selectSingleNode("//file-info/icon");
                this.iconPath = node == null ? "" : node.getText();
                node = doc.selectSingleNode("//file-info/url");
                if (node == null) {
                    this.url = "";
                } else {
                    this.url = node.getText();
                    this.type = FILE_TYPE_URL;
                }
                node = doc.selectSingleNode("//file-info/visible");
                if (node != null) {
                    this.visible = "true".equalsIgnoreCase(node.getText());
                }
                if ((node = doc.selectSingleNode("//file-info/result-mime-type")) != null) {
                    this.mimeType = node.getText();
                }
                if ((node = doc.selectSingleNode("//file-info/display-type")) != null) {
                    this.displayType = node.getText();
                    if (!(this.displayType.equals(FILE_DISPLAY_TYPE_PROCESS) || this.displayType.equals(FILE_DISPLAY_TYPE_REPORT) || this.displayType.equals(FILE_DISPLAY_TYPE_RULE) || this.displayType.equals(FILE_DISPLAY_TYPE_VIEW))) {
                        this.displayType = FILE_DISPLAY_TYPE_UNKNOWN;
                    }
                }
                this.lastUpdated = null;
                this.size = -1L;
                List params = doc.selectNodes("//parameters/parameter/name");
                if (params != null) {
                    Iterator it = params.iterator();
                    this.parameterNames = new ArrayList();
                    while (it.hasNext()) {
                        this.parameterNames.add(((Element)it.next()).getText());
                        this.hasParameters = true;
                    }
                }
            }
        } else {
            if (fileNameCaseless.endsWith(".xpdl")) {
                this.mimeType = "text/xml";
                this.type = FILE_TYPE_XPDL;
                this.visible = false;
            } else if (fileNameCaseless.endsWith(".pdf")) {
                this.mimeType = "application/pdf";
                this.type = FILE_TYPE_CONTENT;
                this.visible = true;
            } else if (fileNameCaseless.endsWith(".html")) {
                this.mimeType = "text/html";
                this.type = FILE_TYPE_CONTENT;
                this.visible = true;
            } else if (fileNameCaseless.endsWith(".htm")) {
                this.mimeType = "text/html";
                this.type = FILE_TYPE_CONTENT;
                this.visible = true;
            } else if (fileNameCaseless.endsWith(".xhtml")) {
                this.mimeType = "text/html";
                this.type = FILE_TYPE_CONTENT;
                this.visible = true;
            }
            this.name = fileName.replace('_', ' ');
            this.author = "";
            this.description = "";
            this.hasParameters = false;
            this.lastUpdated = lastModified;
            this.size = -1L;
            this.parameterNames = null;
        }
    }

    public FileInfo(Element node, ILogger logger) {
        String fileType = node.attributeValue("type");
        if (fileType == null) {
            logger.error(Messages.getErrorString("FileInfo.ERROR_0001_DOCUMENT_HAS_NO_TYPE"));
        } else if (node.attributeValue("type").equals(FILE_TYPE_FOLDER)) {
            this.initFolderFromNode(node, logger);
        } else {
            this.initFileInfoFromNode(node, logger);
        }
    }

    private void initFileInfoFromNode(Element node, ILogger logger) {
        try {
            this.type = node.attributeValue("type");
            this.mimeType = node.attributeValue("mimetype");
            this.displayType = node.attributeValue("displaytype");
            this.visible = "true".equalsIgnoreCase(node.attributeValue("visible"));
            Node tmpNode = node.selectSingleNode("filename");
            if (tmpNode != null) {
                this.fileName = tmpNode.getText();
            }
            if ((tmpNode = node.selectSingleNode(FILE_DISPLAY_TYPE_SOLUTION)) != null) {
                this.solutionId = tmpNode.getText();
            }
            if ((tmpNode = node.selectSingleNode("path")) != null) {
                this.path = tmpNode.getText();
            }
            if ((tmpNode = node.selectSingleNode("name")) != null) {
                this.name = tmpNode.getText();
            }
            if ((tmpNode = node.selectSingleNode("description")) != null) {
                this.description = tmpNode.getText();
            }
            if ((tmpNode = node.selectSingleNode("has-parameters")) != null) {
                this.hasParameters = "true".equals(tmpNode.getText());
            }
            if ((tmpNode = node.selectSingleNode("last-modified")) != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    this.lastUpdated = format.parse(tmpNode.getText());
                }
                catch (Exception e) {
                    this.lastUpdated = null;
                }
            }
            this.size = -1L;
            tmpNode = node.selectSingleNode("size");
            if (tmpNode != null) {
                this.size = new Long(tmpNode.getText());
            }
            if ((tmpNode = node.selectSingleNode("author")) != null) {
                this.author = tmpNode.getText();
            }
            if ((tmpNode = node.selectSingleNode("icon")) != null) {
                this.iconPath = tmpNode.getText();
            }
            if ((tmpNode = node.selectSingleNode(FILE_DISPLAY_TYPE_URL)) != null) {
                this.url = tmpNode.getText();
            }
            List parameterList = node.selectNodes("parameters/parameter/name");
            this.hasParameters = false;
            if (parameterList != null) {
                this.parameterNames = new ArrayList();
                Iterator it = parameterList.iterator();
                while (it.hasNext()) {
                    this.parameterNames.add(((Node)it.next()).getText());
                    this.hasParameters = true;
                }
            } else {
                this.parameterNames = null;
            }
        }
        catch (Exception e) {
            logger.error(Messages.getErrorString("FileInfo.ERROR_0002_COULD_NOT_LOAD"), (Throwable)e);
        }
    }

    private void initFolderFromNode(Element node, ILogger logger) {
        try {
            this.type = FILE_TYPE_FOLDER;
            this.path = node.selectSingleNode("path").getText();
            this.name = node.selectSingleNode("name").getText();
            this.description = node.selectSingleNode("description").getText();
            this.iconPath = node.selectSingleNode("icon").getText();
            this.visible = "true".equalsIgnoreCase(node.selectSingleNode("@visible").getText());
            this.solutionId = node.selectSingleNode(FILE_DISPLAY_TYPE_SOLUTION).getText();
        }
        catch (Exception e) {
            logger.error(Messages.getErrorString("FileInfo.ERROR_0002_COULD_NOT_LOAD"), (Throwable)e);
        }
    }

    public Element toXmlNode(Element parent) {
        Element node = parent.addElement("file");
        if (this.type != null) {
            node.addAttribute("type", this.type);
        }
        if (this.path != null) {
            node.addElement("path").setText(this.path);
        }
        if (this.name != null) {
            node.addElement("name").setText(this.name);
        }
        if (this.mimeType != null) {
            node.addAttribute("mimetype", this.mimeType);
        }
        if (this.displayType != null) {
            node.addAttribute("displaytype", this.displayType);
        }
        node.addAttribute("visible", Boolean.toString(this.visible));
        if (this.author != null) {
            node.addElement("author").setText(this.author);
        }
        if (this.fileName != null) {
            node.addElement("filename").setText(this.fileName);
        }
        if (this.solutionId != null) {
            node.addElement(FILE_DISPLAY_TYPE_SOLUTION).setText(this.solutionId);
        }
        if (this.url != null) {
            node.addElement(FILE_DISPLAY_TYPE_URL).setText(this.url);
        }
        if (this.size != -1L) {
            node.addElement("size").setText(new Long(this.size).toString());
        }
        if (this.description != null) {
            node.addElement("description").setText(this.description);
        }
        if (this.iconPath != null) {
            node.addElement("icon").setText(this.iconPath);
        }
        if (this.lastUpdated == null) {
            node.addElement("last-modified").setText("");
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            node.addElement("last-updated").setText(format.format(this.lastUpdated));
        }
        if (this.parameterNames != null) {
            node.addElement("has-parameters").setText("true");
            Element parametersNode = node.addElement("parameters");
            for (int idx = 0; idx < this.parameterNames.size(); ++idx) {
                parametersNode.addElement("parameter").addElement("name").setText((String)this.parameterNames.get(idx));
            }
        } else {
            node.addElement("has-parameters").setText("false");
        }
        return node;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public long getSize() {
        return this.size;
    }

    public boolean getHasParameters() {
        return this.hasParameters;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public String getDescription() {
        return this.description;
    }

    public List getParamterNames() {
        return this.parameterNames;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setHasParameters(boolean hasParameters) {
        this.hasParameters = hasParameters;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParamterNames(List parameterNames) {
        this.parameterNames = parameterNames;
    }
}

