/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.filebased;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.pentaho.platform.api.engine.IFileFilter;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.util.FileHelper;

public class FileSolutionFile
implements ISolutionFile {
    String solutionName = "";
    String pathName = "";
    String fileName = "";
    String extension = "";
    int solutionAbsoluteStart = 0;
    File file = null;
    File solutionRoot = null;

    public FileSolutionFile(File inFile, File inSolutionRoot) {
        int pos;
        if (inFile == null) {
            throw new NullPointerException("The file can not be null!");
        }
        this.file = inFile;
        this.solutionRoot = inSolutionRoot;
        this.solutionAbsoluteStart = this.solutionRoot == null ? 0 : this.solutionRoot.getAbsolutePath().length() - this.solutionRoot.getName().length();
        int solutionNameLength = this.solutionRoot == null ? 0 : this.solutionRoot.getName().length();
        String fullName = this.file.getAbsolutePath().substring(this.solutionAbsoluteStart);
        fullName = fullName.replace('\\', '/');
        this.solutionName = fullName.substring(0, solutionNameLength);
        this.fileName = this.file.getName();
        if (this.file.isDirectory()) {
            if (fullName.length() > solutionNameLength) {
                this.pathName = fullName.substring(solutionNameLength + 1);
            }
        } else {
            this.pathName = solutionNameLength > 0 && fullName.length() > solutionNameLength + this.fileName.length() + 1 ? fullName.substring(solutionNameLength + 1, fullName.length() - this.fileName.length() - 1) : fullName.substring(0, fullName.length() - this.fileName.length() - 1);
            if (this.pathName.equals(this.solutionName)) {
                this.pathName = "";
            }
        }
        if ((pos = this.fileName.lastIndexOf(46)) != -1) {
            this.extension = this.fileName.substring(pos + 1);
        }
    }

    public boolean isDirectory() {
        return this.file != null && this.file.isDirectory();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSolutionPath() {
        return this.pathName;
    }

    public String getSolution() {
        return this.solutionName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getFullPath() {
        String fullName = "/" + this.solutionName;
        if (this.pathName.length() > 0) {
            fullName = fullName + "/" + this.pathName;
        }
        if (!this.isDirectory() && this.fileName.length() > 0) {
            fullName = fullName + "/" + this.fileName;
        }
        return fullName;
    }

    public String getFileType() {
        int dotIndex = this.fileName.lastIndexOf(46);
        return dotIndex < 0 ? "" : this.fileName.substring(dotIndex);
    }

    public ISolutionFile[] listFiles() {
        if (this.file == null) {
            return null;
        }
        File[] files = this.file.listFiles();
        if (files == null) {
            return null;
        }
        ISolutionFile[] solFiles = new ISolutionFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            FileSolutionFile solFile = new FileSolutionFile(files[i], this.solutionRoot);
            solFiles[i] = solFile;
        }
        return solFiles;
    }

    public String toString() {
        return this.getSolution() + " : " + this.getSolutionPath() + " : " + this.getFileName() + " : " + this.getFileType();
    }

    public static void main(String[] args) {
        File f = new File("E:/eclipse/workspace/pentaho-samples/solutions/test-solution");
        FileSolutionFile.printRecursive(new FileSolutionFile(f, f));
    }

    private static void printRecursive(ISolutionFile sFile) {
        if (sFile.isDirectory()) {
            ISolutionFile[] sFiles;
            for (ISolutionFile element : sFiles = sFile.listFiles()) {
                FileSolutionFile.printRecursive(element);
            }
        }
    }

    public boolean isRoot() {
        if (this.file != null) {
            if (this.solutionRoot != null) {
                try {
                    return this.solutionRoot.getCanonicalPath().equals(this.file.getCanonicalPath());
                }
                catch (IOException iOException) {
                }
            } else {
                return this.file.getParentFile() == null;
            }
        }
        return false;
    }

    public byte[] getData() {
        try {
            return FileHelper.getBytesFromFile((File)this.file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public ISolutionFile retrieveParent() {
        return new FileSolutionFile(this.file.getParentFile(), this.solutionRoot);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public ISolutionFile[] listFiles(IFileFilter filter) {
        ISolutionFile[] objArray;
        ArrayList<ISolutionFile> matchedFiles = new ArrayList<ISolutionFile>();
        for (ISolutionFile element : objArray = this.listFiles()) {
            if (!filter.accept(element)) continue;
            matchedFiles.add(element);
        }
        return matchedFiles.toArray(new ISolutionFile[0]);
    }
}

