/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution.filebased;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.operations.FileOperations;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.repository.solution.filebased.SolutionRepositoryFileName;
import org.pentaho.platform.repository.solution.filebased.SolutionRepositoryVfsFileContent;

public class SolutionRepositoryVfsFileObject
implements FileObject {
    private String solution;
    private String path;
    private String action;
    private String fileRef;
    private ISolutionRepository repository;
    private FileContent content = null;
    private FileName name;
    private FileType type;

    public SolutionRepositoryVfsFileObject(String fileRef, ISolutionRepository repository) {
        this.repository = repository;
        this.fileRef = fileRef;
        ActionInfo info = ActionInfo.parseActionString((String)fileRef, (boolean)false);
        if (info != null) {
            this.solution = info.getSolutionName();
            this.path = info.getPath();
            this.action = info.getActionName();
            this.type = this.action == null ? FileType.FOLDER : FileType.FILE;
        } else {
            this.type = FileType.FOLDER;
        }
        this.name = new SolutionRepositoryFileName(fileRef, this.type);
    }

    public SolutionRepositoryVfsFileObject(String fileRef, ISolutionRepository repository, FileType type) {
        this.repository = repository;
        this.fileRef = fileRef;
        ActionInfo info = ActionInfo.parseActionString((String)fileRef, (boolean)false);
        if (info != null) {
            this.solution = info.getSolutionName();
            this.path = info.getPath();
            this.action = info.getActionName();
        } else {
            this.solution = null;
            this.path = null;
            this.action = null;
        }
        this.type = type;
        this.name = new SolutionRepositoryFileName(fileRef, type);
    }

    public ISolutionRepository getRepository() {
        return this.repository;
    }

    public String getFileRef() {
        return this.fileRef;
    }

    public FileName getName() {
        return this.name;
    }

    public URL getURL() throws FileSystemException {
        URL url = null;
        try {
            url = new URL("solution:/" + this.solution + "/" + this.path + "/" + this.action);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public boolean exists() throws FileSystemException {
        return this.repository.resourceExists(this.fileRef, 1);
    }

    public boolean isHidden() throws FileSystemException {
        return false;
    }

    public boolean isReadable() throws FileSystemException {
        return this.exists();
    }

    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    public FileType getType() throws FileSystemException {
        return this.type;
    }

    public FileObject getParent() throws FileSystemException {
        return null;
    }

    public FileSystem getFileSystem() {
        return null;
    }

    public FileObject[] getChildren() throws FileSystemException {
        ArrayList<SolutionRepositoryVfsFileObject> fileList = new ArrayList<SolutionRepositoryVfsFileObject>();
        if (this.solution == null) {
            ISolutionFile[] files;
            for (ISolutionFile element : files = this.repository.getRootFolder(1).listFiles()) {
                if (!element.isDirectory()) continue;
                SolutionRepositoryVfsFileObject fileInfo = new SolutionRepositoryVfsFileObject("/" + element.getFileName(), this.repository, FileType.FOLDER);
                fileList.add(fileInfo);
            }
        } else {
            ISolutionFile[] files;
            ISolutionFile file = this.repository.getSolutionFile(this.fileRef, 1);
            if (file == null) {
                return new FileObject[0];
            }
            for (ISolutionFile element : files = file.listFiles()) {
                SolutionRepositoryVfsFileObject fileInfo;
                if (element.isDirectory()) {
                    fileInfo = new SolutionRepositoryVfsFileObject("/" + element.getFileName(), this.repository, FileType.FOLDER);
                    fileList.add(fileInfo);
                    continue;
                }
                fileInfo = new SolutionRepositoryVfsFileObject(this.fileRef + "/" + element.getFileName(), this.repository, FileType.FILE);
                fileList.add(fileInfo);
            }
        }
        FileObject[] fileObjects = new FileObject[fileList.size()];
        fileList.toArray(fileObjects);
        return fileObjects;
    }

    public FileObject getChild(String arg0) throws FileSystemException {
        return null;
    }

    public FileObject resolveFile(String arg0, NameScope arg1) throws FileSystemException {
        return null;
    }

    public FileObject resolveFile(String arg0) throws FileSystemException {
        return null;
    }

    public FileObject[] findFiles(FileSelector arg0) throws FileSystemException {
        return null;
    }

    public void findFiles(FileSelector arg0, boolean arg1, List arg2) throws FileSystemException {
    }

    public boolean delete() throws FileSystemException {
        return false;
    }

    public int delete(FileSelector arg0) throws FileSystemException {
        return 0;
    }

    public void createFolder() throws FileSystemException {
    }

    public void createFile() throws FileSystemException {
    }

    public void copyFrom(FileObject arg0, FileSelector arg1) throws FileSystemException {
    }

    public void moveTo(FileObject arg0) throws FileSystemException {
    }

    public boolean canRenameTo(FileObject arg0) {
        return false;
    }

    public FileContent getContent() throws FileSystemException {
        this.content = new SolutionRepositoryVfsFileContent(this);
        return this.content;
    }

    public void close() throws FileSystemException {
        if (this.content != null) {
            this.content.close();
            this.content = null;
        }
    }

    public void refresh() throws FileSystemException {
    }

    public boolean isAttached() {
        return false;
    }

    public boolean isContentOpen() {
        return this.content != null && this.content.isOpen();
    }

    public FileOperations getFileOperations() throws FileSystemException {
        return null;
    }
}

