/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.subscription;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.repository.ISchedule;
import org.pentaho.platform.api.repository.ISubscribeContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribeContent
implements ISubscribeContent {
    public static final String TYPE_REPORT = "report";
    public static final String TYPE_VIEW = "view";
    public static final String TYPE_DASHBOARD = "dashboard";
    private int revision = -1;
    private String id;
    private String actionReference;
    private Map<String, Object> parameters;
    private String type;
    private List<ISchedule> schedules;

    protected SubscribeContent() {
    }

    public SubscribeContent(String subContId, String actionReference, String type) {
        this.actionReference = actionReference;
        this.id = subContId;
        this.type = type;
        this.parameters = new HashMap<String, Object>();
        this.schedules = new ArrayList<ISchedule>();
    }

    public SubscribeContent(String subContId, String actionReference, String type, Map<String, Object> parameters) {
        this.actionReference = actionReference;
        this.id = subContId;
        this.type = type;
        this.parameters = parameters;
        this.schedules = new ArrayList<ISchedule>();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SubscribeContent)) {
            return false;
        }
        SubscribeContent that = (SubscribeContent)other;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public int getRevision() {
        return this.revision;
    }

    protected void setRevision(int revision) {
        this.revision = revision;
    }

    public String getActionReference() {
        return this.actionReference;
    }

    public void addSchedule(ISchedule schedule) {
        this.schedules.add(schedule);
    }

    public List<ISchedule> getSchedules() {
        return this.schedules;
    }

    public boolean hasSchedule(ISchedule schedule) {
        return this.schedules.contains(schedule);
    }

    public boolean removeSchedule(ISchedule schedule) {
        return this.schedules.remove(schedule);
    }

    public void clearsSchedules() {
        this.schedules.clear();
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    protected void setId(String value) {
        this.id = value;
    }

    public void setActionReference(String actionReference) {
        this.actionReference = actionReference;
    }

    public void setSchedules(List<ISchedule> schedules) {
        this.schedules = schedules;
    }

    public void setType(String type) {
        this.type = type;
    }
}

