/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.subscription;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.platform.api.repository.ISchedule;
import org.pentaho.platform.api.repository.ISubscribeContent;
import org.pentaho.platform.api.repository.ISubscription;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.repository.subscription.SubscribeContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription
implements ISubscription {
    public static final int TYPE_PERSONAL = 1;
    public static final int TYPE_ROLE = 2;
    public static final int TYPE_GROUP = 3;
    public static final int COLUMN_USER = 0;
    public static final int COLUMN_ID = 1;
    public static final int COLUMN_DESTINATION = 2;
    public static final int COLUMN_CONTENT_ID = 3;
    public static final int COLUMN_TITLE = 4;
    public static final int COLUMN_SOLUTION = 5;
    public static final int COLUMN_PATH = 6;
    public static final int COLUMN_ACTION = 7;
    private static final String[] baseHeaders = new String[]{"user", "id", "destination", "contentid", "title", "solution", "path", "action"};
    private String id;
    private int type;
    private String user;
    private String title;
    private ISubscribeContent content;
    private Map<String, Object> parameters;
    private List<ISchedule> schedules;
    private String destination;
    private int revision = -1;

    public static MemoryMetaData getMetadata(String[] parameterNames) {
        Object[][] columnHeaders = new Object[1][];
        String[] headerNames = new String[baseHeaders.length + parameterNames.length];
        for (int i = 0; i < baseHeaders.length; ++i) {
            headerNames[i] = baseHeaders[i];
        }
        int offset = baseHeaders.length;
        for (int i = 0; i < parameterNames.length; ++i) {
            headerNames[offset + i] = parameterNames[i];
        }
        columnHeaders[0] = headerNames;
        return new MemoryMetaData(columnHeaders, (Object[][])null);
    }

    protected Subscription() {
    }

    public Subscription(String subscriptionId, String user, String title, ISubscribeContent content, String destination, int type) {
        this(subscriptionId, user, title, content, destination, type, new HashMap<String, Object>());
    }

    public Subscription(String subscriptionId, String user, String title, ISubscribeContent content, String destination, int type, Map<String, Object> parameters) {
        this.user = user;
        this.title = title;
        this.content = content;
        this.type = type;
        this.parameters = parameters;
        this.destination = destination;
        this.schedules = new ArrayList<ISchedule>();
        this.id = subscriptionId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Subscription)) {
            return false;
        }
        Subscription that = (Subscription)other;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public int getRevision() {
        return this.revision;
    }

    protected void setRevision(int revision) {
        this.revision = revision;
    }

    public void addSchedule(ISchedule sched) {
        this.schedules.add(sched);
    }

    public boolean deleteSchedule(ISchedule sched) {
        return this.schedules.remove(sched);
    }

    public List<ISchedule> getSchedules() {
        return this.schedules;
    }

    public String getUser() {
        return this.user;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDestination() {
        return this.destination;
    }

    public ISubscribeContent getContent() {
        return this.content;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String value) {
        this.id = value;
    }

    public int getType() {
        return this.type;
    }

    public Document asDocument() {
        return null;
    }

    public String asXml() {
        return null;
    }

    protected void setContent(SubscribeContent content) {
        this.content = content;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    protected void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    protected void setSchedules(List<ISchedule> schedules) {
        this.schedules = schedules;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void setType(int type) {
        this.type = type;
    }

    protected void setUser(String user) {
        this.user = user;
    }

    public Object[] toResultRow(String[] parameterNames) {
        Object[] result = new Object[baseHeaders.length + parameterNames.length];
        result[0] = this.getUser();
        result[1] = this.getId();
        result[2] = this.getDestination();
        result[3] = this.getContent().getActionReference();
        ActionInfo contentInfo = ActionInfo.parseActionString((String)this.getContent().getActionReference());
        result[4] = this.getTitle();
        result[5] = contentInfo.getSolutionName();
        result[6] = contentInfo.getPath();
        if (this.parameters != null) {
            result[7] = this.parameters.get("action");
            if (result[7] == null) {
                result[7] = contentInfo.getActionName();
            }
        } else {
            result[7] = contentInfo.getActionName();
        }
        int offset = baseHeaders.length;
        for (int i = 0; i < parameterNames.length; ++i) {
            result[offset + i] = this.parameters.get(parameterNames[i]);
        }
        return result;
    }
}

