/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.subscription;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.commons.connection.ActivationHelper;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class SubscriptionEmailContent {
    private static final Log logger = LogFactory.getLog(SubscriptionEmailContent.class);
    private static final String MAILER = "smtpsend";
    private Properties props = new Properties();
    private IPentahoStreamSource attachment = null;
    private String attachmentName = null;

    SubscriptionEmailContent(IPentahoStreamSource inAttachment, String inAttachmentName, String inSubject, String destination) {
        this.setup();
        this.props.put("to", destination);
        this.props.put("subject", inSubject);
        this.props.put("body", Messages.getString("SubscriptionExecute.EMAIL_BODY_MESSAGE"));
        this.attachment = inAttachment;
        this.attachmentName = inAttachmentName;
    }

    public void setup() {
        try {
            Document configDocument = PentahoSystem.getSystemSettings().getSystemSettingsDocument("smtp-email/email_config.xml");
            List properties = configDocument.selectNodes("/email-smtp/properties/*");
            for (Node propertyNode : properties) {
                String propertyName = propertyNode.getName();
                String propertyValue = propertyNode.getText();
                this.props.put(propertyName, propertyValue);
            }
            this.props.put("mail.from.default", PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.from.default", (String)""));
        }
        catch (Exception e) {
            logger.error((Object)"Email.ERROR_0013_CONFIG_FILE_INVALID", (Throwable)e);
        }
    }

    public boolean send() {
        String cc = null;
        String bcc = null;
        String from = this.props.getProperty("mail.from.default");
        String to = this.props.getProperty("to");
        boolean authenticate = "true".equalsIgnoreCase(this.props.getProperty("mail.smtp.auth"));
        String subject = this.props.getProperty("subject");
        String body = this.props.getProperty("body");
        logger.info((Object)("Going to send an email to " + to + " from " + from + "with the subject '" + subject + "' and the body " + body));
        try {
            IPentahoStreamSource source;
            Session session;
            if (authenticate) {
                EmailAuthenticator authenticator = new EmailAuthenticator();
                session = Session.getInstance((Properties)this.props, (Authenticator)authenticator);
            } else {
                session = Session.getInstance((Properties)this.props);
            }
            if (!this.props.containsKey("mail.debug")) {
                session.setDebug(false);
            }
            MimeMessage msg = new MimeMessage(session);
            MimeMultipart multipart = new MimeMultipart();
            if (from != null) {
                msg.setFrom((Address)new InternetAddress(from));
            } else {
                logger.error((Object)"Email.ERROR_0012_FROM_NOT_DEFINED");
            }
            if (to != null && to.trim().length() > 0) {
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            }
            if (cc != null && cc.trim().length() > 0) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc, (boolean)false));
            }
            if (bcc != null && bcc.trim().length() > 0) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc, (boolean)false));
            }
            if (subject != null) {
                msg.setSubject(subject, LocaleHelper.getSystemEncoding());
            }
            if (body != null) {
                MimeBodyPart textBodyPart = new MimeBodyPart();
                textBodyPart.setContent((Object)body, "text/plain; charset=" + LocaleHelper.getSystemEncoding());
                multipart.addBodyPart((BodyPart)textBodyPart);
            }
            if ((source = this.attachment) == null) {
                logger.error((Object)"Email.ERROR_0015_ATTACHMENT_FAILED");
                return false;
            }
            ActivationHelper.PentahoStreamSourceWrapper dataSource = new ActivationHelper.PentahoStreamSourceWrapper(source);
            MimeBodyPart attachmentBodyPart = new MimeBodyPart();
            attachmentBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
            attachmentBodyPart.setFileName(this.attachmentName);
            multipart.addBodyPart((BodyPart)attachmentBodyPart);
            msg.setContent((Multipart)multipart);
            msg.setHeader("X-Mailer", MAILER);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            return true;
        }
        catch (SendFailedException e) {
            logger.error((Object)("Email.ERROR_0011_SEND_FAILED -" + to), (Throwable)e);
        }
        catch (AuthenticationFailedException e) {
            logger.error((Object)("Email.ERROR_0014_AUTHENTICATION_FAILED - " + to), (Throwable)e);
        }
        catch (Throwable e) {
            logger.error((Object)("Email.ERROR_0011_SEND_FAILED - " + to), e);
        }
        return false;
    }

    private class EmailAuthenticator
    extends Authenticator {
        private EmailAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            String user = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.userid", null);
            String password = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.password", null);
            return new PasswordAuthentication(user, password);
        }
    }
}

