/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.subscription;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.api.engine.SubscriptionSchedulerException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.ISchedule;
import org.pentaho.platform.api.repository.ISubscribeContent;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.api.repository.SubscriptionRepositoryCheckedException;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.PentahoSessionParameterProvider;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.engine.core.system.UserSession;
import org.pentaho.platform.engine.services.BaseRequestHandler;
import org.pentaho.platform.repository.content.CoreContentRepositoryOutputHandler;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.subscription.Subscription;
import org.pentaho.platform.repository.subscription.SubscriptionEmailContent;
import org.pentaho.platform.repository.subscription.SubscriptionHelper;
import org.pentaho.platform.repository.subscription.SubscriptionRepositoryHelper;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.util.messages.LocaleHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionExecute
extends PentahoBase {
    private static final boolean debug = true;
    private static final long serialVersionUID = -6053183867424885168L;
    private static final Log logger = LogFactory.getLog(SubscriptionExecute.class);
    private String logId;

    public Log getLogger() {
        return logger;
    }

    public String getLogId() {
        return this.logId;
    }

    public IPentahoSession getEffectiveUserSession(String userName) {
        IUserDetailsRoleListService userDetailsRoleListService = PentahoSystem.getUserDetailsRoleListService();
        if (userDetailsRoleListService != null) {
            return userDetailsRoleListService.getEffectiveUserSession(userName, null);
        }
        UserSession us = new UserSession(userName, null, null);
        us.setAuthenticated(userName);
        return us;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String scheduleReference, boolean isFinalFiring) {
        Class<SubscriptionExecute> clazz = SubscriptionExecute.class;
        synchronized (SubscriptionExecute.class) {
            PentahoSystem.systemEntryPoint();
            try {
                String sessionId = "scheduler-" + UUIDUtil.getUUIDAsString();
                StandaloneSession scheduleSession = new StandaloneSession(scheduleReference, sessionId);
                ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)scheduleSession);
                ISchedule sched = subscriptionRepository.getScheduleByScheduleReference(scheduleReference);
                if (sched == null) {
                    this.error(Messages.getErrorString("SubscriptionExecute.ERROR_0001_UNABLE_TO_GET_SCHEDULE", scheduleReference));
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                Date lastExeTm = sched.getLastTrigger();
                sched.setLastTrigger(new Date());
                List subscriptionList = subscriptionRepository.getSubscriptionsForSchedule(scheduleReference);
                this.info("FIRE: " + scheduleReference);
                for (int i = 0; i < subscriptionList.size(); ++i) {
                    Subscription sub = (Subscription)subscriptionList.get(i);
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.putAll(sub.getParameters());
                    ISubscribeContent subContent = sub.getContent();
                    ActionInfo contentInfo = ActionInfo.parseActionString((String)subContent.getActionReference());
                    String jobName = sub.getUser() + " : " + sub.getTitle();
                    IPentahoSession userSession = this.getEffectiveUserSession(sub.getUser());
                    PentahoSessionHolder.setSession((IPentahoSession)userSession);
                    paramMap.put("solution", contentInfo.getSolutionName());
                    paramMap.put("path", contentInfo.getPath());
                    paramMap.put("action", contentInfo.getActionName());
                    paramMap.put("SUB_SCHEDULED_EXECUTE", "true");
                    paramMap.put("SUB_EXECUTE_TIME", sched.getLastTrigger());
                    paramMap.put("SUB_PREV_EXECUTE_TIME", lastExeTm);
                    if (sched.isCronSchedule()) {
                        paramMap.put("SUB_SCHEDULE", sched.getCronString());
                    } else if (sched.isRepeatSchedule()) {
                        if (null != sched.getRepeatCount()) {
                            paramMap.put("SUB_SCHEDULE_REPEAT_COUNT", sched.getRepeatCount());
                        }
                        paramMap.put("SUB_SCHEDULE_REPEAT_TIME", sched.getRepeatInterval());
                    } else {
                        throw new IllegalStateException(Messages.getErrorString("SubscriptionExecute.ERROR_0005_INVALID_CRON_OR_REPEAT", sched.getId()));
                    }
                    DateFormat fmt = SubscriptionHelper.getDateTimeFormatter();
                    Date d = sched.getStartDate();
                    if (null != d) {
                        paramMap.put("SUB_START_DATE", fmt.format(d));
                    }
                    if (null != (d = sched.getEndDate())) {
                        paramMap.put("SUB_END_DATE", fmt.format(d));
                    }
                    paramMap.put("SUB_SCHEDULE_NAME", sched.getTitle());
                    paramMap.put("SUB_SCHEDULE_REF", sched.getScheduleReference());
                    paramMap.put("SUB_SCHEDULE_DESC", sched.getDescription());
                    paramMap.put("SUB_NAME", sub.getTitle());
                    paramMap.put("SUB_ID", sub.getId());
                    paramMap.put("useContentRepository", Boolean.TRUE);
                    paramMap.put("content-handler-pattern", PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() + "GetContent?id={0}");
                    paramMap.put("SUB_DESTINATION", sub.getDestination());
                    this.execute(jobName, paramMap, userSession);
                }
                if (isFinalFiring) {
                    try {
                        SubscriptionRepositoryHelper.deleteScheduleContentAndSubscription(subscriptionRepository, sched);
                    }
                    catch (SubscriptionRepositoryCheckedException e) {
                        logger.error((Object)Messages.getErrorString("SubscriptionExecute.ERROR_0004_SCHEDULE_DELETE_FAILED", scheduleReference), (Throwable)e);
                    }
                    catch (SubscriptionSchedulerException e) {
                        logger.error((Object)Messages.getErrorString("SubscriptionExecute.ERROR_0004_SCHEDULE_DELETE_FAILED", scheduleReference), (Throwable)e);
                    }
                }
            }
            finally {
                PentahoSystem.systemExitPoint();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void execute(String jobName, Map<String, Object> parametersMap, IPentahoSession userSession) {
        try {
            block21: {
                LocaleHelper.setLocale((Locale)Locale.getDefault());
                this.logId = "Pro Subscription:" + jobName;
                now = new Date();
                SubscriptionExecute.logger.info((Object)Messages.getString("SubscriptionExecute.INFO_TRIGGER_TIME", jobName, DateFormat.getDateInstance().format(now), DateFormat.getTimeInstance().format(now)));
                solutionName = (String)parametersMap.get("solution");
                actionPath = (String)parametersMap.get("path");
                actionName = (String)parametersMap.get("action");
                subscriptionDestination = (String)parametersMap.get("SUB_DESTINATION");
                instanceId = null;
                processId = this.getClass().getName();
                if (solutionName == null) {
                    this.error(Messages.getErrorString("SubscriptionExecute.ERROR_0001_SOLUTION_NAME_MISSING"));
                    return;
                }
                if (actionPath == null) {
                    this.error(Messages.getErrorString("SubscriptionExecute.ERROR_0002_ACTION_PATH_MISSING"));
                    return;
                }
                if (actionName == null) {
                    this.error(Messages.getErrorString("SubscriptionExecute.ERROR_0003_ACTION_NAME_MISSING"));
                    return;
                }
                this.debug(Messages.getString("SubscriptionExecute.DEBUG_EXECUTION_INFO", solutionName + "/" + actionPath + "/" + actionName));
                ignoreSubscriptionOutput = "true".equalsIgnoreCase((String)parametersMap.get("SUB_IGNORE_OUTPUT"));
                subscriptionId = (String)parametersMap.get("SUB_ID");
                subscriptionName = (String)parametersMap.get("SUB_NAME");
                outputHandler /* !! */  = null;
                if (ignoreSubscriptionOutput) {
                    outputHandler /* !! */  = new SimpleOutputHandler((OutputStream)null, false);
                } else {
                    contentPath = SubscriptionHelper.getSubscriptionOutputLocation(solutionName, actionPath, actionName);
                    outputHandler /* !! */  = new CoreContentRepositoryOutputHandler(contentPath, subscriptionId, solutionName, userSession);
                    ((CoreContentRepositoryOutputHandler)outputHandler /* !! */ ).setWriteMode(0);
                }
                parametersMap.put("useContentRepository", Boolean.TRUE);
                contentUrlPattern = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
                if (!contentUrlPattern.endsWith("/")) {
                    contentUrlPattern = contentUrlPattern + "/";
                }
                contentUrlPattern = contentUrlPattern + "GetContent?id={0}";
                parametersMap.put("content-handler-pattern", contentUrlPattern);
                parameterProvider = new SimpleParameterProvider(parametersMap);
                sessionParams = new PentahoSessionParameterProvider(userSession);
                lastDot = actionName.lastIndexOf(46);
                type = actionName.substring(lastDot + 1);
                pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)userSession);
                generator = pluginManager.getContentGeneratorForType(type, userSession);
                if (generator == null) {
                    requestHandler = new BaseRequestHandler(userSession, null, (IOutputHandler)outputHandler /* !! */ , (IParameterProvider)parameterProvider, null);
                    requestHandler.setParameterProvider("session", (IParameterProvider)sessionParams);
                    requestHandler.setInstanceId(instanceId);
                    requestHandler.setProcessId(processId);
                    requestHandler.setAction(actionPath, actionName);
                    requestHandler.setSolutionName(solutionName);
                    rt = null;
                    try {
                        rt = requestHandler.handleActionRequest(0, 0);
                        if (this.isValidEmailAddress(subscriptionDestination)) {
                            this.emailContent((IOutputHandler)outputHandler /* !! */ , subscriptionName, solutionName, actionName, instanceId, subscriptionDestination);
                        }
                        if (ignoreSubscriptionOutput || outputHandler /* !! */ .contentDone()) ** GOTO lbl97
                        if (rt != null && rt.getStatus() == 6) {
                            buffer = new StringBuffer();
                            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)userSession)).formatSuccessMessage("text/html", rt, buffer, false);
                            this.writeMessage(buffer.toString(), (IOutputHandler)outputHandler /* !! */ , subscriptionName, solutionName, actionName, instanceId, userSession);
                        }
                        buffer = new StringBuffer();
                        ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)userSession)).formatFailureMessage("text/html", rt, buffer, requestHandler.getMessages());
                        this.writeMessage(buffer.toString(), (IOutputHandler)outputHandler /* !! */ , subscriptionName, solutionName, actionName, instanceId, userSession);
                    }
                    finally {
                        if (rt != null) {
                            rt.dispose();
                        }
                    }
                } else {
                    generator.setOutputHandler((IOutputHandler)outputHandler /* !! */ );
                    generator.setItemName(actionName);
                    generator.setInstanceId(instanceId);
                    generator.setSession(userSession);
                    parameterProviders = new HashMap<String, Object>();
                    parameterProviders.put("request", parameterProvider);
                    parameterProviders.put("session", new PentahoSessionParameterProvider(userSession));
                    generator.setParameterProviders(parameterProviders);
                    try {
                        generator.createContent();
                        if (this.isValidEmailAddress(subscriptionDestination)) {
                            this.emailContent((IOutputHandler)outputHandler /* !! */ , subscriptionName, solutionName, actionName, instanceId, subscriptionDestination);
                        } else if (!ignoreSubscriptionOutput && !outputHandler /* !! */ .contentDone()) {
                            message = Messages.getString("SubscriptionExecute.DEBUG_FINISHED_EXECUTION", jobName);
                            this.writeMessage(message.toString(), (IOutputHandler)outputHandler /* !! */ , subscriptionName, solutionName, actionName, instanceId, userSession);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (ignoreSubscriptionOutput || outputHandler /* !! */ .contentDone()) break block21;
                        message = Messages.getString("PRO_SUBSCRIPTREP.EXCEPTION_WITH_SCHEDULE", jobName);
                        this.writeMessage(message.toString(), (IOutputHandler)outputHandler /* !! */ , subscriptionName, solutionName, actionName, instanceId, userSession);
                    }
                }
            }
            SubscriptionExecute.logger.debug((Object)Messages.getString("SubscriptionExecute.DEBUG_FINISHED_EXECUTION", jobName));
        }
        catch (Throwable t) {
            SubscriptionExecute.logger.error((Object)"Error Executing Job", t);
        }
    }

    protected void writeMessage(String message, IOutputHandler outputHandler, String subscriptionName, String solutionName, String fileName, String instanceId, IPentahoSession userSession) {
        IContentItem outputContentItem = outputHandler.getOutputContentItem("response", "content", subscriptionName, null, solutionName, instanceId, "text/html");
        outputContentItem.setMimeType("text/html");
        try {
            OutputStream os = outputContentItem.getOutputStream(fileName);
            os.write(message.getBytes(LocaleHelper.getSystemEncoding()));
            outputContentItem.closeOutputStream();
        }
        catch (IOException ex) {
            this.error(ex.getLocalizedMessage());
        }
    }

    protected boolean isValidEmailAddress(String destination) {
        if (StringUtils.isEmpty((String)destination)) {
            return false;
        }
        return destination.contains("@");
    }

    protected void emailContent(IOutputHandler outputHandler, String subscriptionName, String solutionName, String fileName, String instanceId, String destination) {
        IContentItem outputContentItem = outputHandler.getOutputContentItem("response", "content", subscriptionName, null, solutionName, instanceId, null);
        fileName = subscriptionName;
        if ("application/pdf".equals(outputContentItem.getMimeType())) {
            fileName = fileName + ".pdf";
        } else if ("text/html".equals(outputContentItem.getMimeType())) {
            fileName = fileName + ".html";
        } else if ("text/csv".equals(outputContentItem.getMimeType())) {
            fileName = fileName + ".csv";
        } else if ("application/vnd.ms-excel".equals(outputContentItem.getMimeType())) {
            fileName = fileName + ".xls";
        } else if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(outputContentItem.getMimeType())) {
            fileName = fileName + ".xlsx";
        }
        SubscriptionEmailContent emailer = new SubscriptionEmailContent(outputContentItem.getDataSource(), fileName, subscriptionName, destination);
        if (!emailer.send()) {
            logger.error((Object)"Problem sending subscription email.");
        }
    }
}

