/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.subscription;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IBackgroundExecution;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IParameterSetter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IContentItemFile;
import org.pentaho.platform.api.repository.ISchedule;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.repository.ISubscribeContent;
import org.pentaho.platform.api.repository.ISubscription;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.api.scheduler.BackgroundExecutionException;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.PentahoSessionParameterProvider;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleParameterSetter;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.subscription.SubscribeContent;
import org.pentaho.platform.repository.subscription.Subscription;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;

public class SubscriptionHelper {
    protected static final Log logger = LogFactory.getLog(SubscriptionHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editSubscription(String subscriptionName, IPentahoSession session, SimpleUrlFactory urlFactory, OutputStream outputStream) {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)session);
        ISubscription subscription = subscriptionRepository.getSubscription(subscriptionName, session);
        if (subscription == null) {
            return;
        }
        ISubscribeContent content = subscription.getContent();
        Map contentParameters = content.getParameters();
        SimpleParameterSetter parameters = new SimpleParameterSetter();
        parameters.setParameters(contentParameters);
        SubscriptionHelper.getSubscriptionParameters(subscriptionName, (IParameterSetter)parameters, session);
        ISystemSettings systemSettings = PentahoSystem.getSystemSettings();
        String defaultParameterXsl = systemSettings.getSystemSetting("default-parameter-xsl", "DefaultParameterForm.xsl");
        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)session);
        solutionEngine.setLoggingLevel(PentahoSystem.loggingLevel);
        solutionEngine.init(session);
        solutionEngine.setParameterXsl(defaultParameterXsl);
        solutionEngine.setForcePrompt(true);
        HashMap<String, Object> parameterProviderMap = new HashMap<String, Object>();
        parameterProviderMap.put("PRO_EDIT_SUBSCRIPTION", parameters);
        PentahoSessionParameterProvider sessionParameters = new PentahoSessionParameterProvider(session);
        parameterProviderMap.put("session", sessionParameters);
        SimpleOutputHandler outputHandler = null;
        if (outputStream != null) {
            outputHandler = new SimpleOutputHandler(outputStream, true);
        }
        outputHandler.setOutputPreference(1);
        ArrayList messages = new ArrayList();
        IRuntimeContext runtime = null;
        String instanceId = null;
        boolean persisted = false;
        ActionInfo contentInfo = ActionInfo.parseActionString((String)content.getActionReference());
        try {
            runtime = solutionEngine.execute(contentInfo.getSolutionName(), contentInfo.getPath(), contentInfo.getActionName(), "Subscriptions", false, true, instanceId, persisted, parameterProviderMap, (IOutputHandler)outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
        }
        finally {
            runtime.dispose();
        }
    }

    public static String saveSubscription(IParameterProvider parameterProvider, String actionReference, IPentahoSession userSession) {
        return SubscriptionHelper.saveSubscription(parameterProvider, actionReference, userSession, false);
    }

    public static String saveSubscription(IParameterProvider parameterProvider, String actionReference, IPentahoSession userSession, boolean saveOnly) {
        String parameterValue;
        ActionInfo contentInfo;
        boolean isUniqueName;
        if (userSession == null || userSession.getName() == null) {
            return Messages.getString("SubscriptionHelper.USER_LOGIN_NEEDED");
        }
        String subscriptionId = (String)parameterProvider.getParameter("subscribe-id");
        boolean editing = subscriptionId != null && subscriptionId.length() > 0;
        String subscriptionName = (String)parameterProvider.getParameter("subscribe-name");
        String destination = parameterProvider.getStringParameter("destination", null);
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)userSession);
        if (!editing && !(isUniqueName = subscriptionRepository.checkUniqueSubscriptionName(subscriptionName, userSession.getName(), actionReference))) {
            return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_NAME_ALREADY_EXISTS", subscriptionName);
        }
        ISolutionRepository solutionRepository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        IActionSequence actionSequence = solutionRepository.getActionSequence((contentInfo = ActionInfo.parseActionString((String)actionReference)).getSolutionName(), contentInfo.getPath(), contentInfo.getActionName(), PentahoSystem.loggingLevel, 2);
        if (actionSequence == null) {
            return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_NOT_CREATE");
        }
        Map inputs = actionSequence.getInputDefinitionsForParameterProvider("request");
        ISubscribeContent content = subscriptionRepository.getContentByActionReference(actionReference);
        if (content == null) {
            if (saveOnly) {
                String subContId = UUIDUtil.getUUIDAsString();
                content = new SubscribeContent(subContId, actionReference, "report");
                subscriptionRepository.addContent(content);
            } else {
                return Messages.getString("SubscriptionHelper.ACTION_SEQUENCE_NOT_ALLOWED", contentInfo.getActionName());
            }
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String parameterName : inputs.keySet()) {
            Object parameterValue2 = parameterProvider.getParameter(parameterName);
            if (parameterValue2 == null) continue;
            parameters.put(parameterName, parameterValue2);
        }
        if (saveOnly && (parameterValue = (String)parameterProvider.getParameter("mdx")) != null) {
            parameters.put("mdx", parameterValue);
        }
        if ((parameterValue = (String)parameterProvider.getParameter("action2")) != null) {
            parameters.put("action", parameterValue);
        }
        ISubscription subscription = null;
        if (editing) {
            subscription = subscriptionRepository.getSubscription(subscriptionId, userSession);
            if (subscription == null) {
                editing = false;
            } else {
                subscription.setTitle(subscriptionName);
                subscription.setDestination(destination);
                subscription.getParameters().clear();
                subscription.getParameters().putAll(parameters);
                subscription.getSchedules().clear();
            }
        }
        if (!editing) {
            subscriptionId = UUIDUtil.getUUIDAsString();
            subscription = new Subscription(subscriptionId, userSession.getName(), subscriptionName, content, destination, 1, parameters);
        }
        List schedules = subscriptionRepository.getSchedules();
        for (int i = 0; i < schedules.size(); ++i) {
            ISchedule schedule = (ISchedule)schedules.get(i);
            String scheduleId = schedule.getId();
            String scheduleValue = (String)parameterProvider.getParameter("schedule-" + scheduleId);
            if (!"true".equals(scheduleValue)) continue;
            subscription.addSchedule(schedule);
        }
        if (subscriptionRepository.addSubscription(subscription)) {
            return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_CREATED");
        }
        return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_NOT_CREATE");
    }

    public static String deleteSubscription(String subscriptionId, IPentahoSession userSession) {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)userSession);
        ISubscription subscription = subscriptionRepository.getSubscription(subscriptionId, userSession);
        if (subscription == null) {
            return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_NOT_DELETED");
        }
        try {
            subscriptionRepository.deleteSubscription(subscriptionId, userSession);
            return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_DELETED");
        }
        catch (Exception e) {
            return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_NOT_DELETED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSubscription(String subscriptionName, IPentahoSession session, IParameterProvider sessionParameters, SimpleUrlFactory urlFactory, IOutputHandler outputHandler) {
        block19: {
            try {
                ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)session);
                ISubscription subscription = subscriptionRepository.getSubscription(subscriptionName, session);
                if (subscription == null) {
                    return;
                }
                ISubscribeContent content = subscription.getContent();
                Map contentParameters = content.getParameters();
                Map subscriptionParameters = subscription.getParameters();
                ActionInfo contentInfo = ActionInfo.parseActionString((String)content.getActionReference());
                subscriptionParameters.put("solution", contentInfo.getSolutionName());
                subscriptionParameters.put("path", contentInfo.getPath());
                subscriptionParameters.put("action", contentInfo.getActionName());
                SimpleParameterProvider parameterProvider = new SimpleParameterProvider(contentParameters);
                parameterProvider.setParameters(subscriptionParameters);
                ArrayList messages = new ArrayList();
                String instanceId = null;
                boolean persisted = false;
                String actionName = contentInfo.getActionName();
                int lastDot = actionName.lastIndexOf(46);
                String type = actionName.substring(lastDot + 1);
                IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)session);
                IContentGenerator generator = pluginManager.getContentGeneratorForType(type, session);
                if (generator == null) {
                    IRuntimeContext runtime = null;
                    try {
                        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)session);
                        solutionEngine.setLoggingLevel(PentahoSystem.loggingLevel);
                        solutionEngine.init(session);
                        HashMap<String, Object> parameterProviderMap = new HashMap<String, Object>();
                        parameterProviderMap.put("request", parameterProvider);
                        parameterProviderMap.put("session", sessionParameters);
                        runtime = solutionEngine.execute(contentInfo.getSolutionName(), contentInfo.getPath(), actionName, "Subscriptions", false, true, instanceId, persisted, parameterProviderMap, outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
                        if (!outputHandler.contentDone()) {
                            IContentItem contentItem = outputHandler.getFeedbackContentItem();
                            OutputStream outputStream = contentItem.getOutputStream(subscriptionName);
                            if (runtime == null) {
                                StringBuffer buffer = new StringBuffer();
                                ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)session)).formatFailureMessage("text/html", runtime, buffer);
                                outputStream.write(buffer.toString().getBytes());
                                contentItem.closeOutputStream();
                            } else if (runtime.getStatus() == 6) {
                                StringBuffer buffer = new StringBuffer();
                                ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)session)).formatSuccessMessage("text/html", runtime, buffer, false);
                                outputStream.write(buffer.toString().getBytes());
                                contentItem.closeOutputStream();
                            } else {
                                StringBuffer buffer = new StringBuffer();
                                ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)session)).formatFailureMessage("text/html", runtime, buffer);
                                outputStream.write(buffer.toString().getBytes());
                                contentItem.closeOutputStream();
                            }
                        }
                        break block19;
                    }
                    catch (Throwable t) {
                        break block19;
                    }
                    finally {
                        if (runtime != null) {
                            runtime.dispose();
                        }
                    }
                }
                generator.setOutputHandler(outputHandler);
                generator.setItemName(actionName);
                generator.setInstanceId(instanceId);
                generator.setSession(session);
                HashMap<String, Object> parameterProviders = new HashMap<String, Object>();
                parameterProviders.put("request", parameterProvider);
                parameterProviders.put("session", new PentahoSessionParameterProvider(session));
                generator.setParameterProviders(parameterProviders);
                try {
                    generator.createContent();
                    if (!outputHandler.contentDone()) {
                        String message = Messages.getString("SubscriptionExecute.DEBUG_FINISHED_EXECUTION", subscriptionName);
                        SubscriptionHelper.writeMessage(message.toString(), outputHandler, subscriptionName, contentInfo.getSolutionName(), actionName, instanceId, session);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!outputHandler.contentDone()) {
                        String message = Messages.getString("PRO_SUBSCRIPTREP.EXCEPTION_WITH_SCHEDULE", subscriptionName);
                        SubscriptionHelper.writeMessage(message.toString(), outputHandler, subscriptionName, contentInfo.getSolutionName(), actionName, instanceId, session);
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error Executing Subscription", t);
            }
        }
    }

    protected static void writeMessage(String message, IOutputHandler outputHandler, String subscriptionName, String solutionName, String fileName, String instanceId, IPentahoSession userSession) {
        IContentItem outputContentItem = outputHandler.getOutputContentItem("response", "content", subscriptionName, null, solutionName, instanceId, "text/html");
        outputContentItem.setMimeType("text/html");
        try {
            OutputStream os = outputContentItem.getOutputStream(fileName);
            os.write(message.getBytes(LocaleHelper.getSystemEncoding()));
            outputContentItem.closeOutputStream();
        }
        catch (IOException ex) {
            logger.error((Object)ex.getLocalizedMessage());
        }
    }

    public static void getArchived(String subscriptionName, String fileId, IPentahoSession session, IOutputHandler outputHandler) {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)session);
        ISubscription subscription = subscriptionRepository.getSubscription(subscriptionName, session);
        if (subscription == null) {
            return;
        }
        IContentItem contentItem = subscriptionRepository.getContentItem(subscriptionName, session);
        List files = contentItem.getFileVersions();
        Iterator fileIterator = files.iterator();
        IContentItemFile file = null;
        while (fileIterator.hasNext() && !fileId.equals((file = (IContentItemFile)fileIterator.next()).getId())) {
        }
        try {
            IContentItem outoutContentItem = outputHandler.getOutputContentItem("response", "content", null, null, contentItem.getMimeType());
            OutputStream outputStream = outoutContentItem.getOutputStream(subscriptionName);
            if (file == null) {
                outputStream.write(Messages.getString("SubscriptionHelper.USER_ARCHIVE_NOT_FOUND").getBytes());
                outoutContentItem.closeOutputStream();
                return;
            }
            outoutContentItem.setMimeType(contentItem.getMimeType());
            InputStream inputStream = file.getInputStream();
            byte[] buffer = new byte[2048];
            int n = inputStream.read(buffer);
            while (n > 0) {
                outputStream.write(buffer, 0, n);
                n = inputStream.read(buffer);
            }
            outoutContentItem.closeOutputStream();
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
    }

    public static String getSubscriptionParameters(String subscriptionName, IParameterSetter parameters, IPentahoSession session) {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)session);
        ISubscription subscription = subscriptionRepository.getSubscription(subscriptionName, session);
        if (subscription == null) {
            return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_DOES_NOT_EXIST");
        }
        Map subscriptionParameters = subscription.getParameters();
        for (String key : subscriptionParameters.keySet()) {
            Object value = subscriptionParameters.get(key);
            parameters.setParameter(key, value);
        }
        parameters.setParameter("subscribe-title", subscription.getTitle());
        parameters.setParameter("destination", subscription.getDestination());
        parameters.setParameter("action", subscription.getContent().getId());
        parameters.setParameter("subscribe-id", subscription.getId());
        String actionReference = subscription.getContent().getActionReference();
        ActionInfo actionInfo = ActionInfo.parseActionString((String)actionReference);
        parameters.setParameter("solution", actionInfo.getSolutionName());
        parameters.setParameter("path", actionInfo.getPath());
        parameters.setParameter("action", actionInfo.getActionName());
        List schedules = subscription.getSchedules();
        for (int i = 0; i < schedules.size(); ++i) {
            ISchedule schedule = (ISchedule)schedules.get(i);
            parameters.setParameter("schedule-" + schedule.getId(), "true");
        }
        return null;
    }

    public static String deleteSubscriptionArchive(String subscriptionName, String fileId, IPentahoSession session) {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)session);
        ISubscription subscription = subscriptionRepository.getSubscription(subscriptionName, session);
        if (subscription == null) {
            return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_DOES_NOT_EXIST");
        }
        IContentItem contentItem = subscriptionRepository.getContentItem(subscriptionName, session);
        if (contentItem == null) {
            return Messages.getString("SubscriptionHelper.USER_CONTENT_ITEM_DOES_NOT_EXIST");
        }
        contentItem.removeVersion(fileId);
        return Messages.getString("SubscriptionHelper.USER_ARCHIVE_DELETED");
    }

    public static String createSubscriptionArchive(String subscriptionName, IPentahoSession session, SimpleUrlFactory urlFactory, IParameterProvider sessionParameters) throws BackgroundExecutionException {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)session);
        ISubscription subscription = subscriptionRepository.getSubscription(subscriptionName, session);
        if (subscription == null) {
            return Messages.getString("SubscriptionHelper.USER_SUBSCRIPTION_DOES_NOT_EXIST");
        }
        ISubscribeContent content = subscription.getContent();
        if (content == null) {
            return Messages.getString("SubscriptionHelper.USER_CONTENT_ITEM_DOES_NOT_EXIST");
        }
        Map contentParameters = content.getParameters();
        Map subscriptionParameters = subscription.getParameters();
        SimpleParameterProvider parameterProvider = new SimpleParameterProvider(contentParameters);
        parameterProvider.setParameters(subscriptionParameters);
        if (subscriptionName != null) {
            parameterProvider.setParameter("subscribe-name", subscriptionName);
        }
        ActionInfo contentInfo = ActionInfo.parseActionString((String)content.getActionReference());
        String actionName = (String)subscriptionParameters.get("action");
        if (actionName == null) {
            actionName = contentInfo.getActionName();
        }
        String path = ActionInfo.buildSolutionPath((String)contentInfo.getSolutionName(), (String)contentInfo.getPath(), (String)actionName);
        parameterProvider.setParameter("actionRef", path);
        IBackgroundExecution be = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (String)"BackgroundSubscriptionExecution", (IPentahoSession)session);
        return be.backgroundExecuteAction(session, (IParameterProvider)parameterProvider);
    }

    public static String getSubscriptionOutputLocation(String solutionName, String actionPath, String actionName) {
        String outputFolder = actionName.substring(0, actionName.lastIndexOf(46));
        return solutionName + "/" + actionPath + "/" + outputFolder + "/subscriptions";
    }

    public static DateFormat getDateTimeFormatter() {
        return DateFormat.getDateTimeInstance(1, 2, LocaleHelper.getLocale());
    }
}

