/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.subscription;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.engine.core.system.BasePublisher;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class SubscriptionPublisher
extends BasePublisher {
    private static final long serialVersionUID = -2578938864526146490L;
    private static final Log logger = LogFactory.getLog(SubscriptionPublisher.class);

    public Log getLogger() {
        return logger;
    }

    public String publish(IPentahoSession session) {
        String publishSrcPath = PentahoSystem.getApplicationContext().getSolutionPath("") + "system/ScheduleAndContentImport.xml";
        Document document = DocumentHelper.createDocument();
        Element root = DocumentHelper.createElement((String)"importContentResults");
        document.add(root);
        try {
            ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)session);
            File file = new File(publishSrcPath);
            if (!file.canRead()) {
                throw new FileNotFoundException("SubscriptionPublisher.publish() requires the file \"" + publishSrcPath + "\" to exist. The file does not exist.");
            }
            Document importDoc = XmlDom4JHelper.getDocFromFile((File)file, null);
            root.add(subscriptionRepository.importSchedules(importDoc));
            root.add(subscriptionRepository.importContent(importDoc));
        }
        catch (FileNotFoundException e) {
            this.getLogger().error((Object)Messages.getString("SubscriptionPublisher.ERROR_0001", publishSrcPath), (Throwable)e);
            return Messages.getString("SubscriptionPublisher.ERROR_0002", publishSrcPath);
        }
        catch (DocumentException e) {
            this.getLogger().error((Object)Messages.getString("SubscriptionPublisher.ERROR_0003", publishSrcPath), (Throwable)e);
            return Messages.getString("SubscriptionPublisher.ERROR_0004") + publishSrcPath;
        }
        catch (IOException e) {
            this.getLogger().error((Object)Messages.getString("SubscriptionPublisher.ERROR_0005", publishSrcPath), (Throwable)e);
            return Messages.getString("SubscriptionPublisher.ERROR_0006", publishSrcPath);
        }
        List resultNodes = document.selectNodes("//@result");
        for (Attribute attribute : resultNodes) {
            if (!"ERROR".equalsIgnoreCase(attribute.getValue())) continue;
            return Messages.getString("SubscriptionPublisher.ERROR_0007");
        }
        return Messages.getString("SubscriptionPublisher.INFO_0001");
    }

    public String getDescription() {
        return Messages.getString("SubscriptionPublisher.INFO_0002");
    }

    public String getName() {
        return Messages.getString("SubscriptionPublisher.INFO_0003");
    }
}

