/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.subscription;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISubscriptionScheduler;
import org.pentaho.platform.api.engine.SubscriptionSchedulerException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IContentItemFile;
import org.pentaho.platform.api.repository.IContentLocation;
import org.pentaho.platform.api.repository.IContentRepository;
import org.pentaho.platform.api.repository.ISchedule;
import org.pentaho.platform.api.repository.ISubscribeContent;
import org.pentaho.platform.api.repository.ISubscription;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.api.repository.SubscriptionRepositoryCheckedException;
import org.pentaho.platform.api.repository.SubscriptionRepositoryException;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.subscription.Schedule;
import org.pentaho.platform.repository.subscription.SubscribeContent;
import org.pentaho.platform.repository.subscription.Subscription;
import org.pentaho.platform.repository.subscription.SubscriptionHelper;
import org.pentaho.platform.repository.subscription.SubscriptionResultSet;
import org.pentaho.platform.util.UUIDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionRepository
implements ISubscriptionRepository {
    private static final byte[] SyncLock = new byte[0];
    private static final Log logger = LogFactory.getLog(SubscriptionRepository.class);
    private static final ISubscriptionScheduler subscriptionScheduler = (ISubscriptionScheduler)PentahoSystem.get(ISubscriptionScheduler.class, null);

    public Log getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element importSchedules(Document doc) {
        Element resultElement = DocumentHelper.createElement((String)"importSchedulesResults");
        if (doc == null) {
            Element ele = resultElement.addElement("message").addText(Messages.getString("PRO_SUBSCRIPTREP.DOCUMENT_IS_NULL"));
            ele.addAttribute("result", "ERROR");
            return resultElement;
        }
        List scheduleNodes = doc.selectNodes("//schedules/*");
        if (scheduleNodes.size() == 0) {
            Element ele = resultElement.addElement("message").addText(Messages.getString("PRO_SUBSCRIPTREP.NO_SCHEDULES_DEFINED"));
            ele.addAttribute("result", "WARNING");
            return resultElement;
        }
        byte[] byArray = SyncLock;
        synchronized (SyncLock) {
            Node scheduleNode = null;
            try {
                logger.info((Object)Messages.getString("PRO_SUBSCRIPTREP.USER_IMPORT_PROCESSING_SCHEDULES", Integer.toString(scheduleNodes.size())));
                for (int i = 0; i < scheduleNodes.size(); ++i) {
                    scheduleNode = (Node)scheduleNodes.get(i);
                    String schedRef = scheduleNode.selectSingleNode("@ref").getText();
                    String schedName = scheduleNode.selectSingleNode("@name").getText();
                    String schedDesc = scheduleNode.selectSingleNode("@description").getText();
                    String schedGroup = scheduleNode.selectSingleNode("@group").getText();
                    String cronString = scheduleNode.getText();
                    try {
                        ISchedule aSchedule = this.getScheduleByScheduleReference(schedRef);
                        if (aSchedule != null) {
                            aSchedule.setCronString(cronString);
                            aSchedule.setDescription(schedDesc);
                            aSchedule.setGroup(schedGroup);
                            aSchedule.setTitle(schedName);
                            resultElement.addElement("modified").addText(schedRef);
                            logger.info((Object)Messages.getString("PRO_SUBSCRIPTREP.MODIFIED_SUBSCRIPTION_SCHEDULE", schedRef));
                        } else {
                            aSchedule = this.addCronSchedule(schedName, schedRef, schedDesc, cronString, schedGroup, null, null);
                            resultElement.addElement("added").addText(schedRef);
                            logger.info((Object)Messages.getString("PRO_SUBSCRIPTREP.ADDED_SUBSCRIPTION_SCHEDULE", schedRef));
                        }
                        subscriptionScheduler.getCronSummary(cronString);
                        continue;
                    }
                    catch (Exception e) {
                        resultElement.addElement("message").addText(Messages.getString("PRO_SUBSCRIPTREP.ERROR_OCCURRED_WITH_SCHEDULE", schedRef, e.getLocalizedMessage()));
                        logger.warn((Object)Messages.getString("PRO_SUBSCRIPTREP.EXCEPTION_WITH_SCHEDULE", schedRef), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                Element ele = resultElement.addElement("message").addText(Messages.getString("PRO_SUBSCRIPTREP.ERROR_PROCESSING_IMPORTS") + e.getLocalizedMessage());
                ele.addAttribute("result", "ERROR");
                logger.error((Object)Messages.getString("PRO_SUBSCRIPTREP.EXCEPTION_PROCESSING_IMPORTS"), (Throwable)e);
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return resultElement;
            }
            return resultElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element importContent(Document doc) {
        Element resultElement = DocumentHelper.createElement((String)"importContentResults");
        if (doc == null) {
            Element ele = resultElement.addElement("message").addText(Messages.getString("PRO_SUBSCRIPTREP.DOCUMENT_IS_NULL"));
            ele.addAttribute("result", "ERROR");
            return resultElement;
        }
        List contentNodes = doc.selectNodes("//subscription-content/*");
        if (contentNodes.size() == 0) {
            Element ele = resultElement.addElement("message").addText(Messages.getString("PRO_SUBSCRIPTREP.NO_SCHEDULES_DEFINED"));
            ele.addAttribute("result", "WARNING");
            return resultElement;
        }
        byte[] byArray = SyncLock;
        synchronized (SyncLock) {
            Node contentNode = null;
            Node tempNode = null;
            ISubscribeContent subscribeContent = null;
            List<ISchedule> schedList = this.getSchedules();
            HashMap<String, Schedule> scheduleMap = new HashMap<String, Schedule>();
            HashMap<String, ArrayList<Schedule>> groupMap = new HashMap<String, ArrayList<Schedule>>();
            for (int j = 0; j < schedList.size(); ++j) {
                Schedule aSchedule = (Schedule)schedList.get(j);
                scheduleMap.put(aSchedule.getScheduleReference(), aSchedule);
                ArrayList<Schedule> groupList = (ArrayList<Schedule>)groupMap.get(aSchedule.getGroup());
                if (groupList == null) {
                    groupList = new ArrayList<Schedule>();
                    groupMap.put(aSchedule.getGroup(), groupList);
                }
                groupList.add(aSchedule);
            }
            try {
                logger.info((Object)Messages.getString("PRO_SUBSCRIPTREP.USER_PROCESSING_CONTENT_NODES", Integer.toString(contentNodes.size())));
                for (int i = 0; i < contentNodes.size(); ++i) {
                    contentNode = (Node)contentNodes.get(i);
                    String actionRef = contentNode.selectSingleNode("@action").getText();
                    String contentType = contentNode.selectSingleNode("@type").getText();
                    tempNode = contentNode.selectSingleNode("@allowAllSchedules");
                    String allowAllSchedules = tempNode != null ? tempNode.getText() : "false";
                    try {
                        subscribeContent = this.getContentByActionReference(actionRef);
                        if (subscribeContent != null) {
                            subscribeContent.setType(contentType);
                            resultElement.addElement("modified").addText(actionRef);
                            logger.info((Object)Messages.getString("PRO_SUBSCRIPTREP.MODIFIED_SUBSCRIPTION_CONTENT", actionRef));
                        } else {
                            subscribeContent = this.addContent(actionRef, contentType);
                            resultElement.addElement("added").addText(actionRef);
                            logger.info((Object)Messages.getString("PRO_SUBSCRIPTREP.ADDED_SUBSCRIPTION_CONTENT", actionRef));
                        }
                    }
                    catch (Exception e) {
                        resultElement.addElement("message").addText(Messages.getString("PRO_SUBSCRIPTREP.ERROR_WITH_CONTENT", actionRef, e.getLocalizedMessage()));
                        logger.warn((Object)Messages.getString("PRO_SUBSCRIPTREP.ERROR_WITH_CONTENT_LOG", actionRef), (Throwable)e);
                    }
                    ArrayList<Object> contentSchedules = new ArrayList<Object>();
                    if ("true".equalsIgnoreCase(allowAllSchedules)) {
                        contentSchedules.addAll(schedList);
                    } else {
                        List suppliedGroups;
                        List suppliedSchedules = contentNode.selectNodes("schedule");
                        if (suppliedSchedules != null) {
                            for (int j = 0; j < suppliedSchedules.size(); ++j) {
                                Object aSchedule;
                                tempNode = (Node)suppliedSchedules.get(j);
                                String schName = tempNode.getText();
                                if (schName == null || (aSchedule = scheduleMap.get(schName)) == null) continue;
                                contentSchedules.add(aSchedule);
                            }
                        }
                        if ((suppliedGroups = contentNode.selectNodes("group")) != null) {
                            for (int j = 0; j < suppliedGroups.size(); ++j) {
                                List groupList;
                                tempNode = (Node)suppliedGroups.get(j);
                                String grpName = tempNode.getText();
                                if (grpName == null || (groupList = (List)groupMap.get(grpName)) == null) continue;
                                contentSchedules.addAll(groupList);
                            }
                        }
                    }
                    HibernateUtil.beginTransaction();
                    subscribeContent.setSchedules(contentSchedules);
                    HibernateUtil.commitTransaction();
                }
            }
            catch (Exception e) {
                Element ele = resultElement.addElement("message").addText(Messages.getString("PRO_SUBSCRIPTREP.ERROR_PROCESSING_IMPORTS") + e.getLocalizedMessage());
                ele.addAttribute("result", "ERROR");
                logger.error((Object)Messages.getString("PRO_SUBSCRIPTREP.EXCEPTION_PROCESSING_IMPORTS"), (Throwable)e);
                // ** MonitorExit[var4_6] (shouldn't be in output)
                return resultElement;
            }
            return resultElement;
        }
    }

    public boolean addSubscription(ISubscription subscription) {
        if (subscription.getId() != null && subscription.getTitle() != null) {
            Session session = HibernateUtil.getSession();
            session.save((Object)subscription);
            return true;
        }
        return false;
    }

    public List<ISubscription> getSubscriptionsForSchedule(ISchedule schedule) {
        if (schedule == null) {
            return new ArrayList<ISubscription>();
        }
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.Schedule.findSubscriptionsBySchedule").setCacheable(true);
        qry.setEntity("schedule", (Object)schedule);
        return qry.list();
    }

    public List<ISubscription> getSubscriptionsForSchedule(String scheduleId) {
        return this.getSubscriptionsForSchedule(this.getScheduleByScheduleReference(scheduleId));
    }

    public IPentahoResultSet getSubscriptions(String scheduleId, IPentahoSession session, String solution, String path, String action, String[] parameterNames) {
        SubscriptionResultSet results = new SubscriptionResultSet(scheduleId, session, parameterNames, solution, path, action);
        return results;
    }

    public void addContent(ISubscribeContent content) {
        if (this.getContentByActionReference(content.getActionReference()) != null) {
            throw new SubscriptionRepositoryException(Messages.getString("PRO_SUBSCRIPTREP.ACTION_SEQUENCE_ALREADY_EXISTS", content.getActionReference()));
        }
        Session session = HibernateUtil.getSession();
        session.save((Object)content);
        this.clearSessionCaches();
    }

    public void deleteContent(ISubscribeContent content) {
        Session session = HibernateUtil.getSession();
        session.delete((Object)content);
        this.clearSessionCaches();
    }

    private void clearSessionCaches() {
        ICacheManager cm = PentahoSystem.getCacheManager(null);
        if (cm != null) {
            cm.killSessionCaches();
        }
    }

    public ISubscribeContent addContent(String actionRef, String contentType) {
        SubscribeContent newContent = new SubscribeContent(UUIDUtil.getUUIDAsString(), actionRef, contentType);
        this.addContent(newContent);
        return newContent;
    }

    public List<ISubscribeContent> addContent(String[] actionRefs) throws SubscriptionRepositoryCheckedException {
        ArrayList<ISubscribeContent> newContents = new ArrayList<ISubscribeContent>();
        List<ISubscribeContent> allContent = this.getAllContent();
        HashMap<String, ISubscribeContent> existingContentActionRef = new HashMap<String, ISubscribeContent>();
        for (ISubscribeContent content : allContent) {
            existingContentActionRef.put(content.getActionReference(), content);
        }
        for (String actionRef : actionRefs) {
            if (!existingContentActionRef.containsKey(actionRef)) {
                ISubscribeContent newContent = this.addContent(actionRef, "");
                newContents.add(newContent);
                continue;
            }
            newContents.add((ISubscribeContent)existingContentActionRef.get(actionRef));
        }
        return newContents;
    }

    public void setContent(String[] actionRefs) throws Exception {
        int i;
        ArrayList<String> keepList = new ArrayList<String>(Arrays.asList(actionRefs));
        List<ISubscribeContent> allContent = this.getAllContent();
        ArrayList<ISubscribeContent> deleteList = new ArrayList<ISubscribeContent>();
        for (ISubscribeContent content : allContent) {
            if (keepList.contains(content.getActionReference())) {
                keepList.remove(content.getActionReference());
                continue;
            }
            deleteList.add(content);
        }
        for (i = 0; i < keepList.size(); ++i) {
            this.addContent((String)keepList.get(i), "");
        }
        for (i = 0; i < deleteList.size(); ++i) {
            this.deleteSubscribeContent((SubscribeContent)deleteList.get(i));
        }
    }

    public ISubscribeContent editContent(String contentId, String actionRef, String contentType) {
        ISubscribeContent oldCont = this.getContentById(contentId);
        if (oldCont != null) {
            if (actionRef != null) {
                oldCont.setActionReference(actionRef);
            }
            if (contentType != null) {
                oldCont.setType(contentType);
            }
            return oldCont;
        }
        return null;
    }

    public boolean deleteContentForSchedule(String contentId, String schedId) throws SubscriptionRepositoryCheckedException {
        ISubscribeContent content = this.getContentById(contentId);
        ISchedule sched = this.getSchedule(schedId);
        return this.deleteContentForSchedule(content, sched);
    }

    public boolean deleteContentForSchedule(ISubscribeContent content, ISchedule sched) throws SubscriptionRepositoryCheckedException {
        if (content == null) {
            return false;
        }
        return content.removeSchedule(sched);
    }

    public boolean addContentForSchedule(String contentId, String schedId) throws SubscriptionRepositoryCheckedException {
        ISubscribeContent content = this.getContentById(contentId);
        ISchedule sched = this.getSchedule(schedId);
        return this.addContentForSchedule(content, sched);
    }

    public boolean addContentForSchedule(ISubscribeContent content, ISchedule sched) throws SubscriptionRepositoryCheckedException {
        if (content == null) {
            return false;
        }
        content.addSchedule(sched);
        return true;
    }

    public void setSchedulesForContent(String[] scheduleId, String contentId) throws Exception {
        ISubscribeContent content = this.getContentById(contentId);
        ArrayList<ISchedule> schedList = new ArrayList<ISchedule>();
        for (String element : scheduleId) {
            ISchedule sched = this.getSchedule(element);
            if (sched == null) continue;
            schedList.add(sched);
        }
        content.setSchedules(schedList);
    }

    public void addContentForSchedule(String[] contentIds, String schedId) throws SubscriptionRepositoryCheckedException {
        ISchedule sched = this.getSchedule(schedId);
        for (String contentId : contentIds) {
            ISubscribeContent content = this.getContentById(contentId);
            this.addContentForSchedule(content, sched);
        }
    }

    public void setContentForSchedule(String[] contentIds, String schedId) throws Exception {
        ISchedule sched = this.getSchedule(schedId);
        List<ISubscribeContent> allContent = this.getAllContent();
        for (String contentId : contentIds) {
            ISubscribeContent content = this.getContentById(contentId);
            this.addContentForSchedule(content, sched);
            allContent.remove(content);
        }
        for (int i = 0; i < allContent.size(); ++i) {
            SubscribeContent content = (SubscribeContent)allContent.get(i);
            this.deleteContentForSchedule(content, sched);
        }
    }

    public ISubscribeContent getContentById(String theId) {
        Session session = HibernateUtil.getSession();
        try {
            return (ISubscribeContent)session.get(SubscribeContent.class, (Serializable)((Object)theId));
        }
        catch (HibernateException ex) {
            throw new SubscriptionRepositoryException(Messages.getErrorString("PRO_SUBSCRIPTREP.ERROR_0001_GETTING_SUBSCRIPTION", theId), (Throwable)ex);
        }
    }

    public List<ISubscribeContent> getAllContent() {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.SubscribeContent.getAllContent").setCacheable(true);
        return qry.list();
    }

    public ISubscribeContent getContentByActionReference(String actionReference) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.SubscribeContent.findSubscriptionContentByActionRef").setCacheable(true);
        qry.setString("searchTerm", actionReference);
        Object rtn = null;
        try {
            rtn = qry.uniqueResult();
        }
        catch (Exception ignored) {
            logger.error((Object)"Exception being ignored: ", (Throwable)ignored);
        }
        return (SubscribeContent)rtn;
    }

    public List<ISubscribeContent> getContentBySchedule(ISchedule schedule) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.SubscribeContent.findContentBySchedule").setCacheable(true);
        qry.setParameter("schedule", (Object)schedule);
        return qry.list();
    }

    public Document getUserSubscriptions(String user, String contentId, IPentahoSession session) {
        Document document = DocumentHelper.createDocument();
        Element subscriptionsNode = document.addElement("subscriptions");
        this.addSubscriptionsToDocument(user, contentId, subscriptionsNode, null, session);
        return document;
    }

    public void deleteUserSubscriptions(String user) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.Subscription.findUserSubscriptionsForDeletion").setCacheable(true);
        qry.setString("searchUser", user);
        logger.warn((Object)Messages.getErrorString("PRO_SUBSCRIPTREP.USER_REMOVING_USER", user));
        List subscriptions = qry.list();
        Subscription subscriptToDelete = null;
        for (int i = 0; i < subscriptions.size(); ++i) {
            subscriptToDelete = (Subscription)subscriptions.get(i);
            HibernateUtil.makeTransient(subscriptToDelete);
        }
        HibernateUtil.flushSession();
    }

    public List<ISubscription> getUserSubscriptionsToContentReference(String user, String contentId) {
        Session session = HibernateUtil.getSession();
        ISubscribeContent content = this.getContentByActionReference(contentId);
        if (content == null) {
            return new ArrayList<ISubscription>();
        }
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.Subscription.findUserSubscriptions").setCacheable(true);
        qry.setString("searchUser", user);
        qry.setEntity("searchContent", (Object)content);
        return qry.list();
    }

    public List<ISubscription> getUserSubscriptions(String user) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.Subscription.findAllUserSubscriptions").setCacheable(true);
        qry.setString("searchUser", user);
        return qry.list();
    }

    public List<ISubscription> getAllSubscriptions() {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.Subscription.getAllSubscriptions").setCacheable(true);
        return qry.list();
    }

    public void addSubscriptionsToDocument(String user, String contentId, Element subscriptionsNode, String editId, IPentahoSession session) {
        List<ISubscription> userSubsToContent = this.getUserSubscriptionsToContentReference(user, contentId);
        if (userSubsToContent == null) {
            return;
        }
        for (int i = 0; i < userSubsToContent.size(); ++i) {
            ISubscription subscription = userSubsToContent.get(i);
            this.addSubscriptionToDocument(subscription, subscriptionsNode, editId, session);
        }
    }

    public boolean checkUniqueSubscriptionName(String name, String user, String contentId) {
        if (name == null) {
            return true;
        }
        List<ISubscription> userSubsToContent = this.getUserSubscriptionsToContentReference(user, contentId);
        if (userSubsToContent == null) {
            return true;
        }
        for (int i = 0; i < userSubsToContent.size(); ++i) {
            Subscription subscription = (Subscription)userSubsToContent.get(i);
            if (!name.equals(subscription.getTitle())) continue;
            return false;
        }
        return true;
    }

    public void addSchedulesToDocument(String user, String contentId, Element schedulesNode, String editId) {
        ISubscribeContent content = this.getContentByActionReference(contentId);
        if (content == null) {
            return;
        }
        List schedules = content.getSchedules();
        for (Schedule schedule : schedules) {
            if (schedule == null) continue;
            Element scheduleNode = schedulesNode.addElement("schedule");
            scheduleNode.addElement("id").setText(schedule.getId());
            scheduleNode.addElement("title").setText(schedule.getTitle());
            scheduleNode.addElement("group").setText(schedule.getGroup());
            scheduleNode.addElement("schedRef").setText(schedule.getScheduleReference());
        }
    }

    public void addSubscriptionToDocument(ISubscription subscription, Element subscriptionsNode, String editId, IPentahoSession session) {
        List contentFiles;
        Element node = subscriptionsNode.addElement("subscription");
        if (subscription.getTitle() == null) {
            node.addElement("title").setText("Unknown");
        } else {
            node.addElement("title").setText(subscription.getTitle());
        }
        node.addElement("content-id").setText(subscription.getContent().getId());
        node.addElement("id").setText(subscription.getId());
        node.addElement("user").setText(subscription.getUser());
        if (editId != null && editId.equals(subscription.getId())) {
            node.addAttribute("edit", "true");
        }
        int type = subscription.getType();
        switch (type) {
            case 1: {
                node.addElement("type").setText("personal");
                break;
            }
            case 3: {
                node.addElement("type").setText("group");
                break;
            }
            case 2: {
                node.addElement("type").setText("role");
            }
        }
        Map parameters = subscription.getParameters();
        Iterator parameterIterator = parameters.keySet().iterator();
        Element parametersNode = node.addElement("parameters");
        while (parameterIterator.hasNext()) {
            String name = (String)parameterIterator.next();
            Object value = parameters.get(name);
            Element parameterNode = parametersNode.addElement("parameter");
            parameterNode.addElement("name").setText(name);
            parameterNode.addElement("value").setText(value.toString());
        }
        IContentItem contentItem = this.getContentItem(subscription.getId(), session);
        if (contentItem != null && (contentFiles = contentItem.getFileVersions()) != null && contentFiles.size() > 0) {
            Element archivesNode = node.addElement("archives");
            for (IContentItemFile file : contentFiles) {
                Date date = file.getFileDateTime();
                SimpleDateFormat format = new SimpleDateFormat("MM-dd-yyyy hh:mm aa");
                String fileId = file.getId();
                Element archiveNode = archivesNode.addElement("archive");
                archiveNode.addElement("id").setText(fileId);
                archiveNode.addElement("date").setText(format.format(date));
                archiveNode.addElement("size").setText(Long.toString(file.getFileSize()));
                archiveNode.addElement("mimetype").setText(contentItem.getMimeType());
            }
        }
    }

    public ISubscription getSubscriptionById(String theId) {
        Session session = HibernateUtil.getSession();
        try {
            return (ISubscription)session.get(Subscription.class, (Serializable)((Object)theId));
        }
        catch (HibernateException ex) {
            throw new SubscriptionRepositoryException(Messages.getErrorString("PRO_SUBSCRIPTREP.ERROR_0001_GETTING_SUBSCRIPTION", theId), (Throwable)ex);
        }
    }

    public ISubscription getSubscription(String subscriptionId, IPentahoSession session) {
        if (session == null) {
            return null;
        }
        if (!session.isAuthenticated()) {
            return null;
        }
        ISubscription subscription = this.getSubscriptionById(subscriptionId);
        if (subscription == null) {
            return null;
        }
        if (subscription.getUser().equals(session.getName())) {
            return subscription;
        }
        return null;
    }

    public void init(IPentahoSession session) {
        HibernateUtil.beginTransaction();
    }

    public List<ISchedule> getSchedules() {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.Schedule.getAllSchedules").setCacheable(true);
        return qry.list();
    }

    public List<ISchedule> syncSchedules() throws Exception {
        return subscriptionScheduler.syncSchedule(this.getSchedules());
    }

    public List<ISchedule> getSchedulesByTitle(String title) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.Schedule.findScheduleByTitle").setCacheable(true);
        qry.setString("searchTerm", title);
        return qry.list();
    }

    public ISchedule getScheduleByScheduleReference(String scheduleReference) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.subscription.Schedule.findSchedulesByReference").setCacheable(true);
        qry.setString("searchTerm", scheduleReference);
        return (Schedule)qry.uniqueResult();
    }

    public boolean deleteSubscription(String subscriptionId, IPentahoSession session) {
        if (session == null) {
            return false;
        }
        if (!session.isAuthenticated()) {
            return false;
        }
        ISubscription subscription = this.getSubscription(subscriptionId, session);
        if (subscription == null) {
            return false;
        }
        if (subscription.getUser().equals(session.getName())) {
            HibernateUtil.makeTransient(subscription);
            return true;
        }
        return false;
    }

    public boolean deleteSubscription(String subscriptionId) throws SubscriptionRepositoryCheckedException {
        ISubscription subscription = this.getSubscriptionById(subscriptionId);
        if (subscription == null) {
            throw new SubscriptionRepositoryException(Messages.getString("PRO_SUBSCRIPTREP.SUBSCRIPTION_ID_NOT_FOUND", subscriptionId));
        }
        HibernateUtil.makeTransient(subscription);
        return true;
    }

    public boolean deleteSubscriptionForSchedule(ISubscription subscription, ISchedule sched) throws SubscriptionRepositoryCheckedException {
        return subscription.deleteSchedule(sched);
    }

    public boolean deleteSchedule(ISchedule sched) throws SubscriptionRepositoryCheckedException {
        if (sched == null) {
            return false;
        }
        List<ISubscribeContent> contentList = this.getContentBySchedule(sched);
        for (ISubscribeContent content : contentList) {
            this.deleteContentForSchedule(content, sched);
        }
        HibernateUtil.makeTransient(sched);
        HibernateUtil.flushSession();
        try {
            subscriptionScheduler.syncSchedule(sched.getScheduleReference(), null);
        }
        catch (SubscriptionSchedulerException e) {
            HibernateUtil.rollbackTransaction();
            throw new SubscriptionRepositoryCheckedException("Failed to delete schedule with name " + sched.getScheduleReference() + " and id " + sched.getId(), (Throwable)e);
        }
        return true;
    }

    public boolean deleteScheduleById(String scheduleId) throws SubscriptionRepositoryCheckedException {
        ISchedule sched = this.getSchedule(scheduleId);
        if (sched == null) {
            throw new SubscriptionRepositoryCheckedException(Messages.getString("PRO_SUBSCRIPTREP.SCHEDULE_ID_NOT_FOUND", scheduleId));
        }
        return this.deleteSchedule(sched);
    }

    public boolean deleteSubscribeContent(ISubscribeContent subContent) throws SubscriptionSchedulerException {
        HibernateUtil.makeTransient(subContent);
        HibernateUtil.flushSession();
        this.clearSessionCaches();
        return true;
    }

    public boolean deleteSubscribeContentById(String subContentId) throws SubscriptionSchedulerException {
        ISubscribeContent content = this.getContentById(subContentId);
        return this.deleteSubscribeContent(content);
    }

    public void addSchedule(ISchedule schedule) throws SubscriptionRepositoryCheckedException {
        if (this.getScheduleByScheduleReference(schedule.getScheduleReference()) != null) {
            throw new SubscriptionRepositoryCheckedException(Messages.getString("PRO_SUBSCRIPTREP.SCHEDULE_REF_NOT_UNIQUE_ADD", schedule.getScheduleReference()));
        }
        Session session = HibernateUtil.getSession();
        session.save((Object)schedule);
        try {
            subscriptionScheduler.syncSchedule(null, schedule);
        }
        catch (SubscriptionSchedulerException e) {
            HibernateUtil.rollbackTransaction();
            throw new SubscriptionRepositoryCheckedException("", (Throwable)e);
        }
    }

    public ISchedule addCronSchedule(String title, String scheduleRef, String description, String cronString, String group, Date startDate, Date endDate) throws SubscriptionRepositoryCheckedException {
        Schedule newSched = new Schedule(UUIDUtil.getUUIDAsString(), title, scheduleRef, description, cronString, group, startDate, endDate);
        this.addSchedule(newSched);
        return newSched;
    }

    public ISchedule addRepeatSchedule(String title, String scheduleRef, String description, Integer repeatCount, Integer repeatInterval, String group, Date startDate, Date endDate) throws SubscriptionRepositoryCheckedException {
        Schedule newSched = new Schedule(UUIDUtil.getUUIDAsString(), title, scheduleRef, description, repeatCount, repeatInterval, group, startDate, endDate);
        this.addSchedule(newSched);
        return newSched;
    }

    public ISchedule editCronSchedule(String id, String title, String scheduleRef, String description, String cronString, String group, Date startDate, Date endDate) throws SubscriptionRepositoryCheckedException {
        ISchedule oldSched = this.getSchedule(id);
        if (oldSched != null) {
            String oldScheduleReference = oldSched.getScheduleReference();
            if (scheduleRef != null) {
                if (!oldScheduleReference.equals(scheduleRef) && this.getScheduleByScheduleReference(scheduleRef) != null) {
                    throw new SubscriptionRepositoryException(Messages.getString("PRO_SUBSCRIPTREP.SCHEDULE_REF_NOT_UNIQUE_EDIT", scheduleRef));
                }
                oldSched.setScheduleReference(scheduleRef);
            }
            if (title != null) {
                oldSched.setTitle(title);
            }
            if (description != null) {
                oldSched.setDescription(description);
            }
            if (cronString != null) {
                oldSched.setCronString(cronString);
            }
            if (group != null) {
                oldSched.setGroup(group);
            }
            oldSched.setStartDate(startDate);
            oldSched.setEndDate(endDate);
            try {
                subscriptionScheduler.syncSchedule(oldScheduleReference, oldSched);
            }
            catch (SubscriptionSchedulerException ex) {
                throw new SubscriptionRepositoryException(Messages.getString("PRO_SUBSCRIPTREP.CANNOT_EDIT_SCHEDULE", id), (Throwable)ex);
            }
            return oldSched;
        }
        return null;
    }

    public ISchedule editRepeatSchedule(String id, String title, String scheduleRef, String description, Integer repeatCount, Integer repeatInterval, String group, Date startDate, Date endDate) throws SubscriptionRepositoryCheckedException {
        ISchedule oldSched = this.getSchedule(id);
        if (oldSched != null) {
            String oldScheduleReference = oldSched.getScheduleReference();
            if (scheduleRef != null) {
                if (!oldScheduleReference.equals(scheduleRef) && this.getScheduleByScheduleReference(scheduleRef) != null) {
                    throw new SubscriptionRepositoryException(Messages.getString("PRO_SUBSCRIPTREP.SCHEDULE_REF_NOT_UNIQUE_EDIT", scheduleRef));
                }
                oldSched.setScheduleReference(scheduleRef);
            }
            if (title != null) {
                oldSched.setTitle(title);
            }
            if (description != null) {
                oldSched.setDescription(description);
            }
            oldSched.setRepeatCount(repeatCount);
            if (repeatInterval != null) {
                oldSched.setRepeatInterval(repeatInterval);
            }
            if (group != null) {
                oldSched.setGroup(group);
            }
            oldSched.setStartDate(startDate);
            oldSched.setEndDate(endDate);
            try {
                subscriptionScheduler.syncSchedule(oldScheduleReference, oldSched);
            }
            catch (SubscriptionSchedulerException ex) {
                throw new SubscriptionRepositoryException(Messages.getString("PRO_SUBSCRIPTREP.CANNOT_EDIT_SCHEDULE", id), (Throwable)ex);
            }
            return oldSched;
        }
        return null;
    }

    public ISchedule getSchedule(String scheduleId) {
        Session session = HibernateUtil.getSession();
        try {
            return (Schedule)session.get(Schedule.class, (Serializable)((Object)scheduleId));
        }
        catch (HibernateException ex) {
            throw new SubscriptionRepositoryException(Messages.getErrorString("PRO_SUBSCRIPTREP.ERROR_0002_GETTING_SCHEDULE", scheduleId), (Throwable)ex);
        }
    }

    public List getSubscriptionArchives(String subscriptionName, IPentahoSession session) {
        IContentItem contentItem = this.getContentItem(subscriptionName, session);
        if (contentItem == null) {
            return null;
        }
        return contentItem.getFileVersions();
    }

    public IContentItem getContentItem(String subscriptionName, IPentahoSession session) {
        IContentItem contentItem;
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)session);
        ISubscription subscription = subscriptionRepository.getSubscription(subscriptionName, session);
        if (subscription == null) {
            return null;
        }
        ISubscribeContent content = subscription.getContent();
        Map subscriptionParameters = subscription.getParameters();
        ActionInfo contentInfo = ActionInfo.parseActionString((String)content.getActionReference());
        String actionName = (String)subscriptionParameters.get("action");
        if (actionName == null) {
            actionName = contentInfo.getActionName();
        }
        if ((contentItem = this.getContentItem(actionName, subscriptionName, null, null, session, contentInfo.getSolutionName(), contentInfo.getPath(), false)) == null) {
            return null;
        }
        return contentItem;
    }

    public IContentItem getContentItem(String contentName, String subscriptionName, String mimeType, String extension, IPentahoSession session, String solutionName, String solutionPath, boolean allowCreate) {
        IContentRepository contentRepository = (IContentRepository)PentahoSystem.get(IContentRepository.class, (IPentahoSession)session);
        if (contentRepository == null) {
            return null;
        }
        String contentPath = SubscriptionHelper.getSubscriptionOutputLocation(solutionName, solutionPath, contentName);
        IContentLocation contentLocation = null;
        try {
            contentLocation = contentRepository.getContentLocationByPath(contentPath);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (contentLocation == null && allowCreate) {
            contentLocation = contentRepository.newContentLocation(contentPath, subscriptionName, subscriptionName, solutionName, true);
        }
        if (contentLocation == null) {
            return null;
        }
        IContentItem contentItem = null;
        try {
            contentItem = contentLocation.getContentItemByName(subscriptionName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (contentItem == null && allowCreate) {
            contentItem = contentLocation.newContentItem(subscriptionName, contentName, extension, mimeType, null, 0);
        }
        return contentItem;
    }
}

