/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.subscription;

import java.util.Date;
import java.util.List;
import org.pentaho.platform.api.engine.SubscriptionSchedulerException;
import org.pentaho.platform.api.repository.ISchedule;
import org.pentaho.platform.api.repository.ISubscribeContent;
import org.pentaho.platform.api.repository.ISubscription;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.api.repository.SubscriptionRepositoryCheckedException;

public class SubscriptionRepositoryHelper {
    private SubscriptionRepositoryHelper() {
    }

    public static void deleteScheduleContentAndSubscription(ISubscriptionRepository subscriptionRepository, ISchedule schedule) throws SubscriptionRepositoryCheckedException, SubscriptionSchedulerException {
        List subscriptions = subscriptionRepository.getSubscriptionsForSchedule(schedule);
        for (ISubscription subscription : subscriptions) {
            subscriptionRepository.deleteSubscriptionForSchedule(subscription, schedule);
            if (0 != subscription.getSchedules().size()) continue;
            subscriptionRepository.deleteSubscription(subscription.getId());
        }
        List contentList = subscriptionRepository.getContentBySchedule(schedule);
        for (ISubscribeContent content : contentList) {
            subscriptionRepository.deleteContentForSchedule(content, schedule);
            if (0 != content.getSchedules().size()) continue;
            subscriptionRepository.deleteSubscribeContent(content);
        }
        boolean deleteSuccess = subscriptionRepository.deleteSchedule(schedule);
        if (!deleteSuccess) {
            throw new SubscriptionSchedulerException("Failed to delete schedule with id: " + schedule.getId() + "and description: " + schedule.getDescription());
        }
    }

    public static ISchedule editScheduleAndContent(ISubscriptionRepository subscriptionRepository, String schedId, String title, String schedRef, String desc, String cronExpr, Integer repeatCount, Integer repeatInterval, String group, Date startDate, Date endDate, String[] actionRefs) throws SubscriptionRepositoryCheckedException {
        ISchedule sched = null;
        sched = null != cronExpr ? subscriptionRepository.editCronSchedule(schedId, title, schedRef, desc, cronExpr, group, startDate, endDate) : subscriptionRepository.editRepeatSchedule(schedId, title, schedRef, desc, repeatCount, repeatInterval, group, startDate, endDate);
        List contentList = subscriptionRepository.getContentBySchedule(sched);
        for (ISubscribeContent content : contentList) {
            subscriptionRepository.deleteContentForSchedule(content, sched);
        }
        List newContents = subscriptionRepository.addContent(actionRefs);
        for (ISubscribeContent newContent : newContents) {
            subscriptionRepository.addContentForSchedule(newContent, sched);
        }
        return sched;
    }

    public static ISchedule editScheduleWithoutContent(ISubscriptionRepository subscriptionRepository, String schedId, String title, String schedRef, String desc, String cronExpr, Integer repeatCount, Integer repeatInterval, String group, Date startDate, Date endDate) throws SubscriptionRepositoryCheckedException {
        ISchedule sched = null;
        sched = null != cronExpr ? subscriptionRepository.editCronSchedule(schedId, title, schedRef, desc, cronExpr, group, startDate, endDate) : subscriptionRepository.editRepeatSchedule(schedId, title, schedRef, desc, repeatCount, repeatInterval, group, startDate, endDate);
        return sched;
    }

    public static ISchedule addScheduleAndContent(ISubscriptionRepository subscriptionRepository, String title, String schedRef, String desc, String cronExpr, Integer repeatCount, Integer repeatInterval, String group, Date startDate, Date endDate, String[] actionRefs) throws SubscriptionRepositoryCheckedException {
        ISchedule sched = null;
        sched = null != cronExpr ? subscriptionRepository.addCronSchedule(title, schedRef, desc, cronExpr, group, startDate, endDate) : subscriptionRepository.addRepeatSchedule(title, schedRef, desc, repeatCount, repeatInterval, group, startDate, endDate);
        List newContents = subscriptionRepository.addContent(actionRefs);
        for (ISubscribeContent newContent : newContents) {
            subscriptionRepository.addContentForSchedule(newContent.getId(), sched.getId());
        }
        return sched;
    }

    public static ISchedule addScheduleWithoutContent(ISubscriptionRepository subscriptionRepository, String title, String schedRef, String desc, String cronExpr, Integer repeatCount, Integer repeatInterval, String group, Date startDate, Date endDate) throws SubscriptionRepositoryCheckedException {
        ISchedule sched = null;
        sched = null != cronExpr ? subscriptionRepository.addCronSchedule(title, schedRef, desc, cronExpr, group, startDate, endDate) : subscriptionRepository.addRepeatSchedule(title, schedRef, desc, repeatCount, repeatInterval, group, startDate, endDate);
        return sched;
    }
}

