/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.subscription;

import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISubscribeContent;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.subscription.Subscription;

public class SubscriptionResultSet
extends MemoryResultSet {
    IPentahoSession userSession;
    ISubscriptionRepository subscriptionRepository;
    String[] parameterNames;
    String actionRef = null;

    public SubscriptionResultSet(String scheduleId, IPentahoSession userSession, String[] parameterNames, String solution, String path, String action) {
        this.userSession = userSession;
        this.parameterNames = parameterNames;
        if (solution != null && path != null && action != null) {
            this.actionRef = solution + "/" + path + "/" + action;
        }
        this.setMetaData((IPentahoMetaData)Subscription.getMetadata(parameterNames));
        this.subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)userSession);
        this.setRows(this.subscriptionRepository.getSubscriptionsForSchedule(scheduleId));
    }

    public Object[] next() {
        if (this.iterator == null) {
            this.iterator = this.rows.iterator();
        }
        while (this.iterator.hasNext()) {
            Subscription subscr = (Subscription)this.iterator.next();
            if (this.actionRef != null) {
                ISubscribeContent content = subscr.getContent();
                if (!this.isBursterFor(this.actionRef, content.getActionReference())) continue;
                return subscr.toResultRow(this.parameterNames);
            }
            return subscr.toResultRow(this.parameterNames);
        }
        return null;
    }

    private boolean isBursterFor(String bursterRef, String contentRef) {
        try {
            contentRef = contentRef.substring(contentRef.lastIndexOf(47), contentRef.lastIndexOf(".xaction"));
            bursterRef = bursterRef.substring(bursterRef.lastIndexOf(47), bursterRef.lastIndexOf("Burst.xaction"));
            return bursterRef.equals(contentRef);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Object getValueAt(int row, int column) {
        Object[] theRow = (Object[])this.rows.get(row);
        return theRow[column];
    }
}

