/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.usersettings;

import java.util.List;
import org.hibernate.Session;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.usersettings.UserSettingDAO;
import org.pentaho.platform.repository.usersettings.pojo.UserSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSettingService
implements IUserSettingService {
    public static final String GLOBAL_SETTING = "_GLOBAL";
    IPentahoSession session = null;

    public void init(IPentahoSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUserSettings() {
        Session hibsession = HibernateUtil.getSession();
        try {
            HibernateUtil.beginTransaction();
            try {
                List<IUserSetting> settings = UserSettingDAO.getUserSettings(hibsession, this.session.getName());
                if (settings != null) {
                    for (IUserSetting setting : settings) {
                        hibsession.delete((Object)setting);
                    }
                }
            }
            finally {
                HibernateUtil.commitTransaction();
            }
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IUserSetting> getUserSettings() {
        List<IUserSetting> userSettings = null;
        Session hibsession = HibernateUtil.getSession();
        try {
            HibernateUtil.beginTransaction();
            try {
                userSettings = UserSettingDAO.getUserSettings(hibsession, this.session.getName());
                List<IUserSetting> globalSettings = UserSettingDAO.getUserSettings(hibsession, GLOBAL_SETTING);
                for (IUserSetting globalSetting : globalSettings) {
                    if (userSettings.contains(globalSetting)) continue;
                    userSettings.add(globalSetting);
                }
            }
            finally {
                HibernateUtil.commitTransaction();
            }
        }
        finally {
            HibernateUtil.closeSession();
        }
        return userSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUserSetting getUserSetting(String settingName, String defaultValue) {
        IUserSetting userSetting = null;
        Session hibsession = HibernateUtil.getSession();
        try {
            HibernateUtil.beginTransaction();
            try {
                userSetting = UserSettingDAO.getUserSetting(hibsession, this.session.getName(), settingName);
                if (userSetting == null) {
                    userSetting = this.getGlobalUserSetting(settingName, defaultValue);
                }
            }
            finally {
                HibernateUtil.commitTransaction();
            }
        }
        finally {
            HibernateUtil.closeSession();
        }
        return userSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserSetting(String settingName, String settingValue) {
        Session hibsession = HibernateUtil.getSession();
        try {
            HibernateUtil.beginTransaction();
            try {
                UserSettingDAO.setUserSetting(hibsession, this.session.getName(), settingName, settingValue);
            }
            finally {
                HibernateUtil.commitTransaction();
            }
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUserSetting getGlobalUserSetting(String settingName, String defaultValue) {
        IUserSetting userSetting = null;
        Session hibsession = HibernateUtil.getSession();
        try {
            HibernateUtil.beginTransaction();
            try {
                userSetting = UserSettingDAO.getUserSetting(hibsession, GLOBAL_SETTING, settingName);
                if (userSetting == null && defaultValue != null) {
                    userSetting = new UserSetting();
                    userSetting.setUsername(this.session.getName());
                    userSetting.setSettingName(settingName);
                    userSetting.setSettingValue(defaultValue);
                }
            }
            finally {
                HibernateUtil.commitTransaction();
            }
        }
        finally {
            HibernateUtil.closeSession();
        }
        return userSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IUserSetting> getGlobalUserSettings() {
        List<IUserSetting> settings = null;
        Session hibsession = HibernateUtil.getSession();
        try {
            HibernateUtil.beginTransaction();
            try {
                settings = UserSettingDAO.getUserSettings(hibsession, GLOBAL_SETTING);
            }
            finally {
                HibernateUtil.commitTransaction();
            }
        }
        finally {
            HibernateUtil.closeSession();
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalUserSetting(String settingName, String settingValue) {
        block7: {
            if (SecurityHelper.isPentahoAdministrator((IPentahoSession)this.session)) {
                Session hibsession = HibernateUtil.getSession();
                try {
                    HibernateUtil.beginTransaction();
                    try {
                        UserSettingDAO.setUserSetting(hibsession, GLOBAL_SETTING, settingName, settingValue);
                        break block7;
                    }
                    finally {
                        HibernateUtil.commitTransaction();
                    }
                }
                finally {
                    HibernateUtil.closeSession();
                }
            }
            throw new UnsupportedOperationException(Messages.getErrorString("UserSettingService.ERROR_0001_INSUFFICIENT_PRIVILEGES"));
        }
    }
}

