/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.BaseRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.row.RowMetaInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingListeningRowSet
extends BaseRowSet
implements Comparable<RowSet>,
RowSet {
    private BlockingQueue<Object[]> queArray;
    private AtomicBoolean blocking;

    public BlockingListeningRowSet(int maxSize) {
        this.queArray = new ArrayBlockingQueue<Object[]>(maxSize, false);
        this.blocking = new AtomicBoolean(false);
    }

    @Override
    public boolean putRow(RowMetaInterface rowMeta, Object[] rowData) {
        return this.putRowWait(rowMeta, rowData, 100L, TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean putRowWait(RowMetaInterface rowMeta, Object[] rowData, long time, TimeUnit tu) {
        this.rowMeta = rowMeta;
        try {
            this.blocking.set(true);
            boolean b = this.queArray.offer(rowData, time, tu);
            this.blocking.set(false);
            return b;
        }
        catch (InterruptedException e) {
            this.blocking.set(false);
            return false;
        }
        catch (NullPointerException e) {
            this.blocking.set(false);
            return false;
        }
    }

    @Override
    public Object[] getRow() {
        this.blocking.set(true);
        Object[] row = this.getRowWait(100L, TimeUnit.NANOSECONDS);
        this.blocking.set(false);
        return row;
    }

    @Override
    public Object[] getRowImmediate() {
        this.blocking.set(true);
        Object[] row = (Object[])this.queArray.poll();
        this.blocking.set(false);
        return row;
    }

    @Override
    public Object[] getRowWait(long timeout, TimeUnit tu) {
        try {
            this.blocking.set(true);
            Object[] row = this.queArray.poll(timeout, tu);
            this.blocking.set(false);
            return row;
        }
        catch (InterruptedException e) {
            this.blocking.set(false);
            return null;
        }
    }

    @Override
    public int size() {
        return this.queArray.size();
    }

    @Override
    public boolean isBlocking() {
        return this.blocking.get();
    }
}

