/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;

public class LogChannel
implements LogChannelInterface {
    public static LogChannelInterface GENERAL = new LogChannel("General");
    public static LogChannelInterface METADATA = new LogChannel("Metadata");
    public static LogChannelInterface UI = new LogChannel("GUI");
    private static LogWriter log = LogWriter.getInstance();
    private String logChannelId;
    private LogLevel logLevel;
    private String containerObjectId;

    public LogChannel(Object subject) {
        this.logLevel = DefaultLogLevel.getLogLevel();
        this.logChannelId = LoggingRegistry.getInstance().registerLoggingSource(subject);
    }

    public LogChannel(Object subject, LoggingObjectInterface parentObject) {
        if (parentObject != null) {
            this.logLevel = parentObject.getLogLevel();
            this.containerObjectId = parentObject.getContainerObjectId();
        } else {
            this.logLevel = DefaultLogLevel.getLogLevel();
            this.containerObjectId = null;
        }
        this.logChannelId = LoggingRegistry.getInstance().registerLoggingSource(subject);
    }

    public String toString() {
        return this.logChannelId;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void logMinimal(String s) {
        log.println(new LogMessage(s, this.logChannelId, LogLevel.MINIMAL), this.logLevel);
    }

    public void logBasic(String s) {
        log.println(new LogMessage(s, this.logChannelId, LogLevel.BASIC), this.logLevel);
    }

    public void logError(String s) {
        log.println(new LogMessage(s, this.logChannelId, LogLevel.ERROR), this.logLevel);
    }

    public void logError(String s, Throwable e) {
        log.println(new LogMessage(s, this.logChannelId, LogLevel.ERROR), e, this.logLevel);
    }

    public void logBasic(String s, Object ... arguments) {
        log.println(new LogMessage(s, this.logChannelId, arguments, LogLevel.BASIC), this.logLevel);
    }

    public void logDetailed(String s, Object ... arguments) {
        log.println(new LogMessage(s, this.logChannelId, arguments, LogLevel.DETAILED), this.logLevel);
    }

    public void logError(String s, Object ... arguments) {
        log.println(new LogMessage(s, this.logChannelId, arguments, LogLevel.ERROR), this.logLevel);
    }

    public void logDetailed(String s) {
        log.println(new LogMessage(s, this.logChannelId, LogLevel.DETAILED), this.logLevel);
    }

    public void logDebug(String s) {
        log.println(new LogMessage(s, this.logChannelId, LogLevel.DEBUG), this.logLevel);
    }

    public void logDebug(String message, Object ... arguments) {
        log.println(new LogMessage(message, this.logChannelId, arguments, LogLevel.DEBUG), this.logLevel);
    }

    public void logRowlevel(String s) {
        log.println(new LogMessage(s, this.logChannelId, LogLevel.ROWLEVEL), this.logLevel);
    }

    public void logMinimal(String message, Object ... arguments) {
        log.println(new LogMessage(message, this.logChannelId, arguments, LogLevel.MINIMAL), this.logLevel);
    }

    public void logRowlevel(String message, Object ... arguments) {
        log.println(new LogMessage(message, this.logChannelId, arguments, LogLevel.ROWLEVEL), this.logLevel);
    }

    public boolean isBasic() {
        return this.logLevel.isBasic();
    }

    public boolean isDebug() {
        return this.logLevel.isDebug();
    }

    public boolean isDetailed() {
        try {
            return this.logLevel.isDetailed();
        }
        catch (NullPointerException ex) {
            System.out.println("Oops!");
            return false;
        }
    }

    public boolean isRowLevel() {
        return this.logLevel.isRowlevel();
    }

    public boolean isError() {
        return this.logLevel.isError();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }
}

