/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.text.MessageFormat;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogMessageInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;

public class LogMessage
implements LogMessageInterface {
    private String logChannelId;
    private String message;
    private String subject;
    private Object[] arguments;
    private LogLevel level;
    private String copy;

    public LogMessage(String subject, LogLevel level) {
        this.subject = subject;
        this.level = level;
        this.message = null;
        this.logChannelId = null;
    }

    public LogMessage(String message, String logChannelId, LogLevel level) {
        this.message = message;
        this.logChannelId = logChannelId;
        this.level = level;
        this.lookupSubject();
    }

    public LogMessage(String message, String logChannelId, Object[] arguments, LogLevel level) {
        this.message = message;
        this.logChannelId = logChannelId;
        this.arguments = arguments;
        this.level = level;
        this.lookupSubject();
    }

    private void lookupSubject() {
        LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(this.logChannelId);
        if (loggingObject != null) {
            this.subject = loggingObject.getObjectName();
            this.copy = loggingObject.getObjectCopy();
        }
    }

    public String toString() {
        if (this.message == null) {
            return this.subject;
        }
        if (this.arguments != null && this.arguments.length > 0) {
            return this.subject + " - " + MessageFormat.format(this.message, this.arguments);
        }
        return this.subject + " - " + this.message;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public void setLevel(LogLevel level) {
        this.level = level;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public boolean isError() {
        return this.level.isError();
    }

    public String getCopy() {
        return this.copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }
}

