/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;

public class LoggingObject
implements LoggingObjectInterface {
    private String logChannelId;
    private LoggingObjectType objectType;
    private String objectName;
    private String objectCopy;
    private RepositoryDirectoryInterface repositoryDirectory;
    private String filename;
    private ObjectId objectId;
    private ObjectRevision objectRevision;
    private LogLevel logLevel = DefaultLogLevel.getLogLevel();
    private String containerObjectId;
    private LoggingObjectInterface parent;
    private Date registrationDate;

    public LoggingObject(Object object) {
        if (object instanceof LoggingObjectInterface) {
            this.grabLoggingObjectInformation((LoggingObjectInterface)object);
        } else {
            this.grabObjectInformation(object);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LoggingObject)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            boolean sameCarteFamily;
            LoggingObject loggingObject = (LoggingObject)obj;
            boolean bl = sameCarteFamily = this.getContainerObjectId() == null && loggingObject.getContainerObjectId() == null || this.getContainerObjectId() != null && loggingObject.getContainerObjectId() != null && this.getContainerObjectId().equals(loggingObject.getContainerObjectId());
            if (sameCarteFamily && loggingObject.getObjectId() != null && loggingObject.getObjectId().equals(this.getObjectId())) {
                return true;
            }
            if (sameCarteFamily && !Const.isEmpty(loggingObject.getFilename()) && loggingObject.getFilename().equals(this.getFilename())) {
                return true;
            }
            if (!sameCarteFamily || loggingObject.getObjectName() == null && this.getObjectName() != null || loggingObject.getObjectName() != null && this.getObjectName() == null) {
                return false;
            }
            if (sameCarteFamily && (loggingObject.getObjectName() == null && this.getObjectName() == null || loggingObject.getObjectName().equals(this.getObjectName())) && loggingObject.getObjectType().equals((Object)this.getObjectType())) {
                if (!Const.isEmpty(this.getObjectCopy()) && !this.getObjectCopy().equals(loggingObject.getObjectCopy())) {
                    return false;
                }
                LoggingObjectInterface parent1 = loggingObject.getParent();
                LoggingObjectInterface parent2 = this.getParent();
                if (parent1 != null && parent2 == null || parent1 == null && parent2 != null) {
                    return false;
                }
                if (parent1 == null && parent2 == null) {
                    return true;
                }
                if (parent1.equals(parent2)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void grabLoggingObjectInformation(LoggingObjectInterface loggingObject) {
        this.objectType = loggingObject.getObjectType();
        this.objectName = loggingObject.getObjectName();
        this.repositoryDirectory = loggingObject.getRepositoryDirectory();
        this.filename = loggingObject.getFilename();
        this.objectId = loggingObject.getObjectId();
        this.objectRevision = loggingObject.getObjectRevision();
        this.objectCopy = loggingObject.getObjectCopy();
        this.logLevel = loggingObject.getLogLevel();
        this.containerObjectId = loggingObject.getContainerObjectId();
        if (loggingObject.getParent() != null) {
            this.getParentLoggingObject(loggingObject.getParent());
            this.containerObjectId = loggingObject.getParent().getContainerObjectId();
        }
    }

    private void grabObjectInformation(Object object) {
        this.objectType = LoggingObjectType.GENERAL;
        this.objectName = object.toString();
        this.parent = null;
    }

    private void getParentLoggingObject(Object parentObject) {
        LoggingObject check;
        if (parentObject == null) {
            return;
        }
        if (parentObject instanceof LoggingObjectInterface) {
            LoggingObjectInterface parentLoggingObject;
            this.parent = (LoggingObjectInterface)parentObject;
            if (this.parent.getLogChannelId() != null && (parentLoggingObject = LoggingRegistry.getInstance().getLoggingObject(this.parent.getLogChannelId())) != null) {
                this.parent = parentLoggingObject;
            }
            return;
        }
        LoggingRegistry registry = LoggingRegistry.getInstance();
        LoggingObjectInterface loggingObject = registry.findExistingLoggingSource(check = new LoggingObject(parentObject));
        if (loggingObject == null) {
            String logChannelId = registry.registerLoggingSource(check);
            loggingObject = check;
            check.setLogChannelId(logChannelId);
        }
        this.parent = loggingObject;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String name) {
        this.objectName = name;
    }

    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public void setRepositoryDirectory(RepositoryDirectory repositoryDirectory) {
        this.repositoryDirectory = repositoryDirectory;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    public ObjectRevision getObjectRevision() {
        return this.objectRevision;
    }

    public void setObjectRevision(ObjectRevision objectRevision) {
        this.objectRevision = objectRevision;
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    public LoggingObjectInterface getParent() {
        return this.parent;
    }

    public void setParent(LoggingObjectInterface parent) {
        this.parent = parent;
    }

    public LoggingObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(LoggingObjectType objectType) {
        this.objectType = objectType;
    }

    public String getObjectCopy() {
        return this.objectCopy;
    }

    public void setObjectCopy(String objectCopy) {
        this.objectCopy = objectCopy;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setCarteObjectId(String carteObjectId) {
        this.containerObjectId = carteObjectId;
    }

    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }
}

