/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.pentaho.di.compatibility.Value;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.w3c.dom.Node;

public class ValueMeta
implements ValueMetaInterface {
    private static Class<?> PKG = Const.class;
    public static final String DEFAULT_DATE_FORMAT_MASK = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String XML_META_TAG = "value-meta";
    public static final String XML_DATA_TAG = "value-data";
    public static final boolean EMPTY_STRING_AND_NULL_ARE_DIFFERENT = ValueMeta.convertStringToBoolean(Const.NVL(System.getProperty("KETTLE_EMPTY_STRING_DIFFERS_FROM_NULL", "N"), "N"));
    private String name;
    private int length;
    private int precision;
    private int type;
    private int trimType;
    private int storageType;
    private String origin;
    private String comments;
    private Object[] index;
    private String conversionMask;
    private String stringEncoding;
    private String decimalSymbol;
    private String groupingSymbol;
    private String currencySymbol;
    private boolean caseInsensitive;
    private boolean sortedDescending;
    private boolean outputPaddingEnabled;
    private boolean largeTextField;
    private Locale dateFormatLocale;
    private boolean dateFormatLenient;
    private SimpleDateFormat dateFormat;
    private boolean dateFormatChanged;
    private DecimalFormat decimalFormat;
    private boolean decimalFormatChanged;
    private ValueMetaInterface storageMetadata;
    private boolean identicalFormat;
    private ValueMetaInterface conversionMetadata;
    boolean singleByteEncoding;
    private long numberOfBinaryStringConversions;
    private boolean bigNumberFormatting;
    private int originalColumnType;
    private String originalColumnTypeName;
    private int originalPrecision;
    private int originalScale;
    private boolean originalAutoIncrement;
    private int originalNullable;
    private boolean originalSigned;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, "ValueMeta.TrimType.None", new String[0]), BaseMessages.getString(PKG, "ValueMeta.TrimType.Left", new String[0]), BaseMessages.getString(PKG, "ValueMeta.TrimType.Right", new String[0]), BaseMessages.getString(PKG, "ValueMeta.TrimType.Both", new String[0])};
    public static final String[] SINGLE_BYTE_ENCODINGS = new String[]{"ISO8859_1", "Cp1252", "ASCII", "Cp037", "Cp273", "Cp277", "Cp278", "Cp280", "Cp284", "Cp285", "Cp297", "Cp420", "Cp424", "Cp437", "Cp500", "Cp737", "Cp775", "Cp850", "Cp852", "Cp855", "Cp856", "Cp857", "Cp858", "Cp860", "Cp861", "Cp862", "Cp863", "Cp865", "Cp866", "Cp869", "Cp870", "Cp871", "Cp875", "Cp918", "Cp921", "Cp922", "Cp1140", "Cp1141", "Cp1142", "Cp1143", "Cp1144", "Cp1145", "Cp1146", "Cp1147", "Cp1148", "Cp1149", "Cp1250", "Cp1251", "Cp1253", "Cp1254", "Cp1255", "Cp1257", "ISO8859_2", "ISO8859_3", "ISO8859_5", "ISO8859_5", "ISO8859_6", "ISO8859_7", "ISO8859_8", "ISO8859_9", "ISO8859_13", "ISO8859_15", "ISO8859_15_FDIS", "MacCentralEurope", "MacCroatian", "MacCyrillic", "MacDingbat", "MacGreek", "MacHebrew", "MacIceland", "MacRoman", "MacRomania", "MacSymbol", "MacTurkish", "MacUkraine"};
    private static SimpleDateFormat compatibleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    public ValueMeta() {
        this(null, 0, -1, -1);
    }

    public ValueMeta(String name) {
        this(name, 0, -1, -1);
    }

    public ValueMeta(String name, int type) {
        this(name, type, -1, -1);
    }

    public ValueMeta(String name, int type, int storageType) {
        this(name, type, -1, -1);
        this.storageType = storageType;
        this.setDefaultConversionMask();
    }

    public ValueMeta(String name, int type, int length, int precision) {
        this.name = name;
        this.type = type;
        this.length = length;
        this.precision = precision;
        this.storageType = 0;
        this.sortedDescending = false;
        this.outputPaddingEnabled = false;
        this.decimalSymbol = "" + Const.DEFAULT_DECIMAL_SEPARATOR;
        this.groupingSymbol = "" + Const.DEFAULT_GROUPING_SEPARATOR;
        this.dateFormatLocale = Locale.getDefault();
        this.identicalFormat = true;
        this.bigNumberFormatting = true;
        this.determineSingleByteEncoding();
        this.setDefaultConversionMask();
    }

    private void setDefaultConversionMask() {
        switch (this.type) {
            case 5: {
                this.setConversionMask("#;-#");
                break;
            }
            case 1: {
                this.setConversionMask("#.#;-#.#");
                break;
            }
            case 6: {
                this.setConversionMask("#.###############################################;-#.###############################################");
                this.setGroupingSymbol(null);
                this.setDecimalSymbol(".");
                break;
            }
        }
    }

    private void determineSingleByteEncoding() {
        this.singleByteEncoding = false;
        Charset cs = Const.isEmpty(this.stringEncoding) ? Charset.defaultCharset() : Charset.forName(this.stringEncoding);
        for (String charSetEncoding : SINGLE_BYTE_ENCODINGS) {
            if (!cs.toString().equalsIgnoreCase(charSetEncoding)) continue;
            this.singleByteEncoding = true;
        }
    }

    public ValueMeta clone() {
        try {
            ValueMeta valueMeta = (ValueMeta)super.clone();
            valueMeta.dateFormat = null;
            valueMeta.decimalFormat = null;
            if (this.dateFormatLocale != null) {
                valueMeta.dateFormatLocale = (Locale)this.dateFormatLocale.clone();
            }
            if (this.storageMetadata != null) {
                valueMeta.storageMetadata = this.storageMetadata.clone();
            }
            if (this.conversionMetadata != null) {
                valueMeta.conversionMetadata = this.conversionMetadata.clone();
            }
            valueMeta.compareStorageAndActualFormat();
            return valueMeta;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Object[] getIndex() {
        return this.index;
    }

    public void setIndex(Object[] index) {
        this.index = index;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setLength(int length, int precision) {
        this.length = length;
        this.precision = precision;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public int getPrecision() {
        if (this.isInteger() || this.isBinary()) {
            return 0;
        }
        if (this.isString() || this.isBoolean()) {
            return -1;
        }
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    public boolean isStorageNormal() {
        return this.storageType == 0;
    }

    public boolean isStorageIndexed() {
        return this.storageType == 2;
    }

    public boolean isStorageBinaryString() {
        return this.storageType == 1;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
        this.dateFormatChanged = true;
        this.decimalFormatChanged = true;
        this.compareStorageAndActualFormat();
    }

    public String getStringEncoding() {
        return this.stringEncoding;
    }

    public void setStringEncoding(String encoding) {
        this.stringEncoding = encoding;
        this.determineSingleByteEncoding();
        this.compareStorageAndActualFormat();
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
        this.decimalFormatChanged = true;
        this.compareStorageAndActualFormat();
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
        this.decimalFormatChanged = true;
        this.compareStorageAndActualFormat();
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
        this.decimalFormatChanged = true;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean isSortedDescending() {
        return this.sortedDescending;
    }

    public void setSortedDescending(boolean sortedDescending) {
        this.sortedDescending = sortedDescending;
    }

    public boolean isOutputPaddingEnabled() {
        return this.outputPaddingEnabled;
    }

    public void setOutputPaddingEnabled(boolean outputPaddingEnabled) {
        this.outputPaddingEnabled = outputPaddingEnabled;
    }

    public boolean isLargeTextField() {
        return this.largeTextField;
    }

    public void setLargeTextField(boolean largeTextField) {
        this.largeTextField = largeTextField;
    }

    public boolean isDateFormatLenient() {
        return this.dateFormatLenient;
    }

    public void setDateFormatLenient(boolean dateFormatLenient) {
        this.dateFormatLenient = dateFormatLenient;
        this.dateFormatChanged = true;
    }

    public Locale getDateFormatLocale() {
        return this.dateFormatLocale;
    }

    public void setDateFormatLocale(Locale dateFormatLocale) {
        this.dateFormatLocale = dateFormatLocale;
        this.dateFormatChanged = true;
    }

    private synchronized String convertDateToString(Date date) {
        if (date == null) {
            return null;
        }
        return this.getDateFormat().format(date);
    }

    private synchronized String convertDateToCompatibleString(Date date) {
        if (date == null) {
            return null;
        }
        return compatibleDateFormat.format(date);
    }

    private synchronized Date convertStringToDate(String string) throws KettleValueException {
        if (Const.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            return this.getDateFormat().parse(string);
        }
        catch (ParseException e) {
            String dateFormat = this.getDateFormat() != null ? this.getDateFormat().toPattern() : "null";
            throw new KettleValueException(this.toString() + " : couldn't convert string [" + string + "] to a date using format [" + dateFormat + "]", e);
        }
    }

    private Double convertDateToNumber(Date date) {
        return new Double(date.getTime());
    }

    private Date convertNumberToDate(Double number) {
        return new Date(number.longValue());
    }

    private Long convertDateToInteger(Date date) {
        return new Long(date.getTime());
    }

    private Date convertIntegerToDate(Long number) {
        return new Date(number);
    }

    private BigDecimal convertDateToBigNumber(Date date) {
        return new BigDecimal(date.getTime());
    }

    private Date convertBigNumberToDate(BigDecimal number) {
        return new Date(number.longValue());
    }

    private synchronized String convertNumberToString(Double number) throws KettleValueException {
        if (number == null) {
            if (!this.outputPaddingEnabled || this.length < 1) {
                return null;
            }
            String[] emptyPaddedStrings = Const.getEmptyPaddedStrings();
            if (this.length < emptyPaddedStrings.length) {
                return emptyPaddedStrings[this.length];
            }
            return Const.rightPad("", this.length);
        }
        try {
            return this.getDecimalFormat(false).format(number);
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert Number to String ", e);
        }
    }

    private synchronized String convertNumberToCompatibleString(Double number) throws KettleValueException {
        if (number == null) {
            return null;
        }
        return Double.toString(number);
    }

    private synchronized Double convertStringToNumber(String string) throws KettleValueException {
        if (Const.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            return new Double(this.getDecimalFormat(false).parse(string).doubleValue());
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert String to number ", e);
        }
    }

    public synchronized SimpleDateFormat getDateFormat() {
        if (this.conversionMetadata != null) {
            return this.conversionMetadata.getDateFormat();
        }
        if (this.dateFormat == null || this.dateFormatChanged) {
            this.dateFormat = new SimpleDateFormat();
            String mask = Const.isEmpty(this.conversionMask) ? DEFAULT_DATE_FORMAT_MASK : this.conversionMask;
            this.dateFormat = this.dateFormatLocale == null || this.dateFormatLocale.equals(Locale.getDefault()) ? new SimpleDateFormat(mask) : new SimpleDateFormat(mask, this.dateFormatLocale);
            this.dateFormat.setLenient(this.dateFormatLenient);
            this.dateFormatChanged = false;
        }
        return this.dateFormat;
    }

    public synchronized DecimalFormat getDecimalFormat() {
        return this.getDecimalFormat(false);
    }

    public synchronized DecimalFormat getDecimalFormat(boolean useBigDecimal) {
        if (this.conversionMetadata != null) {
            return this.conversionMetadata.getDecimalFormat(useBigDecimal);
        }
        if (this.decimalFormat == null || this.decimalFormatChanged) {
            this.decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            this.decimalFormat.setParseBigDecimal(useBigDecimal);
            DecimalFormatSymbols decimalFormatSymbols = this.decimalFormat.getDecimalFormatSymbols();
            if (!Const.isEmpty(this.currencySymbol)) {
                decimalFormatSymbols.setCurrencySymbol(this.currencySymbol);
            }
            if (!Const.isEmpty(this.groupingSymbol)) {
                decimalFormatSymbols.setGroupingSeparator(this.groupingSymbol.charAt(0));
            }
            if (!Const.isEmpty(this.decimalSymbol)) {
                decimalFormatSymbols.setDecimalSeparator(this.decimalSymbol.charAt(0));
            }
            this.decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            if (!Const.isEmpty(this.conversionMask)) {
                this.decimalFormat.applyPattern(this.conversionMask);
            } else {
                switch (this.type) {
                    case 5: {
                        int i;
                        if (this.length < 1) {
                            this.decimalFormat.applyPattern(" ###############0;-###############0");
                            break;
                        }
                        StringBuffer integerPattern = new StringBuffer();
                        integerPattern.append(" ");
                        for (i = 0; i < this.getLength(); ++i) {
                            integerPattern.append('0');
                        }
                        integerPattern.append(";");
                        integerPattern.append("-");
                        for (i = 0; i < this.getLength(); ++i) {
                            integerPattern.append('0');
                        }
                        this.decimalFormat.applyPattern(integerPattern.toString());
                        break;
                    }
                    case 1: 
                    case 6: {
                        int i;
                        if (this.length < 1) {
                            this.decimalFormat.applyPattern(" ##########0.0########;-#########0.0########");
                            break;
                        }
                        StringBuffer numberPattern = new StringBuffer();
                        numberPattern.append(' ');
                        if (this.precision < 0) {
                            for (i = 0; i < this.length; ++i) {
                                numberPattern.append('0');
                            }
                            numberPattern.append(".00");
                        } else {
                            for (i = 0; i <= this.length; ++i) {
                                numberPattern.append('0');
                            }
                            int pos = this.length - this.precision + 1;
                            if (pos >= 0 && pos < numberPattern.length()) {
                                numberPattern.setCharAt(this.length - this.precision + 1, '.');
                            }
                        }
                        StringBuffer negativePattern = new StringBuffer(numberPattern);
                        negativePattern.setCharAt(0, '-');
                        numberPattern.append(";");
                        numberPattern.append(negativePattern);
                        this.decimalFormat.applyPattern(numberPattern.toString());
                    }
                }
            }
            this.decimalFormatChanged = false;
        }
        return this.decimalFormat;
    }

    private synchronized String convertIntegerToString(Long integer) throws KettleValueException {
        if (integer == null) {
            if (!this.outputPaddingEnabled || this.length < 1) {
                return null;
            }
            String[] emptyPaddedStrings = Const.getEmptyPaddedStrings();
            if (this.length < emptyPaddedStrings.length) {
                return emptyPaddedStrings[this.length];
            }
            return Const.rightPad("", this.length);
        }
        try {
            return this.getDecimalFormat(false).format(integer);
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert Long to String ", e);
        }
    }

    private synchronized String convertIntegerToCompatibleString(Long integer) throws KettleValueException {
        if (integer == null) {
            return null;
        }
        return Long.toString(integer);
    }

    private synchronized Long convertStringToInteger(String string) throws KettleValueException {
        if (Const.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            return new Long(this.getDecimalFormat(false).parse(string).longValue());
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert String to Integer", e);
        }
    }

    private synchronized String convertBigNumberToString(BigDecimal number) throws KettleValueException {
        if (number == null) {
            return null;
        }
        try {
            return this.getDecimalFormat(this.bigNumberFormatting).format(number);
        }
        catch (Exception e) {
            throw new KettleValueException(this.toString() + " : couldn't convert BigNumber to String ", e);
        }
    }

    private synchronized BigDecimal convertStringToBigNumber(String string) throws KettleValueException {
        if (Const.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            return (BigDecimal)this.getDecimalFormat(this.bigNumberFormatting).parse(string);
        }
        catch (Exception e) {
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException ex) {
                throw new KettleValueException(this.toString() + " : couldn't convert string value '" + string + "' to a big number.", ex);
            }
        }
    }

    private String convertBooleanToString(Boolean bool) {
        if (bool == null) {
            return null;
        }
        if (this.length >= 3) {
            return bool != false ? "true" : "false";
        }
        return bool != false ? "Y" : "N";
    }

    public static Boolean convertStringToBoolean(String string) {
        if (Const.isEmpty(string)) {
            return null;
        }
        return "Y".equalsIgnoreCase(string) || "TRUE".equalsIgnoreCase(string) || "YES".equalsIgnoreCase(string) || "1".equals(string);
    }

    private Double convertBooleanToNumber(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return new Double(bool != false ? 1.0 : 0.0);
    }

    private Boolean convertNumberToBoolean(Double number) {
        if (number == null) {
            return null;
        }
        return number.intValue() != 0;
    }

    private Long convertBooleanToInteger(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? 1L : 0L;
    }

    private Boolean convertIntegerToBoolean(Long number) {
        if (number == null) {
            return null;
        }
        return number != 0L;
    }

    private BigDecimal convertBooleanToBigNumber(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    private Boolean convertBigNumberToBoolean(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.intValue() != 0;
    }

    private String convertBinaryStringToString(byte[] binary) throws KettleValueException {
        if (binary == null || binary.length == 0) {
            return EMPTY_STRING_AND_NULL_ARE_DIFFERENT && binary != null ? "" : null;
        }
        String encoding = this.identicalFormat ? this.getStringEncoding() : this.storageMetadata.getStringEncoding();
        if (Const.isEmpty(encoding)) {
            return new String(binary);
        }
        try {
            return new String(binary, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new KettleValueException(this.toString() + " : couldn't convert binary value to String with specified string encoding [" + this.stringEncoding + "]", e);
        }
    }

    public Object convertToNormalStorageType(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.storageType) {
            case 0: {
                return object;
            }
            case 1: {
                return this.convertBinaryStringToNativeType((byte[])object);
            }
            case 2: {
                return this.index[(Integer)object];
            }
        }
        throw new KettleValueException(this.toStringMeta() + " : Unknown storage type [" + this.storageType + "] while converting to normal storage type");
    }

    public Object convertToBinaryStringStorageType(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.storageType) {
            case 0: {
                return this.convertNormalStorageTypeToBinaryString(object);
            }
            case 1: {
                return object;
            }
            case 2: {
                return this.convertNormalStorageTypeToBinaryString(this.index[(Integer)object]);
            }
        }
        throw new KettleValueException(this.toStringMeta() + " : Unknown storage type [" + this.storageType + "] while converting to normal storage type");
    }

    public Object convertBinaryStringToNativeType(byte[] binary) throws KettleValueException {
        if (binary == null) {
            return null;
        }
        ++this.numberOfBinaryStringConversions;
        String string = this.convertBinaryStringToString(binary);
        return this.convertData(this.storageMetadata, string);
    }

    public Object convertNormalStorageTypeToBinaryString(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        String string = this.getString(object);
        return this.convertStringToBinaryString(string);
    }

    private byte[] convertStringToBinaryString(String string) throws KettleValueException {
        if (string == null) {
            return null;
        }
        if (Const.isEmpty(this.stringEncoding)) {
            return string.getBytes();
        }
        try {
            return string.getBytes(this.stringEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new KettleValueException(this.toString() + " : couldn't convert String to Binary with specified string encoding [" + this.stringEncoding + "]", e);
        }
    }

    public Object cloneValueData(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        if (this.storageType == 0) {
            switch (this.getType()) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    return object;
                }
                case 3: {
                    return new Date(((Date)object).getTime());
                }
                case 8: {
                    byte[] origin = (byte[])object;
                    byte[] target = new byte[origin.length];
                    System.arraycopy(origin, 0, target, 0, origin.length);
                    return target;
                }
                case 7: {
                    return object;
                }
            }
            throw new KettleValueException(this.toString() + ": unable to make copy of value type: " + this.getType());
        }
        return object;
    }

    public String getCompatibleString(Object object) throws KettleValueException {
        try {
            String string;
            block1 : switch (this.type) {
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertDateToCompatibleString((Date)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertDateToCompatibleString((Date)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertDateToCompatibleString((Date)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertNumberToCompatibleString((Double)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertNumberToCompatibleString((Double)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertNumberToCompatibleString((Double)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertIntegerToCompatibleString((Long)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertIntegerToCompatibleString((Long)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertIntegerToCompatibleString((Long)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                default: {
                    return this.getString(object);
                }
            }
            return string;
        }
        catch (ClassCastException e) {
            throw new KettleValueException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    public String getString(Object object) throws KettleValueException {
        try {
            String string;
            block1 : switch (this.type) {
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : object.toString();
                            break;
                        }
                        case 1: {
                            string = (String)this.convertBinaryStringToNativeType((byte[])object);
                            break;
                        }
                        case 2: {
                            string = object == null ? null : (String)this.index[(Integer)object];
                            break;
                        }
                        default: {
                            throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                        }
                    }
                    if (string == null) break;
                    string = this.trim(string);
                    break;
                }
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertDateToString((Date)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertDateToString((Date)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertDateToString((Date)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertNumberToString((Double)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertNumberToString((Double)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertNumberToString((Double)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertIntegerToString((Long)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertIntegerToString((Long)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertIntegerToString((Long)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 6: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertBigNumberToString((BigDecimal)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertBigNumberToString((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertBigNumberToString((BigDecimal)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 4: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertBooleanToString((Boolean)object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertBooleanToString((Boolean)this.convertBinaryStringToNativeType((byte[])object));
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertBooleanToString((Boolean)this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 8: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertBinaryStringToString((byte[])this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 7: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : object.toString();
                            break block1;
                        }
                        case 1: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.index[(Integer)object].toString();
                            break block1;
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                default: {
                    throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
                }
            }
            if (this.isOutputPaddingEnabled() && this.getLength() > 0) {
                string = ValueDataUtil.rightPad(string, this.getLength());
            }
            return string;
        }
        catch (ClassCastException e) {
            throw new KettleValueException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    private String trim(String string) {
        switch (this.getTrimType()) {
            case 0: {
                break;
            }
            case 2: {
                string = Const.rtrim(string);
                break;
            }
            case 1: {
                string = Const.ltrim(string);
                break;
            }
            case 3: {
                string = Const.trim(string);
                break;
            }
        }
        return string;
    }

    public Double getNumber(Object object) throws KettleValueException {
        try {
            if (object == null) {
                return null;
            }
            switch (this.type) {
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            return (Double)object;
                        }
                        case 1: {
                            return (Double)this.convertBinaryStringToNativeType((byte[])object);
                        }
                        case 2: {
                            return (Double)this.index[(Integer)object];
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToNumber((String)object);
                        }
                        case 1: {
                            return this.convertStringToNumber((String)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertStringToNumber((String)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertDateToNumber((Date)object);
                        }
                        case 1: {
                            return this.convertDateToNumber((Date)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return new Double(((Date)this.index[(Integer)object]).getTime());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            return new Double(((Long)object).doubleValue());
                        }
                        case 1: {
                            return new Double(((Long)this.convertBinaryStringToNativeType((byte[])object)).doubleValue());
                        }
                        case 2: {
                            return new Double(((Long)this.index[(Integer)object]).doubleValue());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 6: {
                    switch (this.storageType) {
                        case 0: {
                            return new Double(((BigDecimal)object).doubleValue());
                        }
                        case 1: {
                            return new Double(((BigDecimal)this.convertBinaryStringToNativeType((byte[])object)).doubleValue());
                        }
                        case 2: {
                            return new Double(((BigDecimal)this.index[(Integer)object]).doubleValue());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 4: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertBooleanToNumber((Boolean)object);
                        }
                        case 1: {
                            return this.convertBooleanToNumber((Boolean)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertBooleanToNumber((Boolean)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 8: {
                    throw new KettleValueException(this.toString() + " : I don't know how to convert binary values to numbers.");
                }
                case 7: {
                    throw new KettleValueException(this.toString() + " : I don't know how to convert serializable values to numbers.");
                }
            }
            throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
        }
        catch (Exception e) {
            throw new KettleValueException("Unexpected conversion error while converting value [" + this.toString() + "] to a Number", e);
        }
    }

    public Long getInteger(Object object) throws KettleValueException {
        try {
            if (object == null) {
                return null;
            }
            switch (this.type) {
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            return (Long)object;
                        }
                        case 1: {
                            return (Long)this.convertBinaryStringToNativeType((byte[])object);
                        }
                        case 2: {
                            return (Long)this.index[(Integer)object];
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToInteger((String)object);
                        }
                        case 1: {
                            return this.convertStringToInteger((String)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertStringToInteger((String)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            return new Long(Math.round((Double)object));
                        }
                        case 1: {
                            return new Long(Math.round((Double)this.convertBinaryStringToNativeType((byte[])object)));
                        }
                        case 2: {
                            return new Long(Math.round((Double)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertDateToInteger((Date)object);
                        }
                        case 1: {
                            return new Long(((Date)this.convertBinaryStringToNativeType((byte[])object)).getTime());
                        }
                        case 2: {
                            return this.convertDateToInteger((Date)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 6: {
                    switch (this.storageType) {
                        case 0: {
                            return new Long(((BigDecimal)object).longValue());
                        }
                        case 1: {
                            return new Long(((BigDecimal)this.convertBinaryStringToNativeType((byte[])object)).longValue());
                        }
                        case 2: {
                            return new Long(((BigDecimal)this.index[(Integer)object]).longValue());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 4: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertBooleanToInteger((Boolean)object);
                        }
                        case 1: {
                            return this.convertBooleanToInteger((Boolean)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertBooleanToInteger((Boolean)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 8: {
                    throw new KettleValueException(this.toString() + " : I don't know how to convert binary values to integers.");
                }
                case 7: {
                    throw new KettleValueException(this.toString() + " : I don't know how to convert serializable values to integers.");
                }
            }
            throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
        }
        catch (Exception e) {
            throw new KettleValueException("Unexpected conversion error while converting value [" + this.toString() + "] to an Integer", e);
        }
    }

    public BigDecimal getBigNumber(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return (BigDecimal)object;
                    }
                    case 1: {
                        return (BigDecimal)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (BigDecimal)this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToBigNumber((String)object);
                    }
                    case 1: {
                        return this.convertStringToBigNumber((String)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertStringToBigNumber((String)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return BigDecimal.valueOf((Long)object);
                    }
                    case 1: {
                        return BigDecimal.valueOf((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return BigDecimal.valueOf((Long)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return BigDecimal.valueOf((Double)object);
                    }
                    case 1: {
                        return BigDecimal.valueOf((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return BigDecimal.valueOf((Double)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 3: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertDateToBigNumber((Date)object);
                    }
                    case 1: {
                        return this.convertDateToBigNumber((Date)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertDateToBigNumber((Date)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 4: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBooleanToBigNumber((Boolean)object);
                    }
                    case 1: {
                        return this.convertBooleanToBigNumber((Boolean)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBooleanToBigNumber((Boolean)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 8: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert binary values to integers.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert serializable values to integers.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    public Boolean getBoolean(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 4: {
                switch (this.storageType) {
                    case 0: {
                        return (Boolean)object;
                    }
                    case 1: {
                        return (Boolean)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (Boolean)this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return ValueMeta.convertStringToBoolean(this.trim((String)object));
                    }
                    case 1: {
                        return ValueMeta.convertStringToBoolean(this.trim((String)this.convertBinaryStringToNativeType((byte[])object)));
                    }
                    case 2: {
                        return ValueMeta.convertStringToBoolean(this.trim((String)this.index[(Integer)object]));
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertIntegerToBoolean((Long)object);
                    }
                    case 1: {
                        return this.convertIntegerToBoolean((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertIntegerToBoolean((Long)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertNumberToBoolean((Double)object);
                    }
                    case 1: {
                        return this.convertNumberToBoolean((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertNumberToBoolean((Double)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBigNumberToBoolean((BigDecimal)object);
                    }
                    case 1: {
                        return this.convertBigNumberToBoolean((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBigNumberToBoolean((BigDecimal)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 3: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert date values to booleans.");
            }
            case 8: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert binary values to booleans.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert serializable values to booleans.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    public Date getDate(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 3: {
                switch (this.storageType) {
                    case 0: {
                        return (Date)object;
                    }
                    case 1: {
                        return (Date)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (Date)this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToDate((String)object);
                    }
                    case 1: {
                        return this.convertStringToDate((String)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertStringToDate((String)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertNumberToDate((Double)object);
                    }
                    case 1: {
                        return this.convertNumberToDate((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertNumberToDate((Double)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertIntegerToDate((Long)object);
                    }
                    case 1: {
                        return this.convertIntegerToDate((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertIntegerToDate((Long)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBigNumberToDate((BigDecimal)object);
                    }
                    case 1: {
                        return this.convertBigNumberToDate((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBigNumberToDate((BigDecimal)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 4: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a boolean to a date.");
            }
            case 8: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a binary value to date.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a serializable value to date.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    public byte[] getBinary(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 8: {
                switch (this.storageType) {
                    case 0: {
                        return (byte[])object;
                    }
                    case 1: {
                        return (byte[])object;
                    }
                    case 2: {
                        return (byte[])this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 3: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a date to binary.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToBinaryString((String)object);
                    }
                    case 1: {
                        return (byte[])object;
                    }
                    case 2: {
                        return this.convertStringToBinaryString((String)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a number to binary.");
            }
            case 5: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert an integer to binary.");
            }
            case 6: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a bignumber to binary.");
            }
            case 4: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a boolean to binary.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a serializable to binary.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    public byte[] getBinaryString(Object object) throws KettleValueException {
        if (this.isStorageBinaryString() && this.identicalFormat) {
            return (byte[])object;
        }
        try {
            if (object == null) {
                return null;
            }
            switch (this.type) {
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString((String)object);
                        }
                        case 1: {
                            return this.convertStringToBinaryString((String)this.convertBinaryStringToNativeType((byte[])object));
                        }
                        case 2: {
                            return this.convertStringToBinaryString((String)this.index[(Integer)object]);
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 3: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertDateToString((Date)object));
                        }
                        case 1: {
                            return this.convertStringToBinaryString(this.convertDateToString((Date)this.convertBinaryStringToNativeType((byte[])object)));
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertDateToString((Date)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 1: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertNumberToString((Double)object));
                        }
                        case 1: {
                            return this.convertStringToBinaryString(this.convertNumberToString((Double)this.convertBinaryStringToNativeType((byte[])object)));
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertNumberToString((Double)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 5: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertIntegerToString((Long)object));
                        }
                        case 1: {
                            return this.convertStringToBinaryString(this.convertIntegerToString((Long)this.convertBinaryStringToNativeType((byte[])object)));
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertIntegerToString((Long)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 6: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertBigNumberToString((BigDecimal)object));
                        }
                        case 1: {
                            return this.convertStringToBinaryString(this.convertBigNumberToString((BigDecimal)this.convertBinaryStringToNativeType((byte[])object)));
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertBigNumberToString((BigDecimal)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 4: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(this.convertBooleanToString((Boolean)object));
                        }
                        case 1: {
                            return this.convertStringToBinaryString(this.convertBooleanToString((Boolean)this.convertBinaryStringToNativeType((byte[])object)));
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.convertBooleanToString((Boolean)this.index[(Integer)object]));
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 8: {
                    switch (this.storageType) {
                        case 0: {
                            return (byte[])object;
                        }
                        case 1: {
                            return (byte[])object;
                        }
                        case 2: {
                            return (byte[])this.index[(Integer)object];
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 7: {
                    switch (this.storageType) {
                        case 0: {
                            return this.convertStringToBinaryString(object.toString());
                        }
                        case 1: {
                            return (byte[])object;
                        }
                        case 2: {
                            return this.convertStringToBinaryString(this.index[(Integer)object].toString());
                        }
                    }
                    throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
            }
            throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
        }
        catch (ClassCastException e) {
            throw new KettleValueException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    public boolean isString() {
        return this.type == 2;
    }

    public boolean isDate() {
        return this.type == 3;
    }

    public boolean isBigNumber() {
        return this.type == 6;
    }

    public boolean isNumber() {
        return this.type == 1;
    }

    public boolean isBoolean() {
        return this.type == 4;
    }

    public boolean isSerializableType() {
        return this.type == 7;
    }

    public boolean isBinary() {
        return this.type == 8;
    }

    public boolean isInteger() {
        return this.type == 5;
    }

    public boolean isNumeric() {
        return this.isInteger() || this.isNumber() || this.isBigNumber();
    }

    public static final boolean isNumeric(int t) {
        return t == 5 || t == 1 || t == 6;
    }

    public boolean isSortedAscending() {
        return !this.isSortedDescending();
    }

    public String getTypeDesc() {
        return typeCodes[this.type];
    }

    public String getStorageTypeDesc() {
        return storageTypeCodes[this.storageType];
    }

    public String toString() {
        return this.name + " " + this.toStringMeta();
    }

    public String toStringMeta() {
        StringBuffer retval = new StringBuffer(this.getTypeDesc());
        switch (this.getType()) {
            case 2: {
                if (this.getLength() <= 0) break;
                retval.append('(').append(this.getLength()).append(')');
                break;
            }
            case 1: 
            case 6: {
                if (this.getLength() <= 0) break;
                retval.append('(').append(this.getLength());
                if (this.getPrecision() > 0) {
                    retval.append(", ").append(this.getPrecision());
                }
                retval.append(')');
                break;
            }
            case 5: {
                if (this.getLength() <= 0) break;
                retval.append('(').append(this.getLength()).append(')');
                break;
            }
        }
        if (!this.isStorageNormal()) {
            retval.append("<").append(this.getStorageTypeDesc()).append(">");
        }
        return retval.toString();
    }

    public void writeData(DataOutputStream outputStream, Object object) throws KettleFileException {
        try {
            outputStream.writeBoolean(object == null);
            if (object != null) {
                block1 : switch (this.storageType) {
                    case 0: {
                        switch (this.getType()) {
                            case 2: {
                                this.writeString(outputStream, (String)object);
                                break block1;
                            }
                            case 1: {
                                this.writeNumber(outputStream, (Double)object);
                                break block1;
                            }
                            case 5: {
                                this.writeInteger(outputStream, (Long)object);
                                break block1;
                            }
                            case 3: {
                                this.writeDate(outputStream, (Date)object);
                                break block1;
                            }
                            case 6: {
                                this.writeBigNumber(outputStream, (BigDecimal)object);
                                break block1;
                            }
                            case 4: {
                                this.writeBoolean(outputStream, (Boolean)object);
                                break block1;
                            }
                            case 8: {
                                this.writeBinary(outputStream, (byte[])object);
                                break block1;
                            }
                        }
                        throw new KettleFileException(this.toString() + " : Unable to serialize data type " + this.getType());
                    }
                    case 1: {
                        this.writeBinaryString(outputStream, (byte[])object);
                        break;
                    }
                    case 2: {
                        this.writeInteger(outputStream, (Integer)object);
                        break;
                    }
                    default: {
                        throw new KettleFileException(this.toString() + " : Unknown storage type " + this.getStorageType());
                    }
                }
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to write value data to output stream", e);
        }
    }

    public Object readData(DataInputStream inputStream) throws KettleFileException, KettleEOFException, SocketTimeoutException {
        try {
            if (inputStream.readBoolean()) {
                return null;
            }
            switch (this.storageType) {
                case 0: {
                    switch (this.getType()) {
                        case 2: {
                            return this.readString(inputStream);
                        }
                        case 1: {
                            return this.readNumber(inputStream);
                        }
                        case 5: {
                            return this.readInteger(inputStream);
                        }
                        case 3: {
                            return this.readDate(inputStream);
                        }
                        case 6: {
                            return this.readBigNumber(inputStream);
                        }
                        case 4: {
                            return this.readBoolean(inputStream);
                        }
                        case 8: {
                            return this.readBinary(inputStream);
                        }
                    }
                    throw new KettleFileException(this.toString() + " : Unable to de-serialize data of type " + this.getType());
                }
                case 1: {
                    return this.readBinaryString(inputStream);
                }
                case 2: {
                    return this.readSmallInteger(inputStream);
                }
            }
            throw new KettleFileException(this.toString() + " : Unknown storage type " + this.getStorageType());
        }
        catch (EOFException e) {
            throw new KettleEOFException(e);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to read value data from input stream", e);
        }
    }

    private void writeString(DataOutputStream outputStream, String string) throws IOException {
        if (string == null) {
            outputStream.writeInt(-1);
        } else {
            byte[] chars = string.getBytes("UTF-8");
            outputStream.writeInt(chars.length);
            outputStream.write(chars);
        }
    }

    private void writeBinaryString(DataOutputStream outputStream, byte[] binaryString) throws IOException {
        if (binaryString == null) {
            outputStream.writeInt(-1);
        } else {
            outputStream.writeInt(binaryString.length);
            outputStream.write(binaryString);
        }
    }

    private String readString(DataInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        if (length < 0) {
            return null;
        }
        byte[] chars = new byte[length];
        inputStream.readFully(chars);
        String string = new String(chars, "UTF-8");
        return string;
    }

    private byte[] readBinaryString(DataInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        if (length < 0) {
            return null;
        }
        byte[] chars = new byte[length];
        inputStream.readFully(chars);
        return chars;
    }

    private void writeBigNumber(DataOutputStream outputStream, BigDecimal number) throws IOException {
        String string = number.toString();
        this.writeString(outputStream, string);
    }

    private BigDecimal readBigNumber(DataInputStream inputStream) throws IOException {
        String string = this.readString(inputStream);
        return new BigDecimal(string);
    }

    private void writeDate(DataOutputStream outputStream, Date date) throws IOException {
        outputStream.writeLong(date.getTime());
    }

    private Date readDate(DataInputStream inputStream) throws IOException {
        long time = inputStream.readLong();
        return new Date(time);
    }

    private void writeBoolean(DataOutputStream outputStream, Boolean bool) throws IOException {
        outputStream.writeBoolean(bool);
    }

    private Boolean readBoolean(DataInputStream inputStream) throws IOException {
        Boolean bool = inputStream.readBoolean();
        return bool;
    }

    private void writeNumber(DataOutputStream outputStream, Double number) throws IOException {
        outputStream.writeDouble(number);
    }

    private Double readNumber(DataInputStream inputStream) throws IOException {
        Double d = new Double(inputStream.readDouble());
        return d;
    }

    private void writeInteger(DataOutputStream outputStream, Long number) throws IOException {
        outputStream.writeLong(number);
    }

    private Long readInteger(DataInputStream inputStream) throws IOException {
        Long l = new Long(inputStream.readLong());
        return l;
    }

    private void writeInteger(DataOutputStream outputStream, Integer number) throws IOException {
        outputStream.writeInt(number);
    }

    private Integer readSmallInteger(DataInputStream inputStream) throws IOException {
        Integer i = inputStream.readInt();
        return i;
    }

    private void writeBinary(DataOutputStream outputStream, byte[] binary) throws IOException {
        outputStream.writeInt(binary.length);
        outputStream.write(binary);
    }

    private byte[] readBinary(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        byte[] buffer = new byte[size];
        inputStream.readFully(buffer);
        return buffer;
    }

    public void writeMeta(DataOutputStream outputStream) throws KettleFileException {
        try {
            int type = this.getType();
            outputStream.writeInt(type);
            outputStream.writeInt(this.storageType);
            switch (this.storageType) {
                case 2: {
                    if (this.index == null) {
                        outputStream.writeInt(-1);
                        break;
                    }
                    outputStream.writeInt(this.index.length);
                    for (int i = 0; i < this.index.length; ++i) {
                        try {
                            switch (type) {
                                case 2: {
                                    this.writeString(outputStream, (String)this.index[i]);
                                    break;
                                }
                                case 1: {
                                    this.writeNumber(outputStream, (Double)this.index[i]);
                                    break;
                                }
                                case 5: {
                                    this.writeInteger(outputStream, (Long)this.index[i]);
                                    break;
                                }
                                case 3: {
                                    this.writeDate(outputStream, (Date)this.index[i]);
                                    break;
                                }
                                case 6: {
                                    this.writeBigNumber(outputStream, (BigDecimal)this.index[i]);
                                    break;
                                }
                                case 4: {
                                    this.writeBoolean(outputStream, (Boolean)this.index[i]);
                                    break;
                                }
                                case 8: {
                                    this.writeBinary(outputStream, (byte[])this.index[i]);
                                    break;
                                }
                                default: {
                                    throw new KettleFileException(this.toString() + " : Unable to serialize indexe storage type for data type " + this.getType());
                                }
                            }
                            continue;
                        }
                        catch (ClassCastException e) {
                            throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + this.index[i].getClass().getName() + " object [" + this.index[i] + "] does not correspond to value meta [" + this.toStringMeta() + "]");
                        }
                    }
                    break;
                }
                case 1: {
                    outputStream.writeBoolean(this.storageMetadata != null);
                    if (this.storageMetadata == null) break;
                    this.storageMetadata.writeMeta(outputStream);
                    break;
                }
            }
            this.writeString(outputStream, this.name);
            outputStream.writeInt(this.getLength());
            outputStream.writeInt(this.getPrecision());
            this.writeString(outputStream, this.origin);
            this.writeString(outputStream, this.comments);
            this.writeString(outputStream, this.conversionMask);
            this.writeString(outputStream, this.decimalSymbol);
            this.writeString(outputStream, this.groupingSymbol);
            this.writeString(outputStream, this.currencySymbol);
            outputStream.writeInt(this.trimType);
            outputStream.writeBoolean(this.caseInsensitive);
            outputStream.writeBoolean(this.sortedDescending);
            outputStream.writeBoolean(this.outputPaddingEnabled);
            outputStream.writeBoolean(this.dateFormatLenient);
            this.writeString(outputStream, this.dateFormatLocale != null ? this.dateFormatLocale.toString() : null);
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to write value metadata to output stream", e);
        }
    }

    public ValueMeta(DataInputStream inputStream) throws KettleFileException, KettleEOFException {
        this();
        try {
            this.type = inputStream.readInt();
            this.storageType = inputStream.readInt();
            switch (this.storageType) {
                case 2: {
                    int indexSize = inputStream.readInt();
                    if (indexSize < 0) {
                        this.index = null;
                        break;
                    }
                    this.index = new Object[indexSize];
                    block16: for (int i = 0; i < indexSize; ++i) {
                        switch (this.type) {
                            case 2: {
                                this.index[i] = this.readString(inputStream);
                                continue block16;
                            }
                            case 1: {
                                this.index[i] = this.readNumber(inputStream);
                                continue block16;
                            }
                            case 5: {
                                this.index[i] = this.readInteger(inputStream);
                                continue block16;
                            }
                            case 3: {
                                this.index[i] = this.readDate(inputStream);
                                continue block16;
                            }
                            case 6: {
                                this.index[i] = this.readBigNumber(inputStream);
                                continue block16;
                            }
                            case 4: {
                                this.index[i] = this.readBoolean(inputStream);
                                continue block16;
                            }
                            case 8: {
                                this.index[i] = this.readBinary(inputStream);
                                continue block16;
                            }
                            default: {
                                throw new KettleFileException(this.toString() + " : Unable to de-serialize indexed storage type for data type " + this.getType());
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    if (!inputStream.readBoolean()) break;
                    this.storageMetadata = new ValueMeta(inputStream);
                    break;
                }
            }
            this.name = this.readString(inputStream);
            this.length = inputStream.readInt();
            this.precision = inputStream.readInt();
            this.origin = this.readString(inputStream);
            this.comments = this.readString(inputStream);
            this.conversionMask = this.readString(inputStream);
            this.decimalSymbol = this.readString(inputStream);
            this.groupingSymbol = this.readString(inputStream);
            this.currencySymbol = this.readString(inputStream);
            this.trimType = inputStream.readInt();
            this.caseInsensitive = inputStream.readBoolean();
            this.sortedDescending = inputStream.readBoolean();
            this.outputPaddingEnabled = inputStream.readBoolean();
            this.dateFormatLenient = inputStream.readBoolean();
            String strDateFormatLocale = this.readString(inputStream);
            this.dateFormatLocale = Const.isEmpty(strDateFormatLocale) ? null : EnvUtil.createLocale(strDateFormatLocale);
        }
        catch (EOFException e) {
            throw new KettleEOFException(e);
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to read value metadata from input stream", e);
        }
    }

    public String getMetaXML() throws IOException {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLHandler.openTag(XML_META_TAG));
        xml.append(XMLHandler.addTagValue("type", this.getTypeDesc()));
        xml.append(XMLHandler.addTagValue("storagetype", ValueMeta.getStorageTypeCode(this.getStorageType())));
        switch (this.storageType) {
            case 2: {
                xml.append(XMLHandler.openTag("index"));
                if (this.index != null) {
                    for (int i = 0; i < this.index.length; ++i) {
                        try {
                            switch (this.type) {
                                case 2: {
                                    xml.append(XMLHandler.addTagValue("value", (String)this.index[i]));
                                    break;
                                }
                                case 1: {
                                    xml.append(XMLHandler.addTagValue("value", (Double)this.index[i]));
                                    break;
                                }
                                case 5: {
                                    xml.append(XMLHandler.addTagValue("value", (Long)this.index[i]));
                                    break;
                                }
                                case 3: {
                                    xml.append(XMLHandler.addTagValue("value", (Date)this.index[i]));
                                    break;
                                }
                                case 6: {
                                    xml.append(XMLHandler.addTagValue("value", (BigDecimal)this.index[i]));
                                    break;
                                }
                                case 4: {
                                    xml.append(XMLHandler.addTagValue("value", (boolean)((Boolean)this.index[i])));
                                    break;
                                }
                                case 8: {
                                    xml.append(XMLHandler.addTagValue("value", (byte[])this.index[i]));
                                    break;
                                }
                                default: {
                                    throw new IOException(this.toString() + " : Unable to serialize indexe storage type to XML for data type " + this.getType());
                                }
                            }
                            continue;
                        }
                        catch (ClassCastException e) {
                            throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + this.index[i].getClass().getName() + " object [" + this.index[i] + "] does not correspond to value meta [" + this.toStringMeta() + "]");
                        }
                    }
                }
                xml.append(XMLHandler.closeTag("index"));
                break;
            }
            case 1: {
                if (this.storageMetadata == null) break;
                xml.append(XMLHandler.openTag("storage-meta"));
                xml.append(this.storageMetadata.getMetaXML());
                xml.append(XMLHandler.closeTag("storage-meta"));
                break;
            }
        }
        xml.append(XMLHandler.addTagValue("name", this.name));
        xml.append(XMLHandler.addTagValue("length", this.length));
        xml.append(XMLHandler.addTagValue("precision", this.precision));
        xml.append(XMLHandler.addTagValue("origin", this.origin));
        xml.append(XMLHandler.addTagValue("comments", this.comments));
        xml.append(XMLHandler.addTagValue("conversion_Mask", this.conversionMask));
        xml.append(XMLHandler.addTagValue("decimal_symbol", this.decimalSymbol));
        xml.append(XMLHandler.addTagValue("grouping_symbol", this.groupingSymbol));
        xml.append(XMLHandler.addTagValue("currency_symbol", this.currencySymbol));
        xml.append(XMLHandler.addTagValue("trim_type", ValueMeta.getTrimTypeCode(this.trimType)));
        xml.append(XMLHandler.addTagValue("case_insensitive", this.caseInsensitive));
        xml.append(XMLHandler.addTagValue("sort_descending", this.sortedDescending));
        xml.append(XMLHandler.addTagValue("output_padding", this.outputPaddingEnabled));
        xml.append(XMLHandler.addTagValue("date_format_lenient", this.dateFormatLenient));
        xml.append(XMLHandler.addTagValue("date_format_locale", this.dateFormatLocale.toString()));
        xml.append(XMLHandler.closeTag(XML_META_TAG));
        return xml.toString();
    }

    public ValueMeta(Node node) throws KettleException {
        this();
        this.type = ValueMeta.getType(XMLHandler.getTagValue(node, "type"));
        this.storageType = ValueMeta.getStorageType(XMLHandler.getTagValue(node, "storagetype"));
        switch (this.storageType) {
            case 2: {
                Node indexNode = XMLHandler.getSubNode(node, "index");
                int nrIndexes = XMLHandler.countNodes(indexNode, "value");
                this.index = new Object[nrIndexes];
                block13: for (int i = 0; i < this.index.length; ++i) {
                    Node valueNode = XMLHandler.getSubNodeByNr(indexNode, "value", i);
                    String valueString = XMLHandler.getNodeValue(valueNode);
                    if (Const.isEmpty(valueString)) {
                        this.index[i] = null;
                        continue;
                    }
                    switch (this.type) {
                        case 2: {
                            this.index[i] = valueString;
                            continue block13;
                        }
                        case 1: {
                            this.index[i] = Double.parseDouble(valueString);
                            continue block13;
                        }
                        case 5: {
                            this.index[i] = Long.parseLong(valueString);
                            continue block13;
                        }
                        case 3: {
                            this.index[i] = XMLHandler.stringToDate(valueString);
                            continue block13;
                        }
                        case 6: {
                            this.index[i] = new BigDecimal(valueString);
                            continue block13;
                        }
                        case 4: {
                            this.index[i] = "Y".equalsIgnoreCase(valueString);
                            continue block13;
                        }
                        case 8: {
                            this.index[i] = XMLHandler.stringToBinary(valueString);
                            continue block13;
                        }
                        default: {
                            throw new KettleException(this.toString() + " : Unable to de-serialize indexe storage type from XML for data type " + this.getType());
                        }
                    }
                }
                break;
            }
            case 1: {
                Node storageMetaNode = XMLHandler.getSubNode(node, "storage-meta");
                Node storageValueMetaNode = XMLHandler.getSubNode(storageMetaNode, XML_META_TAG);
                if (storageValueMetaNode == null) break;
                this.storageMetadata = new ValueMeta(storageValueMetaNode);
                break;
            }
        }
        this.name = XMLHandler.getTagValue(node, "name");
        this.length = Integer.parseInt(XMLHandler.getTagValue(node, "length"));
        this.precision = Integer.parseInt(XMLHandler.getTagValue(node, "precision"));
        this.origin = XMLHandler.getTagValue(node, "origin");
        this.comments = XMLHandler.getTagValue(node, "comments");
        this.conversionMask = XMLHandler.getTagValue(node, "conversion_Mask");
        this.decimalSymbol = XMLHandler.getTagValue(node, "decimal_symbol");
        this.groupingSymbol = XMLHandler.getTagValue(node, "grouping_symbol");
        this.currencySymbol = XMLHandler.getTagValue(node, "currency_symbol");
        this.trimType = ValueMeta.getTrimTypeByCode(XMLHandler.getTagValue(node, "trim_type"));
        this.caseInsensitive = "Y".equalsIgnoreCase(XMLHandler.getTagValue(node, "case_insensitive"));
        this.sortedDescending = "Y".equalsIgnoreCase(XMLHandler.getTagValue(node, "sort_descending"));
        this.outputPaddingEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue(node, "output_padding"));
        this.dateFormatLenient = "Y".equalsIgnoreCase(XMLHandler.getTagValue(node, "date_format_lenient"));
        String dateFormatLocaleString = XMLHandler.getTagValue(node, "date_format_locale");
        if (!Const.isEmpty(dateFormatLocaleString)) {
            this.dateFormatLocale = EnvUtil.createLocale(dateFormatLocaleString);
        }
    }

    public String getDataXML(Object object) throws IOException {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLHandler.openTag(XML_DATA_TAG));
        if (object != null) {
            try {
                block1 : switch (this.storageType) {
                    case 0: {
                        switch (this.getType()) {
                            case 2: {
                                xml.append((String)object);
                                break block1;
                            }
                            case 1: {
                                xml.append((Double)object);
                                break block1;
                            }
                            case 5: {
                                xml.append((Long)object);
                                break block1;
                            }
                            case 3: {
                                xml.append(XMLHandler.date2string((Date)object));
                                break block1;
                            }
                            case 6: {
                                xml.append((BigDecimal)object);
                                break block1;
                            }
                            case 4: {
                                xml.append((Boolean)object);
                                break block1;
                            }
                            case 8: {
                                xml.append(XMLHandler.addTagValue("binary-value", (byte[])object));
                                break block1;
                            }
                        }
                        throw new IOException(this.toString() + " : Unable to serialize data type to XML " + this.getType());
                    }
                    case 1: {
                        xml.append(XMLHandler.addTagValue("binary-string", (byte[])object));
                        break;
                    }
                    case 2: {
                        xml.append(XMLHandler.addTagValue("index-value", (int)((Integer)object)));
                        break;
                    }
                    default: {
                        throw new IOException(this.toString() + " : Unknown storage type " + this.getStorageType());
                    }
                }
            }
            catch (ClassCastException e) {
                throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
            }
        }
        xml.append(XMLHandler.closeTag(XML_DATA_TAG));
        return xml.toString();
    }

    public Object getValue(Node node) throws KettleException {
        switch (this.storageType) {
            case 0: {
                String valueString = XMLHandler.getNodeValue(node);
                if (Const.isEmpty(valueString)) {
                    return null;
                }
                switch (this.getType()) {
                    case 2: {
                        return valueString;
                    }
                    case 1: {
                        return Double.parseDouble(valueString);
                    }
                    case 5: {
                        return Long.parseLong(valueString);
                    }
                    case 3: {
                        return XMLHandler.stringToDate(valueString);
                    }
                    case 6: {
                        return new BigDecimal(valueString);
                    }
                    case 4: {
                        return "Y".equalsIgnoreCase(valueString);
                    }
                    case 8: {
                        return XMLHandler.stringToBinary(XMLHandler.getTagValue(node, "binary-value"));
                    }
                }
                throw new KettleException(this.toString() + " : Unable to de-serialize '" + valueString + "' from XML for data type " + this.getType());
            }
            case 1: {
                String binaryString = XMLHandler.getTagValue(node, "binary-string");
                if (Const.isEmpty(binaryString)) {
                    return null;
                }
                return XMLHandler.stringToBinary(binaryString);
            }
            case 2: {
                String indexString = XMLHandler.getTagValue(node, "index-value");
                if (Const.isEmpty(indexString)) {
                    return null;
                }
                return Integer.parseInt(indexString);
            }
        }
        throw new KettleException(this.toString() + " : Unknown storage type " + this.getStorageType());
    }

    public static final String[] getTypes() {
        String[] retval = new String[typeCodes.length - 1];
        System.arraycopy(typeCodes, 1, retval, 0, typeCodes.length - 1);
        return retval;
    }

    public static final String[] getAllTypes() {
        String[] retval = new String[typeCodes.length];
        System.arraycopy(typeCodes, 0, retval, 0, typeCodes.length);
        return retval;
    }

    public static final String getTypeDesc(int type) {
        return typeCodes[type];
    }

    public static final int getType(String desc) {
        for (int i = 1; i < typeCodes.length; ++i) {
            if (!typeCodes[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final int getStorageType(String desc) {
        for (int i = 0; i < storageTypeCodes.length; ++i) {
            if (!storageTypeCodes[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return -1;
    }

    public static final String getStorageTypeCode(int storageType) {
        if (storageType >= 0 && storageType <= 2) {
            return storageTypeCodes[storageType];
        }
        return null;
    }

    public boolean isNull(Object data) throws KettleValueException {
        try {
            Object value = data;
            if (this.isStorageBinaryString()) {
                if (value == null || !EMPTY_STRING_AND_NULL_ARE_DIFFERENT && ((byte[])value).length == 0) {
                    return true;
                }
                value = this.convertBinaryStringToNativeType((byte[])data);
            }
            if (value == null) {
                return true;
            }
            if (EMPTY_STRING_AND_NULL_ARE_DIFFERENT) {
                return false;
            }
            return this.isString() && value.toString().length() == 0;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unable to verify if [" + this.toString() + "] is null or not because of an error:" + e.toString(), e);
        }
    }

    public int compare(Object data1, Object data2) throws KettleValueException {
        boolean n1 = this.isNull(data1);
        boolean n2 = this.isNull(data2);
        if (n1 && !n2) {
            return -1;
        }
        if (!n1 && n2) {
            return 1;
        }
        if (n1 && n2) {
            return 0;
        }
        int cmp = 0;
        switch (this.getType()) {
            case 2: {
                String one = this.getString(data1);
                String two = this.getString(data2);
                if (this.caseInsensitive) {
                    cmp = one.compareToIgnoreCase(two);
                    break;
                }
                cmp = one.compareTo(two);
                break;
            }
            case 5: {
                long compare = this.getInteger(data1) - this.getInteger(data2);
                if (compare < 0L) {
                    cmp = -1;
                    break;
                }
                if (compare > 0L) {
                    cmp = 1;
                    break;
                }
                cmp = 0;
                break;
            }
            case 1: {
                cmp = Double.compare(this.getNumber(data1), this.getNumber(data2));
                break;
            }
            case 3: {
                long compare = this.getDate(data1).getTime() - this.getDate(data2).getTime();
                if (compare < 0L) {
                    cmp = -1;
                    break;
                }
                if (compare > 0L) {
                    cmp = 1;
                    break;
                }
                cmp = 0;
                break;
            }
            case 6: {
                cmp = this.getBigNumber(data1).compareTo(this.getBigNumber(data2));
                break;
            }
            case 4: {
                if (this.getBoolean(data1).booleanValue() == this.getBoolean(data2).booleanValue()) {
                    cmp = 0;
                    break;
                }
                if (this.getBoolean(data1).booleanValue() && !this.getBoolean(data2).booleanValue()) {
                    cmp = 1;
                    break;
                }
                cmp = -1;
                break;
            }
            case 8: {
                byte[] b1 = (byte[])data1;
                byte[] b2 = (byte[])data2;
                int length = b1.length < b2.length ? b1.length : b2.length;
                for (int i = 0; i < length; ++i) {
                    cmp = b1[i] - b2[i];
                    if (cmp == 0) continue;
                    cmp = cmp < 0 ? -1 : 1;
                    break;
                }
                cmp = b1.length - b2.length;
                break;
            }
            default: {
                throw new KettleValueException(this.toString() + " : Comparing values can not be done with data type : " + this.getType());
            }
        }
        if (this.isSortedDescending()) {
            return -cmp;
        }
        return cmp;
    }

    public int compare(Object data1, ValueMetaInterface meta2, Object data2) throws KettleValueException {
        if (meta2 == null) {
            throw new KettleValueException(this.toStringMeta() + " : Second meta data (meta2) is null, please check one of the previous steps.");
        }
        try {
            if (this.getType() == meta2.getType()) {
                if (this.getStorageType() == meta2.getStorageType()) {
                    return this.compare(data1, data2);
                }
                switch (this.getStorageType()) {
                    case 0: {
                        return this.compare(data1, meta2.convertToNormalStorageType(data2));
                    }
                    case 1: {
                        return this.compare(data1, meta2.convertToBinaryStringStorageType(data2));
                    }
                    case 2: {
                        switch (meta2.getStorageType()) {
                            case 2: {
                                return this.compare(data1, data2);
                            }
                            case 0: {
                                return -meta2.compare(data2, this.convertToNormalStorageType(data1));
                            }
                            case 1: {
                                return -meta2.compare(data2, this.convertToBinaryStringStorageType(data1));
                            }
                        }
                        throw new KettleValueException(meta2.toStringMeta() + " : Unknown storage type : " + meta2.getStorageType());
                    }
                }
                throw new KettleValueException(this.toStringMeta() + " : Unknown storage type : " + this.getStorageType());
            }
            return this.compare(data1, this.convertData(meta2, data2));
        }
        catch (Exception e) {
            throw new KettleValueException(this.toStringMeta() + " : Unable to compare with value [" + meta2.toStringMeta() + "]", e);
        }
    }

    public Object convertData(ValueMetaInterface meta2, Object data2) throws KettleValueException {
        switch (this.getType()) {
            case 2: {
                return meta2.getString(data2);
            }
            case 1: {
                return meta2.getNumber(data2);
            }
            case 5: {
                return meta2.getInteger(data2);
            }
            case 3: {
                return meta2.getDate(data2);
            }
            case 6: {
                return meta2.getBigNumber(data2);
            }
            case 4: {
                return meta2.getBoolean(data2);
            }
            case 8: {
                return meta2.getBinary(data2);
            }
        }
        throw new KettleValueException(this.toString() + " : I can't convert the specified value to data type : " + this.getType());
    }

    public Object convertDataCompatible(ValueMetaInterface meta2, Object data2) throws KettleValueException {
        switch (this.getType()) {
            case 2: {
                return meta2.getCompatibleString(data2);
            }
            case 1: {
                return meta2.getNumber(data2);
            }
            case 5: {
                return meta2.getInteger(data2);
            }
            case 3: {
                return meta2.getDate(data2);
            }
            case 6: {
                return meta2.getBigNumber(data2);
            }
            case 4: {
                return meta2.getBoolean(data2);
            }
            case 8: {
                return meta2.getBinary(data2);
            }
        }
        throw new KettleValueException(this.toString() + " : I can't convert the specified value to data type : " + this.getType());
    }

    public Object convertDataUsingConversionMetaData(Object data2) throws KettleValueException {
        if (this.conversionMetadata == null) {
            throw new KettleValueException("API coding error: please specify the conversion metadata before attempting to convert value " + this.name);
        }
        switch (this.conversionMetadata.getType()) {
            case 2: {
                return this.getString(data2);
            }
            case 5: {
                return this.getInteger(data2);
            }
            case 1: {
                return this.getNumber(data2);
            }
            case 3: {
                return this.getDate(data2);
            }
            case 6: {
                return this.getBigNumber(data2);
            }
            case 4: {
                return this.getBoolean(data2);
            }
            case 8: {
                return this.getBinary(data2);
            }
        }
        throw new KettleValueException(this.toString() + " : I can't convert the specified value to data type : " + this.storageMetadata.getType());
    }

    public Object convertDataFromString(String pol, ValueMetaInterface convertMeta, String nullIf, String ifNull, int trim_type) throws KettleValueException {
        String null_value = nullIf;
        if (null_value == null) {
            switch (convertMeta.getType()) {
                case 4: {
                    null_value = "";
                    break;
                }
                case 2: {
                    null_value = "";
                    break;
                }
                case 6: {
                    null_value = "";
                    break;
                }
                case 1: {
                    null_value = "";
                    break;
                }
                case 5: {
                    null_value = "";
                    break;
                }
                case 3: {
                    null_value = "";
                    break;
                }
                case 8: {
                    null_value = "";
                    break;
                }
                default: {
                    null_value = "";
                }
            }
        }
        if (!Const.isEmpty(ifNull) && (Const.isEmpty(pol) || pol.equalsIgnoreCase(Const.rightPad(new StringBuffer(null_value), pol.length())))) {
            pol = ifNull;
        }
        if (Const.isEmpty(pol)) {
            return null;
        }
        if (!Const.isEmpty(null_value) ? null_value.length() <= pol.length() && pol.equalsIgnoreCase(Const.rightPad(new StringBuffer(null_value), pol.length())) : Const.onlySpaces(pol)) {
            return null;
        }
        switch (trim_type) {
            case 1: {
                StringBuffer strpol = new StringBuffer(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                pol = strpol.toString();
                break;
            }
            case 2: {
                StringBuffer strpol = new StringBuffer(pol);
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
            case 3: {
                StringBuffer strpol = new StringBuffer(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
        }
        return this.convertData(convertMeta, pol);
    }

    public int hashCode(Object object) throws KettleValueException {
        int hash = 0;
        if (this.isNull(object)) {
            switch (this.getType()) {
                case 4: {
                    hash ^= 1;
                    break;
                }
                case 3: {
                    hash ^= 2;
                    break;
                }
                case 1: {
                    hash ^= 4;
                    break;
                }
                case 2: {
                    hash ^= 8;
                    break;
                }
                case 5: {
                    hash ^= 0x10;
                    break;
                }
                case 6: {
                    hash ^= 0x20;
                    break;
                }
                case 0: {
                    break;
                }
            }
        } else {
            switch (this.getType()) {
                case 4: {
                    hash ^= this.getBoolean(object).hashCode();
                    break;
                }
                case 3: {
                    hash ^= this.getDate(object).hashCode();
                    break;
                }
                case 5: {
                    hash ^= this.getInteger(object).hashCode();
                    break;
                }
                case 1: {
                    hash ^= this.getNumber(object).hashCode();
                    break;
                }
                case 2: {
                    hash ^= this.getString(object).hashCode();
                    break;
                }
                case 6: {
                    hash ^= this.getBigNumber(object).hashCode();
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
        return hash;
    }

    public Value createOriginalValue(Object data) throws KettleValueException {
        Value value = new Value(this.name, this.type);
        value.setLength(this.length, this.precision);
        if (this.isNull(data)) {
            value.setNull();
        } else {
            switch (value.getType()) {
                case 2: {
                    value.setValue(this.getString(data));
                    break;
                }
                case 1: {
                    value.setValue(this.getNumber(data));
                    break;
                }
                case 5: {
                    value.setValue(this.getInteger(data));
                    break;
                }
                case 3: {
                    value.setValue(this.getDate(data));
                    break;
                }
                case 4: {
                    value.setValue((boolean)this.getBoolean(data));
                    break;
                }
                case 6: {
                    value.setValue(this.getBigNumber(data));
                    break;
                }
                case 8: {
                    value.setValue(this.getBinary(data));
                    break;
                }
                default: {
                    throw new KettleValueException(this.toString() + " : We can't convert data type " + this.getTypeDesc() + " to an original (V2) Value");
                }
            }
        }
        return value;
    }

    public Object getValueData(Value value) throws KettleValueException {
        if (value == null || value.isNull()) {
            return null;
        }
        switch (this.getType()) {
            case 2: {
                return value.getString();
            }
            case 1: {
                return value.getNumber();
            }
            case 5: {
                return value.getInteger();
            }
            case 3: {
                return value.getDate();
            }
            case 4: {
                return value.getBoolean();
            }
            case 6: {
                return value.getBigNumber();
            }
            case 8: {
                return value.getBytes();
            }
        }
        throw new KettleValueException(this.toString() + " : We can't convert original data type " + value.getTypeDesc() + " to a primitive data type");
    }

    public ValueMetaInterface getStorageMetadata() {
        return this.storageMetadata;
    }

    public void setStorageMetadata(ValueMetaInterface storageMetadata) {
        this.storageMetadata = storageMetadata;
        this.compareStorageAndActualFormat();
    }

    private void compareStorageAndActualFormat() {
        if (this.storageMetadata == null) {
            this.identicalFormat = true;
        } else if (this.trimType != 0) {
            this.identicalFormat = false;
        } else if (this.getStringEncoding() != null && this.getStringEncoding().equals(this.storageMetadata.getStringEncoding()) || this.getStringEncoding() == null && this.storageMetadata.getStringEncoding() == null) {
            if (this.isDate()) {
                this.identicalFormat = this.getConversionMask() != null && this.getConversionMask().equals(this.storageMetadata.getConversionMask()) || this.getConversionMask() == null && this.storageMetadata.getConversionMask() == null;
            } else if (this.isNumeric()) {
                this.identicalFormat = this.getLength() != this.storageMetadata.getLength() ? false : (this.getPrecision() != this.storageMetadata.getPrecision() ? false : (this.getConversionMask() != null && this.getConversionMask().equals(this.storageMetadata.getConversionMask()) || this.getConversionMask() == null && this.storageMetadata.getConversionMask() == null ? (this.getGroupingSymbol() != null && this.getGroupingSymbol().equals(this.storageMetadata.getGroupingSymbol()) || this.getConversionMask() == null && this.storageMetadata.getConversionMask() == null ? this.getDecimalFormat(false) != null && this.getDecimalFormat(false).equals(this.storageMetadata.getDecimalFormat(false)) || this.getDecimalFormat(false) == null && this.storageMetadata.getDecimalFormat(false) == null : false) : false));
            }
        }
    }

    public int getTrimType() {
        return this.trimType;
    }

    public void setTrimType(int trimType) {
        this.trimType = trimType;
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ValueMeta.getTrimTypeByCode(tt);
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public ValueMetaInterface getConversionMetadata() {
        return this.conversionMetadata;
    }

    public void setConversionMetadata(ValueMetaInterface conversionMetadata) {
        this.conversionMetadata = conversionMetadata;
    }

    public boolean isSingleByteEncoding() {
        return this.singleByteEncoding;
    }

    public long getNumberOfBinaryStringConversions() {
        return this.numberOfBinaryStringConversions;
    }

    public void setNumberOfBinaryStringConversions(long numberOfBinaryStringConversions) {
        this.numberOfBinaryStringConversions = numberOfBinaryStringConversions;
    }

    public boolean isOriginalAutoIncrement() {
        return this.originalAutoIncrement;
    }

    public void setOriginalAutoIncrement(boolean originalAutoIncrement) {
        this.originalAutoIncrement = originalAutoIncrement;
    }

    public int getOriginalColumnType() {
        return this.originalColumnType;
    }

    public void setOriginalColumnType(int originalColumnType) {
        this.originalColumnType = originalColumnType;
    }

    public String getOriginalColumnTypeName() {
        return this.originalColumnTypeName;
    }

    public void setOriginalColumnTypeName(String originalColumnTypeName) {
        this.originalColumnTypeName = originalColumnTypeName;
    }

    public int isOriginalNullable() {
        return this.originalNullable;
    }

    public void setOriginalNullable(int originalNullable) {
        this.originalNullable = originalNullable;
    }

    public int getOriginalPrecision() {
        return this.originalPrecision;
    }

    public void setOriginalPrecision(int originalPrecision) {
        this.originalPrecision = originalPrecision;
    }

    public int getOriginalScale() {
        return this.originalScale;
    }

    public void setOriginalScale(int originalScale) {
        this.originalScale = originalScale;
    }

    public boolean isOriginalSigned() {
        return this.originalSigned;
    }

    public void setOriginalSigned(boolean originalSigned) {
        this.originalSigned = originalSigned;
    }

    public boolean isBigNumberFormatting() {
        return this.bigNumberFormatting;
    }

    public void setBigNumberFormatting(boolean bigNumberFormatting) {
        this.bigNumberFormatting = bigNumberFormatting;
    }

    public static String[] getTrimTypeCodes() {
        return trimTypeCode;
    }

    public static String[] getTrimTypeDescriptions() {
        return trimTypeDesc;
    }

    public boolean requiresRealClone() {
        return this.type == 8 || this.type == 7;
    }
}

