/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.variables;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.version.BuildVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variables
implements VariableSpace {
    private Map<String, String> properties = new Hashtable<String, String>();
    private VariableSpace parent = null;
    private Map<String, String> injection = null;
    private boolean initialized = false;

    public Variables() {
        this.properties.put("Internal.Kettle.Version", "4.4.0");
        this.properties.put("Internal.Kettle.Build.Version", BuildVersion.getInstance().getRevision());
        this.properties.put("Internal.Kettle.Build.Date", BuildVersion.getInstance().getBuildDate());
    }

    @Override
    public void copyVariablesFrom(VariableSpace space) {
        if (space != null && this != space) {
            String[] variableNames = space.listVariables();
            for (int idx = 0; idx < variableNames.length; ++idx) {
                this.properties.put(variableNames[idx], space.getVariable(variableNames[idx]));
            }
        }
    }

    @Override
    public VariableSpace getParentVariableSpace() {
        return this.parent;
    }

    @Override
    public void setParentVariableSpace(VariableSpace parent) {
        this.parent = parent;
    }

    @Override
    public String getVariable(String variableName, String defaultValue) {
        String var = this.properties.get(variableName);
        if (var == null) {
            return defaultValue;
        }
        return var;
    }

    @Override
    public String getVariable(String variableName) {
        return this.properties.get(variableName);
    }

    @Override
    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty(variableName) && !Const.isEmpty(value = this.environmentSubstitute(variableName))) {
            return ValueMeta.convertStringToBoolean(value);
        }
        return defaultValue;
    }

    @Override
    public void initializeVariablesFrom(VariableSpace parent) {
        this.parent = parent;
        for (Object key : System.getProperties().keySet()) {
            this.properties.put((String)key, System.getProperties().getProperty((String)key));
        }
        if (parent != null) {
            this.copyVariablesFrom(parent);
        }
        if (this.injection != null) {
            this.properties.putAll(this.injection);
            this.injection = null;
        }
        this.initialized = true;
    }

    @Override
    public String[] listVariables() {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.properties.keySet()) {
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void setVariable(String variableName, String variableValue) {
        if (variableValue != null) {
            this.properties.put(variableName, variableValue);
        } else {
            this.properties.remove(variableName);
        }
    }

    @Override
    public String environmentSubstitute(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        return StringUtil.environmentSubstitute(aString, this.properties);
    }

    @Override
    public String[] environmentSubstitute(String[] string) {
        String[] retval = new String[string.length];
        for (int i = 0; i < string.length; ++i) {
            retval[i] = this.environmentSubstitute(string[i]);
        }
        return retval;
    }

    @Override
    public void shareVariablesWith(VariableSpace space) {
    }

    @Override
    public void injectVariables(Map<String, String> prop) {
        if (this.initialized) {
            if (prop != null) {
                this.properties.putAll(prop);
                this.injection = null;
            }
        } else {
            this.injection = new Hashtable<String, String>();
            this.injection.putAll(prop);
        }
    }

    public static synchronized VariableSpace getADefaultVariableSpace() {
        Variables space = new Variables();
        space.initializeVariablesFrom(null);
        return space;
    }
}

