/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryDirectory
implements RepositoryDirectoryInterface {
    public static final String DIRECTORY_SEPARATOR = "/";
    private RepositoryDirectoryInterface parent;
    private List<RepositoryDirectoryInterface> children;
    private List<RepositoryElementMetaInterface> repositoryObjects;
    private String directoryname;
    private ObjectId id;
    private boolean visible = true;

    public RepositoryDirectory(RepositoryDirectoryInterface parent, String directoryname) {
        this.parent = parent;
        this.directoryname = directoryname;
        this.children = new ArrayList<RepositoryDirectoryInterface>();
        this.id = null;
    }

    public RepositoryDirectory() {
        this(null, null);
    }

    @Override
    public List<RepositoryDirectoryInterface> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<RepositoryDirectoryInterface> children) {
        this.children = children;
    }

    @Override
    public List<RepositoryElementMetaInterface> getRepositoryObjects() {
        return this.repositoryObjects;
    }

    @Override
    public void setRepositoryObjects(List<RepositoryElementMetaInterface> repositoryObjects) {
        this.repositoryObjects = repositoryObjects;
    }

    @Override
    public void clear() {
        this.parent = null;
        this.directoryname = null;
        this.children = new ArrayList<RepositoryDirectoryInterface>();
    }

    @Override
    public ObjectId getObjectId() {
        return this.id;
    }

    @Override
    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    @Override
    public void setParent(RepositoryDirectoryInterface parent) {
        this.parent = parent;
    }

    @Override
    public RepositoryDirectoryInterface getParent() {
        return this.parent;
    }

    @Override
    public void setName(String directoryname) {
        this.directoryname = directoryname;
    }

    @Override
    public String getName() {
        if (this.directoryname == null) {
            return DIRECTORY_SEPARATOR;
        }
        return this.directoryname;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null && this.directoryname == null;
    }

    @Override
    public String getPath() {
        if (this.getParent() == null) {
            return DIRECTORY_SEPARATOR;
        }
        if (this.getParent().getParent() == null) {
            return DIRECTORY_SEPARATOR + this.getName();
        }
        return this.getParent().getPath() + DIRECTORY_SEPARATOR + this.getName();
    }

    @Override
    public String[] getPathArray() {
        int depth = 1;
        RepositoryDirectoryInterface follow = this.getParent();
        if (follow != null) {
            ++depth;
            follow = follow.getParent();
        }
        String[] retval = new String[depth];
        int level = depth - 1;
        retval[level] = this.getName();
        follow = this.getParent();
        if (follow != null) {
            retval[--level] = follow.getName();
            follow = follow.getParent();
        }
        return retval;
    }

    @Override
    public void addSubdirectory(RepositoryDirectoryInterface subdir) {
        subdir.setParent(this);
        this.children.add(subdir);
    }

    @Override
    public int getNrSubdirectories() {
        return this.children.size();
    }

    @Override
    public RepositoryDirectory getSubdirectory(int i) {
        if (this.children == null) {
            return null;
        }
        return (RepositoryDirectory)this.children.get(i);
    }

    @Override
    public RepositoryDirectory findDirectory(String[] path) {
        String[] directoryPath;
        if (this.isRoot() && path.length == 1 && path[0].equalsIgnoreCase(DIRECTORY_SEPARATOR)) {
            return this;
        }
        if (path.length < 1) {
            return this;
        }
        if (path.length > 0 && path[0].equalsIgnoreCase(DIRECTORY_SEPARATOR)) {
            directoryPath = new String[path.length - 1];
            for (int x = 0; x < directoryPath.length; ++x) {
                directoryPath[x] = path[x + 1];
            }
        } else {
            directoryPath = path;
        }
        if (this.isRoot() && directoryPath.length == 1 && directoryPath[0].equalsIgnoreCase(DIRECTORY_SEPARATOR)) {
            return this;
        }
        if (directoryPath.length == 1 && directoryPath[0].equalsIgnoreCase(this.getName())) {
            return this;
        }
        if (directoryPath.length >= 1) {
            RepositoryDirectory follow = this;
            for (int i = 0; i < directoryPath.length; ++i) {
                RepositoryDirectory directory = follow.findChild(directoryPath[i]);
                if (directory == null) {
                    return null;
                }
                follow = directory;
            }
            return follow;
        }
        return null;
    }

    @Override
    public RepositoryDirectory findDirectory(String path) {
        String[] newPath = Const.splitPath(path, DIRECTORY_SEPARATOR);
        String[] p = null;
        if (this.parent == null) {
            p = new String[newPath.length + 1];
            p[0] = DIRECTORY_SEPARATOR;
            for (int i = 0; i < newPath.length; ++i) {
                p[i + 1] = newPath[i];
            }
        } else {
            p = newPath;
        }
        return this.findDirectory(p);
    }

    @Override
    public RepositoryDirectory findChild(String name) {
        for (RepositoryDirectoryInterface child : this.children) {
            if (!child.getName().equalsIgnoreCase(name)) continue;
            return (RepositoryDirectory)child;
        }
        return null;
    }

    @Override
    public RepositoryDirectory findDirectory(ObjectId id_directory) {
        if (this.getObjectId() == null && id_directory == null) {
            return this;
        }
        if (this.getObjectId() != null && this.getObjectId().equals(id_directory)) {
            return this;
        }
        for (int i = 0; i < this.getNrSubdirectories(); ++i) {
            RepositoryDirectory rd = this.getSubdirectory(i).findDirectory(id_directory);
            if (rd == null) continue;
            return rd;
        }
        return null;
    }

    public String getXML() {
        return this.getXML(0);
    }

    public String getXML(int level) {
        String spaces = Const.rightPad(" ", level);
        StringBuffer retval = new StringBuffer(200);
        retval.append(spaces).append("<repdir>").append(Const.CR);
        retval.append(spaces).append("  ").append(XMLHandler.addTagValue("name", this.getName()));
        if (this.getNrSubdirectories() > 0) {
            retval.append(spaces).append("    <subdirs>").append(Const.CR);
            for (int i = 0; i < this.getNrSubdirectories(); ++i) {
                RepositoryDirectory subdir = this.getSubdirectory(i);
                retval.append(subdir.getXML(level + 1));
            }
            retval.append(spaces).append("    </subdirs>").append(Const.CR);
        }
        retval.append(spaces).append("</repdir>").append(Const.CR);
        return retval.toString();
    }

    public boolean loadXML(Node repdirnode) {
        try {
            this.clear();
            this.directoryname = XMLHandler.getTagValue(repdirnode, "name");
            Node subdirsnode = XMLHandler.getSubNode(repdirnode, "subdirs");
            if (subdirsnode != null) {
                int n = XMLHandler.countNodes(subdirsnode, "repdir");
                for (int i = 0; i < n; ++i) {
                    RepositoryDirectory subdir = new RepositoryDirectory();
                    Node subdirnode = XMLHandler.getSubNodeByNr(subdirsnode, "repdir", i);
                    if (!subdir.loadXML(subdirnode)) {
                        return false;
                    }
                    subdir.setParent(this);
                    this.addSubdirectory(subdir);
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ObjectId[] getDirectoryIDs() {
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        this.getDirectoryIDs(ids);
        return ids.toArray(new ObjectId[ids.size()]);
    }

    private void getDirectoryIDs(List<ObjectId> ids) {
        if (this.getObjectId() != null) {
            ids.add(this.getObjectId());
        }
        for (int i = 0; i < this.getNrSubdirectories(); ++i) {
            this.getSubdirectory(i).getDirectoryIDs(ids);
        }
    }

    @Override
    public RepositoryDirectoryInterface findRoot() {
        if (this.isRoot()) {
            return this;
        }
        return this.getParent().findRoot();
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public String getPathObjectCombination(String transName) {
        if (this.isRoot()) {
            return this.getPath() + transName;
        }
        return this.getPath() + DIRECTORY_SEPARATOR + transName;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

