/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.VersionInfo;

public class HBaseConfiguration
extends Configuration {
    private static final Log LOG = LogFactory.getLog(HBaseConfiguration.class);

    @Deprecated
    public HBaseConfiguration() {
        HBaseConfiguration.addHbaseResources(this);
        LOG.warn((Object)"instantiating HBaseConfiguration() is deprecated. Please use HBaseConfiguration#create() to construct a plain Configuration");
    }

    @Deprecated
    public HBaseConfiguration(Configuration c) {
        this();
        for (Map.Entry e : c) {
            this.set((String)e.getKey(), (String)e.getValue());
        }
    }

    private static void checkDefaultsVersion(Configuration conf) {
        if (conf.getBoolean("hbase.defaults.for.version.skip", Boolean.FALSE.booleanValue())) {
            return;
        }
        String defaultsVersion = conf.get("hbase.defaults.for.version");
        String thisVersion = VersionInfo.getVersion();
        if (!thisVersion.equals(defaultsVersion)) {
            throw new RuntimeException("hbase-default.xml file seems to be for and old version of HBase (" + defaultsVersion + "), this version is " + thisVersion);
        }
    }

    private static void checkForClusterFreeMemoryLimit(Configuration conf) {
        float blockCacheUpperLimit;
        float globalMemstoreLimit = conf.getFloat("hbase.regionserver.global.memstore.upperLimit", 0.4f);
        if (1.0f - (globalMemstoreLimit + (blockCacheUpperLimit = conf.getFloat("hfile.block.cache.size", 0.2f))) < 0.2f) {
            throw new RuntimeException("Current heap configuration for MemStore and BlockCache exceeds the threshold required for successful cluster operation. The combined value cannot exceed 0.8. Please check the settings for hbase.regionserver.global.memstore.upperLimit and hfile.block.cache.size in your configuration.");
        }
    }

    public static Configuration addHbaseResources(Configuration conf) {
        conf.addResource("hbase-default.xml");
        conf.addResource("hbase-site.xml");
        HBaseConfiguration.checkDefaultsVersion(conf);
        HBaseConfiguration.checkForClusterFreeMemoryLimit(conf);
        return conf;
    }

    public static Configuration create() {
        Configuration conf = new Configuration();
        return HBaseConfiguration.addHbaseResources(conf);
    }

    public static Configuration create(Configuration that) {
        Configuration conf = HBaseConfiguration.create();
        for (Map.Entry e : that) {
            conf.set((String)e.getKey(), (String)e.getValue());
        }
        return conf;
    }
}

