/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class HServerLoad
implements WritableComparable<HServerLoad> {
    private int numberOfRegions;
    private int numberOfRequests;
    private int usedHeapMB;
    private int maxHeapMB;
    private ArrayList<RegionLoad> regionLoad = new ArrayList();

    public HServerLoad() {
    }

    public HServerLoad(int numberOfRequests, int usedHeapMB, int maxHeapMB) {
        this.numberOfRequests = numberOfRequests;
        this.usedHeapMB = usedHeapMB;
        this.maxHeapMB = maxHeapMB;
    }

    public HServerLoad(HServerLoad hsl) {
        this(hsl.numberOfRequests, hsl.usedHeapMB, hsl.maxHeapMB);
        this.regionLoad.addAll(hsl.regionLoad);
    }

    public int getLoad() {
        return this.numberOfRegions;
    }

    public String toString() {
        return this.toString(1);
    }

    public String toString(int msgInterval) {
        StringBuilder sb = new StringBuilder();
        sb = Strings.appendKeyValue(sb, "requests", this.numberOfRequests / msgInterval);
        sb = Strings.appendKeyValue(sb, "regions", this.numberOfRegions);
        sb = Strings.appendKeyValue(sb, "usedHeap", this.usedHeapMB);
        sb = Strings.appendKeyValue(sb, "maxHeap", this.maxHeapMB);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((HServerLoad)o) == 0;
    }

    public int hashCode() {
        int result = Integer.valueOf(this.numberOfRequests).hashCode();
        return result ^= Integer.valueOf(this.numberOfRegions).hashCode();
    }

    public int getNumberOfRegions() {
        return this.numberOfRegions;
    }

    public int getNumberOfRequests() {
        return this.numberOfRequests;
    }

    public int getUsedHeapMB() {
        return this.usedHeapMB;
    }

    public int getMaxHeapMB() {
        return this.maxHeapMB;
    }

    public Collection<RegionLoad> getRegionsLoad() {
        return Collections.unmodifiableCollection(this.regionLoad);
    }

    public int getStorefiles() {
        int count = 0;
        for (RegionLoad info : this.regionLoad) {
            count += info.getStorefiles();
        }
        return count;
    }

    public int getStorefileSizeInMB() {
        int count = 0;
        for (RegionLoad info : this.regionLoad) {
            count += info.getStorefileSizeMB();
        }
        return count;
    }

    public int getMemStoreSizeInMB() {
        int count = 0;
        for (RegionLoad info : this.regionLoad) {
            count += info.getMemStoreSizeMB();
        }
        return count;
    }

    public int getStorefileIndexSizeInMB() {
        int count = 0;
        for (RegionLoad info : this.regionLoad) {
            count += info.getStorefileIndexSizeMB();
        }
        return count;
    }

    public void setNumberOfRegions(int numberOfRegions) {
        this.numberOfRegions = numberOfRegions;
    }

    public void setNumberOfRequests(int numberOfRequests) {
        this.numberOfRequests = numberOfRequests;
    }

    public void setUsedHeapMB(int usedHeapMB) {
        this.usedHeapMB = usedHeapMB;
    }

    public void setMaxHeapMB(int maxHeapMB) {
        this.maxHeapMB = maxHeapMB;
    }

    public void addRegionInfo(RegionLoad load) {
        ++this.numberOfRegions;
        this.regionLoad.add(load);
    }

    @Deprecated
    public void addRegionInfo(byte[] name, int stores, int storefiles, int storefileSizeMB, int memstoreSizeMB, int storefileIndexSizeMB) {
        this.regionLoad.add(new RegionLoad(name, stores, storefiles, storefileSizeMB, memstoreSizeMB, storefileIndexSizeMB));
    }

    public void readFields(DataInput in) throws IOException {
        this.numberOfRequests = in.readInt();
        this.usedHeapMB = in.readInt();
        this.maxHeapMB = in.readInt();
        this.numberOfRegions = in.readInt();
        for (int i = 0; i < this.numberOfRegions; ++i) {
            RegionLoad rl = new RegionLoad();
            rl.readFields(in);
            this.regionLoad.add(rl);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.numberOfRequests);
        out.writeInt(this.usedHeapMB);
        out.writeInt(this.maxHeapMB);
        out.writeInt(this.numberOfRegions);
        for (int i = 0; i < this.numberOfRegions; ++i) {
            this.regionLoad.get(i).write(out);
        }
    }

    public int compareTo(HServerLoad o) {
        return this.getLoad() - o.getLoad();
    }

    public static class RegionLoad
    implements Writable {
        private byte[] name;
        private int stores;
        private int storefiles;
        private int storefileSizeMB;
        private int memstoreSizeMB;
        private int storefileIndexSizeMB;

        public RegionLoad() {
        }

        public RegionLoad(byte[] name, int stores, int storefiles, int storefileSizeMB, int memstoreSizeMB, int storefileIndexSizeMB) {
            this.name = name;
            this.stores = stores;
            this.storefiles = storefiles;
            this.storefileSizeMB = storefileSizeMB;
            this.memstoreSizeMB = memstoreSizeMB;
            this.storefileIndexSizeMB = storefileIndexSizeMB;
        }

        public byte[] getName() {
            return this.name;
        }

        public String getNameAsString() {
            return Bytes.toString(this.name);
        }

        public int getStores() {
            return this.stores;
        }

        public int getStorefiles() {
            return this.storefiles;
        }

        public int getStorefileSizeMB() {
            return this.storefileSizeMB;
        }

        public int getMemStoreSizeMB() {
            return this.memstoreSizeMB;
        }

        public int getStorefileIndexSizeMB() {
            return this.storefileIndexSizeMB;
        }

        public void setName(byte[] name) {
            this.name = name;
        }

        public void setStores(int stores) {
            this.stores = stores;
        }

        public void setStorefiles(int storefiles) {
            this.storefiles = storefiles;
        }

        public void setMemStoreSizeMB(int memstoreSizeMB) {
            this.memstoreSizeMB = memstoreSizeMB;
        }

        public void setStorefileIndexSizeMB(int storefileIndexSizeMB) {
            this.storefileIndexSizeMB = storefileIndexSizeMB;
        }

        public void readFields(DataInput in) throws IOException {
            int namelen = in.readInt();
            this.name = new byte[namelen];
            in.readFully(this.name);
            this.stores = in.readInt();
            this.storefiles = in.readInt();
            this.storefileSizeMB = in.readInt();
            this.memstoreSizeMB = in.readInt();
            this.storefileIndexSizeMB = in.readInt();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.name.length);
            out.write(this.name);
            out.writeInt(this.stores);
            out.writeInt(this.storefiles);
            out.writeInt(this.storefileSizeMB);
            out.writeInt(this.memstoreSizeMB);
            out.writeInt(this.storefileIndexSizeMB);
        }

        public String toString() {
            StringBuilder sb = Strings.appendKeyValue(new StringBuilder(), "stores", this.stores);
            sb = Strings.appendKeyValue(sb, "storefiles", this.storefiles);
            sb = Strings.appendKeyValue(sb, "storefileSizeMB", this.storefileSizeMB);
            sb = Strings.appendKeyValue(sb, "memstoreSizeMB", this.memstoreSizeMB);
            sb = Strings.appendKeyValue(sb, "storefileIndexSizeMB", this.storefileIndexSizeMB);
            return sb.toString();
        }
    }
}

