/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.util.Utf8;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.avro.AvroUtil;
import org.apache.hadoop.hbase.avro.generated.AClusterStatus;
import org.apache.hadoop.hbase.avro.generated.ADelete;
import org.apache.hadoop.hbase.avro.generated.AFamilyDescriptor;
import org.apache.hadoop.hbase.avro.generated.AGet;
import org.apache.hadoop.hbase.avro.generated.AIOError;
import org.apache.hadoop.hbase.avro.generated.AIllegalArgument;
import org.apache.hadoop.hbase.avro.generated.AMasterNotRunning;
import org.apache.hadoop.hbase.avro.generated.APut;
import org.apache.hadoop.hbase.avro.generated.AResult;
import org.apache.hadoop.hbase.avro.generated.AScan;
import org.apache.hadoop.hbase.avro.generated.ATableDescriptor;
import org.apache.hadoop.hbase.avro.generated.ATableExists;
import org.apache.hadoop.hbase.avro.generated.HBase;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class AvroServer {
    private static void printUsageAndExit() {
        AvroServer.printUsageAndExit(null);
    }

    private static void printUsageAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.out.println("Usage: java org.apache.hadoop.hbase.avro.AvroServer --help | [--port=PORT] start");
        System.out.println("Arguments:");
        System.out.println(" start Start Avro server");
        System.out.println(" stop  Stop Avro server");
        System.out.println("Options:");
        System.out.println(" port  Port to listen on. Default: 9090");
        System.out.println(" help  Print this message and exit");
        System.exit(0);
    }

    protected static void doMain(String[] args) throws Exception {
        if (args.length < 1) {
            AvroServer.printUsageAndExit();
        }
        int port = 9090;
        String portArgKey = "--port=";
        for (String cmd : args) {
            if (cmd.startsWith("--port=")) {
                port = Integer.parseInt(cmd.substring("--port=".length()));
                continue;
            }
            if (cmd.equals("--help") || cmd.equals("-h")) {
                AvroServer.printUsageAndExit();
            } else {
                if (cmd.equals("start")) continue;
                if (cmd.equals("stop")) {
                    AvroServer.printUsageAndExit("To shutdown the Avro server run bin/hbase-daemon.sh stop avro or send a kill signal to the Avro server pid");
                }
            }
            AvroServer.printUsageAndExit();
        }
        Log LOG = LogFactory.getLog((String)"AvroServer");
        LOG.info((Object)("starting HBase Avro server on port " + Integer.toString(port)));
        SpecificResponder r = new SpecificResponder(HBase.class, (Object)new HBaseImpl());
        HttpServer server = new HttpServer((Responder)r, port);
        server.start();
        server.join();
    }

    public static void main(String[] args) throws Exception {
        AvroServer.doMain(args);
    }

    public static class HBaseImpl
    implements HBase {
        protected Configuration conf = null;
        protected HBaseAdmin admin = null;
        protected HTablePool htablePool = null;
        protected final Log LOG = LogFactory.getLog((String)this.getClass().getName());
        protected int nextScannerId = 0;
        protected HashMap<Integer, ResultScanner> scannerMap = null;

        protected synchronized int addScanner(ResultScanner scanner) {
            int id = this.nextScannerId++;
            this.scannerMap.put(id, scanner);
            return id;
        }

        protected synchronized ResultScanner getScanner(int id) {
            return this.scannerMap.get(id);
        }

        protected synchronized ResultScanner removeScanner(int id) {
            return this.scannerMap.remove(id);
        }

        HBaseImpl() throws IOException {
            this(HBaseConfiguration.create());
        }

        HBaseImpl(Configuration c) throws IOException {
            this.conf = c;
            this.admin = new HBaseAdmin(this.conf);
            this.htablePool = new HTablePool(this.conf, 10);
            this.scannerMap = new HashMap();
        }

        public Utf8 getHBaseVersion() throws AIOError {
            try {
                return new Utf8(this.admin.getClusterStatus().getHBaseVersion());
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public AClusterStatus getClusterStatus() throws AIOError {
            try {
                return AvroUtil.csToACS(this.admin.getClusterStatus());
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        public GenericArray<ATableDescriptor> listTables() throws AIOError {
            try {
                HTableDescriptor[] tables = this.admin.listTables();
                Schema atdSchema = Schema.createArray((Schema)ATableDescriptor.SCHEMA$);
                GenericData.Array result = null;
                result = new GenericData.Array(tables.length, atdSchema);
                for (HTableDescriptor table : tables) {
                    result.add((Object)AvroUtil.htdToATD(table));
                }
                return result;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public ATableDescriptor describeTable(ByteBuffer table) throws AIOError {
            try {
                return AvroUtil.htdToATD(this.admin.getTableDescriptor(Bytes.toBytes(table)));
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public boolean isTableEnabled(ByteBuffer table) throws AIOError {
            try {
                return this.admin.isTableEnabled(Bytes.toBytes(table));
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public boolean tableExists(ByteBuffer table) throws AIOError {
            try {
                return this.admin.tableExists(Bytes.toBytes(table));
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public AFamilyDescriptor describeFamily(ByteBuffer table, ByteBuffer family) throws AIOError {
            try {
                HTableDescriptor htd = this.admin.getTableDescriptor(Bytes.toBytes(table));
                return AvroUtil.hcdToAFD(htd.getFamily(Bytes.toBytes(family)));
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void createTable(ATableDescriptor table) throws AIOError, AIllegalArgument, ATableExists, AMasterNotRunning {
            try {
                this.admin.createTable(AvroUtil.atdToHTD(table));
                return null;
            }
            catch (IllegalArgumentException e) {
                AIllegalArgument iae = new AIllegalArgument();
                iae.message = new Utf8(e.getMessage());
                throw iae;
            }
            catch (TableExistsException e) {
                ATableExists tee = new ATableExists();
                tee.message = new Utf8(e.getMessage());
                throw tee;
            }
            catch (MasterNotRunningException e) {
                AMasterNotRunning mnre = new AMasterNotRunning();
                mnre.message = new Utf8(e.getMessage());
                throw mnre;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void deleteTable(ByteBuffer table) throws AIOError {
            try {
                this.admin.deleteTable(Bytes.toBytes(table));
                return null;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void modifyTable(ByteBuffer tableName, ATableDescriptor tableDescriptor) throws AIOError {
            try {
                this.admin.modifyTable(Bytes.toBytes(tableName), AvroUtil.atdToHTD(tableDescriptor));
                return null;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void enableTable(ByteBuffer table) throws AIOError {
            try {
                this.admin.enableTable(Bytes.toBytes(table));
                return null;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void disableTable(ByteBuffer table) throws AIOError {
            try {
                this.admin.disableTable(Bytes.toBytes(table));
                return null;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void flush(ByteBuffer table) throws AIOError {
            try {
                this.admin.flush(Bytes.toBytes(table));
                return null;
            }
            catch (InterruptedException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void split(ByteBuffer table) throws AIOError {
            try {
                this.admin.split(Bytes.toBytes(table));
                return null;
            }
            catch (InterruptedException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void addFamily(ByteBuffer table, AFamilyDescriptor family) throws AIOError {
            try {
                this.admin.addColumn(Bytes.toBytes(table), AvroUtil.afdToHCD(family));
                return null;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void deleteFamily(ByteBuffer table, ByteBuffer family) throws AIOError {
            try {
                this.admin.deleteColumn(Bytes.toBytes(table), Bytes.toBytes(family));
                return null;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public Void modifyFamily(ByteBuffer table, ByteBuffer familyName, AFamilyDescriptor familyDescriptor) throws AIOError {
            try {
                this.admin.modifyColumn(Bytes.toBytes(table), AvroUtil.afdToHCD(familyDescriptor));
                return null;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        @Override
        public AResult get(ByteBuffer table, AGet aget) throws AIOError {
            HTableInterface htable = this.htablePool.getTable(Bytes.toBytes(table));
            try {
                AResult aResult = AvroUtil.resultToAResult(htable.get(AvroUtil.agetToGet(aget)));
                return aResult;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
            finally {
                this.htablePool.putTable(htable);
            }
        }

        @Override
        public boolean exists(ByteBuffer table, AGet aget) throws AIOError {
            HTableInterface htable = this.htablePool.getTable(Bytes.toBytes(table));
            try {
                boolean bl = htable.exists(AvroUtil.agetToGet(aget));
                return bl;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
            finally {
                this.htablePool.putTable(htable);
            }
        }

        @Override
        public Void put(ByteBuffer table, APut aput) throws AIOError {
            HTableInterface htable = this.htablePool.getTable(Bytes.toBytes(table));
            try {
                htable.put(AvroUtil.aputToPut(aput));
                Void void_ = null;
                return void_;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
            finally {
                this.htablePool.putTable(htable);
            }
        }

        @Override
        public Void delete(ByteBuffer table, ADelete adelete) throws AIOError {
            HTableInterface htable = this.htablePool.getTable(Bytes.toBytes(table));
            try {
                htable.delete(AvroUtil.adeleteToDelete(adelete));
                Void void_ = null;
                return void_;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
            finally {
                this.htablePool.putTable(htable);
            }
        }

        @Override
        public long incrementColumnValue(ByteBuffer table, ByteBuffer row, ByteBuffer family, ByteBuffer qualifier, long amount, boolean writeToWAL) throws AIOError {
            HTableInterface htable = this.htablePool.getTable(Bytes.toBytes(table));
            try {
                long l = htable.incrementColumnValue(Bytes.toBytes(row), Bytes.toBytes(family), Bytes.toBytes(qualifier), amount, writeToWAL);
                return l;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
            finally {
                this.htablePool.putTable(htable);
            }
        }

        @Override
        public int scannerOpen(ByteBuffer table, AScan ascan) throws AIOError {
            HTableInterface htable = this.htablePool.getTable(Bytes.toBytes(table));
            try {
                Scan scan = AvroUtil.ascanToScan(ascan);
                int n = this.addScanner(htable.getScanner(scan));
                return n;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
            finally {
                this.htablePool.putTable(htable);
            }
        }

        @Override
        public Void scannerClose(int scannerId) throws AIOError, AIllegalArgument {
            try {
                ResultScanner scanner = this.getScanner(scannerId);
                if (scanner == null) {
                    AIllegalArgument aie = new AIllegalArgument();
                    aie.message = new Utf8("scanner ID is invalid: " + scannerId);
                    throw aie;
                }
                scanner.close();
                this.removeScanner(scannerId);
                return null;
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }

        public GenericArray<AResult> scannerGetRows(int scannerId, int numberOfRows) throws AIOError, AIllegalArgument {
            try {
                ResultScanner scanner = this.getScanner(scannerId);
                if (scanner == null) {
                    AIllegalArgument aie = new AIllegalArgument();
                    aie.message = new Utf8("scanner ID is invalid: " + scannerId);
                    throw aie;
                }
                return AvroUtil.resultsToAResults(scanner.next(numberOfRows));
            }
            catch (IOException e) {
                AIOError ioe = new AIOError();
                ioe.message = new Utf8(e.getMessage());
                throw ioe;
            }
        }
    }
}

