/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.Writable;

public class Put
implements HeapSize,
Writable,
Row,
Comparable<Row> {
    private static final byte PUT_VERSION = 1;
    private byte[] row = null;
    private long timestamp = Long.MAX_VALUE;
    private long lockId = -1L;
    private boolean writeToWAL = true;
    private Map<byte[], List<KeyValue>> familyMap = new TreeMap<byte[], List<KeyValue>>(Bytes.BYTES_COMPARATOR);
    private static final long OVERHEAD = ClassSize.align(ClassSize.OBJECT + ClassSize.REFERENCE + 16 + 1 + ClassSize.REFERENCE + ClassSize.TREEMAP);

    public Put() {
    }

    public Put(byte[] row) {
        this(row, null);
    }

    public Put(byte[] row, RowLock rowLock) {
        this(row, Long.MAX_VALUE, rowLock);
    }

    public Put(byte[] row, long ts) {
        this(row, ts, null);
    }

    public Put(byte[] row, long ts, RowLock rowLock) {
        if (row == null || row.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Row key is invalid");
        }
        this.row = Arrays.copyOf(row, row.length);
        this.timestamp = ts;
        if (rowLock != null) {
            this.lockId = rowLock.getLockId();
        }
    }

    public Put(Put putToCopy) {
        this(putToCopy.getRow(), putToCopy.timestamp, putToCopy.getRowLock());
        this.familyMap = new TreeMap<byte[], List<KeyValue>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], List<KeyValue>> entry : putToCopy.getFamilyMap().entrySet()) {
            this.familyMap.put(entry.getKey(), entry.getValue());
        }
        this.writeToWAL = putToCopy.writeToWAL;
    }

    public Put add(byte[] family, byte[] qualifier, byte[] value) {
        return this.add(family, qualifier, this.timestamp, value);
    }

    public Put add(byte[] family, byte[] qualifier, long ts, byte[] value) {
        List<KeyValue> list = this.getKeyValueList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value);
        list.add(kv);
        this.familyMap.put(kv.getFamily(), list);
        return this;
    }

    public Put add(KeyValue kv) throws IOException {
        byte[] family = kv.getFamily();
        List<KeyValue> list = this.getKeyValueList(family);
        int res = Bytes.compareTo(this.row, 0, this.row.length, kv.getBuffer(), kv.getRowOffset(), kv.getRowLength());
        if (res != 0) {
            throw new IOException("The row in the recently added KeyValue " + Bytes.toStringBinary(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength()) + " doesn't match the original one " + Bytes.toStringBinary(this.row));
        }
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    private KeyValue createPutKeyValue(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return new KeyValue(this.row, family, qualifier, ts, KeyValue.Type.Put, value);
    }

    public boolean has(byte[] family, byte[] qualifier) {
        return this.has(family, qualifier, this.timestamp, new byte[0], true, true);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts) {
        return this.has(family, qualifier, ts, new byte[0], false, true);
    }

    public boolean has(byte[] family, byte[] qualifier, byte[] value) {
        return this.has(family, qualifier, this.timestamp, value, true, false);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return this.has(family, qualifier, ts, value, false, false);
    }

    private boolean has(byte[] family, byte[] qualifier, long ts, byte[] value, boolean ignoreTS, boolean ignoreValue) {
        List<KeyValue> list = this.getKeyValueList(family);
        if (list.size() == 0) {
            return false;
        }
        if (!ignoreTS && !ignoreValue) {
            KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value);
            return list.contains(kv);
        }
        if (ignoreValue) {
            for (KeyValue kv : list) {
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier) || kv.getTimestamp() != ts) continue;
                return true;
            }
        } else {
            for (KeyValue kv : list) {
                if (!Arrays.equals(kv.getFamily(), family) || !Arrays.equals(kv.getQualifier(), qualifier) || !Arrays.equals(kv.getValue(), value)) continue;
                return true;
            }
        }
        return false;
    }

    public List<KeyValue> get(byte[] family, byte[] qualifier) {
        ArrayList<KeyValue> filteredList = new ArrayList<KeyValue>();
        for (KeyValue kv : this.getKeyValueList(family)) {
            if (!Arrays.equals(kv.getQualifier(), qualifier)) continue;
            filteredList.add(kv);
        }
        return filteredList;
    }

    private List<KeyValue> getKeyValueList(byte[] family) {
        List<KeyValue> list = this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>(0);
        }
        return list;
    }

    public Map<byte[], List<KeyValue>> getFamilyMap() {
        return this.familyMap;
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public RowLock getRowLock() {
        return new RowLock(this.row, this.lockId);
    }

    public long getLockId() {
        return this.lockId;
    }

    public boolean isEmpty() {
        return this.familyMap.isEmpty();
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public int size() {
        int size = 0;
        for (List<KeyValue> kvList : this.familyMap.values()) {
            size += kvList.size();
        }
        return size;
    }

    public boolean getWriteToWAL() {
        return this.writeToWAL;
    }

    public void setWriteToWAL(boolean write) {
        this.writeToWAL = write;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("row=");
        sb.append(Bytes.toStringBinary(this.row));
        sb.append(", families={");
        boolean moreThanOne = false;
        for (Map.Entry<byte[], List<KeyValue>> entry : this.familyMap.entrySet()) {
            if (moreThanOne) {
                sb.append(", ");
            } else {
                moreThanOne = true;
            }
            sb.append("(family=");
            sb.append(Bytes.toString(entry.getKey()));
            sb.append(", keyvalues=(");
            boolean moreThanOneB = false;
            for (KeyValue kv : entry.getValue()) {
                if (moreThanOneB) {
                    sb.append(", ");
                } else {
                    moreThanOneB = true;
                }
                sb.append(kv.toString());
            }
            sb.append(")");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int compareTo(Row p) {
        return Bytes.compareTo(this.getRow(), p.getRow());
    }

    @Override
    public long heapSize() {
        long heapsize = OVERHEAD;
        heapsize += (long)ClassSize.align(ClassSize.ARRAY + this.row.length);
        heapsize += (long)ClassSize.align(this.familyMap.size() * ClassSize.MAP_ENTRY);
        for (Map.Entry<byte[], List<KeyValue>> entry : this.familyMap.entrySet()) {
            heapsize += (long)ClassSize.align(ClassSize.ARRAY + entry.getKey().length);
            heapsize += (long)ClassSize.align(ClassSize.ARRAYLIST);
            int size = entry.getValue().size();
            heapsize += (long)ClassSize.align(ClassSize.ARRAY + size * ClassSize.REFERENCE);
            for (KeyValue kv : entry.getValue()) {
                heapsize += kv.heapSize();
            }
        }
        return ClassSize.align((int)heapsize);
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 1) {
            throw new IOException("version not supported");
        }
        this.row = Bytes.readByteArray(in);
        this.timestamp = in.readLong();
        this.lockId = in.readLong();
        this.writeToWAL = in.readBoolean();
        int numFamilies = in.readInt();
        if (!this.familyMap.isEmpty()) {
            this.familyMap.clear();
        }
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numKeys = in.readInt();
            ArrayList<KeyValue> keys = new ArrayList<KeyValue>(numKeys);
            int totalLen = in.readInt();
            byte[] buf = new byte[totalLen];
            int offset = 0;
            for (int j = 0; j < numKeys; ++j) {
                int keyLength = in.readInt();
                in.readFully(buf, offset, keyLength);
                keys.add(new KeyValue(buf, offset, keyLength));
                offset += keyLength;
            }
            this.familyMap.put(family, keys);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(1);
        Bytes.writeByteArray(out, this.row);
        out.writeLong(this.timestamp);
        out.writeLong(this.lockId);
        out.writeBoolean(this.writeToWAL);
        out.writeInt(this.familyMap.size());
        for (Map.Entry<byte[], List<KeyValue>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            List<KeyValue> keys = entry.getValue();
            out.writeInt(keys.size());
            int totalLen = 0;
            for (KeyValue kv : keys) {
                totalLen += kv.getLength();
            }
            out.writeInt(totalLen);
            for (KeyValue kv : keys) {
                out.writeInt(kv.getLength());
                out.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
            }
        }
    }

    public Put add(byte[] column, long ts, byte[] value) {
        byte[][] parts = KeyValue.parseColumn(column);
        return this.add(parts[0], parts[1], ts, value);
    }
}

