/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.ipc.HRegionInterface;

public abstract class ServerCallable<T>
implements Callable<T> {
    protected final HConnection connection;
    protected final byte[] tableName;
    protected final byte[] row;
    protected HRegionLocation location;
    protected HRegionInterface server;

    public ServerCallable(HConnection connection, byte[] tableName, byte[] row) {
        this.connection = connection;
        this.tableName = tableName;
        this.row = row;
    }

    public void instantiateServer(boolean reload) throws IOException {
        this.location = this.connection.getRegionLocation(this.tableName, this.row, reload);
        this.server = this.connection.getHRegionConnection(this.location.getServerAddress());
    }

    public String getServerName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getServerAddress().toString();
    }

    public byte[] getRegionName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRegionInfo().getRegionName();
    }

    public byte[] getRow() {
        return this.row;
    }
}

