/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

public class ColumnPaginationFilter
extends FilterBase {
    private int limit = 0;
    private int offset = 0;
    private int count = 0;

    public ColumnPaginationFilter() {
    }

    public ColumnPaginationFilter(int limit, int offset) {
        this.limit = limit;
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        if (this.count >= this.offset + this.limit) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        Filter.ReturnCode code = this.count < this.offset ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
        ++this.count;
        return code;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public void readFields(DataInput in) throws IOException {
        this.limit = in.readInt();
        this.offset = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.limit);
        out.writeInt(this.offset);
    }
}

