/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiPut;
import org.apache.hadoop.hbase.client.MultiPutResponse;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HBaseRPCProtocolVersion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Pair;

public interface HRegionInterface
extends HBaseRPCProtocolVersion,
Stoppable,
Abortable {
    public HRegionInfo getRegionInfo(byte[] var1) throws NotServingRegionException, ConnectException, IOException;

    public Result getClosestRowBefore(byte[] var1, byte[] var2, byte[] var3) throws IOException;

    public Result get(byte[] var1, Get var2) throws IOException;

    public boolean exists(byte[] var1, Get var2) throws IOException;

    public void put(byte[] var1, Put var2) throws IOException;

    public int put(byte[] var1, List<Put> var2) throws IOException;

    public void delete(byte[] var1, Delete var2) throws IOException;

    public int delete(byte[] var1, List<Delete> var2) throws IOException;

    public boolean checkAndPut(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, Put var6) throws IOException;

    public boolean checkAndDelete(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, Delete var6) throws IOException;

    public long incrementColumnValue(byte[] var1, byte[] var2, byte[] var3, byte[] var4, long var5, boolean var7) throws IOException;

    public Result increment(byte[] var1, Increment var2) throws IOException;

    public long openScanner(byte[] var1, Scan var2) throws IOException;

    public Result next(long var1) throws IOException;

    public Result[] next(long var1, int var3) throws IOException;

    public void close(long var1) throws IOException;

    public long lockRow(byte[] var1, byte[] var2) throws IOException;

    public void unlockRow(byte[] var1, long var2) throws IOException;

    public List<HRegionInfo> getOnlineRegions();

    public HServerInfo getHServerInfo() throws IOException;

    public MultiResponse multi(MultiAction var1) throws IOException;

    public MultiPutResponse multiPut(MultiPut var1) throws IOException;

    @Deprecated
    public void bulkLoadHFile(String var1, byte[] var2, byte[] var3) throws IOException;

    public void openRegion(HRegionInfo var1) throws IOException;

    public void openRegions(List<HRegionInfo> var1) throws IOException;

    public boolean closeRegion(HRegionInfo var1) throws IOException;

    public boolean closeRegion(HRegionInfo var1, boolean var2) throws IOException;

    public boolean closeRegion(byte[] var1, boolean var2) throws IOException;

    public void flushRegion(HRegionInfo var1) throws NotServingRegionException, IOException;

    public void splitRegion(HRegionInfo var1) throws NotServingRegionException, IOException;

    public void splitRegion(HRegionInfo var1, byte[] var2) throws NotServingRegionException, IOException;

    public void compactRegion(HRegionInfo var1, boolean var2) throws NotServingRegionException, IOException;

    public void replicateLogEntries(HLog.Entry[] var1) throws IOException;

    public boolean bulkLoadHFiles(List<Pair<byte[], String>> var1, byte[] var2) throws IOException;
}

