/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hadoop.hbase.regionserver.LeaseListener;

public class Leases
extends Thread {
    private static final Log LOG = LogFactory.getLog((String)Leases.class.getName());
    private final int leasePeriod;
    private final int leaseCheckFrequency;
    private volatile DelayQueue<Lease> leaseQueue = new DelayQueue();
    protected final Map<String, Lease> leases = new HashMap<String, Lease>();
    private volatile boolean stopRequested = false;

    public Leases(int leasePeriod, int leaseCheckFrequency) {
        this.leasePeriod = leasePeriod;
        this.leaseCheckFrequency = leaseCheckFrequency;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopRequested || this.stopRequested && this.leaseQueue.size() > 0) {
            Lease lease = null;
            try {
                lease = (Lease)this.leaseQueue.poll(this.leaseCheckFrequency, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                continue;
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            catch (Throwable e) {
                LOG.fatal((Object)"Unexpected exception killed leases thread", e);
                break;
            }
            if (lease == null) continue;
            if (lease.getListener() == null) {
                LOG.error((Object)("lease listener is null for lease " + lease.getLeaseName()));
            } else {
                lease.getListener().leaseExpired();
            }
            DelayQueue<Lease> delayQueue = this.leaseQueue;
            synchronized (delayQueue) {
                this.leases.remove(lease.getLeaseName());
            }
        }
        this.close();
    }

    public void closeAfterLeasesExpire() {
        this.stopRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOG.info((Object)(Thread.currentThread().getName() + " closing leases"));
        this.stopRequested = true;
        DelayQueue<Lease> delayQueue = this.leaseQueue;
        synchronized (delayQueue) {
            this.leaseQueue.clear();
            this.leases.clear();
            this.leaseQueue.notifyAll();
        }
        LOG.info((Object)(Thread.currentThread().getName() + " closed leases"));
    }

    public void createLease(String leaseName, LeaseListener listener) throws LeaseStillHeldException {
        this.addLease(new Lease(leaseName, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLease(Lease lease) throws LeaseStillHeldException {
        if (this.stopRequested) {
            return;
        }
        lease.setExpirationTime(System.currentTimeMillis() + (long)this.leasePeriod);
        DelayQueue<Lease> delayQueue = this.leaseQueue;
        synchronized (delayQueue) {
            if (this.leases.containsKey(lease.getLeaseName())) {
                throw new LeaseStillHeldException(lease.getLeaseName());
            }
            this.leases.put(lease.getLeaseName(), lease);
            this.leaseQueue.add(lease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewLease(String leaseName) throws LeaseException {
        DelayQueue<Lease> delayQueue = this.leaseQueue;
        synchronized (delayQueue) {
            Lease lease = this.leases.get(leaseName);
            if (lease == null || !this.leaseQueue.remove(lease)) {
                throw new LeaseException("lease '" + leaseName + "' does not exist or has already expired");
            }
            lease.setExpirationTime(System.currentTimeMillis() + (long)this.leasePeriod);
            this.leaseQueue.add(lease);
        }
    }

    public void cancelLease(String leaseName) throws LeaseException {
        this.removeLease(leaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Lease removeLease(String leaseName) throws LeaseException {
        Lease lease = null;
        DelayQueue<Lease> delayQueue = this.leaseQueue;
        synchronized (delayQueue) {
            lease = this.leases.remove(leaseName);
            if (lease == null) {
                throw new LeaseException("lease '" + leaseName + "' does not exist");
            }
            this.leaseQueue.remove(lease);
        }
        return lease;
    }

    static class Lease
    implements Delayed {
        private final String leaseName;
        private final LeaseListener listener;
        private long expirationTime;

        Lease(String leaseName, LeaseListener listener) {
            this(leaseName, listener, 0L);
        }

        Lease(String leaseName, LeaseListener listener, long expirationTime) {
            this.leaseName = leaseName;
            this.listener = listener;
            this.expirationTime = expirationTime;
        }

        public String getLeaseName() {
            return this.leaseName;
        }

        public LeaseListener getListener() {
            return this.listener;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.hashCode() == ((Lease)obj).hashCode();
        }

        public int hashCode() {
            return this.leaseName.hashCode();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expirationTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long delta = this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS);
            return this.equals(o) ? 0 : (delta > 0L ? 1 : -1);
        }

        public void setExpirationTime(long expirationTime) {
            this.expirationTime = expirationTime;
        }
    }

    public static class LeaseStillHeldException
    extends IOException {
        private final String leaseName;

        public LeaseStillHeldException(String name) {
            this.leaseName = name;
        }

        public String getName() {
            return this.leaseName;
        }
    }
}

