/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.HRegion;

public class PriorityCompactionQueue
implements BlockingQueue<HRegion> {
    static final Log LOG = LogFactory.getLog(PriorityCompactionQueue.class);
    protected final BlockingQueue<CompactionRequest> queue = new PriorityBlockingQueue<CompactionRequest>();
    private final HashMap<HRegion, CompactionRequest> regionsInQueue = new HashMap();

    public PriorityCompactionQueue() {
        LOG.debug((Object)"Create PriorityCompactionQueue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompactionRequest addToRegionsInQueue(HRegion r, int p) {
        CompactionRequest queuedRequest = null;
        CompactionRequest newRequest = new CompactionRequest(r, p);
        HashMap<HRegion, CompactionRequest> hashMap = this.regionsInQueue;
        synchronized (hashMap) {
            queuedRequest = this.regionsInQueue.get(r);
            if (queuedRequest == null || newRequest.getPriority() < queuedRequest.getPriority()) {
                LOG.trace((Object)("Inserting region in queue. " + newRequest));
                this.regionsInQueue.put(r, newRequest);
            } else {
                LOG.trace((Object)("Region already in queue, skipping. Queued: " + queuedRequest + ", requested: " + newRequest));
                newRequest = null;
            }
        }
        if (newRequest != null && queuedRequest != null) {
            this.queue.remove(queuedRequest);
        }
        return newRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompactionRequest removeFromRegionsInQueue(CompactionRequest remove) {
        if (remove == null) {
            return null;
        }
        HashMap<HRegion, CompactionRequest> hashMap = this.regionsInQueue;
        synchronized (hashMap) {
            CompactionRequest cr = null;
            cr = this.regionsInQueue.remove(remove.getHRegion());
            if (cr != null && !cr.equals(remove)) {
                this.regionsInQueue.put(cr.getHRegion(), cr);
            }
            if (cr == null) {
                LOG.warn((Object)("Removed a region it couldn't find in regionsInQueue: " + remove.getHRegion()));
            }
            return cr;
        }
    }

    public boolean add(HRegion e, int p) {
        CompactionRequest request = this.addToRegionsInQueue(e, p);
        if (request != null) {
            boolean result = this.queue.add(request);
            return result;
        }
        return false;
    }

    @Override
    public boolean add(HRegion e) {
        return this.add(e, e.getCompactPriority());
    }

    public boolean offer(HRegion e, int p) {
        CompactionRequest request = this.addToRegionsInQueue(e, p);
        return request != null ? this.queue.offer(request) : false;
    }

    @Override
    public boolean offer(HRegion e) {
        return this.offer(e, e.getCompactPriority());
    }

    public void put(HRegion e, int p) throws InterruptedException {
        CompactionRequest request = this.addToRegionsInQueue(e, p);
        if (request != null) {
            this.queue.put(request);
        }
    }

    @Override
    public void put(HRegion e) throws InterruptedException {
        this.put(e, e.getCompactPriority());
    }

    public boolean offer(HRegion e, int p, long timeout, TimeUnit unit) throws InterruptedException {
        CompactionRequest request = this.addToRegionsInQueue(e, p);
        return request != null ? this.queue.offer(request, timeout, unit) : false;
    }

    @Override
    public boolean offer(HRegion e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e, e.getCompactPriority(), timeout, unit);
    }

    @Override
    public HRegion take() throws InterruptedException {
        CompactionRequest cr = this.queue.take();
        if (cr != null) {
            this.removeFromRegionsInQueue(cr);
            return cr.getHRegion();
        }
        return null;
    }

    @Override
    public HRegion poll(long timeout, TimeUnit unit) throws InterruptedException {
        CompactionRequest cr = this.queue.poll(timeout, unit);
        if (cr != null) {
            this.removeFromRegionsInQueue(cr);
            return cr.getHRegion();
        }
        return null;
    }

    @Override
    public boolean remove(Object r) {
        CompactionRequest cr;
        if (r instanceof CompactionRequest && (cr = this.removeFromRegionsInQueue((CompactionRequest)r)) != null) {
            return this.queue.remove(cr);
        }
        return false;
    }

    @Override
    public HRegion remove() {
        CompactionRequest cr = (CompactionRequest)this.queue.remove();
        if (cr != null) {
            this.removeFromRegionsInQueue(cr);
            return cr.getHRegion();
        }
        return null;
    }

    @Override
    public HRegion poll() {
        CompactionRequest cr = (CompactionRequest)this.queue.poll();
        if (cr != null) {
            this.removeFromRegionsInQueue(cr);
            return cr.getHRegion();
        }
        return null;
    }

    @Override
    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object r) {
        if (r instanceof HRegion) {
            HashMap<HRegion, CompactionRequest> hashMap = this.regionsInQueue;
            synchronized (hashMap) {
                return this.regionsInQueue.containsKey((HRegion)r);
            }
        }
        if (r instanceof CompactionRequest) {
            return this.queue.contains(r);
        }
        return false;
    }

    @Override
    public HRegion element() {
        CompactionRequest cr = (CompactionRequest)this.queue.element();
        return cr != null ? cr.getHRegion() : null;
    }

    @Override
    public HRegion peek() {
        CompactionRequest cr = (CompactionRequest)this.queue.peek();
        return cr != null ? cr.getHRegion() : null;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.regionsInQueue.clear();
        this.queue.clear();
    }

    @Override
    public Iterator<HRegion> iterator() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends HRegion> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int drainTo(Collection<? super HRegion> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int drainTo(Collection<? super HRegion> c, int maxElements) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private class CompactionRequest
    implements Comparable<CompactionRequest> {
        private final HRegion r;
        private final int p;
        private final Long timeInNanos;

        public CompactionRequest(HRegion r, int p) {
            this(r, p, null);
        }

        public CompactionRequest(HRegion r, int p, Long time) {
            if (r == null) {
                throw new NullPointerException("HRegion cannot be null");
            }
            if (time == null) {
                time = System.nanoTime();
            }
            this.r = r;
            this.p = p;
            this.timeInNanos = time;
        }

        @Override
        public int compareTo(CompactionRequest request) {
            if (this.equals(request)) {
                return 0;
            }
            int compareVal = this.p - request.p;
            if (compareVal != 0) {
                return compareVal;
            }
            compareVal = this.timeInNanos.compareTo(request.timeInNanos);
            if (compareVal != 0) {
                return compareVal;
            }
            return -1;
        }

        HRegion getHRegion() {
            return this.r;
        }

        int getPriority() {
            return this.p;
        }

        public String toString() {
            return "regionName=" + this.r.getRegionNameAsString() + ", priority=" + this.p + ", time=" + this.timeInNanos;
        }
    }
}

