/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.metrics.RESTMetrics;

public class RESTServlet
implements Constants {
    private static RESTServlet INSTANCE;
    private final Configuration conf;
    private final HTablePool pool;
    private final RESTMetrics metrics;
    private final HBaseAdmin admin;

    public static synchronized RESTServlet getInstance() throws IOException {
        assert (INSTANCE != null);
        return INSTANCE;
    }

    public static synchronized RESTServlet getInstance(Configuration conf) throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new RESTServlet(conf);
        }
        return INSTANCE;
    }

    public static synchronized void stop() {
        if (INSTANCE != null) {
            INSTANCE = null;
        }
    }

    RESTServlet(Configuration conf) throws IOException {
        this.conf = conf;
        this.pool = new HTablePool(conf, 10);
        this.metrics = new RESTMetrics();
        this.admin = new HBaseAdmin(conf);
    }

    HTablePool getTablePool() {
        return this.pool;
    }

    Configuration getConfiguration() {
        return this.conf;
    }

    RESTMetrics getMetrics() {
        return this.metrics;
    }

    public HBaseAdmin getAdmin() {
        return this.admin;
    }

    boolean isReadOnly() {
        return this.getConfiguration().getBoolean("hbase.rest.readonly", false);
    }
}

