/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.io.Writable;
import org.apache.zookeeper.KeeperException;

public class HBaseFsckRepair {
    public static final Log LOG = LogFactory.getLog(HBaseFsckRepair.class);

    public static void fixMultiAssignment(HBaseAdmin admin, HRegionInfo region, List<HServerAddress> servers) throws IOException, KeeperException, InterruptedException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        for (HServerAddress server : servers) {
            HBaseFsckRepair.closeRegionSilentlyAndWait(admin, server, actualRegion);
        }
        HBaseFsckRepair.forceOfflineInZK(admin, actualRegion);
    }

    public static void fixUnassigned(HBaseAdmin admin, HRegionInfo region) throws IOException, KeeperException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        HBaseFsckRepair.forceOfflineInZK(admin, actualRegion);
    }

    private static void forceOfflineInZK(HBaseAdmin admin, final HRegionInfo region) throws ZooKeeperConnectionException, KeeperException, IOException {
        HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(admin.getConfiguration()){

            @Override
            public Void connect(HConnection connection) throws IOException {
                try {
                    ZKAssign.createOrForceNodeOffline(connection.getZooKeeperWatcher(), region, "HBCKServerName");
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
                return null;
            }
        });
    }

    public static void waitUntilAssigned(HBaseAdmin admin, HRegionInfo region) throws IOException, InterruptedException {
        long timeout = admin.getConfiguration().getLong("hbase.hbck.assign.timeout", 120000L);
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            try {
                Map<String, AssignmentManager.RegionState> rits = admin.getClusterStatus().getRegionsInTransition();
                if (rits.keySet() != null && !rits.keySet().contains(region.getEncodedName())) {
                    return;
                }
                LOG.info((Object)("Region still in transition, waiting for it to become assigned: " + (Object)((Object)region)));
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception when waiting for region to become assigned, retrying", (Throwable)e);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + (Object)((Object)region) + " failed to move out of " + "transition within timeout " + timeout + "ms");
    }

    public static void closeRegionSilentlyAndWait(HBaseAdmin admin, HServerAddress server, HRegionInfo region) throws IOException, InterruptedException {
        HConnection connection = admin.getConnection();
        HRegionInterface rs = connection.getHRegionConnection(server);
        rs.closeRegion(region, false);
        long timeout = admin.getConfiguration().getLong("hbase.hbck.close.timeout", 120000L);
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            try {
                HRegionInfo rsRegion = rs.getRegionInfo(region.getRegionName());
                if (rsRegion == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                return;
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + (Object)((Object)region) + " failed to close within" + " timeout " + timeout);
    }

    public static void fixMetaHoleOnline(Configuration conf, HRegionInfo hri) throws IOException {
        Put p = new Put(hri.getRegionName());
        p.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
        HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
        meta.put(p);
        meta.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixTableDesc(HBaseAdmin admin, HServerAddress hsa, HBaseFsck.HbckInfo hbi, HTableDescriptor htd, Path sidelineTableDir) throws IOException, KeeperException, InterruptedException {
        Path regionDir = hbi.getHdfsRegionDir();
        Path regioninfoPath = new Path(regionDir, ".regioninfo");
        Path sidelineRegionDir = new Path(sidelineTableDir, regionDir.getName());
        Path regioninfoSidelinePath = new Path(sidelineRegionDir, ".regioninfo");
        FileSystem fs = FileSystem.get((Configuration)admin.getConfiguration());
        fs.mkdirs(sidelineRegionDir);
        boolean success = fs.rename(regioninfoPath, regioninfoSidelinePath);
        if (!success) {
            String msg = "Unable to rename file " + regioninfoPath + " to " + regioninfoSidelinePath;
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        HRegionInfo hri = hbi.getHdfsHRI();
        hri.setTableDesc(htd);
        Path tmpDir = new Path(sidelineRegionDir, ".tmp");
        Path tmpPath = new Path(tmpDir, ".regioninfo");
        FSDataOutputStream out = fs.create(tmpPath, true);
        try {
            hri.write((DataOutput)out);
            out.write(10);
            out.write(10);
            out.write(Bytes.toBytes(hri.toString()));
        }
        finally {
            out.close();
        }
        if (!fs.rename(tmpPath, regioninfoPath)) {
            throw new IOException("Unable to rename " + tmpPath + " to " + regioninfoPath);
        }
        if (hsa != null) {
            HBaseFsckRepair.closeRegionSilentlyAndWait(admin, hsa, hri);
        }
        HBaseFsckRepair.forceOfflineInZK(admin, hri);
        HBaseFsckRepair.waitUntilAssigned(admin, hri);
    }

    public static HRegion createHDFSRegionDir(Configuration conf, HRegionInfo hri) throws IOException {
        Path root = FSUtils.getRootDir(conf);
        HRegion region = HRegion.createHRegion(hri, root, conf);
        HLog hlog = region.getLog();
        region.close();
        hlog.closeAndDelete();
        return region;
    }
}

