/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.io.MultipleIOException;

public class OfflineMetaRepair {
    private static final Log LOG = LogFactory.getLog((String)HBaseFsck.class.getName());

    protected static void printUsageAndExit() {
        System.err.println("Usage: OfflineMetaRepair [opts] ");
        System.err.println(" where [opts] are:");
        System.err.println("   -details          Display full report of all regions.");
        System.err.println("   -base <hdfs://>   Base Hbase Data directory");
        Runtime.getRuntime().exit(-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("fs.defaultFS", conf.get("hbase.rootdir"));
        conf.set("fs.default.name", conf.get("hbase.rootdir"));
        HBaseFsck fsck = new HBaseFsck(conf);
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.equals("-details")) {
                fsck.setDisplayFullReport();
                continue;
            }
            if (cmd.equals("-base")) {
                String path = args[++i];
                conf.set("hbase.rootdir", path);
                conf.set("fs.defaultFS", conf.get("hbase.rootdir"));
                conf.set("fs.default.name", conf.get("hbase.rootdir"));
                continue;
            }
            String str = "Unknown command line option : " + cmd;
            LOG.info((Object)str);
            System.out.println(str);
            OfflineMetaRepair.printUsageAndExit();
        }
        boolean success = false;
        try {
            success = fsck.rebuildMeta();
            System.exit(success ? 0 : 1);
        }
        catch (MultipleIOException mioes) {
            for (IOException ioe : mioes.getExceptions()) {
                LOG.error((Object)"Bailed out due to:", (Throwable)ioe);
            }
            System.exit(success ? 0 : 1);
        }
        catch (Exception e) {
            LOG.error((Object)"Bailed out due to: ", (Throwable)e);
            System.exit(success ? 0 : 1);
            {
                catch (Throwable throwable) {
                    System.exit(success ? 0 : 1);
                    throw throwable;
                }
            }
        }
    }
}

