/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.tmpl.common;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hbase.tmpl.common.TaskMonitorTmpl;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TaskMonitorTmplImpl
extends AbstractTemplateImpl
implements TaskMonitorTmpl.Intf {
    private final TaskMonitor taskMonitor;

    protected static TaskMonitorTmpl.ImplData __jamon_setOptionalArguments(TaskMonitorTmpl.ImplData p_implData) {
        if (!p_implData.getTaskMonitor__IsNotDefault()) {
            p_implData.setTaskMonitor(TaskMonitor.get());
        }
        return p_implData;
    }

    public TaskMonitorTmplImpl(TemplateManager p_templateManager, TaskMonitorTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TaskMonitorTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.taskMonitor = p_implData.getTaskMonitor();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        long now = System.currentTimeMillis();
        List<MonitoredTask> tasks = this.taskMonitor.getTasks();
        Collections.reverse(tasks);
        jamonWriter.write("<h2>Currently running tasks</h2>\n\n");
        if (tasks.isEmpty()) {
            jamonWriter.write("\nNo tasks currently running on this node.\n");
        } else {
            jamonWriter.write("\n\n<table>\n<tr>\n  <th>Description</th>\n  <th>Status</th>\n  <th>Age</th>\n</tr>\n");
            for (MonitoredTask task : tasks) {
                jamonWriter.write("\n<tr class=\"task-monitor-");
                Escaping.HTML.write(StandardEmitter.valueOf((Object)((Object)task.getState())), jamonWriter);
                jamonWriter.write("\">\n  <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)task.getDescription()), jamonWriter);
                jamonWriter.write("</td>\n  </td>\n  <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)task.getStatus()), jamonWriter);
                jamonWriter.write("</td>\n  <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)((int)((now - task.getStartTime()) / 1000L))), jamonWriter);
                jamonWriter.write("s  \n  ");
                if (task.getCompletionTimestamp() != -1L) {
                    jamonWriter.write("\n  (Completed ");
                    Escaping.HTML.write(StandardEmitter.valueOf((long)((now - task.getCompletionTimestamp()) / 1000L)), jamonWriter);
                    jamonWriter.write("s ago)\n  ");
                }
                jamonWriter.write("\n  </td>\n</tr>\n");
            }
            jamonWriter.write("\n</table>\n\n");
        }
    }
}

