/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.userroledao;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.pentaho.platform.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.engine.security.userroledao.IPentahoUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PentahoUser
implements IPentahoUser {
    private static final long serialVersionUID = 3647003745944124252L;
    private static final String FIELD_ENABLED = "enabled";
    private static final String PASSWORD_MASK = "[PROTECTED]";
    private static final String FIELD_PASSWORD = "password";
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_DESCRIPTION = "description";
    private String username;
    private String password;
    private String description;
    private boolean enabled = true;
    private Set<IPentahoRole> roles = new HashSet<IPentahoRole>();

    protected PentahoUser() {
    }

    public PentahoUser(String username) {
        this(username, null, null, true);
    }

    public PentahoUser(String username, String password, String description, boolean enabled) {
        this.username = username;
        this.password = password;
        this.description = description;
        this.enabled = enabled;
    }

    public PentahoUser(IPentahoUser userToCopy) {
        this.username = userToCopy.getUsername();
        this.description = userToCopy.getDescription();
        this.enabled = userToCopy.isEnabled();
        this.roles = new HashSet<IPentahoRole>(userToCopy.getRoles());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setRoles(Set<IPentahoRole> roles) {
        this.roles = roles;
    }

    @Override
    public Set<IPentahoRole> getRoles() {
        return this.roles;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PentahoUser)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PentahoUser rhs = (PentahoUser)obj;
        return new EqualsBuilder().append((Object)this.username, (Object)rhs.username).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(71, 223).append((Object)this.username).toHashCode();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(FIELD_USERNAME, (Object)this.username).append(FIELD_PASSWORD, (Object)PASSWORD_MASK).append(FIELD_DESCRIPTION, (Object)this.description).append(FIELD_ENABLED, this.enabled).toString();
    }

    @Override
    public boolean addRole(IPentahoRole role) {
        return this.roles.add(role);
    }

    @Override
    public boolean removeRole(IPentahoRole role) {
        return this.roles.remove(role);
    }

    @Override
    public void clearRoles() {
        this.roles.clear();
    }
}

