/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.userroledao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.pentaho.platform.engine.security.userroledao.AlreadyExistsException;
import org.pentaho.platform.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.engine.security.userroledao.NotFoundException;
import org.pentaho.platform.engine.security.userroledao.PentahoRole;
import org.pentaho.platform.engine.security.userroledao.PentahoUser;
import org.pentaho.platform.engine.security.userroledao.PentahoUserRoleMapping;
import org.pentaho.platform.engine.security.userroledao.UncategorizedUserRoleDaoException;
import org.pentaho.platform.engine.security.userroledao.messages.Messages;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateUserRoleDao
extends HibernateDaoSupport
implements IUserRoleDao {
    public static final String DEFAULT_ALL_USERS_QUERY = "from PentahoUser order by username";
    public static final String DEFAULT_ALL_ROLES_QUERY = "from PentahoRole order by name";
    private String allUsersQuery = "from PentahoUser order by username";
    private String allRolesQuery = "from PentahoRole order by name";
    private InitHandler initHandler;

    public void init() {
        if (this.initHandler != null) {
            this.initHandler.handleInit();
        }
    }

    @Override
    public void createUser(IPentahoUser userToCreate) throws AlreadyExistsException, UncategorizedUserRoleDaoException {
        Assert.notNull((Object)userToCreate, (String)Messages.getString("HibernateUserRoleDao.ERROR_0001_USER_CANNOT_BE_NULL"));
        Assert.hasLength((String)userToCreate.getUsername(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0002_USERNAME_CANNOT_BE_BLANK"));
        Assert.notNull((Object)userToCreate.getPassword(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0003_PASSWORD_CANNOT_BE_NULL"));
        if (this.getUser(userToCreate.getUsername()) == null) {
            try {
                this.getHibernateTemplate().save((Object)userToCreate);
            }
            catch (DataAccessException e) {
                throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
            }
        } else {
            throw new AlreadyExistsException(userToCreate.getUsername());
        }
    }

    @Override
    public void deleteUser(IPentahoUser userToDelete) throws NotFoundException, UncategorizedUserRoleDaoException {
        Assert.notNull((Object)userToDelete, (String)Messages.getString("HibernateUserRoleDao.ERROR_0001_USER_CANNOT_BE_NULL"));
        Assert.hasLength((String)userToDelete.getUsername(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0002_USERNAME_CANNOT_BE_BLANK"));
        IPentahoUser user = this.getUser(userToDelete.getUsername());
        if (user != null) {
            try {
                this.getHibernateTemplate().delete((Object)user);
            }
            catch (DataAccessException e) {
                throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
            }
        } else {
            throw new NotFoundException(userToDelete.getUsername());
        }
    }

    @Override
    public IPentahoUser getUser(String username) throws UncategorizedUserRoleDaoException {
        Assert.hasLength((String)username, (String)Messages.getString("HibernateUserRoleDao.ERROR_0002_USERNAME_CANNOT_BE_BLANK"));
        try {
            return (PentahoUser)this.getHibernateTemplate().get(PentahoUser.class, (Serializable)((Object)username));
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
        }
    }

    @Override
    public List<IPentahoUser> getUsers() throws UncategorizedUserRoleDaoException {
        try {
            return this.getHibernateTemplate().find(this.getAllUsersQuery());
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
        }
    }

    @Override
    public void updateUser(IPentahoUser userToUpdate) throws NotFoundException, UncategorizedUserRoleDaoException {
        Assert.notNull((Object)userToUpdate, (String)Messages.getString("HibernateUserRoleDao.ERROR_0001_USER_CANNOT_BE_NULL"));
        Assert.hasLength((String)userToUpdate.getUsername(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0002_USERNAME_CANNOT_BE_BLANK"));
        Assert.notNull((Object)userToUpdate.getPassword(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0003_PASSWORD_CANNOT_BE_NULL"));
        if (this.getUser(userToUpdate.getUsername()) != null) {
            try {
                this.getHibernateTemplate().update(this.getHibernateTemplate().merge((Object)userToUpdate));
            }
            catch (DataAccessException e) {
                throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
            }
        } else {
            throw new NotFoundException(userToUpdate.getUsername());
        }
    }

    @Override
    public void createRole(IPentahoRole roleToCreate) throws AlreadyExistsException, UncategorizedUserRoleDaoException {
        Assert.notNull((Object)roleToCreate, (String)Messages.getString("HibernateUserRoleDao.ERROR_0005_ROLE_CANNOT_BE_NULL"));
        Assert.hasLength((String)roleToCreate.getName(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0006_ROLE_NAME_CANNOT_BE_BLANK"));
        if (this.getRole(roleToCreate.getName()) == null) {
            try {
                this.getHibernateTemplate().save((Object)roleToCreate);
            }
            catch (DataAccessException e) {
                throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
            }
        } else {
            throw new AlreadyExistsException(roleToCreate.getName());
        }
        for (IPentahoUser user : roleToCreate.getUsers()) {
            this.addUser(roleToCreate, user.getUsername());
        }
    }

    @Override
    public void deleteRole(IPentahoRole roleToDelete) throws NotFoundException, UncategorizedUserRoleDaoException {
        Assert.notNull((Object)roleToDelete, (String)Messages.getString("HibernateUserRoleDao.ERROR_0005_ROLE_CANNOT_BE_NULL"));
        Assert.hasLength((String)roleToDelete.getName(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0006_ROLE_NAME_CANNOT_BE_BLANK"));
        IPentahoRole role = this.getRole(roleToDelete.getName());
        if (role != null) {
            try {
                for (IPentahoUser user : role.getUsers()) {
                    user.removeRole(role);
                    this.updateUser(user);
                }
                this.getHibernateTemplate().delete((Object)role);
            }
            catch (DataAccessException e) {
                throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
            }
        } else {
            throw new NotFoundException(roleToDelete.getName());
        }
    }

    @Override
    public IPentahoRole getRole(String name) throws UncategorizedUserRoleDaoException {
        Assert.hasLength((String)name, (String)Messages.getString("HibernateUserRoleDao.ERROR_0006_ROLE_NAME_CANNOT_BE_BLANK"));
        try {
            PentahoRole role = (PentahoRole)this.getHibernateTemplate().get(PentahoRole.class, (Serializable)((Object)name));
            if (role == null) {
                return null;
            }
            List<IPentahoUser> users = this.getUsersForRole(role.getName());
            for (IPentahoUser user : users) {
                role.addUser(user);
            }
            return role;
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
        }
    }

    @Override
    public List<IPentahoRole> getRoles() throws UncategorizedUserRoleDaoException {
        try {
            List roles = this.getHibernateTemplate().find(this.getAllRolesQuery());
            for (IPentahoRole role : roles) {
                List<IPentahoUser> users = this.getUsersForRole(role.getName());
                for (IPentahoUser user : users) {
                    role.addUser(user);
                }
            }
            return roles;
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
        }
    }

    protected List<IPentahoUser> getUsersForRole(String role) throws UncategorizedUserRoleDaoException {
        try {
            ArrayList<IPentahoUser> users = new ArrayList<IPentahoUser>();
            List mappings = this.getHibernateTemplate().find("from PentahoUserRoleMapping as m where m.id.role = ?", (Object)role);
            for (PentahoUserRoleMapping mapping : mappings) {
                users.add(this.getUser(mapping.getId().getUser()));
            }
            return users;
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
        }
    }

    @Override
    public void updateRole(IPentahoRole roleToUpdate) throws NotFoundException, UncategorizedUserRoleDaoException {
        Assert.notNull((Object)roleToUpdate, (String)Messages.getString("HibernateUserRoleDao.ERROR_0005_ROLE_CANNOT_BE_NULL"));
        Assert.hasLength((String)roleToUpdate.getName(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0006_ROLE_NAME_CANNOT_BE_BLANK"));
        IPentahoRole originalRole = this.getRole(roleToUpdate.getName());
        if (originalRole == null) {
            throw new NotFoundException(roleToUpdate.getName());
        }
        HashSet<IPentahoUser> originalRoleUsers = new HashSet<IPentahoUser>(originalRole.getUsers());
        try {
            this.getHibernateTemplate().update(this.getHibernateTemplate().merge((Object)roleToUpdate));
        }
        catch (DataAccessException e) {
            throw new UncategorizedUserRoleDaoException(Messages.getString("HibernateUserRoleDao.ERROR_0004_DATA_ACCESS_EXCEPTION"), e);
        }
        HashSet usersToAdd = new HashSet(CollectionUtils.subtract(roleToUpdate.getUsers(), originalRoleUsers));
        HashSet usersToRemove = new HashSet(CollectionUtils.subtract(originalRoleUsers, roleToUpdate.getUsers()));
        for (IPentahoUser user : usersToAdd) {
            this.addUser(roleToUpdate, user.getUsername());
        }
        for (IPentahoUser user : usersToRemove) {
            this.removeUser(roleToUpdate, user.getUsername());
        }
    }

    protected void addUser(IPentahoRole roleToUpdate, String username) throws NotFoundException, UncategorizedUserRoleDaoException {
        Assert.notNull((Object)roleToUpdate, (String)Messages.getString("HibernateUserRoleDao.ERROR_0005_ROLE_CANNOT_BE_NULL"));
        Assert.hasLength((String)roleToUpdate.getName(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0006_ROLE_NAME_CANNOT_BE_BLANK"));
        Assert.hasLength((String)username, (String)Messages.getString("HibernateUserRoleDao.ERROR_0002_USERNAME_CANNOT_BE_BLANK"));
        IPentahoUser user = this.getUser(username);
        if (user == null) {
            throw new NotFoundException(username);
        }
        user.addRole(roleToUpdate);
        this.updateUser(user);
    }

    protected void removeUser(IPentahoRole roleToUpdate, String username) throws NotFoundException, UncategorizedUserRoleDaoException {
        Assert.notNull((Object)roleToUpdate, (String)Messages.getString("HibernateUserRoleDao.ERROR_0005_ROLE_CANNOT_BE_NULL"));
        Assert.hasLength((String)roleToUpdate.getName(), (String)Messages.getString("HibernateUserRoleDao.ERROR_0006_ROLE_NAME_CANNOT_BE_BLANK"));
        Assert.hasLength((String)username, (String)Messages.getString("HibernateUserRoleDao.ERROR_0002_USERNAME_CANNOT_BE_BLANK"));
        IPentahoUser user = this.getUser(username);
        if (user == null) {
            throw new NotFoundException(username);
        }
        user.removeRole(roleToUpdate);
        this.updateUser(user);
    }

    public void setAllUsersQuery(String allUsersQuery) {
        Assert.hasLength((String)allUsersQuery, (String)Messages.getString("HibernateUserRoleDao.ERROR_0007_ALL_USERS_QUERY_CANNOT_BE_BLANK"));
        this.allUsersQuery = allUsersQuery;
    }

    public String getAllUsersQuery() {
        return this.allUsersQuery;
    }

    public void setAllRolesQuery(String allRolesQuery) {
        Assert.hasLength((String)this.allUsersQuery, (String)Messages.getString("HibernateUserRoleDao.ERROR_0008_ALL_ROLES_QUERY_CANNOT_BE_BLANK"));
        this.allRolesQuery = allRolesQuery;
    }

    public String getAllRolesQuery() {
        return this.allRolesQuery;
    }

    public void setInitHandler(InitHandler initHandler) {
        this.initHandler = initHandler;
    }

    public static interface InitHandler {
        public void handleInit();
    }
}

