/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.userroledao.hibernate;

import java.util.List;
import org.pentaho.platform.engine.security.userroledao.AlreadyExistsException;
import org.pentaho.platform.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.engine.security.userroledao.NotFoundException;
import org.pentaho.platform.engine.security.userroledao.UncategorizedUserRoleDaoException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserRoleDaoTransactionDecorator
implements IUserRoleDao {
    private TransactionTemplate transactionTemplate;
    private IUserRoleDao userRoleDao;

    @Override
    public void createRole(final IPentahoRole roleToCreate) throws AlreadyExistsException, UncategorizedUserRoleDaoException {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                UserRoleDaoTransactionDecorator.this.userRoleDao.createRole(roleToCreate);
            }
        });
    }

    @Override
    public void createUser(final IPentahoUser userToCreate) throws AlreadyExistsException, UncategorizedUserRoleDaoException {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                UserRoleDaoTransactionDecorator.this.userRoleDao.createUser(userToCreate);
            }
        });
    }

    @Override
    public void deleteRole(final IPentahoRole roleToDelete) throws NotFoundException, UncategorizedUserRoleDaoException {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                UserRoleDaoTransactionDecorator.this.userRoleDao.deleteRole(roleToDelete);
            }
        });
    }

    @Override
    public void deleteUser(final IPentahoUser userToDelete) throws NotFoundException, UncategorizedUserRoleDaoException {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                UserRoleDaoTransactionDecorator.this.userRoleDao.deleteUser(userToDelete);
            }
        });
    }

    @Override
    public IPentahoRole getRole(final String name) throws UncategorizedUserRoleDaoException {
        return (IPentahoRole)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return UserRoleDaoTransactionDecorator.this.userRoleDao.getRole(name);
            }
        });
    }

    @Override
    public List<IPentahoRole> getRoles() throws UncategorizedUserRoleDaoException {
        return (List)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return UserRoleDaoTransactionDecorator.this.userRoleDao.getRoles();
            }
        });
    }

    @Override
    public IPentahoUser getUser(final String username) throws UncategorizedUserRoleDaoException {
        return (IPentahoUser)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return UserRoleDaoTransactionDecorator.this.userRoleDao.getUser(username);
            }
        });
    }

    @Override
    public List<IPentahoUser> getUsers() throws UncategorizedUserRoleDaoException {
        return (List)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                return UserRoleDaoTransactionDecorator.this.userRoleDao.getUsers();
            }
        });
    }

    @Override
    public void updateRole(final IPentahoRole roleToUpdate) throws NotFoundException, UncategorizedUserRoleDaoException {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                UserRoleDaoTransactionDecorator.this.userRoleDao.updateRole(roleToUpdate);
            }
        });
    }

    @Override
    public void updateUser(final IPentahoUser userToUpdate) throws NotFoundException, UncategorizedUserRoleDaoException {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                UserRoleDaoTransactionDecorator.this.userRoleDao.updateUser(userToUpdate);
            }
        });
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setUserRoleDao(IUserRoleDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }
}

