/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.userroledao.hibernate.sample;

import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.pentaho.platform.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.engine.security.userroledao.PentahoRole;
import org.pentaho.platform.engine.security.userroledao.PentahoUser;
import org.pentaho.platform.engine.security.userroledao.UncategorizedUserRoleDaoException;
import org.pentaho.platform.engine.security.userroledao.hibernate.HibernateUserRoleDao;
import org.pentaho.platform.engine.security.userroledao.messages.Messages;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class SampleUsersAndRolesInitHandler
extends HibernateDaoSupport
implements HibernateUserRoleDao.InitHandler {
    private IUserRoleDao userRoleDao;

    public void handleInit() {
        try {
            boolean hasUsers = this.hasUsers();
            if (!hasUsers) {
                PentahoRole adminRole = new PentahoRole("Admin", "Super User");
                PentahoRole anonymous = new PentahoRole("Anonymous", "User has not logged in");
                PentahoRole authenticated = new PentahoRole("Authenticated", "User has logged in");
                PentahoRole ceo = new PentahoRole("ceo", "Chief Executive Officer");
                PentahoRole cto = new PentahoRole("cto", "Chief Technology Officer");
                PentahoRole dev = new PentahoRole("dev", "Developer");
                PentahoRole devMgr = new PentahoRole("devmgr", "Development Manager");
                PentahoRole is = new PentahoRole("is", "Information Services");
                this.userRoleDao.createRole(adminRole);
                this.userRoleDao.createRole(anonymous);
                this.userRoleDao.createRole(authenticated);
                this.userRoleDao.createRole(ceo);
                this.userRoleDao.createRole(cto);
                this.userRoleDao.createRole(dev);
                this.userRoleDao.createRole(devMgr);
                this.userRoleDao.createRole(is);
                PentahoUser admin = new PentahoUser("admin", "c2VjcmV0", null, true);
                admin.addRole(adminRole);
                admin.addRole(authenticated);
                PentahoUser joe = new PentahoUser("joe", "cGFzc3dvcmQ=", null, true);
                joe.addRole(adminRole);
                joe.addRole(ceo);
                joe.addRole(authenticated);
                PentahoUser pat = new PentahoUser("pat", "cGFzc3dvcmQ=", null, true);
                pat.addRole(dev);
                pat.addRole(authenticated);
                PentahoUser suzy = new PentahoUser("suzy", "cGFzc3dvcmQ=", null, true);
                suzy.addRole(cto);
                suzy.addRole(is);
                suzy.addRole(authenticated);
                PentahoUser tiffany = new PentahoUser("tiffany", "cGFzc3dvcmQ=", null, true);
                tiffany.addRole(dev);
                tiffany.addRole(devMgr);
                tiffany.addRole(authenticated);
                this.userRoleDao.createUser(admin);
                this.userRoleDao.createUser(joe);
                this.userRoleDao.createUser(pat);
                this.userRoleDao.createUser(suzy);
                this.userRoleDao.createUser(tiffany);
            }
        }
        catch (UncategorizedUserRoleDaoException e) {
            this.logger.error((Object)Messages.getString("SampleUsersAndRolesInitHandler.ERROR_0001_COULD_NOT_INSERT_SAMPLES"), (Throwable)e);
        }
    }

    protected boolean hasUsers() {
        Long count = (Long)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("select count(*) from PentahoUser");
                return query.iterate().next();
            }
        });
        return count > 0L;
    }

    public void setUserRoleDao(IUserRoleDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }
}

