/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.userroledao.userdetailsservice;

import java.util.Arrays;
import java.util.List;
import org.pentaho.platform.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.engine.security.userroledao.UncategorizedUserRoleDaoException;
import org.pentaho.platform.engine.security.userroledao.messages.Messages;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class UserRoleDaoUserDetailsService
implements UserDetailsService {
    private String rolePrefix = "";
    private IUserRoleDao userRoleDao;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        IPentahoUser user;
        boolean ACCOUNT_NON_EXPIRED = true;
        boolean CREDS_NON_EXPIRED = true;
        boolean ACCOUNT_NON_LOCKED = true;
        try {
            user = this.userRoleDao.getUser(username);
        }
        catch (UncategorizedUserRoleDaoException e) {
            throw new UserRoleDaoUserDetailsServiceException(Messages.getString("UserRoleDaoUserDetailsService.ERROR_0003_DATA_ACCESS_EXCEPTION"), e);
        }
        if (user == null) {
            throw new UsernameNotFoundException(Messages.getString("UserRoleDaoUserDetailsService.ERROR_0001_USER_NOT_FOUND"));
        }
        int authsSize = user.getRoles() != null ? user.getRoles().size() : 0;
        GrantedAuthority[] auths = new GrantedAuthority[authsSize];
        int i = 0;
        for (IPentahoRole role : user.getRoles()) {
            auths[i++] = new GrantedAuthorityImpl(this.rolePrefix + role.getName());
        }
        List<GrantedAuthority> dbAuths = Arrays.asList(auths);
        this.addCustomAuthorities(user.getUsername(), dbAuths);
        if (dbAuths.size() == 0) {
            throw new UsernameNotFoundException(Messages.getString("UserRoleDaoUserDetailsService.ERROR_0002_NO_AUTHORITIES"));
        }
        GrantedAuthority[] arrayAuths = dbAuths.toArray(new GrantedAuthority[dbAuths.size()]);
        return new User(user.getUsername(), user.getPassword(), user.isEnabled(), true, true, true, arrayAuths);
    }

    protected void addCustomAuthorities(String username, List authorities) {
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix == null ? "" : rolePrefix;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setUserRoleDao(IUserRoleDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }

    protected class UserRoleDaoUserDetailsServiceException
    extends DataAccessException {
        private static final long serialVersionUID = -3598806635515478946L;

        public UserRoleDaoUserDetailsServiceException(String msg) {
            super(msg);
        }

        public UserRoleDaoUserDetailsServiceException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

