/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security.userroledao.userrolelistservice;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.engine.security.userroledao.IUserRoleDao;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class UserRoleDaoUserRoleListService
implements IUserRoleListService {
    private IUserRoleDao userRoleDao;
    private UserDetailsService userDetailsService;

    public GrantedAuthority[] getAllAuthorities() {
        List<IPentahoRole> roles = this.userRoleDao.getRoles();
        ArrayList<GrantedAuthorityImpl> auths = new ArrayList<GrantedAuthorityImpl>();
        for (IPentahoRole role : roles) {
            auths.add(new GrantedAuthorityImpl(role.getName()));
        }
        return auths.toArray(new GrantedAuthority[0]);
    }

    public String[] getAllUsernames() {
        List<IPentahoUser> users = this.userRoleDao.getUsers();
        ArrayList<String> usernames = new ArrayList<String>();
        for (IPentahoUser user : users) {
            usernames.add(user.getUsername());
        }
        return usernames.toArray(new String[0]);
    }

    public GrantedAuthority[] getAuthoritiesForUser(String username) throws UsernameNotFoundException, DataAccessException {
        UserDetails user = this.userDetailsService.loadUserByUsername(username);
        return user.getAuthorities();
    }

    public String[] getUsernamesInRole(GrantedAuthority authority) {
        IPentahoRole role = this.userRoleDao.getRole(authority.getAuthority());
        if (role == null) {
            String[] rtn = new String[]{};
            return rtn;
        }
        ArrayList<String> usernames = new ArrayList<String>();
        for (IPentahoUser user : role.getUsers()) {
            usernames.add(user.getUsername());
        }
        return usernames.toArray(new String[0]);
    }

    public void setUserRoleDao(IUserRoleDao userRoleDao) {
        this.userRoleDao = userRoleDao;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

