/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.builtin;

import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IContentRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;

public class ContentRepositoryCleaner
extends ComponentBase {
    private static final long serialVersionUID = 1L;
    private static final String AGE = "days_old";
    private static final String DELETE_COUNT = "delete_count";

    protected boolean validateAction() {
        return this.isDefinedInput(AGE);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public void done() {
    }

    protected boolean executeAction() throws Throwable {
        int daysBack = Integer.parseInt(this.getInputValue(AGE).toString());
        daysBack = Math.abs(daysBack) * -1;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, daysBack);
        Date agedDate = new Date(calendar.getTimeInMillis());
        IContentRepository contentRepository = (IContentRepository)PentahoSystem.get(IContentRepository.class, (IPentahoSession)this.getSession());
        int deleteCount = contentRepository.deleteContentOlderThanDate(agedDate);
        this.setOutputValue(DELETE_COUNT, Integer.toString(deleteCount));
        OutputStream feedbackOutputStream = this.getFeedbackOutputStream();
        if (feedbackOutputStream != null) {
            feedbackOutputStream.write(Messages.getString("ContentRepositoryCleaner.INFO_0001").getBytes());
            feedbackOutputStream.write(Integer.toString(deleteCount).getBytes());
            feedbackOutputStream.write(Messages.getString("ContentRepositoryCleaner.INFO_0002").getBytes());
            feedbackOutputStream.write(Integer.toString(Math.abs(daysBack)).getBytes());
            feedbackOutputStream.write(Messages.getString("ContentRepositoryCleaner.INFO_0003").getBytes());
        }
        return true;
    }

    public boolean init() {
        return true;
    }

    public Log getLogger() {
        return LogFactory.getLog(ContentRepositoryCleaner.class);
    }
}

