/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.builtin;

import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.actions.EmailAction;
import org.pentaho.actionsequence.dom.actions.EmailAttachment;
import org.pentaho.commons.connection.ActivationHelper;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.IPasswordService;
import org.pentaho.platform.api.util.PasswordServiceException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class EmailComponent
extends ComponentBase {
    private static final long serialVersionUID = 1584906077946023715L;
    private String defaultFrom;
    private static final String MAILER = "smtpsend";

    public Log getLogger() {
        return LogFactory.getLog(EmailComponent.class);
    }

    protected boolean validateSystemSettings() {
        boolean ok;
        String mailhost = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.smtp.host", null);
        boolean authenticate = "true".equalsIgnoreCase(PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.smtp.auth", (String)"false"));
        String user = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.userid", (String)"");
        String password = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.password", (String)"");
        this.defaultFrom = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.from.default", (String)"");
        if (mailhost.equals("") || user.equals("") && authenticate || this.defaultFrom.equals("")) {
            boolean allowParameterUI = this.feedbackAllowed();
            if (allowParameterUI) {
                OutputStream feedbackStream = this.getFeedbackOutputStream();
                StringBuffer messageBuffer = new StringBuffer();
                ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)this.getSession())).formatErrorMessage("text/html", Messages.getString("Email.USER_COULD_NOT_SEND_EMAIL"), Messages.getString("Email.USER_SETTINGS_HELP"), messageBuffer);
                try {
                    feedbackStream.write(messageBuffer.toString().getBytes(LocaleHelper.getSystemEncoding()));
                }
                catch (Exception e) {
                    this.error(Messages.getErrorString("Base.ERROR_0003_INVALID_FEEDBACK_STREAM"), e);
                    return false;
                }
                return false;
            }
            this.error(Messages.getErrorString("Email.ERROR_0009_SERVER_SETTINGS_NOT_SET"));
            return false;
        }
        boolean bl = ok = mailhost != null;
        if (authenticate) {
            ok &= user != null && password != null;
        }
        return ok &= this.defaultFrom != null;
    }

    public boolean init() {
        return true;
    }

    public boolean validateAction() {
        boolean result = true;
        if (!(this.getActionDefinition() instanceof EmailAction)) {
            this.error(Messages.getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", this.getActionDefinition().getElement().asXML()));
            result = false;
        } else {
            EmailAction emailAction = (EmailAction)this.getActionDefinition();
            IActionInput to = emailAction.getTo();
            IActionInput subject = emailAction.getSubject();
            IActionInput plainMsg = emailAction.getMessagePlain();
            IActionInput htmlMsg = emailAction.getMessageHtml();
            if (to == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getErrorString("Email.ERROR_0001_TO_NOT_DEFINED", this.getActionName()));
                result = false;
            } else if (subject == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getErrorString("Email.ERROR_0002_SUBJECT_NOT_DEFINED", this.getActionName()));
                result = false;
            } else if (plainMsg == ActionInputConstant.NULL_INPUT && htmlMsg == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getErrorString("Email.ERROR_0003_BODY_NOT_DEFINED", this.getActionName()));
                result = false;
            }
        }
        return result;
    }

    public boolean executeAction() {
        EmailAction emailAction = (EmailAction)this.getActionDefinition();
        String messagePlain = emailAction.getMessagePlain().getStringValue();
        String messageHtml = emailAction.getMessageHtml().getStringValue();
        String subject = emailAction.getSubject().getStringValue();
        String to = emailAction.getTo().getStringValue();
        String cc = emailAction.getCc().getStringValue();
        String bcc = emailAction.getBcc().getStringValue();
        String from = emailAction.getFrom().getStringValue(this.defaultFrom);
        if (from.trim().length() == 0) {
            from = this.defaultFrom;
        }
        this.debug(Messages.getString("Email.DEBUG_TO_FROM", to, from));
        this.debug(Messages.getString("Email.DEBUG_CC_BCC", cc, bcc));
        this.debug(Messages.getString("Email.DEBUG_SUBJECT", subject));
        this.debug(Messages.getString("Email.DEBUG_PLAIN_MESSAGE", messagePlain));
        this.debug(Messages.getString("Email.DEBUG_HTML_MESSAGE", messageHtml));
        if (to == null || to.trim().length() == 0) {
            OutputStream feedbackStream = this.getFeedbackOutputStream();
            if (feedbackStream != null) {
                this.createFeedbackParameter("to", Messages.getString("Email.USER_ENTER_EMAIL_ADDRESS"), "", "", true);
                this.setFeedbackMimeType("text/html");
                return true;
            }
            return false;
        }
        if (subject == null) {
            this.error(Messages.getErrorString("Email.ERROR_0005_NULL_SUBJECT", this.getActionName()));
            return false;
        }
        if (messagePlain == null && messageHtml == null) {
            this.error(Messages.getErrorString("Email.ERROR_0006_NULL_BODY", this.getActionName()));
            return false;
        }
        if (this.getRuntimeContext().isPromptPending()) {
            return true;
        }
        try {
            Session session;
            Properties props = new Properties();
            try {
                Document configDocument = PentahoSystem.getSystemSettings().getSystemSettingsDocument("smtp-email/email_config.xml");
                List properties = configDocument.selectNodes("/email-smtp/properties/*");
                for (Node propertyNode : properties) {
                    String propertyName = propertyNode.getName();
                    String propertyValue = propertyNode.getText();
                    props.put(propertyName, propertyValue);
                }
            }
            catch (Exception e) {
                this.error(Messages.getString("Email.ERROR_0013_CONFIG_FILE_INVALID"), e);
                return false;
            }
            boolean authenticate = "true".equalsIgnoreCase(props.getProperty("mail.smtp.auth"));
            if (authenticate) {
                EmailAuthenticator authenticator = new EmailAuthenticator();
                session = Session.getInstance((Properties)props, (Authenticator)authenticator);
            } else {
                session = Session.getInstance((Properties)props);
            }
            if (!props.containsKey("mail.debug")) {
                session.setDebug(true);
            }
            MimeMessage msg = new MimeMessage(session);
            if (from != null) {
                msg.setFrom((Address)new InternetAddress(from));
            } else {
                this.error(Messages.getString("Email.ERROR_0012_FROM_NOT_DEFINED"));
            }
            if (to != null && to.trim().length() > 0) {
                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            }
            if (cc != null && cc.trim().length() > 0) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc, (boolean)false));
            }
            if (bcc != null && bcc.trim().length() > 0) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc, (boolean)false));
            }
            if (subject != null) {
                msg.setSubject(subject, LocaleHelper.getSystemEncoding());
            }
            EmailAttachment[] emailAttachments = emailAction.getAttachments();
            if (messagePlain != null && messageHtml == null && emailAttachments.length == 0) {
                msg.setText(messagePlain, LocaleHelper.getSystemEncoding());
            } else if (emailAttachments.length == 0) {
                if (messagePlain != null) {
                    msg.setContent((Object)messagePlain, "text/plain; charset=" + LocaleHelper.getSystemEncoding());
                }
                if (messageHtml != null) {
                    msg.setContent((Object)messageHtml, "text/html; charset=" + LocaleHelper.getSystemEncoding());
                }
            } else {
                MimeMultipart multipart = new MimeMultipart();
                if (messageHtml != null) {
                    MimeBodyPart htmlBodyPart = new MimeBodyPart();
                    htmlBodyPart.setContent((Object)messageHtml, "text/html; charset=" + LocaleHelper.getSystemEncoding());
                    multipart.addBodyPart((BodyPart)htmlBodyPart);
                }
                if (messagePlain != null) {
                    MimeBodyPart textBodyPart = new MimeBodyPart();
                    textBodyPart.setContent((Object)messagePlain, "text/plain; charset=" + LocaleHelper.getSystemEncoding());
                    multipart.addBodyPart((BodyPart)textBodyPart);
                }
                for (EmailAttachment element : emailAttachments) {
                    IPentahoStreamSource source = element.getContent();
                    if (source == null) {
                        this.error(Messages.getErrorString("Email.ERROR_0015_ATTACHMENT_FAILED"));
                        return false;
                    }
                    ActivationHelper.PentahoStreamSourceWrapper dataSource = new ActivationHelper.PentahoStreamSourceWrapper(source);
                    String attachmentName = element.getName();
                    this.debug(Messages.getString("Email.DEBUG_ADDING_ATTACHMENT", attachmentName));
                    MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                    attachmentBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                    attachmentBodyPart.setFileName(attachmentName);
                    this.debug(Messages.getString("Email.DEBUG_ATTACHMENT_SOURCE", dataSource.getName()));
                    multipart.addBodyPart((BodyPart)attachmentBodyPart);
                }
                msg.setContent((Multipart)multipart);
            }
            msg.setHeader("X-Mailer", MAILER);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            this.debug(Messages.getString("Email.DEBUG_EMAIL_SUCCESS"));
            return true;
        }
        catch (SendFailedException e) {
            this.error(Messages.getErrorString("Email.ERROR_0011_SEND_FAILED", to), e);
        }
        catch (AuthenticationFailedException e) {
            this.error(Messages.getString("Email.ERROR_0014_AUTHENTICATION_FAILED", to), e);
        }
        catch (Throwable e) {
            this.error(Messages.getErrorString("Email.ERROR_0011_SEND_FAILED", to), e);
        }
        return false;
    }

    public void done() {
    }

    public String decryptPassword(String encpass) {
        if (encpass.startsWith("ENC:")) {
            IPasswordService passwordService = (IPasswordService)PentahoSystem.get(IPasswordService.class, null);
            String tmp = encpass.substring(4);
            try {
                return passwordService.decrypt(tmp);
            }
            catch (PasswordServiceException ex) {
                this.getLogger().error((Object)"Exception decrypting mail password", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return encpass;
    }

    private class EmailAuthenticator
    extends Authenticator {
        private EmailAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            String user = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.userid", null);
            String password = PentahoSystem.getSystemSetting((String)"smtp-email/email_config.xml", (String)"mail.password", null);
            if (password != null) {
                password = EmailComponent.this.decryptPassword(password);
            }
            return new PasswordAuthentication(user, password);
        }
    }
}

