/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.builtin;

import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.AWTRenderer;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.PrinterAction;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;

public class PrintComponent
extends ComponentBase {
    private static final long serialVersionUID = 7377566797214172734L;
    private static final String DEFAULT_PRINTER = "PENTAHO_DEFAULT_PRINTER";

    public Log getLogger() {
        return LogFactory.getLog(PrintComponent.class);
    }

    public boolean init() {
        return true;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        PrinterAction printerAction = null;
        boolean actionValidated = true;
        if (this.getActionDefinition() instanceof PrinterAction) {
            printerAction = (PrinterAction)this.getActionDefinition();
            if (printerAction.getPrintfile() == ActionInputConstant.NULL_INPUT && printerAction.getResourcesPrintFile() == null && printerAction.getReportOutput() == ActionInputConstant.NULL_INPUT && printerAction.getOutputPrinterName() == null) {
                actionValidated = false;
                this.error(Messages.getErrorString("PrintComponent.ERROR_0001_NO_PRINT_FILE_DEFINED") + this.getActionName());
            }
        } else {
            actionValidated = false;
            this.error(Messages.getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", this.getActionDefinition().getElement().asXML()));
        }
        return actionValidated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeAction() {
        String printFileName = null;
        IActionSequenceResource printFileResource = null;
        PrinterAction printAction = (PrinterAction)this.getActionDefinition();
        if (printAction.getPrintfile() != ActionInputConstant.NULL_INPUT) {
            printFileName = printAction.getPrintfile().getStringValue();
        } else if (printAction.getResourcesPrintFile() != null) {
            IActionResource tempResource = printAction.getResourcesPrintFile();
            printFileResource = this.getResource(tempResource.getName());
        }
        InputStream inStream = null;
        String printerName = printAction.getPrinterName().getStringValue(DEFAULT_PRINTER);
        String lastPrinter = printAction.getDefaultPrinter().getStringValue();
        if (printAction.getOutputPrinterName() != null && !printerName.equals("")) {
            IActionOutput output = printAction.getOutputPrinterName();
            output.setValue((Object)printerName);
            if (printAction.getOutputDefaultPrinter() != null) {
                IActionOutput defaultPrinterOutput = printAction.getOutputDefaultPrinter();
                defaultPrinterOutput.setValue((Object)printerName);
            }
            return true;
        }
        PrintService printer = this.getPrinterInternal(printerName, lastPrinter);
        if (printer == null) {
            if (!this.feedbackAllowed()) {
                this.error(Messages.getErrorString("PrintComponent.ERROR_0002_NO_SUITABLE_PRINTER"));
                return false;
            }
            return true;
        }
        if (printAction.getOutputDefaultPrinter() != null) {
            IActionOutput defaultPrinterOutput = printAction.getOutputDefaultPrinter();
            defaultPrinterOutput.setValue((Object)printerName);
        }
        int copies = printAction.getCopies().getIntValue(1);
        if (printFileName != null) {
            ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession());
            try {
                inStream = repository.getResourceInputStream(printFileName, true, 1);
            }
            catch (FileNotFoundException e) {
                return false;
            }
        } else if (printFileResource != null) {
            try {
                inStream = this.getResourceInputStream(printFileResource);
            }
            catch (FileNotFoundException e) {
                return false;
            }
        } else if (printAction.getReportOutput() != ActionInputConstant.NULL_INPUT) {
            inStream = this.getInputStream("report-output");
        } else {
            return false;
        }
        try {
            try {
                FopFactory fopFactory = FopFactory.newInstance();
                FOUserAgent userAgent = fopFactory.newFOUserAgent();
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PrintRenderer renderer = new PrintRenderer(printerJob, copies);
                renderer.setUserAgent(userAgent);
                userAgent.setRendererOverride((Renderer)renderer);
                Fop fop = fopFactory.newFop(userAgent);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                StreamSource src = new StreamSource(inStream);
                SAXResult res = new SAXResult(fop.getDefaultHandler());
                transformer.transform(src, res);
            }
            catch (Exception ex) {
                boolean bl = false;
                try {
                    inStream.close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                return bl;
            }
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return true;
    }

    public void done() {
    }

    public PrintService getPrinterInternal(String printerName, String lastPrinterName) {
        PrintService[] services;
        for (PrintService element : services = PrinterJob.lookupPrintServices()) {
            if (!element.getName().equals(printerName)) continue;
            return element;
        }
        if (this.feedbackAllowed()) {
            ArrayList<String> values = new ArrayList<String>();
            for (PrintService element : services) {
                String value = element.getName();
                values.add(value);
            }
            this.createFeedbackParameter("printer-name", Messages.getString("PrintComponent.USER_PRINTER_NAME"), "", lastPrinterName, values, null, "select");
            this.promptNeeded();
            return null;
        }
        return services[0];
    }

    public static PrintService getPrinter(String printerName) {
        PrintService[] services;
        for (PrintService element : services = PrinterJob.lookupPrintServices()) {
            if (!element.getName().equals(printerName)) continue;
            return element;
        }
        return services[0];
    }

    public static PrintService getDefaultPrinter() {
        PrintService[] services = PrinterJob.lookupPrintServices();
        if (services == null || services.length == 0) {
            return null;
        }
        return services[0];
    }

    class PrintRenderer
    extends AWTRenderer {
        private static final int EVEN_AND_ALL = 0;
        private static final int EVEN = 1;
        private static final int ODD = 2;
        private int startNumber;
        private int endNumber;
        private int mode = 0;
        private int copies = 1;
        private PrinterJob printerJob;

        PrintRenderer(PrinterJob printerJob, int copies) {
            this.printerJob = printerJob;
            this.copies = copies;
            this.startNumber = 0;
            this.endNumber = -1;
            printerJob.setPageable((Pageable)((Object)this));
            printerJob.setCopies(this.copies);
            this.mode = 0;
            String str = null;
            if (str != null) {
                try {
                    this.mode = Boolean.valueOf(str) != false ? 1 : 2;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public void stopRenderer() throws IOException {
            super.stopRenderer();
            try {
                this.printerJob.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
                throw new IOException(Messages.getString("PrintComponent.ERROR_0003_UNABLE_TO_PRINT", e.getClass().getName(), e.getMessage()));
            }
        }

        private ArrayList getInvalidPageNumbers() {
            ArrayList<String> vec = new ArrayList<String>();
            int max = this.getNumberOfPages();
            for (int i = 0; i < max; ++i) {
                boolean isValid = true;
                if (i < this.startNumber || i > this.endNumber) {
                    isValid = false;
                } else if (this.mode != 0) {
                    if (this.mode == 1 && (i + 1) % 2 != 0) {
                        isValid = false;
                    } else if (this.mode == 2 && (i + 1) % 2 != 1) {
                        isValid = false;
                    }
                }
                if (isValid) continue;
                vec.add(i + "");
            }
            return vec;
        }
    }
}

