/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.chartbeans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;
import org.pentaho.chart.ChartBeanFactory;
import org.pentaho.chart.plugin.IChartPlugin;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.chartbeans.ChartSystemInitializationException;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartBeansSystemListener
implements IPentahoSystemListener {
    private String configFile = "chartbeans/chartbeans_config.xml";

    public boolean startup(IPentahoSession session) {
        try {
            int maxDataPointsPerChart;
            ChartBeanFactory.loadDefaultChartPlugins(this.initPlugins());
            List nodes = PentahoSystem.getSystemSettings().getSystemSettings(this.configFile, "max-data-points-per-chart");
            if (nodes.size() > 0 && (maxDataPointsPerChart = Integer.parseInt(((Element)nodes.get(0)).getText())) > 0) {
                ChartBeanFactory.setMaxDataPointsPerChart((int)maxDataPointsPerChart);
            }
        }
        catch (Exception ex) {
            Logger.warn((String)ChartBeansSystemListener.class.getName(), (String)Messages.getString("ChartBeansSystemListener.ERROR_0004_LOAD_FAILED"), (Throwable)ex);
            return false;
        }
        return true;
    }

    private List<IChartPlugin> initPlugins() throws Exception {
        ArrayList<IChartPlugin> plugins = new ArrayList<IChartPlugin>();
        HashMap<String, Object> pluginMap = new HashMap<String, Object>();
        List nodes = PentahoSystem.getSystemSettings().getSystemSettings(this.configFile, "bean");
        if (nodes == null || nodes.size() == 0) {
            String msg = Messages.getString("ChartBeansSystemListener.ERROR_0001_CONFIG_MISSING");
            Logger.warn((String)ChartBeansSystemListener.class.getName(), (String)msg);
            throw new ChartSystemInitializationException(msg);
        }
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        for (int i = 0; i < nodes.size(); ++i) {
            Element node = (Element)nodes.get(i);
            String id = node.attribute("id").getText();
            pluginMap.put(id, node.attribute("class").getText());
            if (null == pluginManager || !pluginManager.isBeanRegistered(id)) continue;
            try {
                Object plugin = pluginManager.getBean(id);
                pluginMap.put(id, plugin);
                continue;
            }
            catch (PluginBeanException e) {
                Logger.warn((String)ChartBeansSystemListener.class.getName(), (String)Messages.getString("ChartBeansSystemListener.ERROR_0002_PLUGINMANAGER_BEAN_MISSING", id), (Throwable)e);
            }
        }
        for (Object clazz : pluginMap.values()) {
            try {
                if (clazz instanceof String) {
                    plugins.add((IChartPlugin)Class.forName(clazz.toString()).newInstance());
                    continue;
                }
                plugins.add((IChartPlugin)clazz);
            }
            catch (Exception ex) {
                Logger.warn((String)ChartBeansSystemListener.class.getName(), (String)(Messages.getString("ChartBeansSystemListener.ERROR_0003_CLASS_CREATION_PROBLEM") + clazz), (Throwable)ex);
            }
        }
        return plugins;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void shutdown() {
    }
}

