/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.datatransforms;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.PentahoDataTransmuter;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;

public class ResultSetCrosstabComponent
extends ComponentBase {
    private static final long serialVersionUID = -868492439427599791L;
    private static final String RESULT_SET = "result_set";
    private static final String PIVOT_COLUMN = "pivot_column";
    private static final String MEASURES_COLUMN = "measures_column";
    private static final String FORMAT_TYPE = "format_type";
    private static final String FORMAT_STRING = "format_string";
    private static final String ORDERED_MAPS = "ordered_maps";
    private static final String TRANSFORM_SORTBYCOL = "sort_by_col";
    private static final String SORT_FORMAT_TYPE = "sort_format_type";
    private static final String SORT_FORMAT_STRING = "sort_format_string";
    private static final String OLD_STYLE_CROSSTAB = "non_ordered";
    private static final String UNIQUE_ROW_IDENTIFIER_COLUMN = "unique_row_identifier_column";

    public void done() {
    }

    protected boolean validateAction() {
        if (!this.isDefinedInput(PIVOT_COLUMN)) {
            this.error(Messages.getErrorString("ResultSetCrosstabComponent.ERROR_0001_PIVOT_COLUMN_IS_REQUIRED"));
            return false;
        }
        if (!this.isDefinedInput(MEASURES_COLUMN)) {
            this.error(Messages.getErrorString("ResultSetCrosstabComponent.ERROR_0002_MEASURES_COLUMN_IS_REQUIRED"));
            return false;
        }
        if (this.isDefinedInput(FORMAT_TYPE) && !this.isDefinedInput(FORMAT_STRING)) {
            this.error(Messages.getErrorString("ResultSetCrosstabComponent.ERROR_0003_FORMAT_PARAMETERS_BAD"));
            return false;
        }
        if (this.isDefinedInput(SORT_FORMAT_TYPE) && !this.isDefinedInput(SORT_FORMAT_STRING)) {
            this.error(Messages.getErrorString("ResultSetCrosstabComponent.ERROR_0004_SORT_FORMAT_PARAMETERS_BAD"));
            return false;
        }
        return true;
    }

    protected boolean executeAction() throws Throwable {
        Object resultSetObject = this.getInputValue(RESULT_SET);
        String outputName = this.getResultOutputName();
        if (outputName == null) {
            return false;
        }
        if (resultSetObject instanceof IPentahoResultSet) {
            int columnToPivot = Integer.parseInt(this.getInputStringValue(PIVOT_COLUMN));
            int measuresColumn = Integer.parseInt(this.getInputStringValue(MEASURES_COLUMN));
            String formatType = null;
            String formatString = null;
            if (this.isDefinedInput(FORMAT_TYPE)) {
                formatType = this.getInputStringValue(FORMAT_TYPE);
                formatString = this.getInputStringValue(FORMAT_STRING);
            }
            Format format = null;
            if (formatType != null && formatType.length() > 0) {
                if ("decimal".equalsIgnoreCase(formatType)) {
                    format = new DecimalFormat(formatString);
                } else if ("date".equalsIgnoreCase(formatType)) {
                    format = new SimpleDateFormat(formatString);
                }
            }
            String orderedMaps = this.getInputStringValue(ORDERED_MAPS);
            boolean orderOutputColumns = "true".equalsIgnoreCase(orderedMaps);
            int transformSortByColumn = 0;
            String sortColumn = this.getInputStringValue(TRANSFORM_SORTBYCOL);
            if (sortColumn != null) {
                transformSortByColumn = Integer.parseInt(sortColumn);
            }
            int uniqueRowIdentifierColumn = -1;
            if (this.isDefinedInput(UNIQUE_ROW_IDENTIFIER_COLUMN)) {
                String tmp = this.getInputStringValue(UNIQUE_ROW_IDENTIFIER_COLUMN);
                uniqueRowIdentifierColumn = Integer.parseInt(tmp);
            }
            String sortFormatType = null;
            String sortFormatString = null;
            if (this.isDefinedInput(SORT_FORMAT_TYPE)) {
                sortFormatString = this.getInputStringValue(SORT_FORMAT_STRING);
                sortFormatType = this.getInputStringValue(SORT_FORMAT_TYPE);
            }
            Format sortFormat = null;
            if (sortFormatType != null && sortFormatType.length() > 0) {
                if ("decimal".equalsIgnoreCase(sortFormatString)) {
                    sortFormat = new DecimalFormat(sortFormatString);
                } else if ("date".equalsIgnoreCase(sortFormatType)) {
                    sortFormat = new SimpleDateFormat(sortFormatString);
                }
            }
            IPentahoResultSet rSet = null;
            if (this.isDefinedInput(OLD_STYLE_CROSSTAB)) {
                this.warn(Messages.getString("ResultSetCrosstabComponent.WARN_DEPRECATED"));
                rSet = PentahoDataTransmuter.crossTab((IPentahoResultSet)((IPentahoResultSet)resultSetObject), (int)(columnToPivot - 1), (int)(measuresColumn - 1), (int)(transformSortByColumn - 1), (Format)format, (Format)sortFormat, (boolean)orderOutputColumns);
            } else {
                rSet = PentahoDataTransmuter.crossTabOrdered((IPentahoResultSet)((IPentahoResultSet)resultSetObject), (int)(columnToPivot - 1), (int)(measuresColumn - 1), (int)(transformSortByColumn - 1), (Format)format, (Format)sortFormat, (boolean)orderOutputColumns, (int)(uniqueRowIdentifierColumn - 1));
            }
            this.setOutputValue(outputName, rSet);
            return true;
        }
        return false;
    }

    public boolean init() {
        return true;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public Log getLogger() {
        return LogFactory.getLog(ResultSetCrosstabComponent.class);
    }

    public String getResultOutputName() {
        Set outputs = this.getOutputNames();
        if (outputs == null || outputs.size() != 1) {
            this.error(Messages.getString("Template.ERROR_0002_OUTPUT_COUNT_WRONG"));
            return null;
        }
        String outputName = null;
        try {
            outputName = this.getInputStringValue("output-name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (outputName == null) {
            outputName = (String)outputs.iterator().next();
        }
        return outputName;
    }
}

